/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesDlgMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesDlgTabPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CPropertiesGeneral
extends CPropertiesDlgTabPanel
implements ActionListener {
    private GroupLayout m_Layout = new GroupLayout(this);
    protected JLabel m_cIconLabel;
    protected JLabel m_cMsgPane;
    protected JSeparator m_cSepSection1;
    private JLabel m_cTypeTitle;
    private JLabel m_cTypeMsg;
    protected JSeparator m_cSepSection2;
    private JLabel m_cLocationTitle;
    private JLabel m_cLocationMsg;
    private JLabel m_cSizeTitle;
    private JLabel m_cSizeMsg;
    private JLabel m_cSizeOnDiskTitle;
    private JLabel m_cSizeOnDiskMsg;
    protected JSeparator m_cSepSection3;
    private JLabel m_cCreatedTitle;
    private JLabel m_cCreatedMsg;
    private JLabel m_cModifiedTitle;
    private JLabel m_cModifiedMsg;
    private JLabel m_cAccessedTitle;
    private JLabel m_cAccessedMsg;
    protected JSeparator m_cSepSection4;
    private JLabel m_cAttrs;
    private JCheckBox m_cReadOnly;
    private JCheckBox m_cHidden;
    private JCheckBox m_cArchived;

    public CPropertiesGeneral() {
        this.m_Layout.setAutoCreateGaps(true);
        this.m_Layout.setAutoCreateContainerGaps(true);
        this.setLayout(this.m_Layout);
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.setOpaque(false);
        this.m_cIconLabel = new JLabel();
        this.m_cMsgPane = new JLabel();
        this.m_cSepSection1 = new JSeparator();
        this.m_cSepSection1.setOrientation(0);
        this.m_cTypeTitle = new JLabel();
        this.m_cTypeTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_TYPE_TITLE"));
        this.m_cTypeMsg = new JLabel();
        this.m_cSepSection2 = new JSeparator();
        this.m_cSepSection2.setOrientation(0);
        this.m_cLocationTitle = new JLabel();
        this.m_cLocationTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_LOCATION_TITLE"));
        this.m_cLocationMsg = new JLabel();
        this.m_cSizeTitle = new JLabel();
        this.m_cSizeTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_SIZE_TITLE"));
        this.m_cSizeMsg = new JLabel();
        this.m_cSizeOnDiskTitle = new JLabel();
        this.m_cSizeOnDiskTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_SIZE_ON_DISK_TITLE"));
        this.m_cSizeOnDiskTitle.setVisible(false);
        this.m_cSizeOnDiskMsg = new JLabel();
        this.m_cSizeOnDiskMsg.setVisible(false);
        this.m_cSepSection3 = new JSeparator();
        this.m_cSepSection3.setOrientation(0);
        this.m_cCreatedTitle = new JLabel();
        this.m_cCreatedTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_CREATED_TITLE"));
        this.m_cCreatedTitle.setVisible(false);
        this.m_cCreatedMsg = new JLabel();
        this.m_cCreatedMsg.setVisible(false);
        this.m_cModifiedTitle = new JLabel();
        this.m_cModifiedTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_MODIFIED_TITLE"));
        this.m_cModifiedMsg = new JLabel();
        this.m_cAccessedTitle = new JLabel();
        this.m_cAccessedTitle.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_ACCESSED_TITLE"));
        this.m_cAccessedTitle.setVisible(false);
        this.m_cAccessedMsg = new JLabel();
        this.m_cAccessedMsg.setVisible(false);
        this.m_cSepSection4 = new JSeparator();
        this.m_cSepSection4.setOrientation(0);
        this.m_cAttrs = new JLabel();
        this.m_cAttrs.setText(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_ATTRIBUTES_TITLE"));
        this.m_cAttrs.setVerticalAlignment(0);
        this.m_cReadOnly = new JCheckBox();
        this.m_cReadOnly.setText(CString.LoadString("IDS_READ_ONLY"));
        this.m_cReadOnly.setOpaque(false);
        this.m_cReadOnly.addActionListener(this);
        this.m_cHidden = new JCheckBox();
        this.m_cHidden.setText(CString.LoadString("IDS_HIDDEN"));
        this.m_cHidden.setOpaque(false);
        this.m_cHidden.addActionListener(this);
        this.m_cArchived = new JCheckBox();
        this.m_cArchived.setText(CString.LoadString("IDS_ARCHIVED"));
        this.m_cArchived.setOpaque(false);
        this.m_cArchived.addActionListener(this);
        this.LoadFileInfo();
    }

    private void EnableApply() {
        CPropertiesDlgMainPanel rMainPanel = (CPropertiesDlgMainPanel)SwingUtilities.getAncestorOfClass(CPropertiesDlgMainPanel.class, this);
        if (rMainPanel != null) {
            rMainPanel.EnableApply();
        }
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        Component cSource;
        Object objSource = rActionEvent.getSource();
        if (objSource instanceof Component && ((cSource = (Component)objSource) == this.m_cReadOnly || cSource == this.m_cHidden || cSource == this.m_cArchived)) {
            this.EnableApply();
            for (int nIdx = 0; nIdx < this.GetFileCount(); ++nIdx) {
                CFile fNext = this.GetFile(nIdx);
                if (fNext == null) continue;
                if (cSource == this.m_cReadOnly) {
                    fNext.SetIsReadOnly(this.m_cReadOnly.isSelected());
                    continue;
                }
                if (cSource == this.m_cHidden) {
                    fNext.SetIsHidden(this.m_cHidden.isSelected());
                    continue;
                }
                if (cSource != this.m_cArchived) continue;
                fNext.SetIsArchived(this.m_cArchived.isSelected());
            }
        }
    }

    private GroupLayout GetLayout() {
        return this.m_Layout;
    }

    public int GetFileCount() {
        int nCount = 0;
        CPropertiesDlgMainPanel rMainPanel = (CPropertiesDlgMainPanel)SwingUtilities.getAncestorOfClass(CPropertiesDlgMainPanel.class, this);
        if (rMainPanel != null) {
            nCount = rMainPanel.GetFileCount();
        }
        return nCount;
    }

    public CFile GetFile(int nIdx) {
        CFile fFile = null;
        CPropertiesDlgMainPanel rMainPanel = (CPropertiesDlgMainPanel)SwingUtilities.getAncestorOfClass(CPropertiesDlgMainPanel.class, this);
        if (rMainPanel != null) {
            fFile = rMainPanel.GetFile(nIdx);
        }
        return fFile;
    }

    private void LoadFileInfo() {
        int nFileCount = this.GetFileCount();
        Icon icoImage = null;
        String sMsgPane = null;
        String sType = null;
        String sLocation = null;
        long nSize = -1L;
        long lModified = -1L;
        Date dtModified = null;
        long lTimestampLastAccessed = -1L;
        Date dtLastAccessed = null;
        long lTimestampCreated = -1L;
        Date dtCreated = null;
        boolean bIsReadOnly = false;
        boolean bIsHidden = false;
        boolean bIsArchived = false;
        boolean bIsLocal = false;
        if (nFileCount > 0) {
            CFile fFirstFile = this.GetFile(0);
            if (fFirstFile != null) {
                if (fFirstFile instanceof CLocalFile) {
                    bIsLocal = true;
                }
                sLocation = fFirstFile.GetParentPath(false);
                if (nFileCount == 1) {
                    icoImage = fFirstFile.GetIcon32();
                    sMsgPane = fFirstFile.GetDisplayName();
                    sType = fFirstFile.GetType();
                    nSize = fFirstFile.GetSize();
                    lModified = fFirstFile.GetLastModified();
                    dtModified = fFirstFile.GetModifiedDate();
                    lTimestampLastAccessed = fFirstFile.GetTimestampLastAccessed();
                    dtLastAccessed = fFirstFile.GetDateLastAccessed();
                    lTimestampCreated = fFirstFile.GetTimestampCreated();
                    dtCreated = fFirstFile.GetDateCreated();
                    bIsReadOnly = fFirstFile.IsReadOnly();
                    bIsHidden = fFirstFile.IsHidden();
                    bIsArchived = fFirstFile.IsArchived();
                }
            }
            if (nFileCount > 1) {
                int nNumOfFiles = 0;
                int nNumOfFolders = 0;
                String sPrevType = null;
                String sNextType = null;
                boolean bMultipleFiles = false;
                sType = CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_MULTIPLE_TYPES");
                for (int nIdx = 0; nIdx < nFileCount; ++nIdx) {
                    sPrevType = sNextType;
                    CFile fFile = this.GetFile(nIdx);
                    if (fFile == null) continue;
                    if (fFile.IsDirectory()) {
                        ++nNumOfFolders;
                    } else {
                        ++nNumOfFiles;
                    }
                    nSize += fFile.GetSize();
                    sNextType = fFile.GetType();
                    if (bMultipleFiles) continue;
                    if (sNextType != null && sPrevType != null && !sPrevType.equals(sNextType)) {
                        bMultipleFiles = true;
                        continue;
                    }
                    sType = sNextType;
                }
                if (bMultipleFiles) {
                    sType = CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_MULTIPLE_TYPES");
                }
                if (CMainFrame.GET_APP() != null) {
                    icoImage = CMainFrame.GET_APP().GetJarImage("MultipleFiles-32x32.png");
                }
                NumberFormat Formatter2 = NumberFormat.getInstance();
                sMsgPane = String.format(CString.LoadString("IDS_FILE_PROPS_TAB_GENERAL_MULTIPLE_MSG"), Formatter2.format(nNumOfFiles), Formatter2.format(nNumOfFolders));
            }
        } else if (DEBUG) {
            this.m_cTypeMsg.setText("<file type>");
            this.m_cLocationMsg.setText("<directory>");
            this.m_cSizeMsg.setText("<size>");
            this.m_cSizeOnDiskMsg.setText("<size on disk>");
            this.m_cCreatedMsg.setText("<created>");
            this.m_cModifiedMsg.setText("<modified>");
            this.m_cReadOnly.setText("Read-only");
            this.m_cHidden.setText("Hidden");
            this.m_cArchived.setText("Archived");
            this.m_cAccessedMsg.setText("<accessed>");
        }
        this.ShowCreatedAndLastAccessControls(false);
        int nMaxSize = 90;
        GroupLayout layout = this.GetLayout();
        if (layout != null) {
            if (nFileCount == 1) {
                if (!bIsLocal) {
                    this.ShowCreatedAndLastAccessControls(true);
                }
                if (nSize >= 0L && lModified > 0L) {
                    layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cIconLabel, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cMsgPane, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection1).addGroup(layout.createSequentialGroup().addComponent(this.m_cTypeTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cTypeMsg, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection2).addGroup(layout.createSequentialGroup().addComponent(this.m_cLocationTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cLocationMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cSizeTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cSizeMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cSizeOnDiskTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cSizeOnDiskMsg, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection3).addGroup(layout.createSequentialGroup().addComponent(this.m_cCreatedTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cCreatedMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cModifiedTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cModifiedMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cAccessedTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cAccessedMsg, 0, -1, Short.MAX_VALUE)));
                    layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cIconLabel, 32, 32, 32).addComponent(this.m_cMsgPane, 16, 16, 26)).addComponent(this.m_cSepSection1, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTypeTitle, -1, -2, -2).addComponent(this.m_cTypeMsg, -1, -2, -2)).addComponent(this.m_cSepSection2, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cLocationTitle, -1, -2, -2).addComponent(this.m_cLocationMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cSizeTitle, -1, -2, -2).addComponent(this.m_cSizeMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cSizeOnDiskTitle, -1, -2, -2).addComponent(this.m_cSizeOnDiskMsg, -1, -2, -2)).addComponent(this.m_cSepSection3, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cCreatedTitle, -1, -2, -2).addComponent(this.m_cCreatedMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cModifiedTitle, -1, -2, -2).addComponent(this.m_cModifiedMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cAccessedTitle, -1, -2, -2).addComponent(this.m_cAccessedMsg, -1, -2, -2)));
                } else {
                    layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cIconLabel, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cMsgPane, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection1).addGroup(layout.createSequentialGroup().addComponent(this.m_cTypeTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cTypeMsg, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection2).addGroup(layout.createSequentialGroup().addComponent(this.m_cLocationTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cLocationMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cSizeOnDiskTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cSizeOnDiskMsg, 0, -1, Short.MAX_VALUE)));
                    layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cIconLabel, 32, 32, 32).addComponent(this.m_cMsgPane, 16, 16, 26)).addComponent(this.m_cSepSection1, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTypeTitle, -1, -2, -2).addComponent(this.m_cTypeMsg, -1, -2, -2)).addComponent(this.m_cSepSection2, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cLocationTitle, -1, -2, -2).addComponent(this.m_cLocationMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cSizeOnDiskTitle, -1, -2, -2).addComponent(this.m_cSizeOnDiskMsg, -1, -2, -2)));
                }
            } else {
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cIconLabel, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cMsgPane, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection1).addGroup(layout.createSequentialGroup().addComponent(this.m_cTypeTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cTypeMsg, 0, -1, Short.MAX_VALUE)).addComponent(this.m_cSepSection2).addGroup(layout.createSequentialGroup().addComponent(this.m_cLocationTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cLocationMsg, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_cSizeTitle, nMaxSize, nMaxSize, nMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 10).addComponent(this.m_cSizeMsg, 0, -1, Short.MAX_VALUE)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cIconLabel, 32, 32, 32).addComponent(this.m_cMsgPane, 16, 16, 26)).addComponent(this.m_cSepSection1, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTypeTitle, -1, -2, -2).addComponent(this.m_cTypeMsg, -1, -2, -2)).addComponent(this.m_cSepSection2, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cLocationTitle, -1, -2, -2).addComponent(this.m_cLocationMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cSizeTitle, -1, -2, -2).addComponent(this.m_cSizeMsg, -1, -2, -2)));
            }
        }
        if (this.m_cIconLabel != null && icoImage != null) {
            this.m_cIconLabel.setIcon(icoImage);
        }
        if (this.m_cMsgPane != null && sMsgPane != null) {
            this.m_cMsgPane.setText(sMsgPane);
        }
        if (this.m_cTypeMsg != null && sType != null) {
            this.m_cTypeMsg.setText(sType);
        }
        if (this.m_cLocationMsg != null && sLocation != null) {
            this.m_cLocationMsg.setText(sLocation);
        }
        if (this.m_cSizeMsg != null && nSize > -1L) {
            String sFmt1 = CString.FormatNumOfBytesDouble(nSize, true, 2);
            String sFmt2 = CString.FormatNumberForThousands(nSize);
            String sTxt = String.format("%s (%s %s)", sFmt1, sFmt2, CString.LoadString("IDS_BYTES"));
            this.m_cSizeMsg.setText(sTxt);
        }
        this.UpdateTimestampField(this.m_cModifiedMsg, dtModified);
        this.UpdateTimestampField(this.m_cAccessedMsg, dtLastAccessed);
        this.UpdateTimestampField(this.m_cCreatedMsg, dtCreated);
        if (this.m_cReadOnly != null) {
            this.m_cReadOnly.setSelected(bIsReadOnly);
        }
        if (this.m_cHidden != null) {
            this.m_cHidden.setSelected(bIsHidden);
        }
        if (this.m_cArchived != null) {
            this.m_cArchived.setSelected(bIsArchived);
        }
    }

    private String GetDateFmtString() {
        return "EEEE, MMMM dd, yyyy, hh:mm:ss a";
    }

    private void ShowCreatedAndLastAccessControls(boolean bShow) {
        if (this.m_cCreatedTitle != null) {
            this.m_cCreatedTitle.setVisible(bShow);
        }
        if (this.m_cCreatedMsg != null) {
            this.m_cCreatedMsg.setVisible(bShow);
        }
        if (this.m_cAccessedTitle != null) {
            this.m_cAccessedTitle.setVisible(bShow);
        }
        if (this.m_cAccessedMsg != null) {
            this.m_cAccessedMsg.setVisible(bShow);
        }
    }

    private IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    private boolean AdjustForDST() {
        Boolean bVal;
        boolean bAdjustForDST = false;
        if (this.GetArchive() != null && (bVal = this.GetArchive().GetValueBool("ShowDST", false)) != null) {
            bAdjustForDST = bVal;
        }
        return bAdjustForDST;
    }

    private void UpdateTimestampField(JLabel rTextField, Date dtTimestamp) {
        if (rTextField != null && dtTimestamp != null) {
            StringBuffer sbuf;
            dtTimestamp = CFileSystemUtils.GetFileSysUtils().AdjustToLocal(dtTimestamp, this.AdjustForDST());
            String sFmt = this.GetDateFmtString();
            SimpleDateFormat sdf = new SimpleDateFormat(sFmt);
            StringBuffer sbuf2 = sdf.format(dtTimestamp, sbuf = new StringBuffer(), new FieldPosition(0));
            if (sbuf2 != null) {
                rTextField.setText(sbuf2.toString());
            }
        }
    }
}

