/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.gui.events.CBaseEventQueue;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class CRhinoDialog
extends JDialog
implements ActionListener,
WindowListener,
KeyListener {
    protected static final boolean DEBUG = CMainFrame.DEBUG;
    public static final int RSLT_UNKNOWN = 0;
    public static final int RSLT_LEFT_BTN = 1;
    public static final int RSLT_CENTER_BTN = 2;
    public static final int RSLT_RIGHT_BTN = 3;
    public static final int RSLT_CLOSE_BTN = 4;
    private long m_nDlgID;
    protected JLabel m_BtnLabel;
    protected JButton m_LeftBtn;
    protected JButton m_CenterBtn;
    protected JButton m_RightBtn;
    protected Component m_CenterToComp;
    private int m_nResult;
    protected boolean m_bShowClosePrompt;
    protected String m_sClosePromptTitle;
    protected String m_sClosePromptMsg;
    private boolean m_bFirstShow;
    private int m_nInitialWidth;
    private int m_nInitialHeight;

    public CRhinoDialog(Frame wndOwner, boolean bIsModal, long nDlgID) {
        super(wndOwner, bIsModal);
        this.InitVars(nDlgID, wndOwner);
    }

    public CRhinoDialog(Dialog wndOwner, boolean bIsModal, long nDlgID) {
        super(wndOwner, bIsModal);
        this.InitVars(nDlgID, wndOwner);
    }

    private void InitVars(long nDlgID, Window wndOwner) {
        this.m_nDlgID = nDlgID;
        this.SetCenterToComp(wndOwner);
        this.m_nResult = 0;
        this.m_bShowClosePrompt = false;
        this.m_bFirstShow = true;
        this.m_nInitialWidth = -1;
        this.m_nInitialHeight = -1;
        this.OnCreate();
    }

    protected void OnCreate() {
        this.ResetResult();
        this.m_BtnLabel = new JLabel();
        this.m_LeftBtn = new JButton();
        this.m_CenterBtn = new JButton();
        this.m_RightBtn = new JButton();
        this.SetDefaultBtn(this.GetLeftBtn());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_BtnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_LeftBtn).addComponent(this.m_CenterBtn).addComponent(this.m_RightBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.m_BtnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, 20).addGroup(layout.createParallelGroup().addComponent(this.m_LeftBtn).addComponent(this.m_CenterBtn).addComponent(this.m_RightBtn))));
        this.ResetClosePrompt();
        this.m_LeftBtn.addActionListener(this);
        this.m_CenterBtn.addActionListener(this);
        this.m_RightBtn.addActionListener(this);
        this.addKeyListener(this);
        this.m_LeftBtn.addKeyListener(this);
        this.m_CenterBtn.addKeyListener(this);
        this.m_RightBtn.addKeyListener(this);
        this.addWindowListener(this);
    }

    public long GetDlgID() {
        return this.m_nDlgID;
    }

    @Override
    public void setVisible(boolean bSetVisible) {
        if (this.m_bFirstShow && bSetVisible) {
            this.m_bFirstShow = false;
            this.ResetResult();
            this.pack();
            if (this.m_nInitialWidth > 10 && this.m_nInitialHeight > 10) {
                this.setSize(this.m_nInitialWidth, this.m_nInitialHeight);
            }
            this.setLocationRelativeTo(this.m_CenterToComp);
        }
        super.setVisible(bSetVisible);
    }

    protected void OnClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        boolean bCloseDlg = false;
        Object objSource = rActionEvent.getSource();
        if (objSource == this.m_LeftBtn) {
            bCloseDlg = true;
            this.m_nResult = 1;
        } else if (objSource == this.m_CenterBtn) {
            bCloseDlg = true;
            this.m_nResult = 2;
        } else if (objSource == this.m_RightBtn) {
            bCloseDlg = true;
            this.m_nResult = 3;
        }
        if (bCloseDlg) {
            this.OnClose();
        }
    }

    @Override
    public void windowOpened(WindowEvent rWndEvent) {
    }

    @Override
    public void windowClosing(WindowEvent rWndEvent) {
        if (this.m_bShowClosePrompt) {
            int nRet = this.ShowClosePrompt();
            if (nRet == 0) {
                this.m_nResult = 4;
                this.OnClose();
            }
        } else {
            this.m_nResult = 4;
        }
    }

    protected int ShowClosePrompt() {
        CMsgBox dlg = new CMsgBox(this, true, -1L, 0, 3);
        dlg.setTitle(this.m_sClosePromptTitle);
        dlg.setPreferredSize(new Dimension(280, 120));
        dlg.SetMainMsg(this.m_sClosePromptMsg);
        dlg.setResizable(false);
        dlg.SetDefaultBtn(1);
        dlg.setVisible(true);
        return dlg.GetExitCode();
    }

    @Override
    public void windowClosed(WindowEvent rWndEvent) {
    }

    @Override
    public void windowIconified(WindowEvent rWndEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent rWndEvent) {
    }

    @Override
    public void windowActivated(WindowEvent rWndEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent jEvent) {
    }

    protected void ResetClosePrompt() {
        this.m_bShowClosePrompt = false;
        this.setDefaultCloseOperation(2);
    }

    public void SetClosePrompt(String sTitle, String sMsg) {
        this.m_bShowClosePrompt = true;
        this.setDefaultCloseOperation(0);
        this.m_sClosePromptTitle = sTitle;
        this.m_sClosePromptMsg = sMsg;
    }

    public int GetResult() {
        return this.m_nResult;
    }

    public void ResetResult() {
        this.m_nResult = 0;
    }

    public void SetCenterToComp(Component rCenterToComp) {
        this.m_CenterToComp = rCenterToComp;
    }

    public void SetBtnLabelTxt(String sTxt) {
        this.m_BtnLabel.setText(sTxt);
    }

    public void SetLeftBtnTxt(String sTxt) {
        this.SetBtnTxt(this.m_LeftBtn, sTxt);
    }

    public void SetCenterBtnTxt(String sTxt) {
        this.SetBtnTxt(this.m_CenterBtn, sTxt);
    }

    public void SetRightBtnTxt(String sTxt) {
        this.SetBtnTxt(this.m_RightBtn, sTxt);
    }

    public void AddLeftBtnListener(ActionListener rListener) {
        this.m_LeftBtn.addActionListener(rListener);
    }

    public void AddCenterBtnListener(ActionListener rListener) {
        this.m_CenterBtn.addActionListener(rListener);
    }

    public void AddRightBtnListener(ActionListener rListener) {
        this.m_RightBtn.addActionListener(rListener);
    }

    public void SetLeftBtnVisible(boolean bVisible) {
        this.m_LeftBtn.setVisible(bVisible);
    }

    public void SetCenterBtnVisible(boolean bVisible) {
        this.m_CenterBtn.setVisible(bVisible);
    }

    public void SetRightBtnVisible(boolean bVisible) {
        this.m_RightBtn.setVisible(bVisible);
    }

    public void SetBtnLabelVisible(boolean bVisible) {
        this.m_BtnLabel.setVisible(bVisible);
    }

    public void SetInitialSize(int nWidth, int nHeight) {
        this.m_nInitialWidth = nWidth;
        this.m_nInitialHeight = nHeight;
    }

    protected boolean GetFirstShow() {
        return this.m_bFirstShow;
    }

    protected void PostEvent(int nEventID) {
        this.PostEvent(nEventID, null);
    }

    protected void PostEvent(int nEventID, Object rEventObj) {
        Window rcTarget = this.getOwner();
        if (rcTarget != null) {
            CRhinoEvent rEvent = new CRhinoEvent(rcTarget, nEventID, rEventObj);
            CBaseEventQueue.PostEvent(rEvent);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetEventSource() = null");
        }
    }

    protected void SetBtnTxt(JButton rBtn, String sTxt) {
        if (rBtn != null) {
            Character chMnemonic = CString.GetMnemonic(sTxt);
            if (chMnemonic != null) {
                rBtn.setMnemonic(chMnemonic.charValue());
            }
            rBtn.setText(CString.RemoveMnemonic(sTxt));
        }
    }

    protected JButton GetLeftBtn() {
        return this.m_LeftBtn;
    }

    protected JButton GetCenterBtn() {
        return this.m_CenterBtn;
    }

    protected JButton GetRightBtn() {
        return this.m_RightBtn;
    }

    @Override
    public void keyTyped(KeyEvent rKeyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        if (rKeyEvent != null) {
            if (this.GetLeftBtn() != null && this.GetLeftBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                this.GetLeftBtn().doClick();
            } else if (this.GetCenterBtn() != null && this.GetCenterBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                this.GetCenterBtn().doClick();
            } else if (this.GetRightBtn() != null && this.GetRightBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                this.GetRightBtn().doClick();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent rKeyEvent) {
    }

    public void SetDefaultBtn(JButton rBtn) {
        if (rBtn != null && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(rBtn);
        }
    }
}

