/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CLinkLabel;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CTreeCtrl;
import com.rhinosoft.fvjv.gui.dialogs.CTreeCtrlModel;
import com.rhinosoft.fvjv.gui.dialogs.CTwoToneLabel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CRhinoPrefsDlgMainPanel
extends CDialogMainPanel
implements ActionListener,
TreeSelectionListener {
    public static final String URL_RHINOSOFT = "http://www.rhinosoft.com/";
    private JLabel m_cTreeLabelCtrl;
    private CTreeCtrl m_cTreeCtrl;
    private JScrollPane m_cTreePaneCtrl;
    private JLabel m_cLogoCtrl;
    private JLabel m_cResellerLogoCtrl;
    private CTwoToneLabel m_cFooterTitleCtrl;
    private JButton m_cOkBtn;
    private JButton m_cCancelBtn;
    private JButton m_cHelpBtn;
    private JPanel m_cDynamicPanel;
    private CRhinoPrefsTreePanel m_cCurTreePanel;
    private LinkedHashMap<String, CRhinoPrefsTreePanel> m_aTreePanels;

    public CRhinoPrefsDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_aTreePanels = new LinkedHashMap();
    }

    protected void InitTreePanels() {
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.InitTreePanels();
        this.m_cTreeLabelCtrl = new JLabel(CString.LoadString("IDS_TREE_CATEGORY"));
        this.m_cTreeCtrl = new CTreeCtrl(false, "DEFAULT_ROOT");
        if (this.GetTreeCtrl() != null) {
            this.AddEscapeKeyListener(this.GetTreeCtrl());
            this.GetTreeCtrl().getSelectionModel().setSelectionMode(1);
            this.GetTreeCtrl().SetShowCellIcons(false);
            this.GetTreeCtrl().addTreeSelectionListener(this);
            LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
            if (aTreePanels != null) {
                boolean bChildOfRoot = true;
                Object jParentNode = null;
                Set<String> sKeySet = aTreePanels.keySet();
                for (String sKey : sKeySet) {
                    this.GetTreeCtrl().AddNode(sKey);
                    CRhinoPrefsTreePanel rTreePanel = aTreePanels.get(sKey);
                    if (rTreePanel == null) continue;
                    rTreePanel.OnCreate();
                }
            }
        }
        this.m_cTreePaneCtrl = new JScrollPane(this.GetTreeCtrl());
        this.m_cLogoCtrl = this.CreateLinkLabel(this.GetMainFrame(), URL_RHINOSOFT);
        if (this.GetLogoCtrl() != null) {
            this.GetLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
        }
        String sResellerURL = CString.LoadString("IDS_RESELLER_COMPANY_URL");
        this.m_cResellerLogoCtrl = this.CreateLinkLabel(this.GetMainFrame(), sResellerURL);
        if (this.GetResellerLogoCtrl() != null) {
            this.GetResellerLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.m_cFooterTitleCtrl = new CTwoToneLabel();
        if (this.GetTreePaneCtrl() != null) {
            this.GetTreePaneCtrl().setMinimumSize(new Dimension(100, 100));
        }
        this.m_cOkBtn = new JButton(CString.LoadString("IDS_OK"));
        this.SetBtnTxt(this.m_cOkBtn, CString.LoadString("IDS_OK", false));
        this.m_cOkBtn.addActionListener(this);
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        this.SetBtnTxt(this.m_cCancelBtn, CString.LoadString("IDS_CANCEL", false));
        this.m_cCancelBtn.addActionListener(this);
        this.m_cHelpBtn = new JButton(CString.LoadString("IDS_HELP_MENU"));
        this.SetBtnTxt(this.m_cHelpBtn, CString.LoadString("IDS_HELP_MENU", false));
        this.m_cHelpBtn.addActionListener(this);
        this.m_cDynamicPanel = new JPanel();
        if (this.GetDynamicPanel() != null) {
            this.GetDynamicPanel().setLayout(new BorderLayout());
        }
        if (this.GetLogoCtrl() != null) {
            this.GetLogoCtrl().setVisible(false);
        }
        if (this.GetResellerLogoCtrl() != null) {
            this.GetResellerLogoCtrl().setVisible(false);
        }
        if (this.GetTreeCtrl() != null) {
            this.GetTreeCtrl().SetSelectionPath(this.GetStoredTreePath());
        }
        this.RecalcLayout();
    }

    private void RecalcLayout() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        if (layout != null) {
            JSeparator cSep = new JSeparator();
            cSep.setOrientation(0);
            int nTreeWidth = this.GetLogoCtrlWidth();
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
                String sLang;
                if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                    nTreeWidth = 160;
                }
                if ((sLang = CMainFrame.GET_APP().GetClientInfo().GetLanguageCode()) != null && sLang.equalsIgnoreCase("ru")) {
                    nTreeWidth += 40;
                }
            }
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(10).addGroup(layout.createParallelGroup().addComponent(this.GetTreeLabelCtrl(), -1, -2, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetTreePaneCtrl(), nTreeWidth, nTreeWidth, nTreeWidth).addComponent(this.GetResellerLogoCtrl(), nTreeWidth, nTreeWidth, nTreeWidth).addComponent(this.GetLogoCtrl(), nTreeWidth, nTreeWidth, nTreeWidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetDynamicPanel(), -1, -2, Short.MAX_VALUE)).addComponent(cSep, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.GetFooterTitleCtrl(), -1, -2, Short.MAX_VALUE).addComponent(this.GetOkBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetCancelBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.GetHelpBtn(), -1, -2, -2))).addGap(10));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(3).addComponent(this.GetTreeLabelCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, 3).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetTreePaneCtrl(), -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.GetResellerLogoCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.GetLogoCtrl(), -1, -2, -2)).addComponent(this.GetDynamicPanel(), -1, -2, Short.MAX_VALUE)).addGap(10).addComponent(cSep, 3, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(this.GetFooterTitleCtrl(), this.GetFooterTitleCtrl().GetNormalHeight(), this.GetFooterTitleCtrl().GetNormalHeight(), this.GetFooterTitleCtrl().GetNormalHeight()).addComponent(this.GetOkBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2).addComponent(this.GetHelpBtn(), -1, -2, -2)).addGap(10));
        }
    }

    public void SavePage() {
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
        if (aTreePanels != null) {
            boolean bChildOfRoot = true;
            Object jParentNode = null;
            Set<String> sKeySet = aTreePanels.keySet();
            for (String sKey : sKeySet) {
                CRhinoPrefsTreePanel rTreePanel = aTreePanels.get(sKey);
                if (rTreePanel == null) continue;
                rTreePanel.SavePage();
            }
        }
    }

    protected String GetStoredTreePath() {
        String sTreePath = null;
        if (this.GetTreeCtrl() != null) {
            sTreePath = this.GetTreeCtrl().FormatTreePath(this.GetTreeCtrl().getPathForRow(0));
        }
        return sTreePath;
    }

    protected void SetStoredTreePath(String sTreePath) {
    }

    @Override
    public void OnInitialUpdate() {
        super.OnInitialUpdate();
    }

    @Override
    public boolean ValidatePage() {
        boolean bIsValid = super.ValidatePage();
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
        if (aTreePanels != null) {
            boolean bChildOfRoot = true;
            Object jParentNode = null;
            Set<String> sKeySet = aTreePanels.keySet();
            for (String sKey : sKeySet) {
                CRhinoPrefsTreePanel rTreePanel = aTreePanels.get(sKey);
                if (rTreePanel == null) continue;
                bIsValid = rTreePanel.ValidatePage() && bIsValid;
            }
        }
        return bIsValid;
    }

    private int GetLogoCtrlWidth() {
        int nWidth = 150;
        if (this.GetLogoCtrl() != null && this.GetLogoCtrl().getIcon() != null) {
            String sLangCode;
            Insets rInsets;
            nWidth = this.GetLogoCtrl().getIcon().getIconWidth();
            if (this.GetLogoCtrl().getBorder() != null && (rInsets = this.GetLogoCtrl().getBorder().getBorderInsets(this.GetLogoCtrl())) != null) {
                nWidth += rInsets.left + rInsets.right;
            }
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null && (sLangCode = CMainFrame.GET_APP().GetClientInfo().GetLanguageCode()) != null && !sLangCode.isEmpty()) {
                String string = sLangCode.toLowerCase();
            }
        }
        return nWidth;
    }

    private void UpdateLogoSizes() {
        if (this.GetLogoCtrl() != null) {
            int nWidth = this.GetLogoCtrlWidth();
            this.GetLogoCtrl().setMinimumSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
            this.GetLogoCtrl().setPreferredSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
            this.GetLogoCtrl().setSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
            if (this.GetResellerLogoCtrl() != null) {
                this.GetLogoCtrl().setMinimumSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
                this.GetLogoCtrl().setPreferredSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
                this.GetResellerLogoCtrl().setSize(new Dimension(nWidth, this.GetLogoCtrl().getIcon().getIconHeight()));
            }
            if (this.GetTreePaneCtrl() != null) {
                this.GetTreePaneCtrl().setMinimumSize(new Dimension(nWidth, 100));
                this.GetTreePaneCtrl().setPreferredSize(new Dimension(nWidth, 100));
                this.GetTreePaneCtrl().setSize(new Dimension(nWidth, 100));
            }
        }
        this.RecalcLayout();
    }

    public void SetLogo(ImageIcon icoLogo) {
        if (icoLogo != null) {
            if (this.GetLogoCtrl() != null) {
                this.GetLogoCtrl().setVisible(true);
                this.GetLogoCtrl().setIcon(icoLogo);
                this.UpdateLogoSizes();
            }
        } else if (this.GetTreePaneCtrl() != null) {
            this.GetTreePaneCtrl().setMinimumSize(new Dimension(100, 100));
        }
    }

    public void SetResellerLogo(ImageIcon icoLogo) {
        if (icoLogo != null && this.GetResellerLogoCtrl() != null) {
            this.GetResellerLogoCtrl().setVisible(true);
            this.GetResellerLogoCtrl().setIcon(icoLogo);
        }
    }

    protected JButton GetOkBtn() {
        return this.m_cOkBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    protected JButton GetHelpBtn() {
        return this.m_cHelpBtn;
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        if (rActionEvent != null) {
            if (rActionEvent.getSource() == this.GetOkBtn()) {
                this.OnOk();
            } else if (rActionEvent.getSource() == this.GetCancelBtn()) {
                this.OnCancel();
            } else if (rActionEvent.getSource() == this.GetHelpBtn()) {
                this.OnHelp();
            }
        }
    }

    private void OnOk() {
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null) {
            rDlg.OnClose(0);
        }
    }

    private void OnCancel() {
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null) {
            rDlg.OnClose(2);
        }
    }

    private void OnHelp() {
        if (this.GetCurTreePanel() != null) {
            this.GetCurTreePanel().OnHelp();
        }
    }

    protected CTreeCtrl GetTreeCtrl() {
        return this.m_cTreeCtrl;
    }

    @Override
    public void valueChanged(TreeSelectionEvent rTreeEvent) {
        TreePath rNewTreePath;
        if (rTreeEvent != null && (rNewTreePath = rTreeEvent.getNewLeadSelectionPath()) != null && this.GetTreeCtrl() != null) {
            String sSelTreePath = this.GetTreeCtrl().FormatTreePath(rNewTreePath);
            if (this.GetTreePanels() != null) {
                CRhinoPrefsTreePanel cNewPanel = this.GetTreePanels().get(sSelTreePath);
                boolean bChangePanel = true;
                if (this.GetCurTreePanel() != null) {
                    bChangePanel = this.GetCurTreePanel().ValidatePage();
                }
                if (bChangePanel) {
                    this.SetStoredTreePath(sSelTreePath);
                    this.SetCurTreePanel(cNewPanel);
                } else {
                    this.GetTreeCtrl().SetSelectionPath(this.GetKey(this.GetCurTreePanel()));
                }
            }
        }
    }

    protected LinkedHashMap<String, CRhinoPrefsTreePanel> GetTreePanels() {
        return this.m_aTreePanels;
    }

    protected String GetKey(CRhinoPrefsTreePanel rTreePanel) {
        String sRetKey = null;
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
        if (aTreePanels != null) {
            Set<String> aKeys = aTreePanels.keySet();
            for (String sKey : aKeys) {
                if (sKey == null || sKey.isEmpty() || aTreePanels.get(sKey) != rTreePanel) continue;
                sRetKey = sKey;
                break;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, aTreePanels = null");
        }
        return sRetKey;
    }

    protected boolean AddTreePanel(String sKey, CRhinoPrefsTreePanel rTreePanel) {
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels;
        boolean bAdded = false;
        if (sKey != null && rTreePanel != null && (aTreePanels = this.GetTreePanels()) != null) {
            CRhinoPrefsTreePanel objVal;
            boolean bCanAdd = true;
            if (aTreePanels.containsKey(sKey = CTreeCtrlModel.FormatTreePath(sKey, "DEFAULT_ROOT")) && (objVal = aTreePanels.get(sKey)) != null) {
                bCanAdd = false;
            }
            if (bCanAdd) {
                aTreePanels.put(sKey, rTreePanel);
                bAdded = true;
            }
        }
        return bAdded;
    }

    protected CRhinoPrefsTreePanel GetCurTreePanel() {
        return this.m_cCurTreePanel;
    }

    protected JPanel GetDynamicPanel() {
        return this.m_cDynamicPanel;
    }

    private void SetCurTreePanel(CRhinoPrefsTreePanel rNewPanel) {
        if (this.GetDynamicPanel() != null) {
            if (this.GetCurTreePanel() != null) {
                this.GetCurTreePanel().setVisible(false);
                this.GetDynamicPanel().remove(this.GetCurTreePanel());
            }
            this.m_cCurTreePanel = rNewPanel;
            if (this.GetCurTreePanel() != null) {
                this.GetCurTreePanel().setVisible(true);
                this.GetDynamicPanel().add("Center", this.GetCurTreePanel());
                this.GetDynamicPanel().validate();
            }
        }
    }

    protected JLabel GetTreeLabelCtrl() {
        return this.m_cTreeLabelCtrl;
    }

    protected JScrollPane GetTreePaneCtrl() {
        return this.m_cTreePaneCtrl;
    }

    protected JLabel GetLogoCtrl() {
        return this.m_cLogoCtrl;
    }

    protected JLabel GetResellerLogoCtrl() {
        return this.m_cResellerLogoCtrl;
    }

    protected CTwoToneLabel GetFooterTitleCtrl() {
        return this.m_cFooterTitleCtrl;
    }

    private CLinkLabel CreateLinkLabel(CMainFrame rFrame, String sURL) {
        CLinkLabel cLinkLabel = new CLinkLabel(rFrame, sURL){

            @Override
            protected void paintComponent(Graphics rGraphics) {
                Graphics2D g2d = (Graphics2D)rGraphics;
                Paint oldPaint = g2d.getPaint();
                int nWidth = this.getWidth();
                int nHeight = this.getHeight();
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, nWidth, nHeight, Color.WHITE, true);
                g2d.setPaint(paint);
                g2d.fillRect(0, 0, nWidth, nHeight);
                g2d.setPaint(oldPaint);
                super.paintComponent(rGraphics);
            }
        };
        return cLinkLabel;
    }
}

