/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import java.util.LinkedHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CTreeCtrlModel
extends DefaultTreeModel {
    public static final String DELIMITER = ",";
    private String m_sRootKey;
    private LinkedHashMap m_TreeNodes;

    protected CTreeCtrlModel() {
        super(null);
    }

    public CTreeCtrlModel(DefaultMutableTreeNode jRootNode) {
        super(jRootNode);
        this.m_TreeNodes = new LinkedHashMap();
        this.m_sRootKey = jRootNode.toString();
        this.m_TreeNodes.put(this.m_sRootKey, jRootNode);
    }

    public void PrintMap() {
        for (String sKey : this.m_TreeNodes.keySet()) {
            DefaultMutableTreeNode jNode = (DefaultMutableTreeNode)this.m_TreeNodes.get(sKey);
            System.out.println("Key: " + sKey + "   Value: " + jNode.toString());
        }
        System.out.println();
    }

    public String FormatTreePath(String sTreePath) {
        return CTreeCtrlModel.FormatTreePath(sTreePath, this.m_sRootKey);
    }

    public static String FormatTreePath(String sTreePath, String sRootLabel) {
        StringBuilder sbFormattedPath = new StringBuilder(sTreePath);
        int nFoundPos = sbFormattedPath.indexOf("[");
        if (nFoundPos > -1) {
            sbFormattedPath.deleteCharAt(nFoundPos);
        }
        if ((nFoundPos = sbFormattedPath.lastIndexOf("]")) > -1) {
            sbFormattedPath.deleteCharAt(nFoundPos);
        }
        while (sbFormattedPath.charAt(0) == ' ') {
            sbFormattedPath.deleteCharAt(0);
        }
        while (sbFormattedPath.charAt(sbFormattedPath.length() - 1) == ' ') {
            sbFormattedPath.deleteCharAt(sbFormattedPath.length() - 1);
        }
        nFoundPos = sbFormattedPath.indexOf(DELIMITER);
        while (nFoundPos > -1) {
            while (sbFormattedPath.charAt(nFoundPos + 1) == ' ') {
                sbFormattedPath.deleteCharAt(nFoundPos + 1);
            }
            nFoundPos = sbFormattedPath.indexOf(DELIMITER, nFoundPos + 1);
        }
        String sRootTemp = sbFormattedPath.toString();
        nFoundPos = sbFormattedPath.indexOf(DELIMITER);
        if (nFoundPos > -1) {
            sRootTemp = sbFormattedPath.substring(0, nFoundPos);
        }
        if ((nFoundPos = sRootTemp.indexOf(sRootLabel)) < 0) {
            sbFormattedPath.insert(0, sRootLabel + DELIMITER);
        }
        return sbFormattedPath.toString();
    }

    public DefaultMutableTreeNode GetRoot() {
        return this.GetNode(this.m_sRootKey, false);
    }

    public DefaultMutableTreeNode GetNode(String sTreePath) {
        return this.GetNode(sTreePath, true);
    }

    private DefaultMutableTreeNode GetNode(String sTreePath, boolean bFormatTreePath) {
        DefaultMutableTreeNode jTreeNode = null;
        if (sTreePath != null) {
            if (bFormatTreePath) {
                sTreePath = this.FormatTreePath(sTreePath);
            }
            if (this.m_TreeNodes != null) {
                jTreeNode = (DefaultMutableTreeNode)this.m_TreeNodes.get(sTreePath);
            }
        }
        return jTreeNode;
    }

    public boolean AddNode(String sTreePath) {
        boolean bAdded = false;
        if (this.CreateNode(sTreePath, true) != null) {
            bAdded = true;
        }
        return bAdded;
    }

    public boolean RemoveNode(String sRemoveTreePath) throws NullPointerException {
        DefaultMutableTreeNode jRemoveChild;
        boolean bRemoved = false;
        if (sRemoveTreePath != null && (jRemoveChild = this.GetNode(sRemoveTreePath = this.FormatTreePath(sRemoveTreePath))) != null) {
            String sParentPath = null;
            int nFound = sRemoveTreePath.lastIndexOf(DELIMITER);
            if (nFound > -1) {
                sParentPath = sRemoveTreePath.substring(0, nFound);
            }
            if (sParentPath != null) {
                DefaultMutableTreeNode jParent = this.GetNode(sParentPath);
                if (jParent != null) {
                    if (this.m_TreeNodes != null) {
                        DefaultMutableTreeNode jChild = null;
                        int nChildCount = jRemoveChild.getChildCount();
                        for (int nIdx = 0; nIdx < nChildCount; ++nIdx) {
                            jChild = (DefaultMutableTreeNode)jRemoveChild.getChildAt(nIdx);
                            if (jChild == null) continue;
                            String sRemoveChild = sRemoveTreePath + DELIMITER + jChild.toString();
                            this.m_TreeNodes.remove(sRemoveChild);
                        }
                        this.m_TreeNodes.remove(sRemoveTreePath);
                    }
                    this.removeNodeFromParent(jRemoveChild);
                    this.reload(jParent);
                    bRemoved = true;
                } else {
                    throw new NullPointerException();
                }
            }
        }
        return bRemoved;
    }

    private DefaultMutableTreeNode CreateNode(String sTreePath, boolean bFormatTreePath) {
        DefaultMutableTreeNode jChild = this.GetNode(sTreePath, bFormatTreePath);
        if (jChild == null && sTreePath != null && sTreePath.length() > 0) {
            String sChildName;
            String sParentPath;
            DefaultMutableTreeNode jParent;
            int nFound;
            if (bFormatTreePath) {
                sTreePath = this.FormatTreePath(sTreePath);
            }
            if ((nFound = sTreePath.lastIndexOf(DELIMITER)) > -1 && (jParent = this.CreateNode(sParentPath = sTreePath.substring(0, nFound), false)) != null && (sChildName = sTreePath.substring(nFound + 1, sTreePath.length())) != null && sChildName.length() > 0) {
                jChild = new DefaultMutableTreeNode(sChildName);
                if (this.m_TreeNodes != null) {
                    this.m_TreeNodes.put(sTreePath, jChild);
                }
                this.insertNodeInto(jChild, jParent, jParent.getChildCount());
                this.reload(jParent);
            }
        }
        return jChild;
    }

    protected LinkedHashMap GetHashMap() {
        return this.m_TreeNodes;
    }
}

