/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.events.dragdrop;

import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNode;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.events.dragdrop.CDragDropInfo;
import com.rhinosoft.fvjv.gui.events.dragdrop.CDragDropTransferable;
import com.rhinosoft.fvjv.gui.events.dragdrop.ICompleteDragDrop;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserTree;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class CDragDropHandler
extends TransferHandler {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    private static final boolean DEBUG_TRACE_METHODS;
    public static final boolean DEBUG_TRACK_CURSOR_FLICKER = false;
    public static final boolean DEBUG_TRACK_CREATE_TRANSFERRABLE = false;
    public static final boolean DEBUG_TRACK_CAN_IMPORT = false;
    public static final boolean DEBUG_TRACK_CAN_IMPORT_DATAFLAVORS = false;
    public static final boolean DEBUG_TRACK_IMPORT_DATA = false;
    public static final boolean DEBUG_TRACK_EXPORT_DONE = false;
    public static final boolean DEBUG_TRACK_DROP_ACTION = false;
    public static final boolean DEBUG_TRACK_DRIVES = false;
    public static final boolean DEBUG_TRACK_MAC = false;
    public static final boolean DEBUG_DROP_ACTION_NIX = false;
    public static final boolean DEBUG_DROP_ACTION_MAC = false;
    public static final boolean DEBUG_DROP_ACTION_WINDOWS = false;
    public static final boolean DEBUG_TRACK_RIGHT_CLICK = false;
    private DataFlavor m_DataFlavorSupported = new DataFlavor(CDragDropInfo.class, "CDragDropInfo");
    private CFile m_fActualDropTarget;
    private CFile m_fDirDropTarget;
    private CDragDropInfo m_rDragInfo;
    private int m_nTransferableCounter = 0;
    private int m_nExportDoneCounter = 0;
    private int m_nCanImportCounter = 0;
    private int m_nImportDataCounter = 0;

    public CDragDropHandler() {
        this.InitVars();
    }

    public void InitVars() {
        this.m_fActualDropTarget = null;
        this.m_fDirDropTarget = null;
        this.m_rDragInfo = null;
    }

    private void ResetVars(Component rComp) {
        if (rComp instanceof JComponent) {
            ((JComponent)rComp).putClientProperty("DndRightClick", null);
        }
        this.InitVars();
        CRhinoEvent rEvent = new CRhinoEvent(rComp, 9146);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    @Override
    protected Transferable createTransferable(JComponent rComp) {
        CDragDropTransferable rTransferable = new CDragDropTransferable();
        if (rComp != null) {
            CDragDropInfo rTransferData = null;
            int[] anSelRows = null;
            CFileModel rFileModel = null;
            if (rComp instanceof CTableViewport) {
                CTableViewport rViewport = (CTableViewport)rComp;
                rComp = rViewport.GetShowComp();
            }
            if (rComp instanceof JTable) {
                JTable rTable = (JTable)rComp;
                anSelRows = rTable.getSelectedRows();
                TableModel rTableModel = rTable.getModel();
                if (rTableModel instanceof CFileModel) {
                    rFileModel = (CFileModel)rTableModel;
                }
            } else if (rComp instanceof JList) {
                JList rList = (JList)rComp;
                anSelRows = rList.getSelectedIndices();
                ListModel rListModel = rList.getModel();
                if (rListModel instanceof CFileModel) {
                    rFileModel = (CFileModel)rListModel;
                }
            }
            if (anSelRows != null && anSelRows.length > 0 && rFileModel != null) {
                rTransferData = new CDragDropInfo();
                boolean bIsSearch = false;
                CBrowserPanel rPanel = (CBrowserPanel)SwingUtilities.getAncestorOfClass(CBrowserPanel.class, rComp);
                if (rPanel != null) {
                    bIsSearch = rPanel.IsSearch();
                }
                rTransferData.SetIsSearch(bIsSearch);
                CFile fDisplayFile = rFileModel.GetDisplayFile();
                rTransferData.SetDragSourceDir(fDisplayFile.CreatePath());
                Object objVal = rComp.getClientProperty("DndRightClick");
                Boolean bVal = CConversionUtils.ConvertToBool(objVal);
                if (bVal != null) {
                    rTransferData.SetRightClick(bVal);
                }
                for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                    CFile fNextFile;
                    int nNextSelRow = anSelRows[nIdx];
                    if (rFileModel == null || (fNextFile = rFileModel.GetFileAt(nNextSelRow)) == null) continue;
                    CPath rTemp = fNextFile.CreatePath(false);
                    rTransferData.AddItem(rTemp);
                }
                rTransferable.SetTransferData(rTransferData);
            } else if (rComp instanceof JTree) {
                JTree rTree = (JTree)rComp;
                CBrowserTree rBrowser = (CBrowserTree)SwingUtilities.getAncestorOfClass(CBrowserTree.class, rComp);
                if (rBrowser != null) {
                    Object objVal;
                    Boolean bVal;
                    rTransferData = new CDragDropInfo();
                    CFile fSelFile = rBrowser.GetSelectedFile();
                    if (fSelFile.GetParent() != null) {
                        rTransferData.SetDragSourceDir(fSelFile.GetParent().CreatePath());
                    }
                    if ((bVal = CConversionUtils.ConvertToBool(objVal = rComp.getClientProperty("DndRightClick"))) != null) {
                        rTransferData.SetRightClick(bVal);
                    }
                    rTransferData.AddItem(fSelFile.CreatePath(true));
                    rTransferable.SetTransferData(rTransferData);
                }
            }
        }
        return rTransferable;
    }

    @Override
    public int getSourceActions(JComponent rComp) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CDragDropHandler.getSourceActions");
            System.out.println("    " + rComp.toString());
        }
        return 3;
    }

    @Override
    protected void exportDone(JComponent rComp, Transferable rTransferable, int nAction) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CDragDropHandler.exportDone");
            System.out.println("  " + rComp.toString());
            System.out.println("  " + rTransferable.toString());
        }
        this.ResetVars(rComp);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport rInfo) {
        boolean bCanImport = false;
        if (rInfo.isDrop()) {
            if (rInfo.isDataFlavorSupported(this.m_DataFlavorSupported) || rInfo.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                TransferHandler.DropLocation rDropLoc = rInfo.getDropLocation();
                this.m_fActualDropTarget = this.GetDropTarget(rDropLoc, rInfo.getComponent(), true);
                this.m_fDirDropTarget = this.GetDropTarget(this.m_fActualDropTarget);
                this.AdjustCursor(rInfo, this.m_fDirDropTarget);
                bCanImport = this.CanImport(rInfo, this.m_fDirDropTarget);
            } else if (rInfo.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                TransferHandler.DropLocation rDropLoc = rInfo.getDropLocation();
                this.m_fActualDropTarget = this.GetDropTarget(rDropLoc, rInfo.getComponent(), true);
                this.m_fDirDropTarget = this.GetDropTarget(this.m_fActualDropTarget);
                this.AdjustCursor(rInfo, this.m_fDirDropTarget);
                bCanImport = this.CanImport(rInfo, this.m_fDirDropTarget);
            }
        }
        if (this.GetDragSourceInfo(rInfo) != null && this.GetDragSourceInfo(rInfo).IsRightClick() && this.IsLinux()) {
            bCanImport = false;
        }
        return bCanImport;
    }

    private void AdjustCursor(TransferHandler.TransferSupport rInfo, CFile fDropTargetDir) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CDragDropHandler.AdjustCursor -->");
        }
        if (rInfo != null) {
            CPath rDragSourceDir = this.GetDragSourcePath(this.GetDragSourceInfo(rInfo));
            int nDropAction = this.GetDropAction(rInfo, rDragSourceDir, fDropTargetDir);
            if (rInfo.isDrop()) {
                if ((nDropAction & 1) == 1) {
                    if ((1 & rInfo.getSourceDropActions()) != 1) {
                        nDropAction = 0;
                    }
                } else if ((nDropAction & 2) == 2) {
                    if ((2 & rInfo.getSourceDropActions()) != 2) {
                        nDropAction = 0;
                    }
                } else if ((nDropAction & 0x40000000) == 0x40000000) {
                    if ((0x40000000 & rInfo.getSourceDropActions()) != 0x40000000) {
                        nDropAction = 0;
                    }
                } else {
                    nDropAction = 0;
                }
            }
            try {
                rInfo.setDropAction(nDropAction);
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
        } else if (DEBUG) {
            System.out.println("rInfo == null");
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CDragDropHandler.AdjustCursor <--");
        }
    }

    private int GetDropAction(TransferHandler.TransferSupport rInfo, CPath rDragSourceDir, CPath rDropTargetDir) {
        int nRetDropAction = 0;
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            if (CFileSystemUtils.GetFileSysUtils().IsNIX()) {
                nRetDropAction = this.GetDropActionLinux(rInfo, rDragSourceDir, rDropTargetDir);
            } else if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                nRetDropAction = this.GetDropActionMac(rInfo, rDragSourceDir, rDropTargetDir);
            } else if (CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                nRetDropAction = this.GetDropActionWindows(rInfo, rDragSourceDir, rDropTargetDir);
            }
        }
        return nRetDropAction;
    }

    private int GetDropActionLinux(TransferHandler.TransferSupport rInfo, CPath rDragSourceDir, CPath rDropTargetDir) {
        int nRetDropAction = 0;
        if (rInfo != null && rDragSourceDir != null && rDropTargetDir != null) {
            int nDropAction;
            nRetDropAction = nDropAction = rInfo.getUserDropAction();
            boolean bIsSameFileSystem = false;
            boolean bIsSameDrive = false;
            if (rDragSourceDir.IsLocal() && rDropTargetDir.IsLocal() || !rDragSourceDir.IsLocal() && !rDropTargetDir.IsLocal()) {
                bIsSameFileSystem = true;
                String sFileSep = "/";
                if (rDragSourceDir.IsLocal()) {
                    sFileSep = File.separator;
                }
                String sDragDrive = CString.GetDrive(rDragSourceDir.GetPath(), sFileSep);
                String sDropDrive = CString.GetDrive(rDropTargetDir.GetPath(), sFileSep);
                if (sDragDrive != null && sDropDrive != null && sDragDrive.equals(sDropDrive)) {
                    bIsSameDrive = true;
                }
            }
            if ((nDropAction & 1) == 1) {
                if (rInfo.isDataFlavorSupported(this.m_DataFlavorSupported)) {
                    if (!bIsSameFileSystem) {
                        nRetDropAction = 2;
                    }
                } else if (bIsSameFileSystem) {
                    nRetDropAction = 2;
                }
            } else if ((nDropAction & 2) == 2) {
                if (rInfo.isDataFlavorSupported(this.m_DataFlavorSupported)) {
                    if (!bIsSameFileSystem) {
                        nRetDropAction = 1;
                    }
                } else if (bIsSameFileSystem) {
                    nRetDropAction = 1;
                }
            } else {
                nRetDropAction = 0;
            }
        }
        return nRetDropAction;
    }

    private int GetDropActionMac(TransferHandler.TransferSupport rInfo, CPath rDragSourceDir, CPath rDropTargetDir) {
        int nRetDropAction = 0;
        if (rInfo != null && rDropTargetDir != null) {
            int nDropAction;
            nRetDropAction = nDropAction = rInfo.getUserDropAction();
            boolean bIsSupported = false;
            boolean bIsSameFileSystem = true;
            if (rInfo.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                bIsSupported = true;
                if (!rDropTargetDir.IsLocal()) {
                    bIsSameFileSystem = false;
                }
            } else if (rInfo.isDataFlavorSupported(this.m_DataFlavorSupported)) {
                bIsSupported = true;
                if (rDragSourceDir != null && (rDragSourceDir.IsLocal() && !rDropTargetDir.IsLocal() || !rDragSourceDir.IsLocal() && rDropTargetDir.IsLocal())) {
                    bIsSameFileSystem = false;
                }
            }
            if (bIsSupported) {
                if ((nDropAction & 1) != 1) {
                    if ((nDropAction & 2) == 2) {
                        if (!bIsSameFileSystem) {
                            nRetDropAction = 1;
                        }
                    } else {
                        nRetDropAction = 0;
                    }
                }
            } else {
                nRetDropAction = 0;
            }
        }
        return nRetDropAction;
    }

    private int GetDropActionWindows(TransferHandler.TransferSupport rInfo, CPath rDragSourceDir, CPath rDropTargetDir) {
        int nRetDropAction = 0;
        if (rInfo != null && rDragSourceDir != null && rDropTargetDir != null) {
            int nDropAction;
            nRetDropAction = nDropAction = rInfo.getUserDropAction();
            boolean bIsSameFileSystem = false;
            boolean bIsSameDrive = false;
            if (rDragSourceDir.IsLocal() && rDropTargetDir.IsLocal() || !rDragSourceDir.IsLocal() && !rDropTargetDir.IsLocal()) {
                bIsSameFileSystem = true;
                String sFileSep = "/";
                if (rDragSourceDir.IsLocal()) {
                    sFileSep = File.separator;
                }
                String sDragDrive = CString.GetDrive(rDragSourceDir.GetPath(), sFileSep);
                String sDropDrive = CString.GetDrive(rDropTargetDir.GetPath(), sFileSep);
                if (sDragDrive != null && sDropDrive != null && sDragDrive.equals(sDropDrive)) {
                    bIsSameDrive = true;
                } else if (!rDragSourceDir.IsLocal() && !rDropTargetDir.IsLocal()) {
                    bIsSameDrive = true;
                }
            }
            if ((nDropAction & 1) == 1) {
                if (!bIsSameFileSystem || !bIsSameDrive) {
                    nRetDropAction = 2;
                }
            } else if ((nDropAction & 2) == 2) {
                if (!bIsSameFileSystem || !bIsSameDrive) {
                    nRetDropAction = 1;
                }
            } else {
                nRetDropAction = 0;
            }
        }
        return nRetDropAction;
    }

    private boolean CanImport(TransferHandler.TransferSupport rInfo, CPath rDropTargetDir) {
        boolean bCanImport = false;
        if (rInfo != null && rDropTargetDir != null) {
            if (this.IsMac() && rInfo.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                bCanImport = true;
            } else {
                CDragDropInfo rDragInfo = this.GetDragSourceInfo(rInfo);
                CPath rDragSourceDir = this.GetDragSourcePath(rDragInfo);
                if (rDragSourceDir != null && rDropTargetDir != null && rDropTargetDir.IsDir() && this.IsValidDrop(rDragInfo, rDropTargetDir)) {
                    bCanImport = rDragSourceDir.IsLocal() || rDropTargetDir.IsLocal() || (rInfo.getDropAction() & 1) != 1;
                }
            }
            if (bCanImport && this.GetActualDropTarget() != null && this.GetActualDropTarget().IsDir()) {
                rInfo.setShowDropLocation(true);
            } else {
                rInfo.setShowDropLocation(false);
            }
        }
        return bCanImport;
    }

    private boolean IsValidDrop(CDragDropInfo rDragInfo, CPath rDropTargetDir) {
        boolean bCanDrop = true;
        if (rDragInfo != null && rDropTargetDir != null) {
            CPath rDragSourceDir = rDragInfo.GetDragSourceDir();
            if (rDragSourceDir != null && this.IsSamePath(rDragSourceDir.GetPath(), rDropTargetDir.GetPath())) {
                bCanDrop = false;
            }
            for (int nIdx = 0; nIdx < rDragInfo.GetItemCount(); ++nIdx) {
                CPath rDragItem = rDragInfo.GetItem(nIdx);
                if (rDragItem == null || !rDragItem.IsDir() || !this.IsChildPath(rDragItem.GetPath(), rDropTargetDir.GetPath())) continue;
                bCanDrop = false;
            }
        }
        return bCanDrop;
    }

    private boolean IsSamePath(String sAbsDragSource, String sAbsDropTarget) {
        boolean bIsSamePath = false;
        if (sAbsDragSource != null && sAbsDropTarget != null && sAbsDragSource.equals(sAbsDropTarget)) {
            bIsSamePath = true;
        }
        return bIsSamePath;
    }

    private boolean IsChildPath(String sAbsDragSource, String sAbsDropTarget) {
        boolean bIsChild = false;
        if (sAbsDragSource != null && sAbsDropTarget != null && sAbsDropTarget.startsWith(sAbsDragSource)) {
            bIsChild = true;
        }
        return bIsChild;
    }

    private CDragDropInfo GetDragSourceInfo(TransferHandler.TransferSupport rInfo) {
        block14: {
            block18: {
                List afFileList;
                block15: {
                    block17: {
                        if (this.m_rDragInfo != null) break block14;
                        if (!rInfo.isDataFlavorSupported(this.m_DataFlavorSupported)) break block17;
                        try {
                            this.m_rDragInfo = (CDragDropInfo)rInfo.getTransferable().getTransferData(this.m_DataFlavorSupported);
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block14;
                            e.printStackTrace();
                        }
                        break block14;
                    }
                    if (!rInfo.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) break block18;
                    afFileList = null;
                    try {
                        afFileList = (List)rInfo.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
                if (afFileList == null || afFileList.size() <= 0) break block14;
                this.m_rDragInfo = new CDragDropInfo();
                CPath rPath = null;
                for (int nIdx = 0; nIdx < afFileList.size(); ++nIdx) {
                    File fParent;
                    rPath = null;
                    File fFile = (File)afFileList.get(nIdx);
                    if (fFile == null) continue;
                    if (nIdx == 0 && (fParent = fFile.getParentFile()) != null && fParent.exists()) {
                        rPath = new CPath(fParent.getAbsolutePath(), fParent.isDirectory(), true);
                        rPath.SetSize(fParent.length());
                        this.m_rDragInfo.SetDragSourceDir(rPath);
                        rPath = null;
                    }
                    rPath = new CPath(fFile.getAbsolutePath(), fFile.isDirectory(), true);
                    rPath.SetSize(fFile.length());
                    this.m_rDragInfo.AddItem(rPath);
                }
                break block14;
            }
            if (rInfo.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String sFileURIs;
                block16: {
                    sFileURIs = null;
                    try {
                        sFileURIs = (String)rInfo.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block16;
                        e.printStackTrace();
                    }
                }
                if (sFileURIs != null && !sFileURIs.isEmpty()) {
                    String[] asFileURIs;
                    this.m_rDragInfo = new CDragDropInfo();
                    String sDelimiter = "\n";
                    int nFirstIdx = sFileURIs.indexOf(10);
                    if (nFirstIdx - 1 > 0 && sFileURIs.charAt(nFirstIdx - 1) == '\r') {
                        sDelimiter = "\r\n";
                    }
                    if ((asFileURIs = sFileURIs.split(sDelimiter)) != null) {
                        CPath rPath = null;
                        for (int nIdx = 0; nIdx < asFileURIs.length; ++nIdx) {
                            File fParent;
                            File fFile;
                            String sFileURI = asFileURIs[nIdx];
                            rPath = null;
                            if (sFileURI == null || sFileURI.isEmpty() || (fFile = new File(URI.create(sFileURI))) == null) continue;
                            if (nIdx == 0 && (fParent = fFile.getParentFile()) != null && fParent.exists()) {
                                rPath = new CPath(fParent.getAbsolutePath(), fParent.isDirectory(), true);
                                rPath.SetSize(fParent.length());
                                this.m_rDragInfo.SetDragSourceDir(rPath);
                                rPath = null;
                            }
                            rPath = new CPath(fFile.getAbsolutePath(), fFile.isDirectory(), true);
                            rPath.SetSize(fFile.length());
                            this.m_rDragInfo.AddItem(rPath);
                        }
                    }
                }
            }
        }
        return this.m_rDragInfo;
    }

    private CPath GetDragSourcePath(CDragDropInfo rDragInfo) {
        CPath rDragSourceDir = null;
        if (rDragInfo != null) {
            rDragSourceDir = rDragInfo.GetDragSourceDir();
        }
        return rDragSourceDir;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport rInfo) {
        boolean bImported = false;
        if (this.canImport(rInfo) && rInfo.isDrop()) {
            CDragDropInfo rDragInfo = this.GetDragSourceInfo(rInfo);
            if (this.IsMac() && rInfo.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.m_rDragInfo = null;
                rDragInfo = this.GetDragSourceInfo(rInfo);
            }
            if (rDragInfo != null) {
                CPath rDragSourceDir = rDragInfo.GetDragSourceDir();
                TransferHandler.DropLocation rDropLoc = rInfo.getDropLocation();
                CFile fActualDropTarget = this.GetDropTarget(rDropLoc, rInfo.getComponent(), false);
                CFile fDropTargetDir = this.GetDropTarget(fActualDropTarget);
                if (rDragSourceDir != null && fDropTargetDir != null) {
                    ICompleteDragDrop rCompleteComp;
                    CTableViewport rViewport;
                    boolean bMoveFiles = (rInfo.getDropAction() & 2) == 2;
                    Point ptDropLoc = rDropLoc.getDropPoint();
                    JTable rTargetTable = null;
                    Component rComp = rInfo.getComponent();
                    if (rComp instanceof JTable) {
                        rTargetTable = (JTable)rComp;
                    } else if (rComp instanceof CTableViewport && (rViewport = (CTableViewport)rComp).GetShowComp() instanceof JTable) {
                        rTargetTable = (JTable)rViewport.GetShowComp();
                    }
                    if (rTargetTable != null && rTargetTable.getTableHeader() != null) {
                        ptDropLoc.y += rTargetTable.getTableHeader().getHeight();
                    }
                    if ((rCompleteComp = (ICompleteDragDrop)((Object)SwingUtilities.getAncestorOfClass(ICompleteDragDrop.class, rInfo.getComponent()))) != null) {
                        rCompleteComp.CompleteDragDrop(rDragSourceDir, fDropTargetDir.CreatePath(), rDragInfo.GetItems(), bMoveFiles, rDragInfo.IsSearch(), rDragInfo.IsRightClick(), ptDropLoc);
                    }
                }
            }
        }
        this.ResetVars(rInfo.getComponent());
        return bImported;
    }

    private CFile GetActualDropTarget() {
        return this.m_fActualDropTarget;
    }

    private CFile GetDropTarget(TransferHandler.DropLocation rDropLoc, Component rDropComp, boolean bIsDragOver) {
        CLocalFile fLocal;
        File fLinkTarget;
        CPath fDropTarget = null;
        if (rDropLoc != null && rDropComp != null) {
            TransferHandler.DropLocation rDropLocEx;
            if (rDropComp instanceof CTableViewport) {
                CTableViewport rViewport = (CTableViewport)rDropComp;
                CFilePanel rFilePanel = (CFilePanel)SwingUtilities.getAncestorOfClass(CFilePanel.class, rViewport);
                if (rFilePanel != null) {
                    fDropTarget = rFilePanel.GetDisplayFile();
                }
            } else if (rDropLoc instanceof JList.DropLocation) {
                JList rList;
                rDropLocEx = (JList.DropLocation)rDropLoc;
                int nIdx = ((JList.DropLocation)rDropLocEx).getIndex();
                if (rDropComp instanceof JList && (rList = (JList)rDropComp).getModel() instanceof CFileModel) {
                    CFileModel rModel = (CFileModel)rList.getModel();
                    if (nIdx >= 0 && nIdx < rModel.getSize()) {
                        fDropTarget = rModel.GetFileAt(nIdx);
                    } else {
                        CFilePanel rFilePanel = (CFilePanel)SwingUtilities.getAncestorOfClass(CFilePanel.class, rList);
                        if (rFilePanel != null) {
                            fDropTarget = rFilePanel.GetDisplayFile();
                        }
                    }
                }
            } else if (rDropLoc instanceof JTable.DropLocation) {
                JTable rTable;
                rDropLocEx = (JTable.DropLocation)rDropLoc;
                int nRow = ((JTable.DropLocation)rDropLocEx).getRow();
                if (rDropComp instanceof JTable && (rTable = (JTable)rDropComp).getModel() instanceof CFileModel) {
                    CFileModel rModel = (CFileModel)rTable.getModel();
                    fDropTarget = rModel.GetFileAt(nRow);
                }
            } else if (rDropLoc instanceof JTree.DropLocation) {
                rDropLocEx = (JTree.DropLocation)rDropLoc;
                if (rDropComp instanceof JTree) {
                    CFileTreeNode rFileNode;
                    CFile fDropTargetDir;
                    Object rNode;
                    TreePath rTreePath;
                    JTree rTree = (JTree)rDropComp;
                    CBrowserTree rBrowser = (CBrowserTree)SwingUtilities.getAncestorOfClass(CBrowserTree.class, rDropComp);
                    if (rBrowser != null) {
                        rBrowser.SetIsDragOver(bIsDragOver);
                    }
                    if ((rTreePath = ((JTree.DropLocation)rDropLocEx).getPath()) != null && (rNode = rTreePath.getLastPathComponent()) != null && rNode instanceof CFileTreeNode && (fDropTargetDir = (rFileNode = (CFileTreeNode)rNode).GetFile()) != null) {
                        fDropTarget = fDropTargetDir;
                    }
                }
            }
        }
        if (fDropTarget != null && fDropTarget.IsLocal() && (fLinkTarget = (fLocal = (CLocalFile)fDropTarget).GetLinkTarget()) != null && fLinkTarget.exists()) {
            fDropTarget = new CLocalFile(fLinkTarget);
        }
        return fDropTarget;
    }

    private CFile GetDropTarget(CFile fDropTarget) {
        if (fDropTarget != null) {
            CLocalFile fLocal;
            File fLinkTarget;
            if (fDropTarget.IsLocal() && (fLinkTarget = (fLocal = (CLocalFile)fDropTarget).GetLinkTarget()) != null && fLinkTarget.exists() && fLinkTarget.isDirectory()) {
                fDropTarget = new CLocalFile(fLinkTarget);
            }
            if (!fDropTarget.IsDir()) {
                fDropTarget = fDropTarget.GetParent();
            }
        }
        return fDropTarget;
    }

    private boolean IsMac() {
        boolean bIsMac = false;
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            bIsMac = CFileSystemUtils.GetFileSysUtils().IsMac();
        }
        return bIsMac;
    }

    private boolean IsLinux() {
        boolean bIsLinux = false;
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            bIsLinux = CFileSystemUtils.GetFileSysUtils().IsNIX();
        }
        return bIsLinux;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

