/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.event.DockableBarEvent;
import com.jidesoft.action.event.DockableBarListener;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.swing.JideSplitButton;
import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.components.files.preview.CFilePreviewPane;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseDockFrameFactory;
import com.rhinosoft.docking.fvjv.search.CSearchBar;
import com.rhinosoft.docking.fvjv.search.CSearchEvent;
import com.rhinosoft.docking.fvjv.search.ISearchListener;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.crumbbar.CBreadBar;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.frames.CFVJVCommandBar;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserFrameFactory;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserToolbar;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserTree;
import com.rhinosoft.fvjv.gui.frames.browser.CCustomPanel;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryItem;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryModel;
import com.rhinosoft.fvjv.gui.frames.browser.CNestedBrowserFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CSearchStateEvent;
import com.rhinosoft.fvjv.gui.frames.browser.IHistoryListener;
import com.rhinosoft.fvjv.gui.frames.browser.ISearchStateListener;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.CThreadMsgSearch;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.List;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class CBrowserPanel
extends CCustomPanel
implements IHistoryListener,
ComponentListener,
ISearchListener,
ISearchStateListener {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_TRACK_STARTUP_DIR;
    public static final boolean DEBUG_DUMP_FRAME_KEYS;
    public static final String STORED_LAYOUT_BROWSER_FILE_NAME = "BrowserPane";
    public static final String STORED_LAYOUT_SEPARATOR = "_";
    private CBreadBar m_cBreadBar;
    private CBrowserTree m_cTree;
    private CFilePreviewPane m_cPreviewPane;
    private CFile m_rfWorkingDir;
    private CBaseThread m_tGeneralThread;
    private CBaseThread m_tThumbThread;
    private CBaseThread m_tPreviewThread;
    private CBaseThread m_tSearchThread;
    private CFilePanel m_cFilePanel;
    private CHistoryModel m_HistoryModel;
    private String m_sPrevActiveKey;
    private CSearchBar m_cSearchBar;

    public CBrowserPanel(RootPaneContainer rootPaneContainer, long lKeyID) {
        super(rootPaneContainer, lKeyID);
        this.InitVars();
    }

    protected abstract String GetKey();

    protected abstract String GetDefLastSessionDir();

    protected abstract CBaseThread CreateThread(String var1);

    protected abstract CBaseThread CreateThreadGeneral();

    protected abstract CBaseThread CreateThreadThumbs();

    protected abstract CBaseThread CreateThreadPreview();

    protected abstract CBaseThread CreateThreadSearch();

    protected abstract boolean IsLocal();

    protected abstract CFilePanel CreateFilePanel(CBaseThread var1, CBaseThread var2, long var3);

    public CFilePanel GetFilePanel() {
        return this.m_cFilePanel;
    }

    private void InitVars() {
        this.m_tGeneralThread = this.CreateThreadGeneral();
        this.m_tThumbThread = this.CreateThreadThumbs();
        this.m_tPreviewThread = this.CreateThreadPreview();
        this.m_tSearchThread = this.CreateThreadSearch();
        long lUniqueID = -1L;
        if (CMainFrame.GET_APP() != null) {
            lUniqueID = CMainFrame.GET_APP().GetUniqueID(this.GetKey());
        }
        this.m_cFilePanel = this.CreateFilePanel(this.GetGeneralThread(), this.GetThumbThread(), lUniqueID);
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().OnCreate();
            this.GetFilePanel().AddSearchStateListener(this);
        }
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().SetFrameKey(this.GetKey());
            this.getDockingManager().getWorkspace().add(this.GetFilePanel());
            this.getDockingManager().setNestedFloatingAllowed(true);
        }
        this.m_HistoryModel = new CHistoryModel();
        if (this.GetHistoryModel() != null) {
            this.GetHistoryModel().AddHistoryListener(this);
        }
    }

    protected CBaseThread GetGeneralThread() {
        return this.m_tGeneralThread;
    }

    protected CBaseThread GetThumbThread() {
        return this.m_tThumbThread;
    }

    protected CBaseThread GetPreviewThread() {
        return this.m_tPreviewThread;
    }

    protected CBaseThread GetSearchThread() {
        return this.m_tSearchThread;
    }

    public String GetTreeFrameKey() {
        StringBuilder sRet = new StringBuilder();
        sRet.append("Tree");
        return sRet.toString();
    }

    public String GetPreviewFrameKey() {
        StringBuilder sRet = new StringBuilder();
        sRet.append("Preview");
        return sRet.toString();
    }

    protected CBreadBar GetBreadBar() {
        return this.m_cBreadBar;
    }

    public void SetBreadBar(CBreadBar rBar) {
        this.m_cBreadBar = rBar;
        if (this.GetBreadBar() != null) {
            this.GetBreadBar().SetThread(this.GetGeneralThread());
            this.GetBreadBar().addComponentListener(this);
        }
    }

    public CBrowserTree GetTree() {
        return this.m_cTree;
    }

    public void SetTree(CBrowserTree rTree) {
        this.m_cTree = rTree;
        if (this.GetTree() != null) {
            this.GetTree().SetGeneralThread(this.GetGeneralThread());
            this.GetTree().AddSearchStateListener(this);
        }
    }

    protected CFilePreviewPane GetPreviewPane() {
        return this.m_cPreviewPane;
    }

    public void SetPreviewPane(CFilePreviewPane rPreviewPane) {
        this.m_cPreviewPane = rPreviewPane;
        if (this.GetPreviewPane() != null) {
            this.GetPreviewPane().SetThread(this.GetPreviewThread());
        }
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().SetPreviewPane(rPreviewPane);
        }
    }

    @Override
    protected CBaseDockFrameFactory CreateDockFrameFactory() {
        return new CBrowserFrameFactory(this);
    }

    public CFile GetWorkingDir() {
        return this.m_rfWorkingDir;
    }

    private void SetWorkingDir(CFile fWorkingDir, Object rSource, CHistoryItem rItem) {
        DockableFrame frame;
        CFile fPrevWorkingDir = this.m_rfWorkingDir;
        this.m_rfWorkingDir = fWorkingDir;
        if (CMainFrame.GET_APP() != null && this.GetWorkingDir() != null && (frame = CMainFrame.GET_APP().getDockingManager().getFrame(this.GetKey())) != null) {
            frame.setToolTipText(fWorkingDir.GetPath());
        }
        if (this.GetHistoryModel() != null) {
            if (rItem != null) {
                this.GetHistoryModel().OnSelectItem(rItem);
            } else if (fPrevWorkingDir != null) {
                rItem = new CHistoryItem(fPrevWorkingDir, 2112);
                this.GetHistoryModel().OnUpdateWorkingDir(rItem);
                if (this.m_rfWorkingDir != null) {
                    rItem = new CHistoryItem(this.m_rfWorkingDir, 2112);
                    this.GetHistoryModel().OnUpdateWorkingDir(rItem);
                }
            }
            this.GetHistoryModel().UpdateBtnStates();
        }
        this.SetBtnEnabled(2114, fWorkingDir.IsUpDirEnabled());
    }

    protected void LoadWorkingDir(boolean bLoadDefaultDir) {
        String sLastWorkingDir = this.GetLastSessionDir(bLoadDefaultDir);
        if (sLastWorkingDir != null && !sLastWorkingDir.isEmpty()) {
            if (DEBUG_TRACK_STARTUP_DIR) {
                System.out.printf("Pane: %s | StartupDir: %s\r\n", this.GetKey(), sLastWorkingDir);
            }
            if (this.GetGeneralThread() != null) {
                this.GetGeneralThread().PostListWorkingDir(this, this.GetClientInfo(), this.GetCompressionType(), new CPath(sLastWorkingDir, true, this.IsLocal()), true, false, null, null);
            }
        }
    }

    private void SaveWorkingDir() {
        if (this.GetWorkingDir() != null) {
            String sLastWorkingDir = this.GetWorkingDir().GetAbsFileName();
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetArchive() != null) {
                CMainFrame.GET_APP().GetArchive().SetValue(this.GetKey(), sLastWorkingDir, this.GetDefLastSessionDir());
            }
        }
    }

    protected String GetLastSessionDir(boolean bLoadDefaultDir) {
        String sLastSessionDir = null;
        if (!bLoadDefaultDir && CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetArchive() != null) {
            sLastSessionDir = CMainFrame.GET_APP().GetArchive().GetValue(this.GetKey(), this.GetDefLastSessionDir());
        }
        if (sLastSessionDir == null || sLastSessionDir.isEmpty()) {
            sLastSessionDir = this.GetDefLastSessionDir();
        }
        return sLastSessionDir;
    }

    @Override
    public void LoadStoredLayout() {
        super.LoadStoredLayout();
    }

    @Override
    protected void OnUpdateArchiveSave(AWTEvent event) {
        super.OnUpdateArchiveSave(event);
        this.SaveWorkingDir();
        this.SaveThumbSize();
    }

    @Override
    protected void OnUpdateArchiveLoad(AWTEvent event) {
        super.OnUpdateArchiveLoad(event);
        this.LoadThumbSize();
        if (CMainFrame.GET_APP() != null && this.GetArchive() != null) {
            boolean bSearchLinkTargets = false;
            Boolean bValue = this.GetArchive().GetValueBool("SearchLinkTargets", false);
            if (bValue != null) {
                bSearchLinkTargets = bValue;
            }
            if (this.GetSearchThread() != null) {
                this.GetSearchThread().SetSearchLinkTargets(bSearchLinkTargets);
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block134: {
            block133: {
                if (!(event instanceof CRhinoEvent)) break block133;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                switch (event.getID()) {
                    case 3005: {
                        Object rSource = rEvent.getSource();
                        if (this.IsEventSource(rSource) && rEvent.GetEventObj() instanceof CThreadMsg) {
                            CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                            switch (rThreadMsg.GetMsgID()) {
                                case 5: {
                                    CThreadMsgList rThreadMsgList;
                                    CPath rFromPath;
                                    if (!(rThreadMsg instanceof CThreadMsgList) || (rFromPath = (rThreadMsgList = (CThreadMsgList)rThreadMsg).GetFromPath(rThreadMsgList.GetPathIndex())) == null) break;
                                    this.OnRecvListError(rFromPath.GetPath());
                                    break;
                                }
                            }
                        }
                        this.RelayEventEx(rEvent);
                        break;
                    }
                    case 3020: {
                        if (this.GetBreadBar() != null) {
                            this.GetBreadBar().dispatchEvent(rEvent);
                        }
                        if (this.GetTree() != null) {
                            this.GetTree().dispatchEvent(rEvent);
                            break;
                        }
                        break block134;
                    }
                    case 9115: {
                        Object obj = rEvent.GetEventObj();
                        if (obj instanceof Boolean) {
                            Boolean bVal = (Boolean)obj;
                            this.LoadWorkingDir(bVal);
                            break;
                        }
                        break block134;
                    }
                    case 9114: {
                        CRhinoEvent rRhinoEvent;
                        if (event instanceof CRhinoEvent && this.IsEventSource((rRhinoEvent = (CRhinoEvent)event).getSource()) && this.GetToolbar() != null) {
                            this.GetToolbar().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 2010: {
                        if (event instanceof CRhinoEvent) {
                            CRhinoEvent rRhinoEvent = (CRhinoEvent)event;
                            if (this.GetGeneralThread() != null) {
                                this.GetGeneralThread().Cancel();
                                break;
                            }
                        }
                        break block134;
                    }
                    case 6009: {
                        if (this.IsEventSource(event.getSource())) {
                            if (this.GetPreviewPane() != null) {
                                this.GetPreviewPane().dispatchEvent(event);
                            }
                            if (this.GetFilePanel() != null) {
                                this.GetFilePanel().dispatchEvent(event);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 6000: {
                        if (this.GetBreadBar() != null) {
                            this.GetBreadBar().dispatchEvent(event);
                        }
                        if (this.GetTree() != null) {
                            this.GetTree().dispatchEvent(event);
                        }
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 6002: 
                    case 6004: {
                        this.RelayEventEx(event);
                        break;
                    }
                    case 6001: 
                    case 6003: 
                    case 6005: 
                    case 6006: 
                    case 6007: {
                        CFile fParent = (CFile)rEvent.getSource();
                        if (fParent != null && (this.IsLocal() && fParent.IsLocal() || !this.IsLocal() && !fParent.IsLocal())) {
                            if (this.GetBreadBar() != null) {
                                this.GetBreadBar().dispatchEvent(event);
                            }
                            if (this.GetTree() != null) {
                                this.GetTree().dispatchEvent(event);
                            }
                            if (this.GetFilePanel() != null) {
                                this.GetFilePanel().dispatchEvent(event);
                            }
                            if (this.GetPreviewPane() != null) {
                                this.GetPreviewPane().dispatchEvent(event);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 6008: {
                        Object[] arObjs = (Object[])rEvent.GetEventObj();
                        if (this.IsEventSource(arObjs[1])) {
                            CFile fFile = null;
                            CHistoryItem rItem = null;
                            if (arObjs[0] != null && arObjs[0] instanceof CFile) {
                                fFile = (CFile)arObjs[0];
                            }
                            if (arObjs[4] != null && arObjs[4] instanceof CHistoryItem) {
                                rItem = (CHistoryItem)arObjs[4];
                            }
                            this.SetWorkingDir(fFile, arObjs[1], rItem);
                            if (this.GetBreadBar() != null) {
                                this.GetBreadBar().dispatchEvent(event);
                            }
                            if (this.GetTree() != null) {
                                this.GetTree().dispatchEvent(event);
                            }
                            if (this.GetFilePanel() != null) {
                                this.GetFilePanel().dispatchEvent(event);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 2112: 
                    case 2113: {
                        JideSplitButton rSplitBtn;
                        if (event.getID() == 2113 && this.GetToolbar() != null && (rSplitBtn = this.GetToolbar().GetForwardBtn()) != null && rSplitBtn.getPopupMenu().isVisible()) {
                            rSplitBtn.doClickOnMenu();
                        }
                        CHistoryItem rItem = null;
                        Object objSource = event.getSource();
                        if (objSource instanceof CHistoryItem) {
                            rItem = (CHistoryItem)objSource;
                        } else if (this.GetHistoryModel() != null) {
                            rItem = event.getID() == 2112 ? this.GetHistoryModel().GetNextBackItem() : this.GetHistoryModel().GetNextForwardItem();
                        }
                        if (rItem != null) {
                            Object[] anItems = new Object[]{rItem.GetFile().IsLocal(), rItem.GetFile().GetPath(), this.GetGeneralThread(), rItem};
                            CRhinoEvent rListEvent = new CRhinoEvent(this, 4000, anItems);
                            if (CMainFrame.GET_APP() != null) {
                                CMainFrame.GET_APP().dispatchEvent(rListEvent);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 2114: {
                        if (this.GetWorkingDir() != null) {
                            CFile fWorkingDir = this.GetWorkingDir().GetParent();
                            if (fWorkingDir == null && CMainFrame.GET_APP() != null) {
                                fWorkingDir = this.GetWorkingDir().IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
                            }
                            if (fWorkingDir != null) {
                                fWorkingDir.GetListing(this.GetGeneralThread(), this, false, true, false, false, null);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 2115: {
                        if (this.GetFilePanel() != null && this.GetFilePanel().IsSearch() && this.GetSearchBar() != null) {
                            this.GetSearchBar().FireSearchEvent();
                            break;
                        }
                        CFile fRefreshFile = this.GetWorkingDir();
                        if (rEvent.GetEventObj() != null && rEvent.GetEventObj() instanceof CFile) {
                            fRefreshFile = (CFile)rEvent.GetEventObj();
                        }
                        if (fRefreshFile != null) {
                            fRefreshFile.GetListing(this.GetGeneralThread(), this, true, true, true, false, null);
                        }
                        if (this.GetPreviewPane() != null) {
                            this.GetPreviewPane().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 2021: 
                    case 2022: {
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().dispatchEvent(event);
                            Object[] arFocusItems = new Object[]{this.GetKey(), null, this.GetFilePanel().GetActiveComponent()};
                            CRhinoEvent Event2 = new CRhinoEvent(this, 9200, arFocusItems);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event2);
                            break;
                        }
                        break block134;
                    }
                    case 2100: 
                    case 2101: 
                    case 2102: 
                    case 2103: 
                    case 2104: 
                    case 2105: {
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 2106: 
                    case 2107: 
                    case 2108: 
                    case 2109: 
                    case 2110: {
                        this.OnActionThumbSize(event);
                        break;
                    }
                    case 2098: 
                    case 2099: {
                        if (this.getDockingManager() != null) {
                            DockableFrame rFrame;
                            boolean bVisible = false;
                            String sKey = null;
                            sKey = event.getID() == 2098 ? this.GetTreeFrameKey() : this.GetPreviewFrameKey();
                            if (sKey != null && (rFrame = this.getDockingManager().getFrame(sKey)) != null) {
                                if (rFrame.isVisible()) {
                                    this.getDockingManager().hideFrame(sKey);
                                    break;
                                }
                                this.getDockingManager().showFrame(sKey);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 2003: 
                    case 2004: 
                    case 2005: 
                    case 2006: 
                    case 2007: 
                    case 2008: 
                    case 2009: {
                        if (this.getDockingManager() != null) {
                            DockableFrame rActiveFrame = this.getDockingManager().getActiveFrame();
                            if (rActiveFrame != null) {
                                rActiveFrame.dispatchEvent(event);
                                break;
                            }
                            if (this.GetTree() != null && this.GetTree().IsEventSource(event.getSource())) {
                                this.GetTree().dispatchEvent(event);
                                break;
                            }
                            if (this.GetFilePanel() != null) {
                                this.GetFilePanel().dispatchEvent(event);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 9020: 
                    case 9022: {
                        if (this.IsEventSource(event.getSource())) {
                            switch (event.getID()) {
                                case 9021: {
                                    this.UpdateBtnStates();
                                    break;
                                }
                                case 9023: {
                                    this.UpdateBtnSelections();
                                    break;
                                }
                            }
                            if (this.getDockingManager() != null) {
                                if (this.GetBreadBar() != null) {
                                    this.GetBreadBar().dispatchEvent(event);
                                }
                                if (this.GetToolbar() != null) {
                                    this.GetToolbar().dispatchEvent(event);
                                }
                                if (this.GetTree() != null) {
                                    this.GetTree().dispatchEvent(event);
                                }
                                if (this.GetPreviewPane() != null) {
                                    this.GetPreviewPane().dispatchEvent(event);
                                }
                                if (this.GetFilePanel() != null) {
                                    this.GetFilePanel().dispatchEvent(event);
                                    break;
                                }
                            }
                        }
                        break block134;
                    }
                    case 9021: 
                    case 9023: {
                        switch (event.getID()) {
                            case 9021: {
                                this.UpdateBtnStates();
                                break;
                            }
                            case 9023: {
                                this.UpdateBtnSelections();
                                break;
                            }
                        }
                        if (this.getDockingManager() != null) {
                            DockableFrame rActiveFrame = this.getDockingManager().getActiveFrame();
                            if (rActiveFrame != null) {
                                rActiveFrame.dispatchEvent(event);
                                break;
                            }
                            if (this.GetBreadBar() != null) {
                                this.GetBreadBar().dispatchEvent(event);
                            }
                            if (this.GetToolbar() != null) {
                                this.GetToolbar().dispatchEvent(event);
                            }
                            if (this.GetFilePanel() != null) {
                                this.GetFilePanel().dispatchEvent(event);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 9025: {
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().dispatchEvent(event);
                        }
                        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().getDockingManager() != this.getDockingManager()) {
                            if (this.GetTree() != null) {
                                this.GetTree().SetDockingManager(this.getDockingManager());
                            }
                            if (this.GetPreviewPane() != null) {
                                this.GetPreviewPane().SetDockingManager(this.getDockingManager());
                                break;
                            }
                        }
                        break block134;
                    }
                    case 9111: {
                        if (this.GetTree() != null) {
                            this.GetTree().dispatchEvent(event);
                        }
                        if (this.GetPreviewPane() != null) {
                            this.GetPreviewPane().dispatchEvent(event);
                        }
                        if (this.GetBreadBar() != null) {
                            this.GetBreadBar().dispatchEvent(event);
                        }
                        if (this.GetToolbar() != null) {
                            this.GetToolbar().dispatchEvent(event);
                        }
                        if (this.GetFilePanel() != null) {
                            Object[] anItems = (Object[])rEvent.GetEventObj();
                            Boolean bEnterRenameMode = (Boolean)anItems[1];
                            if (!(bEnterRenameMode.booleanValue() && this.IsEventSource(rEvent.getSource()) && this.GetFilePanel().IsEventSource(rEvent.getSource()))) {
                                // empty if block
                            }
                            this.GetFilePanel().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 9140: {
                        DockableFrame rActivated = (DockableFrame)rEvent.getSource();
                        DockableFrame rDeactivated = (DockableFrame)rEvent.GetEventObj();
                        this.OnUpdateFocusClrsActivated(rActivated, rDeactivated);
                        long lTime = System.currentTimeMillis();
                        if (this.GetTree() != null) {
                            this.GetTree().SetRenameMarker(lTime);
                        }
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().SetRenameMarker(lTime);
                            break;
                        }
                        break block134;
                    }
                    case 9141: {
                        this.OnDockFrameDeactivated(rEvent);
                        break;
                    }
                    case 9146: {
                        if (this.GetTree() != null) {
                            this.GetTree().dispatchEvent(event);
                        }
                        if (this.GetFilePanel() != null) {
                            this.GetFilePanel().dispatchEvent(event);
                            break;
                        }
                        break block134;
                    }
                    case 9142: {
                        this.OnDockFrameRemoved(rEvent);
                        break;
                    }
                    case 9147: {
                        Component cHasFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        if (cHasFocus != null && this.IsEventSource(cHasFocus) && CMainFrame.GET_APP() != null && CMainFrame.GET_APP().getDockingManager() != null) {
                            CMainFrame.GET_APP().getDockingManager().activateFrame(this.GetKey());
                            break;
                        }
                        break block134;
                    }
                    case 9200: {
                        this.OnSetFocus(rEvent);
                        break;
                    }
                    case 9201: {
                        if (this.IsEventSource(event.getSource()) && this.GetBreadBar() != null) {
                            this.GetBreadBar().ShowComboPopup();
                            break;
                        }
                        break block134;
                    }
                    case 2092: 
                    case 2093: {
                        String sActiveFrameKey;
                        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().getDockingManager() != null && (sActiveFrameKey = CMainFrame.GET_APP().getDockingManager().getActiveFrameKey()) != null && this.GetKey() != null && this.GetKey().equals(sActiveFrameKey) && this.getDockableBarManager() != null) {
                            DockableBar rBar;
                            boolean bVisible = false;
                            String sKey = null;
                            sKey = event.getID() == 2092 ? this.GetBreadBarKey() : this.GetToolbarKey();
                            if (sKey != null && (rBar = this.getDockableBarManager().getDockableBar(sKey)) != null) {
                                this.ShowToolbar(sKey, !rBar.isVisible());
                                break;
                            }
                        }
                        break block134;
                    }
                    case 9206: {
                        if (this.IsEventSource(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                            this.RelayEventEx(event);
                            break;
                        }
                        break block134;
                    }
                    case 8040: 
                    case 8041: 
                    case 8100: {
                        this.RelayEventEx(event);
                        break;
                    }
                    case 2023: {
                        this.OnShowSearchBar();
                        break;
                    }
                    case 2011: {
                        this.RelayEventEx(event);
                        break;
                    }
                    case 9500: {
                        CFile rFile;
                        if (this.IsEventSource(rEvent.getSource()) && (rFile = (CFile)rEvent.GetEventObj()) != null && this.GetFilePanel() != null) {
                            this.GetFilePanel().AddSearchFile(rFile);
                            break;
                        }
                        break block134;
                    }
                    case 3021: {
                        this.RelayEventEx(event);
                        if (rEvent.GetEventObj() instanceof CThreadMsgSearch && this.IsEventSource(event.getSource())) {
                            CThreadMsgSearch rSearchMsg = (CThreadMsgSearch)rEvent.GetEventObj();
                            if (this.GetSearchBar() != null) {
                                this.GetSearchBar().SetProgressRange(0, rSearchMsg.GetFromPathSize());
                                this.GetSearchBar().SetProgressIndex(rSearchMsg.GetPathIndex());
                            }
                            if (this.GetSearchThread() != null) {
                                this.GetSearchThread().PostSearchItemDone(rSearchMsg);
                                break;
                            }
                        }
                        break block134;
                    }
                    case 3022: {
                        this.RelayEventEx(event);
                        if (rEvent.GetEventObj() instanceof CThreadMsgSearch && this.IsEventSource(event.getSource())) {
                            CThreadMsgSearch rSearchMsg = (CThreadMsgSearch)rEvent.GetEventObj();
                            if (this.GetSearchBar() != null) {
                                this.GetSearchBar().HidePauseBtn();
                                this.GetSearchBar().HideProgressBar();
                                break;
                            }
                        }
                        break block134;
                    }
                    default: {
                        super.processEvent(event);
                    }
                }
                break block134;
            }
            super.processEvent(event);
        }
    }

    private CHistoryModel GetHistoryModel() {
        return this.m_HistoryModel;
    }

    @Override
    public CBrowserToolbar GetToolbar() {
        CBrowserToolbar rToolbar = null;
        if (super.GetToolbar() instanceof CBrowserToolbar) {
            rToolbar = (CBrowserToolbar)super.GetToolbar();
        }
        return rToolbar;
    }

    protected CFVJVAction GetAction(int nActionID) {
        CFVJVAction rAction = null;
        if (CMainFrame.GET_APP() != null) {
            rAction = CMainFrame.GET_APP().GetAction(nActionID);
        }
        return rAction;
    }

    @Override
    public void OnAddHistoryItem(CHistoryItem rItem) {
        int nIndex;
        JideSplitButton rInsertInto;
        if (this.GetToolbar() != null && rItem != null && (rInsertInto = this.GetToolbar().GetForwardBtn()) != null && this.GetHistoryModel() != null && (nIndex = this.GetHistoryModel().GetItemIndex(rItem)) >= 0 && nIndex < rInsertInto.getMenuComponentCount() + 1) {
            rInsertInto.insert(rItem, nIndex);
        }
    }

    @Override
    public void OnRemoveHistoryItem(CHistoryItem rItem) {
        JideSplitButton rRemoveFrom;
        if (this.GetToolbar() != null && rItem != null && (rRemoveFrom = this.GetToolbar().GetForwardBtn()) != null) {
            rRemoveFrom.remove(rItem);
        }
    }

    private CClientInfo GetClientInfo() {
        CClientInfo rInfo = null;
        if (CMainFrame.GET_APP() != null) {
            rInfo = CMainFrame.GET_APP().GetClientInfo();
        }
        return rInfo;
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetBreadBar() != null && this.GetBreadBar().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetToolbar() != null && this.GetToolbar().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetSearchBar() != null && this.GetSearchBar().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTree() != null && this.GetTree().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetPreviewPane() != null && this.GetPreviewPane().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetFilePanel() != null && this.GetFilePanel().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetHistoryModel() != null && this.GetHistoryModel().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Object[] anItems = new Object[]{nEventID, bEnabled};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    private void SetBtnSelected(int nEventID, boolean bSelected) {
        Object[] anItems = new Object[]{nEventID, bSelected};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9022, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    private void UpdateBtnStates() {
    }

    private void UpdateBtnSelections() {
        String sKey;
        Integer nEventID;
        int nIdx;
        Object[][] aItems;
        if (this.getDockingManager() != null) {
            aItems = new Object[][]{{2098, this.GetTreeFrameKey()}, {2099, this.GetPreviewFrameKey()}};
            for (nIdx = 0; nIdx < aItems.length; ++nIdx) {
                DockableFrame rFrame;
                nEventID = (Integer)aItems[nIdx][0];
                sKey = (String)aItems[nIdx][1];
                if (nEventID == null || sKey == null || (rFrame = this.getDockingManager().getFrame(sKey)) == null) continue;
                this.SetBtnSelected(nEventID, rFrame.isVisible());
            }
        }
        if (this.getDockableBarManager() != null) {
            aItems = new Object[][]{{2092, this.GetBreadBarKey()}, {2093, this.GetToolbarKey()}, {2023, this.GetSearchBarKey()}};
            for (nIdx = 0; nIdx < aItems.length; ++nIdx) {
                DockableBar rBar;
                nEventID = (Integer)aItems[nIdx][0];
                sKey = (String)aItems[nIdx][1];
                if (nEventID == null || sKey == null || (rBar = this.getDockableBarManager().getDockableBar(sKey)) == null) continue;
                this.SetBtnSelected(nEventID, rBar.isVisible());
            }
        }
    }

    public String GetBreadBarKey() {
        String sKey = null;
        if (this.GetBreadBar() != null) {
            sKey = this.GetBreadBar().getKey();
        }
        return sKey;
    }

    public String GetSearchBarKey() {
        String sKey = null;
        if (this.GetSearchBar() != null) {
            sKey = this.GetSearchBar().getKey();
        }
        return sKey;
    }

    protected String GetKeyThumbWidth() {
        return this.GetKey() + STORED_LAYOUT_SEPARATOR + "ThumbWidth";
    }

    protected String GetKeyThumbHeight() {
        return this.GetKey() + STORED_LAYOUT_SEPARATOR + "ThumbHeight";
    }

    protected int GetDefThumbWidth() {
        return 100;
    }

    protected int GetDefThumbHeight() {
        return 100;
    }

    protected IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    protected int GetStoredThumbWidth() {
        Integer nTemp;
        int nVal = this.GetDefThumbWidth();
        if (this.GetArchive() != null && (nTemp = this.GetArchive().GetValueInt(this.GetKeyThumbWidth(), this.GetDefThumbWidth())) != null) {
            nVal = nTemp;
        }
        return nVal;
    }

    protected int GetStoredThumbHeight() {
        Integer nTemp;
        int nVal = this.GetDefThumbWidth();
        if (this.GetArchive() != null && (nTemp = this.GetArchive().GetValueInt(this.GetKeyThumbHeight(), this.GetDefThumbHeight())) != null) {
            nVal = nTemp;
        }
        return nVal;
    }

    private void LoadThumbSize() {
        if (CMainFrame.GET_APP() != null && this.GetArchive() != null) {
            Integer nThumbWidth = this.GetArchive().GetValueInt(this.GetKeyThumbWidth(), this.GetDefThumbWidth());
            Integer nThumbHeight = this.GetArchive().GetValueInt(this.GetKeyThumbHeight(), this.GetDefThumbHeight());
            if (nThumbWidth != null && nThumbHeight != null && this.GetFilePanel() != null) {
                this.GetFilePanel().SetThumbSize(nThumbWidth, nThumbHeight, true);
            }
        }
    }

    private void SaveThumbSize() {
        if (this.GetArchive() != null) {
            this.GetArchive().SetValue(this.GetKeyThumbWidth(), this.GetStoredThumbWidth(), this.GetDefThumbWidth());
            this.GetArchive().SetValue(this.GetKeyThumbHeight(), this.GetStoredThumbHeight(), this.GetDefThumbHeight());
        }
    }

    private void OnActionThumbSize(AWTEvent event) {
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().dispatchEvent(event);
            if (this.GetArchive() != null) {
                this.GetArchive().SetValue(this.GetKeyThumbWidth(), this.GetFilePanel().GetThumbWidth(), this.GetDefThumbWidth());
                this.GetArchive().SetValue(this.GetKeyThumbHeight(), this.GetFilePanel().GetThumbHeight(), this.GetDefThumbHeight());
            }
        }
    }

    protected DockableFrame GetDockFrame() {
        DockableFrame rRetDockFrame = null;
        DockableFrame rFrame = (DockableFrame)SwingUtilities.getAncestorOfClass(DockableFrame.class, this);
        if (rFrame != null) {
            rRetDockFrame = rFrame;
        }
        return rRetDockFrame;
    }

    private DockableFrame GetMatchingDockableFrame(DockableFrame rFindMatch) {
        DockableFrame rRetDockFrame = null;
        if (rFindMatch != null) {
            List<String> asKeys;
            DockableFrame rDockFrame = this.GetDockFrame();
            if (rDockFrame != null && rFindMatch == rDockFrame) {
                rRetDockFrame = rDockFrame;
            }
            if (rRetDockFrame == null && this.getDockingManager() != null && (asKeys = this.getDockingManager().getAllFrameNames()) != null) {
                Iterator<String> itr = asKeys.iterator();
                while (itr.hasNext() && rRetDockFrame == null) {
                    DockableFrame rNextFrame;
                    String sKey = itr.next();
                    if (sKey == null || sKey.isEmpty() || (rNextFrame = this.getDockingManager().getFrame(sKey)) == null || rNextFrame != rFindMatch) continue;
                    rRetDockFrame = rNextFrame;
                }
            }
        }
        return rRetDockFrame;
    }

    private void OnUpdateFocusClrsActivated(DockableFrame rActivated, DockableFrame rDeactivated) {
        boolean bHasClrsTree = false;
        boolean bHasClrsPreview = false;
        boolean bHasClrsList = false;
        DockableFrame rMatchingFrame = this.GetMatchingDockableFrame(rActivated);
        if (rMatchingFrame != null) {
            List<String> asDockKeys;
            if (DEBUG_DUMP_FRAME_KEYS && this.getDockingManager() != null && (asDockKeys = this.getDockingManager().getAllFrameNames()) != null) {
                System.out.println("--> dockingManager Key dump");
                for (String sKey : asDockKeys) {
                    if (sKey == null || sKey.isEmpty()) continue;
                    String sDockKey = "";
                    DockableFrame rFrame = this.getDockingManager().getFrame(sKey);
                    if (rFrame != null) {
                        sDockKey = rFrame.getKey();
                    }
                    System.out.printf("<dockingManager>.key = %s | <dockableFrame>.getKey: %s\r\n", sKey, sDockKey);
                }
                System.out.println("<-- dockingManager Key dump");
            }
            if (this.GetTreeFrame() == rMatchingFrame) {
                bHasClrsTree = true;
            } else if (this.GetPreviewFrame() == rMatchingFrame) {
                bHasClrsPreview = true;
            } else {
                bHasClrsList = true;
            }
        }
        if (this.GetTree() != null) {
            this.GetTree().SetHasFocusClrs(bHasClrsTree);
        }
        if (this.GetPreviewPane() != null) {
            this.GetPreviewPane().SetHasFocusClrs(bHasClrsPreview);
        }
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().SetHasFocusClrs(bHasClrsList);
        }
    }

    private void OnUpdateFocusClrsDeactivated(DockableFrame rDeactivated, DockableFrame rActivated) {
        DockableFrame rMatchingFrame = this.GetMatchingDockableFrame(rDeactivated);
        if (rMatchingFrame != null && rActivated == null) {
            String sActiveFrameKey;
            if (this.GetTree() != null) {
                this.GetTree().SetHasFocusClrs(false);
            }
            if (this.GetPreviewPane() != null) {
                this.GetPreviewPane().SetHasFocusClrs(false);
            }
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().getDockingManager() != null && (sActiveFrameKey = CMainFrame.GET_APP().getDockingManager().getActiveFrameKey()) != null && this.GetKey() != null && sActiveFrameKey.equals(this.GetKey()) && this.GetFilePanel() != null) {
                this.GetFilePanel().SetHasFocusClrs(true);
                this.GetFilePanel().SetRenameMarker(System.currentTimeMillis());
            }
        }
    }

    private void OnDockFrameDeactivated(CRhinoEvent rEvent) {
        CNestedBrowserFrame rNestedFrame;
        CBrowserPanel rBrowserPanel;
        DockableFrame rMatchingFrame;
        if (DEBUG) {
            System.out.println("CBrowserPanel.OnDockFrameDeactivated -->");
        }
        DockableFrame rDeactivated = (DockableFrame)rEvent.getSource();
        DockableFrame rActivated = (DockableFrame)rEvent.GetEventObj();
        if (DEBUG) {
            System.out.printf("Deactivated: %s\r\n", rDeactivated != null ? rDeactivated.getKey() : "null");
            System.out.printf("Activated: %s\r\n", rActivated != null ? rActivated.getKey() : "null");
        }
        if ((rMatchingFrame = this.GetMatchingDockableFrame(rDeactivated)) != null && rMatchingFrame instanceof CNestedBrowserFrame && (rBrowserPanel = (rNestedFrame = (CNestedBrowserFrame)rMatchingFrame).GetBrowserPanel()) != null && rBrowserPanel.getDockingManager() != null && this.getDockingManager() != null) {
            rBrowserPanel.getDockingManager().activateWorkspace();
        }
        this.OnUpdateFocusClrsDeactivated(rDeactivated, rActivated);
        if (DEBUG) {
            System.out.println("CBrowserPanel.OnDockFrameDeactivated <--");
        }
    }

    private DockableFrame GetTreeFrame() {
        DockableFrame rRetFrame = null;
        if (this.getDockingManager() != null) {
            rRetFrame = this.getDockingManager().getFrame(this.GetKeyTree());
        }
        return rRetFrame;
    }

    private DockableFrame GetPreviewFrame() {
        DockableFrame rRetFrame = null;
        if (this.getDockingManager() != null) {
            rRetFrame = this.getDockingManager().getFrame(this.GetKeyPreview());
        }
        return rRetFrame;
    }

    private void OnDockFrameRemoved(CRhinoEvent rEvent) {
        DockableFrame rRemoved = (DockableFrame)rEvent.getSource();
        DockableFrame rDockFrame = this.GetDockFrame();
        if (rDockFrame != null && rRemoved == rDockFrame) {
            IArchive rArchive = this.GetArchive();
            if (rArchive != null) {
                rArchive.RemoveKey(this.GetKey());
                rArchive.RemoveKey(this.GetKeyThumbWidth());
                rArchive.RemoveKey(this.GetKeyThumbHeight());
            }
            if (this.GetTree() != null) {
                this.GetTree().dispatchEvent(rEvent);
            }
            if (this.GetPreviewPane() != null) {
                this.GetPreviewPane().dispatchEvent(rEvent);
            }
            if (this.GetFilePanel() != null) {
                this.GetFilePanel().dispatchEvent(rEvent);
            }
        }
    }

    private void OnSetFocus(CRhinoEvent rEvent) {
        Object[] arItems;
        if (rEvent != null && (arItems = (Object[])rEvent.GetEventObj()) != null) {
            String sOuterFrameKey = (String)arItems[0];
            String sInnerFrameKey = (String)arItems[1];
            Component cNeedsFocus = (Component)arItems[2];
            if (DEBUG) {
                System.out.printf("OuterFrameKey: %s - InnerFrameKey: %s - Component for Focus: %s\r\n", sOuterFrameKey != null ? sOuterFrameKey : "null", sInnerFrameKey != null ? sInnerFrameKey : "null", cNeedsFocus != null ? cNeedsFocus.getClass().getName() : "null");
            }
            if (sOuterFrameKey != null && CMainFrame.GET_APP().getDockingManager() != null) {
                CMainFrame.GET_APP().getDockingManager().activateFrame(sOuterFrameKey);
            }
            if (this.getDockingManager() != null) {
                if (sInnerFrameKey != null && this.getDockingManager() != null) {
                    this.getDockingManager().activateFrame(sInnerFrameKey);
                } else {
                    this.getDockingManager().activateWorkspace();
                }
            }
            if (cNeedsFocus != null) {
                boolean bHasSelClrs;
                if (this.GetTree() != null) {
                    bHasSelClrs = false;
                    if (this.GetTree().IsEventSource(cNeedsFocus)) {
                        bHasSelClrs = true;
                    }
                    this.GetTree().SetHasFocusClrs(bHasSelClrs);
                }
                if (this.GetPreviewPane() != null) {
                    bHasSelClrs = false;
                    if (this.GetPreviewPane().IsEventSource(cNeedsFocus)) {
                        bHasSelClrs = true;
                    }
                    this.GetPreviewPane().SetHasFocusClrs(bHasSelClrs);
                }
                if (this.GetFilePanel() != null) {
                    bHasSelClrs = false;
                    if (this.GetFilePanel().IsEventSource(cNeedsFocus)) {
                        bHasSelClrs = true;
                    }
                    this.GetFilePanel().SetHasFocusClrs(bHasSelClrs);
                }
            }
        }
    }

    private void OnRecvListError(String sFailedPath) {
        String sDisplayPath;
        CFile fDisplayFile;
        if (sFailedPath != null && this.GetFilePanel() != null && (fDisplayFile = this.GetFilePanel().GetDisplayFile()) != null && (sDisplayPath = fDisplayFile.GetPath()) != null && sFailedPath != null && !sDisplayPath.equals(sFailedPath) && this.GetTree() != null) {
            this.GetTree().MoveTo(fDisplayFile);
        }
    }

    private void UpdateWindowStateFlags(String sKey) {
        if (CMainFrame.GET_APP() != null && sKey != null) {
            CRhinoEvent rEvent = new CRhinoEvent(this, 9099, sKey);
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent rEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent rEvent) {
    }

    @Override
    public void componentShown(ComponentEvent rEvent) {
        String sKey = null;
        if (rEvent.getSource() == this.GetBreadBar()) {
            sKey = this.GetBreadBar().getKey();
        } else if (rEvent.getSource() == this.GetToolbar()) {
            sKey = this.GetToolbar().getKey();
        }
        this.UpdateWindowStateFlags(sKey);
    }

    @Override
    public void componentHidden(ComponentEvent rEvent) {
        String sKey = null;
        if (rEvent.getSource() == this.GetBreadBar()) {
            sKey = this.GetBreadBar().getKey();
        } else if (rEvent.getSource() == this.GetToolbar()) {
            sKey = this.GetToolbar().getKey();
        }
        this.UpdateWindowStateFlags(sKey);
    }

    @Override
    public void SetToolbar(CFVJVCommandBar rBar) {
        super.SetToolbar(rBar);
        if (this.GetToolbar() != null) {
            this.GetToolbar().addComponentListener(this);
        }
    }

    public boolean IsBreadBarVisible() {
        boolean bIsVisible = true;
        if (this.GetBreadBar() != null) {
            bIsVisible = !this.GetBreadBar().isHidden();
        }
        return bIsVisible;
    }

    public boolean IsSearchBarVisible() {
        boolean bIsVisible = true;
        if (this.GetSearchBar() != null) {
            bIsVisible = !this.GetSearchBar().isHidden();
        }
        return bIsVisible;
    }

    private void RelayEventEx(AWTEvent event) {
        List<String> asDockBarKeys;
        if (this.getDockableBarManager() != null && (asDockBarKeys = this.getDockableBarManager().getAllDockableBarNames()) != null) {
            for (String sKey : asDockBarKeys) {
                DockableBar rBar;
                if (sKey == null || sKey.isEmpty() || (rBar = this.getDockableBarManager().getDockableBar(sKey)) == null) continue;
                rBar.dispatchEvent(event);
            }
        }
        if (this.getDockingManager() != null) {
            List<String> asDockKeys = this.getDockingManager().getAllFrameNames();
            if (asDockKeys != null) {
                for (String sKey : asDockKeys) {
                    DockableFrame rFrame;
                    if (sKey == null || sKey.isEmpty() || (rFrame = this.getDockingManager().getFrame(sKey)) == null) continue;
                    rFrame.dispatchEvent(event);
                }
            }
            if (this.getDockingManager().getWorkspace() != null) {
                this.getDockingManager().getWorkspace().dispatchEvent(event);
                Component[] aComps = this.getDockingManager().getWorkspace().getComponents();
                for (int nIdx = 0; nIdx < aComps.length; ++nIdx) {
                    if (aComps[nIdx] == null) continue;
                    aComps[nIdx].dispatchEvent(event);
                }
            }
        }
    }

    protected CSearchBar GetSearchBar() {
        return this.m_cSearchBar;
    }

    public void SetSearchBar(CSearchBar rBar) {
        this.m_cSearchBar = rBar;
        if (this.GetSearchBar() != null) {
            this.GetSearchBar().AddSearchListener(this);
            this.GetSearchBar().addDockableBarListener(new DockableBarListener(){

                @Override
                public void dockableBarAdded(DockableBarEvent rEvent) {
                }

                @Override
                public void dockableBarRemoved(DockableBarEvent rEvent) {
                }

                @Override
                public void dockableBarShown(DockableBarEvent rEvent) {
                    CBrowserPanel.this.SetBtnSelected(2023, rEvent.getDockableBar().isVisible());
                }

                @Override
                public void dockableBarHidden(DockableBarEvent rEvent) {
                    CBrowserPanel.this.SetBtnSelected(2023, rEvent.getDockableBar().isVisible());
                }

                @Override
                public void dockableBarHoriDocked(DockableBarEvent rEvent) {
                }

                @Override
                public void dockableBarVertDocked(DockableBarEvent rEvent) {
                }

                @Override
                public void dockableBarFloating(DockableBarEvent rEvent) {
                }
            });
        }
    }

    private void OnShowSearchBar() {
        if (this.IsEventSource(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) && this.getDockableBarManager() != null && this.GetSearchBar() != null) {
            boolean bIsVisible;
            boolean bl = bIsVisible = this.GetSearchBar().isVisible() && this.GetSearchBar().isDisplayable();
            if (bIsVisible) {
                this.getDockableBarManager().hideDockableBar(this.GetSearchBar().getKey());
                this.GetFilePanel().RequestFocus();
            } else {
                this.getDockableBarManager().showDockableBar(this.GetSearchBar().getKey());
                this.GetSearchBar().RequestFocus();
            }
        }
    }

    @Override
    public void OnSearch(CSearchEvent rEvent) {
        if (rEvent != null) {
            if (DEBUG) {
                String sText = String.format("Search parm: %s \r\nDate - Type: %s | Context: %s | Date: %d\r\nSize - Context: %s | Size: %d\r\n\r\n", rEvent.GetSearchParms(), rEvent.GetDateType().toString(), rEvent.GetDateContext().toString(), rEvent.GetFileDate(), rEvent.GetSizeContext().toString(), rEvent.GetFileSize());
                System.out.printf(sText, new Object[0]);
            }
            CFile rRootDir = this.GetWorkingDir();
            if (this.GetBreadBar() != null) {
                this.GetBreadBar().SetSearchState(CSearchStateEvent.SEARCH_STATE.ON);
            }
            if (this.GetTree() != null) {
                this.GetTree().RemoveSearchStateListener(this);
                this.GetTree().SetSearchState(CSearchStateEvent.SEARCH_STATE.ON);
                this.GetTree().AddSearchStateListener(this);
            }
            if (this.GetFilePanel() != null) {
                this.GetFilePanel().RemoveSearchStateListener(this);
                this.GetFilePanel().SetSearchState(CSearchStateEvent.SEARCH_STATE.ON);
                this.GetFilePanel().AddSearchStateListener(this);
            }
            if (this.GetHistoryModel() != null) {
                this.GetHistoryModel().SetSearchState(CSearchStateEvent.SEARCH_STATE.ON);
            }
            if (this.GetSearchThread() != null) {
                this.GetSearchThread().PostSearch(this, this.GetClientInfo(), this.GetCompressionType(), rRootDir, rEvent.GetSearchParms(), rEvent.GetDateType(), rEvent.GetDateContext(), rEvent.GetFileDate(), rEvent.GetSizeContext(), rEvent.GetFileSize());
            }
        } else {
            throw new InvalidParameterException("rEvent == null");
        }
    }

    public boolean IsSearch() {
        boolean bIsSearch = false;
        if (this.GetFilePanel() != null) {
            bIsSearch = this.GetFilePanel().IsSearch();
        }
        return bIsSearch;
    }

    @Override
    public void OnChangedSearchState(CSearchStateEvent rEvent) {
        if (rEvent.getSource() == this.GetTree()) {
            if (this.GetFilePanel() != null) {
                this.GetFilePanel().SetSearchState(rEvent.GetSearchState());
            }
        } else if (rEvent.getSource() == this.GetFilePanel() && this.GetTree() != null) {
            this.GetTree().SetSearchState(rEvent.GetSearchState());
        }
        if (rEvent.GetSearchState() == CSearchStateEvent.SEARCH_STATE.OFF) {
            this.CancelSearch();
            if (this.GetSearchBar() != null) {
                this.GetSearchBar().HideCancelBtn(false);
            }
        }
    }

    @Override
    public void OnCancelSearch(CSearchEvent rEvent) {
        if (rEvent == null) {
            throw new InvalidParameterException("rEvent == null");
        }
        this.CancelSearch();
    }

    private void CancelSearch() {
        CFile rRootDir = this.GetWorkingDir();
        if (this.GetFilePanel() != null) {
            this.GetFilePanel().RemoveSearchStateListener(this);
            this.GetFilePanel().SetSearchState(CSearchStateEvent.SEARCH_STATE.OFF);
            this.GetFilePanel().AddSearchStateListener(this);
        }
        if (this.GetHistoryModel() != null) {
            this.GetHistoryModel().SetSearchState(CSearchStateEvent.SEARCH_STATE.OFF);
        }
        if (this.GetTree() != null) {
            this.GetTree().RemoveSearchStateListener(this);
            this.GetTree().SetSearchState(CSearchStateEvent.SEARCH_STATE.OFF);
            this.GetTree().AddSearchStateListener(this);
        }
        if (this.GetSearchThread() != null) {
            this.GetSearchThread().Cancel();
        }
    }

    @Override
    public void OnPauseSearch(CSearchEvent rEvent) {
        if (rEvent != null) {
            if (rEvent.GetPauseSearch()) {
                this.PauseSearch();
            } else {
                this.ResumeSearch();
            }
        } else {
            throw new InvalidParameterException("rEvent == null");
        }
    }

    private void PauseSearch() {
        if (this.GetSearchThread() != null) {
            this.GetSearchThread().PauseThread();
        }
        if (this.GetSearchBar() != null) {
            this.GetSearchBar().StopProgressBar();
        }
    }

    private void ResumeSearch() {
        if (this.GetSearchThread() != null) {
            this.GetSearchThread().ResumeThread();
        }
        if (this.GetSearchBar() != null) {
            this.GetSearchBar().StartProgressBar();
        }
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_STARTUP_DIR = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DUMP_FRAME_KEYS = false;
    }
}

