/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.events.CActionFactory;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;

public class CHistoryItem
extends JCheckBoxMenuItem
implements ActionListener {
    private CFile m_fFile;
    private int m_nEventID;
    private CFVJVAction m_rBackAction;
    private CFVJVAction m_rForwardAction;

    public CHistoryItem(CFile fFile, int nEventID) {
        this.InitVars(fFile, nEventID);
    }

    private void InitVars(CFile fFile, int nEventID) {
        this.SetFile(fFile);
        if (CMainFrame.GET_APP() != null) {
            this.m_rBackAction = CActionFactory.CreateAction(2112);
            this.m_rForwardAction = CActionFactory.CreateAction(2113);
        }
        this.SetEventID(nEventID);
        this.addActionListener(this);
    }

    public CFile GetFile() {
        return this.m_fFile;
    }

    private void SetFile(CFile fFile) {
        this.m_fFile = fFile;
    }

    public int GetEventID() {
        return this.m_nEventID;
    }

    public void SetEventID(int nEventID) {
        this.m_nEventID = nEventID;
        this.UpdateAction(nEventID, this.GetFile());
    }

    private void UpdateAction(int nEventID, CFile fFile) {
        if (fFile != null) {
            this.setIcon(fFile.GetIcon16());
            this.setText(fFile.GetPath());
            this.setToolTipText(fFile.GetPath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CRhinoEvent rEvent = new CRhinoEvent(this, this.GetEventID());
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    @Override
    public String toString() {
        String sRet = super.toString();
        if (this.GetFile() != null) {
            sRet = this.GetFile().GetPath();
        }
        return sRet;
    }
}

