/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames.browser;

import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryItem;
import com.rhinosoft.fvjv.gui.frames.browser.CSearchStateEvent;
import com.rhinosoft.fvjv.gui.frames.browser.IHistoryListener;
import com.rhinosoft.fvjv.strings.CString;
import java.util.Vector;

public class CHistoryModel {
    private Vector<CHistoryItem> m_aHistoryItems;
    protected Vector<IHistoryListener> m_aHistoryListeners;
    protected CHistoryItem m_rWorkingDir;
    private CFile m_fSearchFile;
    private CHistoryItem m_SearchHistoryItem;

    public CHistoryModel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_aHistoryItems = new Vector();
        this.m_aHistoryListeners = new Vector();
        this.m_fSearchFile = new CRemoteFile(CString.LoadString("IDS_SEARCH_RESULTS_DEF"), true);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP();
            this.m_fSearchFile.SetIcon16(CMainFrame.GetJARImage("MagnifingGlass16.png"));
        }
        this.m_SearchHistoryItem = new CHistoryItem(this.m_fSearchFile, 2112);
    }

    private Vector<CHistoryItem> GetItems() {
        return this.m_aHistoryItems;
    }

    private int GetItemCount() {
        int nCount = 0;
        if (this.GetItems() != null) {
            nCount = this.GetItems().size();
        }
        return nCount;
    }

    private boolean AddItem(CHistoryItem rItem, boolean bFireEvent) {
        boolean bAdded = false;
        if (this.GetItems() != null) {
            bAdded = this.GetItems().add(rItem);
        }
        if (bAdded && bFireEvent) {
            this.FireAddHistoryItem(rItem);
        }
        return bAdded;
    }

    private boolean InsertItem(CHistoryItem rItem, int nIndex, boolean bFireEvent) {
        boolean bInserted = false;
        if (this.GetItems() != null && nIndex > -1 && nIndex <= this.GetItemCount()) {
            this.GetItems().insertElementAt(rItem, nIndex);
            bInserted = true;
        }
        if (bInserted && bFireEvent) {
            this.FireAddHistoryItem(rItem);
        }
        return bInserted;
    }

    private CHistoryItem GetItem(int nIndex) {
        CHistoryItem rItem = null;
        if (this.GetItems() != null && nIndex > -1 && nIndex < this.GetItemCount()) {
            rItem = this.GetItems().elementAt(nIndex);
        }
        return rItem;
    }

    public int GetItemIndex(CHistoryItem rItem) {
        int nIndex = -1;
        if (this.GetItems() != null && rItem != null) {
            nIndex = this.GetItems().indexOf(rItem);
        }
        return nIndex;
    }

    private CHistoryItem RemoveItem(int nIndex, boolean bFireEvent) {
        CHistoryItem rRemoved = this.GetItem(nIndex);
        if (!this.RemoveItem(rRemoved, bFireEvent)) {
            rRemoved = null;
        }
        return rRemoved;
    }

    private boolean RemoveItem(CHistoryItem rItem, boolean bFireEvent) {
        boolean bRemoved = false;
        if (this.GetItems() != null && rItem != null) {
            bRemoved = this.GetItems().remove(rItem);
        }
        if (bRemoved && bFireEvent) {
            this.FireRemoveHistoryItem(rItem);
        }
        return bRemoved;
    }

    private boolean RemoveAllItems(int nEventID, boolean bFireEvent) {
        boolean bRemovedAll = false;
        if (this.GetItems() != null) {
            for (int nIdx = this.GetItemCount() - 1; nIdx >= 0; --nIdx) {
                CHistoryItem rItem = this.GetItem(nIdx);
                if (rItem == null || rItem.GetEventID() != nEventID) continue;
                this.RemoveItem(rItem, bFireEvent);
            }
            bRemovedAll = true;
        }
        return bRemovedAll;
    }

    private CHistoryItem GetWorkingDir() {
        return this.m_rWorkingDir;
    }

    private void ResetSelectedItem() {
        for (int nIdx = 0; nIdx < this.GetItemCount(); ++nIdx) {
            CHistoryItem rNextItem = this.GetItem(nIdx);
            if (rNextItem == null) continue;
            this.OnUpdateSelectedItem(rNextItem, false);
        }
    }

    private void SetWorkingDir(CHistoryItem rItem) {
        this.m_rWorkingDir = rItem;
        if (this.GetWorkingDir() != null) {
            int nWorkingIdx = this.GetWorkingDirIndex();
            for (int nIdx = 0; nIdx < this.GetItemCount(); ++nIdx) {
                CHistoryItem rNextItem = this.GetItem(nIdx);
                if (rNextItem == null) continue;
                this.OnUpdateSelectedItem(rNextItem, false);
                if (nIdx < nWorkingIdx) {
                    rNextItem.SetEventID(2113);
                    continue;
                }
                rNextItem.SetEventID(2112);
            }
            this.OnUpdateSelectedItem(this.GetWorkingDir(), true);
        }
        this.UpdateBtnStates();
    }

    private void OnUpdateSelectedItem(CHistoryItem rItem, boolean bSelected) {
        if (rItem != null) {
            rItem.setSelected(bSelected);
            if (rItem.GetFile() != null) {
                String sPath;
                String sText = sPath = rItem.GetFile().GetPath();
                if (bSelected) {
                    sText = String.format(CFilePanel.HTML_FMT_BOLD, sText);
                }
                rItem.setText(sText);
            }
        }
    }

    public void UpdateBtnStates() {
        boolean bEnabled = this.GetBackItemCount() > 0;
        this.SetBtnEnabled(2112, bEnabled);
        bEnabled = this.GetForwardItemCount() > 0;
        this.SetBtnEnabled(2113, bEnabled);
    }

    private int GetWorkingDirIndex() {
        int nIndex = -1;
        if (this.GetItems() != null) {
            CHistoryItem rPrevItem = null;
            CHistoryItem rCurItem = null;
            for (int nIdx = 0; nIdx < this.GetItemCount() && nIndex == -1; ++nIdx) {
                rPrevItem = rCurItem;
                rCurItem = this.GetItem(nIdx);
                if (rCurItem == null || rCurItem != this.GetWorkingDir()) continue;
                nIndex = rPrevItem != null && rPrevItem == this.GetSearchHistoryItem() ? nIdx - 1 : nIdx;
            }
        }
        return nIndex;
    }

    public CHistoryItem GetNextBackItem() {
        CHistoryItem rItem = null;
        int nIndex = this.GetWorkingDirIndex();
        rItem = this.GetItem(nIndex + 1);
        return rItem;
    }

    public CHistoryItem GetNextForwardItem() {
        CHistoryItem rItem = null;
        int nIndex = this.GetWorkingDirIndex();
        rItem = this.GetItem(nIndex - 1);
        return rItem;
    }

    public void OnUpdateWorkingDir(CHistoryItem rItem) {
        CHistoryItem rNextItem;
        boolean bInsertItem = true;
        int nWorkingDirIdx = this.GetWorkingDirIndex();
        if (nWorkingDirIdx < 0) {
            nWorkingDirIdx = 0;
        }
        if ((rNextItem = this.GetItem(nWorkingDirIdx)) != null && rNextItem.GetFile() == rItem.GetFile()) {
            bInsertItem = false;
        }
        if (bInsertItem) {
            this.RemoveAllItems(2113, true);
            nWorkingDirIdx = this.GetWorkingDirIndex();
            if (nWorkingDirIdx < 0) {
                nWorkingDirIdx = 0;
            }
            this.InsertItem(rItem, nWorkingDirIdx, true);
            this.SetWorkingDir(rItem);
        }
    }

    public void OnSelectItem(CHistoryItem rItem) {
        this.SetWorkingDir(rItem);
    }

    private Vector<IHistoryListener> GetHistoryListeners() {
        return this.m_aHistoryListeners;
    }

    public void AddHistoryListener(IHistoryListener rListener) {
        if (this.GetHistoryListeners() != null) {
            this.GetHistoryListeners().add(rListener);
        }
    }

    public void RemoveHistoryListener(IHistoryListener rListener) {
        if (this.GetHistoryListeners() != null) {
            this.GetHistoryListeners().remove(rListener);
        }
    }

    private void FireAddHistoryItem(CHistoryItem rItem) {
        this.FireHistoryListener(false, rItem);
    }

    private void FireRemoveHistoryItem(CHistoryItem rItem) {
        this.FireHistoryListener(true, rItem);
    }

    private void FireHistoryListener(boolean bRemoved, CHistoryItem rItem) {
        if (this.GetHistoryListeners() != null) {
            for (IHistoryListener rListener : this.GetHistoryListeners()) {
                if (rListener == null) continue;
                if (bRemoved) {
                    rListener.OnRemoveHistoryItem(rItem);
                    continue;
                }
                rListener.OnAddHistoryItem(rItem);
            }
        }
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Object[] anItems = new Object[]{nEventID, bEnabled};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    private int GetBackItemCount() {
        int nCount = 0;
        for (int nIdx = 0; nIdx < this.GetItemCount(); ++nIdx) {
            CHistoryItem rNextItem = this.GetItem(nIdx);
            if (rNextItem == null || rNextItem == this.GetWorkingDir() || rNextItem.GetEventID() != 2112) continue;
            ++nCount;
        }
        return nCount;
    }

    private int GetForwardItemCount() {
        int nCount = 0;
        for (int nIdx = 0; nIdx < this.GetItemCount(); ++nIdx) {
            CHistoryItem rNextItem = this.GetItem(nIdx);
            if (rNextItem == null || rNextItem.GetEventID() != 2113 || rNextItem == this.GetWorkingDir()) continue;
            ++nCount;
        }
        return nCount;
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    private CHistoryItem GetSearchHistoryItem() {
        return this.m_SearchHistoryItem;
    }

    public void SetSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        if (nSearchState == CSearchStateEvent.SEARCH_STATE.ON) {
            if (this.GetWorkingDir() != null && this.GetWorkingDir().GetFile() != null && this.GetSearchHistoryItem() != null && this.GetSearchHistoryItem().GetFile() != null) {
                String sDisplay = String.format(CString.LoadString("IDS_SEARCH_RESULTS_FMT"), this.GetWorkingDir().GetFile().GetDisplayName());
                this.GetSearchHistoryItem().GetFile().SetDisplayName(sDisplay);
                this.GetSearchHistoryItem().GetFile().SetPath(sDisplay);
                this.GetSearchHistoryItem().SetEventID(2112);
            }
            this.ResetSelectedItem();
            this.InsertItem(this.GetSearchHistoryItem(), 0, true);
            this.OnUpdateSelectedItem(this.GetSearchHistoryItem(), true);
        } else {
            this.RemoveItem(this.GetSearchHistoryItem(), true);
            this.OnUpdateSelectedItem(this.GetWorkingDir(), true);
        }
        this.UpdateBtnStates();
    }
}

