/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.net;

import com.rhinosoft.base.CSpeedTest;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.net.CHTTPConnection;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUURLFactory;
import com.rhinosoft.fvjv.net.CTransferStatsEvent;
import com.rhinosoft.fvjv.net.IListDirListener;
import com.rhinosoft.fvjv.net.ITransferStatsListener;
import com.rhinosoft.fvjv.parsers.CListing;
import com.rhinosoft.fvjv.parsers.CXMLParserResult;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class CSUConnection
extends CHTTPConnection {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_DYNAMIC_BUFFER;
    public static final boolean DEBUG_TRACK_UPLOAD_INDICES;
    public static final boolean DEBUG_SPEED_LISTING;
    public static final int DEFAULT_HTTP_RESPONSE_CODE = 503;
    public static final int DEFAULT_SU_RESULT_CODE = 1;
    private static final int TRANSFER_BUFFER_SIZE_MINIMUM = 1024;
    public static final int TRANSFER_BUFFER_SIZE_DEFAULT = 5120;
    private static final int UPLOAD_MAX = 0x7FFFFBFF;
    private CClientInfo m_ClientInfo;
    private CSUURLFactory m_URLFactory;
    boolean m_bCancel = false;
    private CListing m_Listing;
    private byte[] m_aBuffer;
    private Vector<ITransferStatsListener> m_aTransferStatsListeners;
    private SimpleDateFormat m_DateFormatter;
    private Vector<IListDirListener> m_aListDirListeners;
    private boolean m_bResume = false;
    private long m_lResumeStartIndex = -1L;
    private long m_lResumeEndIndex = -1L;
    private long m_lNumOfBytesRead = 0L;
    private long m_lStartTime = 0L;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CClientInfo rInfo = new CClientInfo();
                rInfo.SetHost("localhost");
                rInfo.SetPort(80L);
                rInfo.SetEncSessionID("9e75fd9e2a745fa57579edf33e3b9b9a4fa66d4b8f3689a80d743fe342aba981a5655770b93c17240754581406246bf8");
                CSUConnection rConn = new CSUConnection(rInfo, 0);
                String sPath = "/C:/Temp/";
                int[] anRetCodes = rConn.SendListDir(sPath);
                System.out.println(String.format("%s | HTTP Response Code: %d | SU Result: %d", sPath, anRetCodes[0], anRetCodes[1]));
                System.out.println(rConn.GetListDir().GetAbsFileName());
                sPath = "/D:/Temp/BlackBetty.jpg";
                anRetCodes = rConn.SendListFile(sPath);
                System.out.println(String.format("%s | HTTP Response Code: %d | SU Result: %d", sPath, anRetCodes[0], anRetCodes[1]));
                System.out.println(rConn.GetListDir().GetAbsFileName() + " | " + rConn.GetListDir().GetChildFile(0).GetAbsFileName());
            }
        });
    }

    public CSUConnection(CClientInfo rInfo, int nCompressionType) {
        super(nCompressionType);
        this.SetClientInfo(rInfo);
        this.m_aTransferStatsListeners = new Vector();
        this.m_aListDirListeners = new Vector();
        this.m_DateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        this.m_DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void finalize() throws Throwable {
        this.m_ClientInfo = null;
        super.finalize();
    }

    protected void SetClientInfo(CClientInfo rClientInfo) {
        this.m_ClientInfo = rClientInfo;
        if (this.m_ClientInfo != null) {
            if (this.m_URLFactory != null) {
                this.m_URLFactory = null;
            }
            this.m_URLFactory = new CSUURLFactory(this.m_ClientInfo.IsSecure(), this.m_ClientInfo.GetHost(), this.m_ClientInfo.GetPublicPort(), this.m_ClientInfo.GetSessionID());
        }
    }

    protected CClientInfo GetClientInfo() {
        return this.m_ClientInfo;
    }

    protected CSUURLFactory GetURLFactory() {
        return this.m_URLFactory;
    }

    public synchronized boolean GetCancel() {
        return this.m_bCancel;
    }

    public synchronized void SetCancel(boolean bCancel) {
        this.m_bCancel = bCancel;
    }

    private String[] CompileRequestHeader() throws NullPointerException {
        return this.CompileRequestHeader(false);
    }

    private String[] CompileRequestHeader(boolean bAcceptCompression) throws NullPointerException {
        if (this.GetClientInfo() == null) {
            throw new NullPointerException("GetClientInfo == null in CSUConnection.CompileRequestHeader");
        }
        String[] asRet = new String[]{"User-Agent", CMainFrame.APP_NAME_VERSION, "Cookie", "Session=" + this.GetClientInfo().GetEncSessionID(), "Accept-Language", "en-us,en;q=0.5", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"};
        if (bAcceptCompression) {
            String[] asTemp = new String[asRet.length];
            System.arraycopy(asRet, 0, asTemp, 0, asRet.length);
            asRet = new String[asRet.length + 2];
            System.arraycopy(asTemp, 0, asRet, 0, asTemp.length);
            asRet[8] = "Accept-Encoding";
            asRet[9] = "gzip,deflate";
        }
        return asRet;
    }

    private int[] SendListPath(String sAbsPath, URL rURL, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = 503;
        anRet[1] = 1;
        String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
        if (this.Get(rURL, asHeaderInfo)) {
            CSpeedTest spt = new CSpeedTest();
            if (DEBUG_SPEED_LISTING) {
                spt.Start();
            }
            this.m_Listing = new CListing(this);
            for (IListDirListener rListener : this.GetListDirListeners()) {
                this.m_Listing.AddListDirListener(rListener);
            }
            nParseRc = this.m_Listing.Parse(this.GetInputStream(), true, bUseCompression);
            anRet[1] = this.m_Listing.GetResult();
            if (DEBUG_SPEED_LISTING) {
                spt.Stop();
                spt.PrintResults(String.format("Speed test for (%s)...%s", bUseCompression ? "Compressed" : "Uncompressed", sAbsPath));
            }
            this.CloseInputStream(this.GetInputStream());
        }
        anRet[0] = this.GetResponseCode();
        this.Disconnect();
        if (nParseRc == 3) {
            anRet = this.SendListPath(sAbsPath, rURL, false);
        }
        return anRet;
    }

    private int[] SendListPath(String sAbsPath, boolean bIsDir) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateList(sAbsPath, bIsDir);
            anRet = this.SendListPath(sAbsPath, rURL, this.UseCompression());
        }
        return anRet;
    }

    public int[] SendListDir(String sAbsPath) {
        return this.SendListPath(sAbsPath, true);
    }

    public int[] SendListFile(String sAbsPath) {
        return this.SendListPath(sAbsPath, false);
    }

    public CRemoteFile GetListDir() {
        CRemoteFile fDir = null;
        if (this.m_Listing != null) {
            fDir = this.m_Listing.GetParent();
        }
        return fDir;
    }

    private int[] SendDeletePath(String sAbsPath, boolean bIsDir) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateDelete(sAbsPath, bIsDir);
            if (this.Get(rURL, asHeaderInfo = this.CompileRequestHeader())) {
                CXMLParserResult rXMLParser = new CXMLParserResult();
                rXMLParser.Parse(this.GetInputStream());
                anRet[1] = rXMLParser.GetResult();
                this.CloseInputStream(this.GetInputStream());
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendDeleteDir(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, true);
    }

    public int[] SendDeleteFile(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, false);
    }

    public int[] SendRenamePath(String sAbsPathFrom, String sAbsPathTo) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateRename(sAbsPathFrom, sAbsPathTo);
            if (this.Get(rURL, asHeaderInfo = this.CompileRequestHeader())) {
                CXMLParserResult rXMLParser = new CXMLParserResult();
                rXMLParser.Parse(this.GetInputStream());
                anRet[1] = rXMLParser.GetResult();
                this.CloseInputStream(this.GetInputStream());
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendCreateDir(String sAbsPath) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateDir(sAbsPath);
            if (this.Get(rURL, asHeaderInfo = this.CompileRequestHeader())) {
                CXMLParserResult rXMLParser = new CXMLParserResult();
                rXMLParser.Parse(this.GetInputStream());
                anRet[1] = rXMLParser.GetResult();
                this.CloseInputStream(this.GetInputStream());
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendDownload(String sAbsFromPath, long lFromSize, String sAbsToPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight, long lResumeStart) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDownload(sAbsFromPath, bIsThumb, nThumbWidth, nThumbHeight);
            boolean bCanTransfer = true;
            String[] asHeaderInfo = this.CompileRequestHeader();
            if (this.GetResume() && asHeaderInfo != null) {
                this.SetResumeRange(0L, lFromSize - 1L);
                if (lResumeStart < 0L) {
                    lResumeStart = this.FindResumeStartIndex(sAbsToPath, false);
                }
                if (lResumeStart >= lFromSize) {
                    bCanTransfer = false;
                    CTransferStatsEvent event = new CTransferStatsEvent(0L, lFromSize, lFromSize, -1L, sAbsToPath);
                    event.SetRecalcOverall(true);
                    event.SetResumeStartIndex(lResumeStart);
                    this.FireTransferStats(event);
                    anRet[0] = 200;
                    anRet[1] = 0;
                } else {
                    this.SetResumeStartIndex(lResumeStart);
                    String[] asTemp = new String[asHeaderInfo.length];
                    System.arraycopy(asHeaderInfo, 0, asTemp, 0, asHeaderInfo.length);
                    asHeaderInfo = new String[asTemp.length + 2];
                    System.arraycopy(asTemp, 0, asHeaderInfo, 0, asTemp.length);
                    asHeaderInfo[asHeaderInfo.length - 2] = "Range";
                    asHeaderInfo[asHeaderInfo.length - 1] = "bytes=" + this.GetResumeStartIndex() + "-" + this.GetResumeEndIndex();
                }
            }
            if (bCanTransfer) {
                if (this.Get(rURL, asHeaderInfo)) {
                    String sContentType = this.GetHeaderValue("Content-Type");
                    if (sContentType != null) {
                        sContentType = sContentType.toLowerCase();
                    }
                    if (sContentType != null && !sContentType.isEmpty() && sContentType.equals("application/download") || bIsThumb && sContentType.startsWith("image")) {
                        anRet = this.DownloadToFile(sAbsToPath);
                    } else {
                        CXMLParserResult rXMLParser = new CXMLParserResult();
                        rXMLParser.Parse(this.GetInputStream());
                        anRet[1] = rXMLParser.GetResult();
                        this.CloseInputStream(this.GetInputStream());
                    }
                }
                anRet[0] = this.GetResponseCode();
            }
            this.Disconnect();
        }
        return anRet;
    }

    /*
     * Exception decompiling
     */
    private int[] DownloadToFile(String sAbsToPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int[] SendUpload(long lTransferID, String sAbsFromPath, long lFromSize, String sAbsToPath, long lResumeStart) {
        int[] anRet = new int[]{503, 1};
        this.m_lNumOfBytesRead = 0L;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateUpload(lTransferID, sAbsToPath);
            String sBoundary = this.CreateBoundary();
            String sContentDispName = "File";
            File fFromFile = new File(sAbsFromPath);
            String sContentDispFileName = fFromFile.getName();
            if (fFromFile != null && fFromFile.exists()) {
                long lLen = fFromFile.length();
                this.SetResumeRange(0L, lLen - 1L);
                if (lResumeStart < 0L) {
                    lResumeStart = this.FindResumeStartIndex(sAbsToPath, true);
                }
                if (!this.GetResume()) {
                    lResumeStart = 0L;
                }
                int nErrorID = 0;
                if (lResumeStart > lFromSize) {
                    CTransferStatsEvent event = new CTransferStatsEvent(0L, lFromSize, lFromSize, -1L, sAbsToPath);
                    event.SetRecalcOverall(true);
                    event.SetResumeStartIndex(lResumeStart);
                    this.FireTransferStats(event);
                    nErrorID = 1;
                } else {
                    this.SetResumeStartIndex(lResumeStart);
                    lLen = this.GetResumeEndIndex() - this.GetResumeStartIndex() + 1L;
                    if (lLen > -1L) {
                        this.SetResume(true);
                        this.m_lStartTime = System.currentTimeMillis();
                        do {
                            int nLen = 0;
                            nLen = lLen <= 0x7FFFFBFFL ? (int)lLen : 0x7FFFFBFF;
                            int nBoundaryLength = this.GetFileBoundaryLength(sBoundary, sContentDispName, sContentDispFileName);
                            String[] asHeaderInfo = this.CompileRequestHeader();
                            int nInfoSize = asHeaderInfo.length + 8;
                            String[] asHeaderInfo2 = new String[nInfoSize];
                            System.arraycopy(asHeaderInfo, 0, asHeaderInfo2, 0, asHeaderInfo.length);
                            asHeaderInfo2[asHeaderInfo.length] = "Accept";
                            asHeaderInfo2[asHeaderInfo.length + 1] = "*/*";
                            asHeaderInfo2[asHeaderInfo.length + 2] = "Content-Type";
                            asHeaderInfo2[asHeaderInfo.length + 3] = String.format("multipart/form-data; boundary=%s", sBoundary);
                            asHeaderInfo2[asHeaderInfo.length + 4] = "Last-Modified";
                            asHeaderInfo2[asHeaderInfo.length + 5] = this.m_DateFormatter.format(new Date(fFromFile.lastModified())) + " GMT";
                            asHeaderInfo2[asHeaderInfo.length + 6] = "Range";
                            asHeaderInfo2[asHeaderInfo.length + 7] = "bytes=" + this.GetResumeStartIndex() + "-" + (this.GetResumeStartIndex() + (long)(nLen - 1));
                            if (this.Post(rURL, asHeaderInfo2, nLen + nBoundaryLength)) {
                                anRet = this.UploadFile(nLen, fFromFile, sBoundary, sContentDispName, sContentDispFileName, lTransferID);
                                if (anRet[0] == 200 && anRet[1] == 0) {
                                    this.SetResumeStartIndex(this.GetResumeStartIndex() + this.m_lNumOfBytesRead);
                                    lLen -= this.m_lNumOfBytesRead;
                                } else {
                                    nErrorID = 3;
                                }
                            } else {
                                nErrorID = 2;
                            }
                            this.Disconnect();
                        } while (lLen > 0L && nErrorID == 0);
                        this.SetResume(false);
                    }
                    if (nErrorID > 0) {
                        switch (nErrorID) {
                            case 1: {
                                anRet[0] = 200;
                                anRet[1] = 17;
                                break;
                            }
                            case 2: {
                                anRet[0] = 503;
                                anRet[1] = 1;
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                    }
                }
            }
        }
        return anRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] UploadFile(int nLen, File fFile, String sBoundary, String sContentDispName, String sContentDispFileName, long lTransferID) {
        if (DEBUG_PRINT_REQUEST_HEADER) {
            this.PrintRequestHeader();
        }
        boolean bPollForResult = false;
        int[] anRet = new int[]{503, 1};
        this.m_lNumOfBytesRead = 0L;
        if (fFile != null && fFile.exists()) {
            OutputStream outStream = null;
            InputStream finStream = null;
            try {
                outStream = this.GetOutputStream();
                finStream = new FileInputStream(fFile);
                boolean bRet = true;
                long lBytesRead = 0L;
                long lMarkerTime = 0L;
                long lWriteTime = 0L;
                long lFileSize = fFile.length();
                long lTotalRead = 0L;
                boolean bRecalcOverallOnce = true;
                boolean bRecalcOverall = false;
                String sTemp = null;
                sTemp = this.FmtStartBoundary(sBoundary, sContentDispName, sContentDispFileName);
                outStream.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                outStream.flush();
                long lResumeStart = this.GetResumeStartIndex();
                if (lResumeStart >= 0L) {
                    long lSkipped;
                    lTotalRead = lSkipped = finStream.skip(lResumeStart);
                }
                long lCalcPerSecSize = lTotalRead;
                long lResumeReceivedSize = 0L;
                long lBytesPerSec = 0L;
                int nBufSize = Math.min(5120, nLen);
                this.m_aBuffer = new byte[nBufSize];
                while (nLen > 0 && (lBytesRead = (long)finStream.read(this.m_aBuffer, 0, this.m_aBuffer.length)) != -1L && !this.GetCancel()) {
                    bRecalcOverall = false;
                    if (DEBUG_TRACK_UPLOAD_INDICES) {
                        System.out.printf("lBytesRead: %d | nLen: %d | m_aBuffer.length: %d\r\n", lBytesRead, nLen, this.m_aBuffer.length);
                    }
                    outStream.write(this.m_aBuffer, 0, (int)lBytesRead);
                    lMarkerTime = System.currentTimeMillis();
                    nLen = (int)((long)nLen - lBytesRead);
                    this.m_lNumOfBytesRead += lBytesRead;
                    lTotalRead += lBytesRead;
                    lCalcPerSecSize = lResumeReceivedSize += lBytesRead;
                    if (bRecalcOverallOnce) {
                        bRecalcOverallOnce = false;
                        bRecalcOverall = true;
                    }
                    lBytesPerSec = CSUConnection.CalcBytesPerSecond(lMarkerTime, this.m_lStartTime, lCalcPerSecSize);
                    CTransferStatsEvent event = new CTransferStatsEvent(lBytesRead, lTotalRead, lFileSize, lBytesPerSec, fFile.getAbsolutePath());
                    event.SetRecalcOverall(bRecalcOverall);
                    event.SetResumeStartIndex(this.GetResumeStartIndex());
                    this.FireTransferStats(event);
                    if (lMarkerTime - this.m_lStartTime > 2000L) {
                        this.AdjustTransferBuffer(lBytesPerSec);
                    }
                    if (this.m_aBuffer.length <= nLen) continue;
                    this.m_aBuffer = null;
                    this.m_aBuffer = new byte[nLen];
                }
                sTemp = this.FmtEndBoundary(sBoundary);
                outStream.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                outStream.flush();
            }
            catch (NullPointerException npe) {
                if (DEBUG) {
                    npe.printStackTrace();
                }
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    ioe.printStackTrace();
                }
                bPollForResult = true;
            }
            finally {
                outStream = this.CloseOutputStream(outStream);
                finStream = this.CloseInputStream(finStream);
                this.m_aBuffer = null;
                if (DEBUG_PRINT_RESPONSE_HEADER) {
                    this.PrintResponseHeader();
                }
                if (DEBUG_PRINT_RESPONSE_BODY) {
                    this.PrintResponseBody();
                }
            }
        }
        if (!bPollForResult) {
            anRet[0] = this.GetResponseCode();
            if (!this.GetCancel()) {
                InputStream inStream = this.GetInputStream();
                CXMLParserResult xmlResult = new CXMLParserResult();
                xmlResult.Parse(inStream);
                anRet[1] = xmlResult.GetResult();
                inStream = this.CloseInputStream(inStream);
            }
        } else {
            anRet = this.PollForResult(lTransferID);
        }
        return anRet;
    }

    private boolean AdjustTransferBuffer(long lBytesPerSecond) {
        boolean bContinue = true;
        long lBufferSize = this.m_aBuffer.length;
        lBufferSize = lBytesPerSecond < 102400L ? lBytesPerSecond / 6L : (lBytesPerSecond < 204800L ? lBytesPerSecond / 5L : (lBytesPerSecond < 307200L ? lBytesPerSecond / 4L : (lBytesPerSecond < 409600L ? lBytesPerSecond / 3L : lBytesPerSecond / 2L)));
        if (lBufferSize < 1024L) {
            lBufferSize = 1024L;
        }
        if ((double)Math.abs(lBufferSize - (long)this.m_aBuffer.length) > (double)this.m_aBuffer.length * 0.05) {
            int nBufSize = this.m_aBuffer.length;
            nBufSize = lBufferSize > 0x7FFFFFFEL ? 0x7FFFFFFE : (int)lBufferSize;
            if (DEBUG_DYNAMIC_BUFFER) {
                System.out.println("AdjustTransferBuffer: " + nBufSize);
            }
            this.m_aBuffer = null;
            try {
                this.m_aBuffer = new byte[nBufSize];
            }
            catch (Exception e) {
                try {
                    System.gc();
                    this.m_aBuffer = new byte[nBufSize];
                }
                catch (Exception ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                        CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Failed to create a dynamic buffer.", false);
                    }
                    bContinue = false;
                    this.SetCancel(true);
                }
            }
        }
        return bContinue;
    }

    public static long CalcBytesPerSecond(long lCurTime, long lStartTime, long lNumOfBytes) {
        long lBytesPerSecond = 0L;
        long lSecondsElapsed = (lCurTime - lStartTime) / 1000L;
        if (lSecondsElapsed < 1L) {
            lSecondsElapsed = 1L;
        }
        lBytesPerSecond = lNumOfBytes / lSecondsElapsed;
        return lBytesPerSecond;
    }

    protected Vector<ITransferStatsListener> GetTransferStatsListeners() {
        return this.m_aTransferStatsListeners;
    }

    public void AddTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().add(rListener);
        }
    }

    public void RemoveTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().remove(rListener);
        }
    }

    protected void FireTransferStats(CTransferStatsEvent rEvent) {
        assert (rEvent != null);
        assert (this.GetTransferStatsListeners() != null);
        for (int nIdx = this.GetTransferStatsListeners().size() - 1; nIdx >= 0; --nIdx) {
            ITransferStatsListener rListener = this.GetTransferStatsListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnUpdateTransferStats(rEvent);
        }
    }

    public int[] SendNoop() {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateNoop();
            boolean bUseCompression = this.UseCompression();
            bUseCompression = false;
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            if (this.Get(rURL, asHeaderInfo)) {
                String sAcceptEncoding = this.GetHeaderValue("Accept-Encoding");
                if (sAcceptEncoding != null) {
                    sAcceptEncoding = sAcceptEncoding.toLowerCase();
                    this.PostEvent(2904, new Integer(this.GetCompressionType()));
                }
                CXMLParserResult rXMLParser = new CXMLParserResult();
                rXMLParser.Parse(this.GetInputStream());
                anRet[1] = rXMLParser.GetResult();
                this.CloseInputStream(this.GetInputStream());
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendLogout() {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateLogout();
            if (this.Get(rURL, asHeaderInfo = this.CompileRequestHeader())) {
                anRet[1] = 0;
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendChangePassword(String sOldPword, String sNewPword) {
        int[] anRet = new int[]{503, 1};
        if (this.GetURLFactory() != null) {
            block4: {
                URL rURL = this.GetURLFactory().CreateChangePassword();
                StringBuilder sData = new StringBuilder();
                sData.append("old_password=" + CSUURLFactory.URLEncode(sOldPword));
                sData.append("&");
                sData.append("new_password=" + CSUURLFactory.URLEncode(sNewPword));
                String[] asHeaderInfo = this.CompileRequestHeader();
                byte[] aData = sData.toString().getBytes();
                int nContentLen = aData.length;
                if (this.Post(rURL, asHeaderInfo, nContentLen)) {
                    OutputStream outStream = null;
                    InputStream inStream = null;
                    try {
                        outStream = this.GetOutputStream();
                        outStream.write(aData, 0, nContentLen);
                        outStream.flush();
                        outStream = this.CloseOutputStream(outStream);
                        inStream = this.GetInputStream();
                        CXMLParserResult rXMLParser = new CXMLParserResult();
                        rXMLParser.Parse(inStream);
                        anRet[1] = rXMLParser.GetResult();
                        inStream = this.CloseInputStream(inStream);
                    }
                    catch (IOException ioe) {
                        if (!DEBUG) break block4;
                        ioe.printStackTrace();
                    }
                }
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    private int[] PollForResult(long lTransferID) {
        boolean bTimedOut;
        int[] anRet = null;
        long lTimeout = System.currentTimeMillis() + 30000L;
        boolean bContinue = true;
        boolean bl = bTimedOut = System.currentTimeMillis() >= lTimeout;
        while (bContinue && !bTimedOut) {
            boolean bl2 = bTimedOut = System.currentTimeMillis() >= lTimeout;
            anRet = this.SendTransferStats(lTransferID);
            if (anRet == null || anRet.length != 2 || anRet[0] != 200 || anRet[1] == -1 || anRet[1] == 6 || anRet[1] == 9) continue;
            bContinue = false;
        }
        if (anRet != null && anRet.length == 2 && anRet[1] == -1) {
            anRet[1] = 1;
        }
        if (bTimedOut) {
            anRet[1] = 20;
        }
        return anRet;
    }

    public int[] SendTransferStats(long lTransferID) {
        int[] anRet = new int[]{503, -1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateTransferStats(lTransferID);
            if (this.Get(rURL, asHeaderInfo = this.CompileRequestHeader())) {
                CXMLParserResult rXMLParser = new CXMLParserResult();
                rXMLParser.Parse(this.GetInputStream());
                anRet[1] = rXMLParser.GetResult();
                this.CloseInputStream(this.GetInputStream());
            }
            anRet[0] = this.GetResponseCode();
            this.Disconnect();
        }
        return anRet;
    }

    protected Vector<IListDirListener> GetListDirListeners() {
        return this.m_aListDirListeners;
    }

    public void AddListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().add(rListener);
        }
    }

    public void RemoveListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().remove(rListener);
        }
    }

    public int GetListDirListenerCount() {
        int nCount = 0;
        if (this.GetListDirListeners() != null) {
            nCount = this.GetListDirListeners().size();
        }
        return nCount;
    }

    public IListDirListener GetListDirListener(int nIndex) {
        IListDirListener rListener = null;
        if (this.GetListDirListeners() != null && nIndex >= 0 && nIndex < this.GetListDirListenerCount()) {
            rListener = this.GetListDirListeners().get(nIndex);
        }
        return rListener;
    }

    public synchronized boolean GetResume() {
        return this.m_bResume;
    }

    public synchronized void SetResume(boolean bResume) {
        this.m_bResume = bResume;
    }

    private long FindResumeStartIndex(String sAbsToPath, boolean bDestIsRemote) {
        long lStart = 0L;
        if (bDestIsRemote) {
            CFile fChild;
            int[] anRetCodes = this.SendListPath(sAbsToPath, false);
            if (anRetCodes != null && anRetCodes.length == 2 && anRetCodes[0] == 200 && anRetCodes[1] == 0 && this.GetListDir() != null && (fChild = this.GetListDir().GetChildFile(0)) != null) {
                lStart = fChild.GetSize();
            }
        } else {
            File fDest = new File(sAbsToPath);
            if (fDest != null && fDest.exists()) {
                lStart = fDest.length();
            }
        }
        return lStart;
    }

    private void SetResumeStartIndex(long lStartIndex) {
        this.m_lResumeStartIndex = lStartIndex;
    }

    private long GetResumeStartIndex() {
        return this.m_lResumeStartIndex;
    }

    private void SetResumeEndIndex(long lEndIndex) {
        this.m_lResumeEndIndex = lEndIndex;
    }

    private long GetResumeEndIndex() {
        return this.m_lResumeEndIndex;
    }

    private void SetResumeRange(long lStartIndex, long lEndIndex) {
        this.SetResumeStartIndex(lStartIndex);
        this.SetResumeEndIndex(lEndIndex);
    }

    public URL GetDownloadMediaURI(String sAbsFromPath) {
        URL url = null;
        if (this.GetURLFactory() != null) {
            url = this.GetURLFactory().CreateDownloadMedia(sAbsFromPath);
        }
        return url;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DYNAMIC_BUFFER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_UPLOAD_INDICES = false;
        DEBUG_SPEED_LISTING = DEBUG;
    }
}

