/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.parsers;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.parsers.CParsedObj;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.net.CListDirEvent;
import com.rhinosoft.fvjv.net.CSUConnection;
import com.rhinosoft.fvjv.net.IListDirListener;
import com.rhinosoft.fvjv.parsers.CResult;
import com.rhinosoft.fvjv.strings.CString;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CListing
extends CResult {
    public static final boolean DEBUG_TRACK_LISTENERS;
    public static final int CSV_COL_HAS_PARENT_DIR = 1;
    public static final int CSV_COL_PARENT_NAME = 2;
    public static final int CSV_COL_PARENT_IS_DRIVE = 3;
    public static final int CSV_COL_PARENT_DRIVE_TYPE = 4;
    public static final int CSV_COL_PARENT_DRIVE_LABEL = 5;
    public static final int CSV_COL_CHILD_NAME = 0;
    public static final int CSV_COL_CHILD_SIZE = 1;
    public static final int CSV_COL_CHILD_MODIFIED_TIMESTAMP = 2;
    public static final int CSV_COL_CHILD_ACCESSED_TIMESTAMP = 3;
    public static final int CSV_COL_CHILD_CREATED_TIMESTAMP = 4;
    public static final int CSV_COL_CHILD_IS_DIR = 5;
    public static final int CSV_COL_CHILD_IS_READ_ONLY = 6;
    public static final int CSV_COL_CHILD_IS_LINK = 7;
    public static final int CSV_COL_CHILD_IS_IMAGE = 8;
    public static final int CSV_COL_CHILD_IS_DRIVE = 9;
    public static final int CSV_COL_CHILD_DRIVE_TYPE = 10;
    public static final int CSV_COL_CHILD_DRIVE_LABEL = 11;
    private boolean m_bIsParent = false;
    private boolean m_bHasParent = false;
    private String m_sName = "";
    private boolean m_bIsDrive = false;
    private int m_nDriveType = 0;
    private String m_sDriveLabel = "";
    private long m_lSize = -1L;
    private long m_lDateModified = -1L;
    private long m_lDateAccessed = -1L;
    private long m_lDateCreated = -1L;
    private boolean m_bIsDirectory = false;
    private boolean m_bIsReadOnly = false;
    private boolean m_bIsLink = false;
    private boolean m_bIsImage = false;
    private Vector<CListing> m_aChildren = new Vector();
    private CListing m_rCurrentChild = null;
    private Vector<IListDirListener> m_aListDirListeners = new Vector();
    private CRemoteFile m_fParent;
    public static final int NUM_OF_CHILDREN_TO_FIRE_EVENT = 50;
    private Vector<CFile> m_aChildFiles = new Vector();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block2: {
                    CListing Tag2 = new CListing(null);
                    try {
                        FileInputStream fis = new FileInputStream("C:\\Temp2\\List.csv");
                        Tag2.Parse(fis, true, false);
                    }
                    catch (Exception e) {
                        if (!CParsedObj.DEBUG) break block2;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public CListing(CSUConnection rSUConnection) {
        super(rSUConnection);
    }

    @Override
    public void finalize() throws Throwable {
        if (this.m_aChildren != null) {
            this.m_aChildren.clear();
        }
        this.m_aChildren = null;
        this.m_rCurrentChild = null;
        this.m_aListDirListeners.clear();
        if (this.m_aChildFiles != null) {
            this.m_aChildFiles.clear();
        }
        this.m_aChildFiles = null;
        super.finalize();
    }

    @Override
    public int Parse(InputStream inStream, boolean bReset, boolean bIsCompressedData) {
        int nRc = super.Parse(inStream, bReset, bIsCompressedData);
        this.FireChildFiles(true);
        return nRc;
    }

    @Override
    protected int ProcessLine(StringBuilder rsLine) {
        int nRet = 0;
        if (rsLine.length() > 0) {
            if (this.m_nLineNumber == 0) {
                this.m_rCurrentChild = null;
                String sValue = null;
                String[] asCols = rsLine.toString().split(",");
                if (asCols.length <= 6) {
                    block22: for (int nIdx = 0; nIdx < asCols.length; ++nIdx) {
                        sValue = asCols[nIdx];
                        switch (nIdx) {
                            case 0: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    this.m_nResult = nVal;
                                    continue block22;
                                }
                                nRet = 21;
                                continue block22;
                            }
                            case 1: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    this.m_bHasParent = bVal;
                                    continue block22;
                                }
                                nRet = 21;
                                continue block22;
                            }
                            case 2: {
                                this.m_sName = CUtils.UrlDecode(sValue);
                                continue block22;
                            }
                            case 3: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    this.m_bIsDrive = bVal;
                                    continue block22;
                                }
                                nRet = 21;
                                continue block22;
                            }
                            case 4: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    this.m_nDriveType = nVal;
                                    continue block22;
                                }
                                nRet = 21;
                                continue block22;
                            }
                            case 5: {
                                this.m_sDriveLabel = sValue;
                                continue block22;
                            }
                            default: {
                                if (!DEBUG) continue block22;
                                System.out.println("WARNING:  Unknown case in CListing.ProcessLine | Parent.");
                            }
                        }
                    }
                    this.m_fParent = new CRemoteFile(this.m_sName, true);
                    this.m_fParent.SetUpDirEnabled(this.m_bHasParent);
                    this.m_fParent.SetIsDrive(this.m_bIsDrive);
                    this.m_fParent.SetDriveType(this.m_nDriveType);
                    this.m_fParent.SetDriveLabel(this.m_sDriveLabel);
                    CListDirEvent rEvent = new CListDirEvent(this.m_fParent);
                    this.FireRecvParent(rEvent);
                } else if (DEBUG) {
                    System.out.println("WARNING:  Unknown column length in CListing.ProcessLine | Parent.");
                }
            } else {
                this.m_sName = "";
                this.m_nDriveType = 0;
                this.m_sDriveLabel = "";
                String sValue = null;
                String[] asCols = rsLine.toString().split(",");
                if (asCols.length <= 12) {
                    CListing Child = new CListing(null);
                    this.m_aChildren.add(Child);
                    this.m_rCurrentChild = Child;
                    block23: for (int nIdx = 0; nIdx < asCols.length; ++nIdx) {
                        sValue = asCols[nIdx];
                        switch (nIdx) {
                            case 0: {
                                String sAbsParent;
                                String sName = CUtils.UrlDecode(sValue);
                                if (this.m_rCurrentChild == null) continue block23;
                                String sAbsChild = sAbsParent = this.m_fParent.GetAbsFileName();
                                sAbsChild = CString.EnsureLastCharIsAForwardSlash(sAbsChild);
                                sAbsChild = sAbsChild + sName;
                                this.m_rCurrentChild.m_sName = sAbsChild = CString.MakeForwardSlashes(sAbsChild);
                                continue block23;
                            }
                            case 1: {
                                Long lVal = this.ParseLong(sValue);
                                if (lVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_lSize = lVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 2: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_lDateModified = CUtils.ConvertTimeT(lTimeT);
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 3: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_lDateAccessed = CUtils.ConvertTimeT(lTimeT);
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 4: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_lDateCreated = CUtils.ConvertTimeT(lTimeT);
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 5: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_bIsDirectory = bVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 6: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_bIsReadOnly = bVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 7: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_bIsLink = bVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 8: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_bIsImage = bVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 9: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_bIsDrive = bVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 10: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    if (this.m_rCurrentChild == null) continue block23;
                                    this.m_rCurrentChild.m_nDriveType = nVal;
                                    continue block23;
                                }
                                nRet = 21;
                                continue block23;
                            }
                            case 11: {
                                if (this.m_rCurrentChild == null) continue block23;
                                this.m_rCurrentChild.m_sDriveLabel = sValue;
                                continue block23;
                            }
                            default: {
                                if (!DEBUG) continue block23;
                                System.out.println("WARNING:  Unknown case in CListing.ProcessLine | Child.");
                            }
                        }
                    }
                    if (this.m_rCurrentChild != null) {
                        CRemoteFile fChild = new CRemoteFile(this.m_rCurrentChild.m_sName, this.m_rCurrentChild.m_bIsDirectory);
                        this.m_fParent.AddChildFile(fChild, false, false);
                        fChild.SetSize(this.m_rCurrentChild.m_lSize);
                        fChild.SetModifiedDate(this.m_rCurrentChild.m_lDateModified);
                        fChild.SetTimestampCreated(this.m_rCurrentChild.m_lDateCreated);
                        fChild.SetTimestampLastAccessed(this.m_rCurrentChild.m_lDateAccessed);
                        fChild.SetIsReadOnly(this.m_rCurrentChild.m_bIsReadOnly);
                        fChild.SetIsLink(this.m_rCurrentChild.m_bIsLink);
                        fChild.SetIsImage(this.m_rCurrentChild.m_bIsImage);
                        fChild.SetIsDrive(this.m_rCurrentChild.m_bIsDrive);
                        fChild.SetDriveType(this.m_rCurrentChild.m_nDriveType);
                        fChild.SetDriveLabel(this.m_rCurrentChild.m_sDriveLabel);
                        fChild.SetForThread(true);
                        this.AddChildFile(fChild);
                        this.FireChildFiles();
                        this.m_rCurrentChild = null;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else if (DEBUG) {
                    System.out.println("WARNING:  Unknown column length in CListing.ProcessLine | Child.");
                }
            }
        }
        ++this.m_nLineNumber;
        return nRet;
    }

    protected Vector<IListDirListener> GetListDirListeners() {
        return this.m_aListDirListeners;
    }

    public void AddListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().add(rListener);
        }
    }

    public void RemoveListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().remove(rListener);
        }
    }

    protected void FireRecvParent(CListDirEvent rEvent) {
        if (!$assertionsDisabled && rEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.GetListDirListeners() == null) {
            throw new AssertionError();
        }
        for (int nIdx = this.GetListDirListeners().size() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetListDirListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvParentFile(rEvent);
        }
    }

    protected void FireRecvChildFiles(CListDirEvent rEvent) {
        if (!$assertionsDisabled && rEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.GetListDirListeners() == null) {
            throw new AssertionError();
        }
        for (int nIdx = this.GetListDirListeners().size() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetListDirListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvChildFiles(rEvent);
        }
    }

    public CRemoteFile GetParent() {
        return this.m_fParent;
    }

    private void AddChildFile(CFile fChild) {
        this.m_aChildFiles.add(fChild);
    }

    private void FireChildFiles() {
        this.FireChildFiles(false);
    }

    private void FireChildFiles(boolean bForce) {
        if (this.m_aChildFiles.size() >= 50 || bForce) {
            CListDirEvent rEvent = new CListDirEvent(this.GetParent());
            rEvent.SetFiles(this.m_aChildFiles);
            this.FireRecvChildFiles(rEvent);
            this.m_aChildFiles.clear();
        }
    }

    @Override
    protected void DumpObj(int nRetCode) {
        System.out.println("Start dump object...");
        System.out.printf("  Routine Code: %d\n", nRetCode);
        System.out.printf("  Result: %s\n", Integer.toString(this.m_nResult));
        System.out.println("  Parent ...");
        System.out.printf("    Name: %s\n", this.m_sName);
        System.out.printf("    HasParent: %s\n", Boolean.toString(this.m_bHasParent));
        System.out.printf("    IsDrive: %s\n", Boolean.toString(this.m_bIsDrive));
        System.out.printf("    DriveType: %s\n", Integer.toString(this.m_nDriveType));
        System.out.printf("    DriveLabel: %s\n", this.m_sDriveLabel);
        System.out.println("  ... Parent");
        if (this.m_aChildren != null) {
            for (CListing rChild : this.m_aChildren) {
                if (rChild == null) continue;
                System.out.println("      Child ....");
                System.out.printf("        Name: %s\n", rChild.m_sName);
                System.out.printf("        Size: %s\n", Long.toString(rChild.m_lSize));
                System.out.printf("        DateModified: %s\n", Long.toString(rChild.m_lDateModified));
                System.out.printf("        DateAccessed: %s\n", Long.toString(rChild.m_lDateAccessed));
                System.out.printf("        DateCreated: %s\n", Long.toString(rChild.m_lDateCreated));
                System.out.printf("        IsDirectory: %s\n", Boolean.toString(rChild.m_bIsDirectory));
                System.out.printf("        IsReadOnly: %s\n", Boolean.toString(rChild.m_bIsReadOnly));
                System.out.printf("        IsLink: %s\n", Boolean.toString(rChild.m_bIsLink));
                System.out.printf("        IsImage: %s\n", Boolean.toString(rChild.m_bIsImage));
                System.out.printf("        IsDrive: %s\n", Boolean.toString(rChild.m_bIsDrive));
                System.out.printf("\t       DriveType: %s\n", Integer.toString(rChild.m_nDriveType));
                System.out.printf("        DriveLabel: %s\n", rChild.m_sDriveLabel);
                System.out.println("      ... Child");
            }
        }
        System.out.println("... End dump object");
    }

    static {
        boolean bl = $assertionsDisabled = !CListing.class.desiredAssertionStatus();
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_LISTENERS = false;
    }
}

