/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.parsers;

import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.parsers.CXMLParser;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.util.HashMap;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CXMLParserResult
extends CXMLParser {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    public static final String XML_TAG_RESULT = "RC";
    public static final int XML_PARSING_RESULT = 0;
    protected int m_nResultVal = -1;
    private HashMap<String, String> m_asXMLAttributes;

    public int GetResult() {
        return this.m_nResultVal;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.m_nResultVal = 1;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String sNamespaceURI, String sName, String sFQName, Attributes jAttrs) throws SAXException {
        super.startElement(sNamespaceURI, sName, sFQName, jAttrs);
        String sXMLTag = this.PrepareXmlTag(sName, sFQName);
        this.m_nParsingTag = -1;
        if (sXMLTag.equalsIgnoreCase(XML_TAG_RESULT)) {
            this.m_nParsingTag = 0;
        }
        if (jAttrs != null) {
            for (int i = 0; i < jAttrs.getLength(); ++i) {
                String sAttrName = jAttrs.getLocalName(i);
                if (sAttrName.equals("")) {
                    sAttrName = jAttrs.getQName(i);
                }
                if (!DEBUG) continue;
                System.out.println("TODO:  handle the attribute");
            }
        }
    }

    @Override
    public void endElement(String sNamespaceURI, String sName, String sFQName) throws SAXException {
        super.endElement(sNamespaceURI, sName, sFQName);
        String sXMLTag = this.PrepareXmlTag(sName, sFQName);
        this.m_nParsingTag = -1;
    }

    @Override
    public void characters(char[] szBuf, int nOffset, int nLen) throws SAXException {
        String sValue;
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("characters -->");
        }
        if ((sValue = new String(szBuf, nOffset, nLen)) != null && !sValue.isEmpty()) {
            switch (this.m_nParsingTag) {
                case 0: {
                    int nValue = CConversionUtils.ConvertToInt(sValue);
                    if (!CConversionUtils.IsValidInt(nValue)) break;
                    this.m_nResultVal = nValue;
                    break;
                }
            }
        }
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("characters <--");
        }
    }

    private void CopyMap(HashMap aFrom, HashMap aTo) {
        if (aFrom != null && aTo != null) {
            Set aKeys = aFrom.keySet();
            for (Object rKey : aKeys) {
                if (rKey == null) continue;
                aTo.put(rKey, aFrom.get(rKey));
            }
        }
    }
}

