/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.strings;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CStringTable {
    public static final boolean DEBUG;
    private String m_sBundlePath;
    private Locale m_UserLocale;
    private ResourceBundle m_ResourceBundle;

    public CStringTable(String sBundlePath, String sLanguageCode, String sCountryCode) {
        block5: {
            this.InitVars();
            this.SetBundlePath(sBundlePath);
            try {
                this.m_UserLocale = new Locale(sLanguageCode, sCountryCode);
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = Locale.getDefault();
                }
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
                if (DEBUG) {
                    System.out.printf("Loading Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                    System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                System.out.printf("Failed to load Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                e.printStackTrace();
            }
        }
        this.Load(this.GetBundlePath(), this.m_UserLocale);
    }

    private void InitVars() {
        this.m_UserLocale = Locale.US;
    }

    private boolean Load(String sBundlePath, Locale rLocale) {
        boolean bLoaded;
        block3: {
            bLoaded = false;
            try {
                this.m_ResourceBundle = ResourceBundle.getBundle(sBundlePath, rLocale);
                if (DEBUG) {
                    System.out.printf("Loaded ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                }
                bLoaded = true;
            }
            catch (MissingResourceException exc) {
                this.m_ResourceBundle = null;
                if (!DEBUG) break block3;
                System.out.printf("Failed to load ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                exc.printStackTrace();
            }
        }
        return bLoaded;
    }

    public Locale GetUserLocale() {
        return this.m_UserLocale;
    }

    protected String GetBundlePath() {
        return this.m_sBundlePath;
    }

    protected void SetBundlePath(String sBundlePath) {
        this.m_sBundlePath = sBundlePath;
    }

    public String GetString(String sKey) {
        String sVal = sKey;
        if (this.m_ResourceBundle != null) {
            sVal = this.m_ResourceBundle.getString(sKey);
        }
        return sVal;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG = false;
    }
}

