/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUConnection;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Toolkit;
import java.util.HashMap;

public abstract class CThreadMsg
extends CWorkerThreadID {
    protected static boolean DEBUG;
    private CSUConnection m_SUConnection;
    private int m_nHTTPCode = 503;
    private int m_nSUResult = 1;
    boolean m_bStop = false;
    private int m_nErrorID = 0;
    private CClientInfo m_ClientInfo;
    private static HashMap<Integer, String> m_aHTTPErrorText;
    private static HashMap<Integer, String> m_aSUErrorText;
    private static HashMap<Integer, String> m_aSUErrorDesc;

    public CThreadMsg(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource);
        this.InitVars(rClientInfo, nCompressionType);
    }

    protected CThreadMsg(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsg) {
            this.Copy((CThreadMsg)rCopyFrom, false);
        }
    }

    public abstract Object clone();

    @Override
    public abstract void ProcessEvent();

    @Override
    public abstract void OnError();

    private void InitVars(CClientInfo rClientInfo, int nCompressionType) {
        this.m_ClientInfo = new CClientInfo(rClientInfo);
        this.m_SUConnection = new CSUConnection(this.m_ClientInfo, nCompressionType);
    }

    public boolean Copy(CThreadMsg rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetSUConnection(rCopyFrom.GetSUConnection())) {
                bChanged = true;
            }
            if (this.SetHTTPCode(rCopyFrom.GetHTTPCode())) {
                bChanged = true;
            }
            if (this.SetSUResult(rCopyFrom.GetSUResult())) {
                bChanged = true;
            }
            if (this.SetErrorID(rCopyFrom.GetErrorID())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    public boolean SetHTTPCode(int nHTTPCode) {
        boolean bChanged = false;
        if (this.m_nHTTPCode != nHTTPCode) {
            this.m_nHTTPCode = nHTTPCode;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetHTTPCode() {
        return this.m_nHTTPCode;
    }

    public boolean SetSUResult(int nResult) {
        boolean bChanged = false;
        if (this.m_nSUResult != nResult) {
            this.m_nSUResult = nResult;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetSUResult() {
        return this.m_nSUResult;
    }

    protected void PostEvent(int nEventID) {
        this.PostEvent(nEventID, null);
    }

    protected void PostEvent(int nEventID, Object rEventObj) {
        if (this.GetSource() != null) {
            CRhinoEvent rEvent = new CRhinoEvent(this.GetSource(), nEventID, rEventObj);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
    }

    private boolean SetSUConnection(CSUConnection rSUConnection) {
        boolean bChanged = false;
        if (this.m_SUConnection != rSUConnection) {
            this.m_SUConnection = rSUConnection;
            bChanged = true;
        }
        return bChanged;
    }

    protected CSUConnection GetSUConnection() {
        return this.m_SUConnection;
    }

    @Override
    public void SetCancel(boolean bCancel) {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().SetCancel(bCancel);
        }
    }

    public boolean GetCancel() {
        boolean bCancel = false;
        if (this.GetSUConnection() != null) {
            bCancel = this.GetSUConnection().GetCancel();
        }
        return bCancel;
    }

    public synchronized void SetStop(boolean bStop) {
        this.m_bStop = bStop;
    }

    public synchronized boolean GetStop() {
        return this.m_bStop;
    }

    public void Stop() {
        this.SetStop(true);
        this.SetCancel(true);
    }

    public CClientInfo GetClientInfo() {
        return this.m_ClientInfo;
    }

    protected boolean SetErrorID(int nErrorID) {
        boolean bChanged = false;
        if (this.m_nErrorID != nErrorID) {
            this.m_nErrorID = nErrorID;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetErrorID() {
        return this.m_nErrorID;
    }

    public static String FormatErrorMsg(int nHTTPCode, int nSUCode) {
        String sHTTPError = CThreadMsg.FormatHTTPTextError(nHTTPCode);
        String sSUError = CThreadMsg.FormatSUTextError(nSUCode);
        String sError = CThreadMsg.GetSUError(nSUCode);
        String sErrorMsg = String.format(CString.LoadString("IDS_HTTP_ERROR_SU_RESULT"), sHTTPError, sSUError, sError);
        return sErrorMsg;
    }

    public static String FormatHTTPTextError(int nHTTPCode) {
        String sHTTPError = "";
        String sError = CThreadMsg.GetHTTPError(nHTTPCode);
        sHTTPError = sError != null && !sError.isEmpty() ? String.format("%s (%d)", sError, nHTTPCode) : String.format("%d", nHTTPCode);
        return sHTTPError;
    }

    public static String FormatSUTextError(int nSUCode) {
        String sSUError = "";
        String sError = CThreadMsg.GetSUErrorText(nSUCode);
        sSUError = sError != null && !sError.isEmpty() ? String.format("%s (%d)", sError, nSUCode) : String.format("%d", nSUCode);
        return sSUError;
    }

    public static String GetHTTPError(int nHTTPCode) {
        String sItem;
        String sError = CString.LoadString("IDS_HTTP_CODE_UNAVAILABLE");
        if (m_aHTTPErrorText != null && (sItem = m_aHTTPErrorText.get(nHTTPCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    public static String GetSUError(int nSUCode) {
        String sItem;
        String sError = CString.LoadString("IDS_SU_CODE_SESS_FAIL");
        if (m_aSUErrorDesc != null && (sItem = m_aSUErrorDesc.get(nSUCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    public static String GetSUErrorText(int nSUCode) {
        String sItem;
        String sError = "SESS_UNKNOWN";
        if (m_aSUErrorText != null && (sItem = m_aSUErrorText.get(nSUCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    private static HashMap<Integer, String> CreateHTTPErrorText() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(200, CString.LoadString("IDS_HTTP_CODE_OK"));
        map.put(201, CString.LoadString("IDS_HTTP_CODE_CREATED"));
        map.put(202, CString.LoadString("IDS_HTTP_CODE_ACCEPTED"));
        map.put(203, CString.LoadString("IDS_HTTP_CODE_NOT_AUTHORITATIVE"));
        map.put(204, CString.LoadString("IDS_HTTP_CODE_NO_CONTENT"));
        map.put(205, CString.LoadString("IDS_HTTP_CODE_RESET"));
        map.put(206, CString.LoadString("IDS_HTTP_CODE_PARTIAL"));
        map.put(300, CString.LoadString("IDS_HTTP_CODE_MULT_CHOICE"));
        map.put(301, CString.LoadString("IDS_HTTP_CODE_MOVED_PERM"));
        map.put(302, CString.LoadString("IDS_HTTP_CODE_MOVED_TEMP"));
        map.put(303, CString.LoadString("IDS_HTTP_CODE_SEE_OTHER"));
        map.put(304, CString.LoadString("IDS_HTTP_CODE_NOT_MODIFIED"));
        map.put(305, CString.LoadString("IDS_HTTP_CODE_USE_PROXY"));
        map.put(307, CString.LoadString("IDS_HTTP_CODE_TEMP_REDIR"));
        map.put(400, CString.LoadString("IDS_HTTP_CODE_BAD_REQUEST"));
        map.put(401, CString.LoadString("IDS_HTTP_CODE_UNAUTHORIZED"));
        map.put(402, CString.LoadString("IDS_HTTP_CODE_PAYMENT_REQUIRED"));
        map.put(403, CString.LoadString("IDS_HTTP_CODE_FORBIDDEN"));
        map.put(404, CString.LoadString("IDS_HTTP_CODE_NOT_FOUND"));
        map.put(405, CString.LoadString("IDS_HTTP_CODE_BAD_METHOD"));
        map.put(406, CString.LoadString("IDS_HTTP_CODE_NOT_ACCEPTABLE"));
        map.put(407, CString.LoadString("IDS_HTTP_CODE_PROXY_AUTH"));
        map.put(408, CString.LoadString("IDS_HTTP_CODE_CLIENT_TIMEOUT"));
        map.put(409, CString.LoadString("IDS_HTTP_CODE_CONFLICT"));
        map.put(410, CString.LoadString("IDS_HTTP_CODE_GONE"));
        map.put(411, CString.LoadString("IDS_HTTP_CODE_LENGTH_REQUIRED"));
        map.put(412, CString.LoadString("IDS_HTTP_CODE_PRECON_FAILED"));
        map.put(413, CString.LoadString("IDS_HTTP_CODE_ENTITY_TOO_LARGE"));
        map.put(414, CString.LoadString("IDS_HTTP_CODE_REQ_TOO_LONG"));
        map.put(415, CString.LoadString("IDS_HTTP_CODE_UNSUPPORTED_TYPE"));
        map.put(500, CString.LoadString("IDS_HTTP_CODE_INTERNAL_ERROR"));
        map.put(501, CString.LoadString("IDS_HTTP_CODE_NOT_IMPLEMENTED"));
        map.put(502, CString.LoadString("IDS_HTTP_CODE_BAD_GATEWAY"));
        map.put(503, CString.LoadString("IDS_HTTP_CODE_UNAVAILABLE"));
        map.put(504, CString.LoadString("IDS_HTTP_CODE_GATEWAY_TIMEOUT"));
        map.put(505, CString.LoadString("IDS_HTTP_CODE_VERSION"));
        return map;
    }

    private static HashMap<Integer, String> CreateSUErrorText() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(-2, "SESS_USER_CANCELLED");
        map.put(-1, "SESS_UNKNOWN");
        map.put(0, "SESS_OKAY");
        map.put(1, "SESS_FAIL");
        map.put(2, "SESS_PENDING");
        map.put(3, "SESS_PERMISSION_DENIED");
        map.put(4, "SESS_INVALID_PARAMETER");
        map.put(5, "SESS_BAD_SEQUENCE_OF_COMMANDS");
        map.put(6, "SESS_NOT_FOUND");
        map.put(7, "SESS_PATH_IS_PORT");
        map.put(8, "SESS_LOGIN_TOO_MANY_INVALID_TRIES");
        map.put(9, "SESS_COMMAND_PENDING");
        map.put(10, "SESS_COMMAND_ABORTED");
        map.put(11, "SESS_INTERNAL_ERROR");
        map.put(12, "SESS_ALREADY_EXISTS");
        map.put(13, "SESS_FILE_IS_DIR");
        map.put(14, "SESS_DIR_IS_FILE");
        map.put(15, "SESS_CANT_REST_EMPTY_FILE");
        map.put(16, "SESS_CANT_REST_BEYOND_EOF");
        map.put(17, "SESS_CANT_SET_FILE_POS");
        map.put(18, "SESS_COMPRESSED_TRANSFER_COMPLETE");
        map.put(19, "SESS_UNAUTHORIZED_IP");
        map.put(20, "SESS_TIME_OUT");
        map.put(21, "SESS_EXCEEDED_MAX_SESSION_TIME");
        map.put(22, "SESS_TOO_MANY_SESSIONS_IP");
        map.put(23, "SESS_TOO_MANY_SESSIONS");
        map.put(24, "SESS_BLOCKED");
        map.put(25, "SESS_DATA_SOCKET_CONNECT");
        map.put(26, "SESS_DATA_SOCKET_CLOSED");
        map.put(27, "SESS_DECR_USER_QUOTA");
        map.put(28, "SESS_NO_FILES_FOUND");
        map.put(29, "SESS_LOCK_CONFLICT");
        map.put(30, "SESS_ADMIN_ABORTED");
        map.put(31, "SESS_UNAUTHORIZED");
        map.put(33, "SESS_NO_SUCH_PATH");
        map.put(34, "SESS_INVALID_PATH");
        map.put(35, "SESS_PROTOCOL_NOT_ALLOWED_FOR_USER");
        map.put(38, "SESS_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN");
        map.put(100, "SESS_USER_OKAY_NEED_PWD");
        map.put(101, "SESS_USER_NOT_FOUND");
        map.put(102, "SESS_USER_OKAY_NEED_EMAIL");
        map.put(104, "SESS_USER_NEED_SECURE_CONNECTION");
        map.put(202, "SESS_PASSWORD_EXPIRED_CHANGE");
        map.put(300, "SESS_CHG_PASSWORD_NO_OLD_PASSWORD_MATCH");
        map.put(301, "SESS_CHG_PASSWORD_TOO_SHORT");
        map.put(302, "SESS_CHG_PASSWORD_NOT_COMPLEX");
        map.put(303, "SESS_CHG_PASSWORD_OLD_NEW_MATCH");
        map.put(304, "SESS_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS");
        map.put(400, "SESS_XCRC_CANNOT_READ_FROM_FILE");
        map.put(601, "SESS_CANT_LOAD_GDI_PLUS");
        map.put(602, "SESS_CANT_CREATE_THUMBNAIL");
        map.put(603, "SESS_CANT_SAVE_THUMBNAIL");
        map.put(605, "SESS_CANT_WRITE");
        map.put(606, "SESS_SERVER_STOP_PENDING");
        map.put(607, "SESS_RETR_INSUFFICIENT_CREDIT");
        map.put(608, "SESS_STOR_INSUFFICIENT_DISK_QUOTA");
        map.put(609, "SESS_STOR_INSUFFICIENT_DISK_SPACE");
        map.put(610, "SESS_STOR_FILE_TOO_LARGE");
        map.put(700, "SESS_FUTURE_TIME");
        map.put(906, "SESS_LIC_NO_FVJV");
        return map;
    }

    private static HashMap<Integer, String> CreateSUErrorDesc() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, CString.LoadString("IDS_SU_CODE_SESS_OKAY"));
        map.put(1, CString.LoadString("IDS_SU_CODE_SESS_FAIL"));
        map.put(2, CString.LoadString("IDS_SU_CODE_SESS_PENDING"));
        map.put(3, CString.LoadString("IDS_SU_CODE_SESS_PERMISSION_DENIED"));
        map.put(4, CString.LoadString("IDS_SU_CODE_SESS_INVALID_PARAMETER"));
        map.put(5, CString.LoadString("IDS_SU_CODE_SESS_BAD_SEQUENCE_OF_COMMANDS"));
        map.put(6, CString.LoadString("IDS_SU_CODE_SESS_NOT_FOUND"));
        map.put(7, CString.LoadString("IDS_SU_CODE_SESS_PATH_IS_PORT"));
        map.put(8, CString.LoadString("IDS_SU_CODE_SESS_LOGIN_TOO_MANY_INVALID_TRIES"));
        map.put(9, CString.LoadString("IDS_SU_CODE_SESS_COMMAND_PENDING"));
        map.put(10, CString.LoadString("IDS_SU_CODE_SESS_COMMAND_ABORTED"));
        map.put(11, CString.LoadString("IDS_SU_CODE_SESS_INTERNAL_ERROR"));
        map.put(12, CString.LoadString("IDS_SU_CODE_SESS_ALREADY_EXISTS"));
        map.put(13, CString.LoadString("IDS_SU_CODE_SESS_FILE_IS_DIR"));
        map.put(14, CString.LoadString("IDS_SU_CODE_SESS_DIR_IS_FILE"));
        map.put(15, CString.LoadString("IDS_SU_CODE_SESS_CANT_REST_EMPTY_FILE"));
        map.put(16, CString.LoadString("IDS_SU_CODE_SESS_CANT_REST_BEYOND_EOF"));
        map.put(17, CString.LoadString("IDS_SU_CODE_SESS_CANT_SET_FILE_POS"));
        map.put(18, CString.LoadString("IDS_SU_CODE_SESS_COMPRESSED_TRANSFER_COMPLETE"));
        map.put(19, CString.LoadString("IDS_SU_CODE_SESS_UNAUTHORIZED_IP"));
        map.put(20, CString.LoadString("IDS_SU_CODE_SESS_TIME_OUT"));
        map.put(21, CString.LoadString("IDS_SU_CODE_SESS_EXCEEDED_MAX_SESSION_TIME"));
        map.put(22, CString.LoadString("IDS_SU_CODE_SESS_TOO_MANY_SESSIONS_IP"));
        map.put(23, CString.LoadString("IDS_SU_CODE_SESS_TOO_MANY_SESSIONS"));
        map.put(24, CString.LoadString("IDS_SU_CODE_SESS_BLOCKED"));
        map.put(25, CString.LoadString("IDS_SU_CODE_SESS_DATA_SOCKET_CONNECT"));
        map.put(26, CString.LoadString("IDS_SU_CODE_SESS_DATA_SOCKET_CLOSED"));
        map.put(27, CString.LoadString("IDS_SU_CODE_SESS_DECR_USER_QUOTA"));
        map.put(28, CString.LoadString("IDS_SU_CODE_SESS_NO_FILES_FOUND"));
        map.put(29, CString.LoadString("IDS_SU_CODE_SESS_LOCK_CONFLICT"));
        map.put(30, CString.LoadString("IDS_SU_CODE_SESS_ADMIN_ABORTED"));
        map.put(31, CString.LoadString("IDS_SU_CODE_SESS_UNAUTHORIZED"));
        map.put(33, CString.LoadString("IDS_SU_CODE_SESS_NO_SUCH_PATH"));
        map.put(34, CString.LoadString("IDS_SU_CODE_SESS_INVALID_PATH"));
        map.put(35, String.format(CString.LoadString("IDS_SU_CODE_SESS_PROTOCOL_NOT_ALLOWED_FOR_USER"), "FTP Voyager JV"));
        map.put(38, CString.LoadString("IDS_SU_CODE_SESS_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN"));
        map.put(100, CString.LoadString("IDS_SU_CODE_SESS_USER_OKAY_NEED_PWD"));
        map.put(101, CString.LoadString("IDS_SU_CODE_SESS_USER_NOT_FOUND"));
        map.put(102, CString.LoadString("IDS_SU_CODE_SESS_USER_OKAY_NEED_EMAIL"));
        map.put(104, CString.LoadString("IDS_SU_CODE_SESS_USER_NEED_SECURE_CONNECTION"));
        map.put(300, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_NO_OLD_PASSWORD_MATCH"));
        map.put(301, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_TOO_SHORT"));
        map.put(302, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_NOT_COMPLEX"));
        map.put(303, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_OLD_NEW_MATCH"));
        map.put(304, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS"));
        map.put(400, CString.LoadString("IDS_SU_CODE_SESS_XCRC_CANNOT_READ_FROM_FILE"));
        map.put(601, CString.LoadString("IDS_SU_CODE_SESS_CANT_LOAD_GDI_PLUS"));
        map.put(602, CString.LoadString("IDS_SU_CODE_SESS_CANT_CREATE_THUMBNAIL"));
        map.put(603, CString.LoadString("IDS_SU_CODE_SESS_CANT_SAVE_THUMBNAIL"));
        map.put(605, CString.LoadString("IDS_SU_CODE_SESS_CANT_WRITE"));
        map.put(606, CString.LoadString("IDS_SU_CODE_SESS_SERVER_STOP_PENDING"));
        map.put(607, CString.LoadString("IDS_SU_CODE_SESS_RETR_INSUFFICIENT_CREDIT"));
        map.put(608, CString.LoadString("IDS_SU_CODE_SESS_STOR_INSUFFICIENT_DISK_QUOTA"));
        map.put(609, CString.LoadString("IDS_SU_CODE_SESS_STOR_INSUFFICIENT_DISK_SPACE"));
        map.put(610, CString.LoadString("IDS_SU_CODE_SESS_STOR_FILE_TOO_LARGE"));
        map.put(700, CString.LoadString("IDS_SU_CODE_SESS_FUTURE_TIME"));
        map.put(906, String.format(CString.LoadString("IDS_SU_CODE_SESS_LIC_NO_FVJV"), "FTP Voyager JV"));
        return map;
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (this.GetSUConnection() != null) {
            nCompressionType = this.GetSUConnection().GetCompressionType();
        }
        return nCompressionType;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG = false;
        m_aHTTPErrorText = CThreadMsg.CreateHTTPErrorText();
        m_aSUErrorText = CThreadMsg.CreateSUErrorText();
        m_aSUErrorDesc = CThreadMsg.CreateSUErrorDesc();
    }
}

