/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.ImageIcon;

public abstract class CThreadMsgCopy
extends CThreadMsgTransfer {
    public CThreadMsgCopy(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 20, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgCopy(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgCopy) {
            this.Copy((CThreadMsgCopy)rCopyFrom, false);
        }
    }

    protected abstract int[] CopyFile(CPath var1, CPath var2);

    @Override
    protected void PrepareTransfer(boolean bPostInitTransfer) {
        if (this.GetMovingFiles()) {
            if (bPostInitTransfer) {
                this.PostNewTransferEvent();
            }
            this.SetPrepDone(true);
            this.PostEvent(6053, this.clone());
        } else {
            super.PrepareTransfer(bPostInitTransfer);
        }
    }

    @Override
    protected boolean InitiateTransfer(CPath rFromPath, CPath rToPath) {
        boolean bSuccessful = false;
        bSuccessful = this.GetMovingFiles() ? this.Transfer(rFromPath, rToPath) : super.InitiateTransfer(rFromPath, rToPath);
        return bSuccessful;
    }

    @Override
    protected boolean Transfer(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes;
        boolean bContinue = false;
        if (this.GetStartTime() <= 0L || this.GetResume()) {
            this.SetStartTime(System.currentTimeMillis());
        }
        if (rFromPath != null && rToPath != null && (anRetCodes = this.CopyFile(rFromPath, rToPath)) != null && anRetCodes.length == 2) {
            this.SetHTTPCode(anRetCodes[0]);
            this.SetSUResult(anRetCodes[1]);
            if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                bContinue = true;
            }
        }
        return bContinue;
    }

    protected void CheckFileReplace(CPath rDestinationPath) {
        int[] anRc;
        boolean bCanOverwrite;
        if (rDestinationPath != null && (bCanOverwrite = this.GetCanOverwrite()) && !rDestinationPath.IsDir() && (anRc = this.Delete(rDestinationPath)) != null && anRc.length == 2 && anRc[1] == 0) {
            this.SetIsRenameReplace(true);
            this.PostDelete(rDestinationPath);
            this.SetIsRenameReplace(false);
        }
    }

    private boolean IsSourceInTarget(String sAbsDir) {
        boolean bRet = false;
        for (int nIdx = this.GetToPathSize() - 1; nIdx >= 0 && !bRet; --nIdx) {
            String sPath;
            CPath rPath = this.GetToPath(nIdx);
            if (rPath == null || !rPath.IsDir() || (sPath = rPath.GetPath()) == null || sPath.isEmpty()) continue;
            bRet = sPath.startsWith(sAbsDir);
        }
        return bRet;
    }

    private boolean DeletePath(CPath rPath) {
        boolean bContinue = true;
        this.SetDeletePath(rPath);
        int[] anRetCodes = this.Delete(rPath);
        if (anRetCodes != null && anRetCodes.length == 2) {
            if (anRetCodes[0] == 200 && (anRetCodes[1] == 0 || anRetCodes[1] == 6)) {
                this.PostDelete(this.GetDeletePath());
                this.SetDeletePath(null);
            } else {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
                this.SetErrorID(43);
                this.PostEvent(3005, this);
                bContinue = false;
            }
        }
        return bContinue;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir() {
        int[] anRet;
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        CThreadMsgCreateDir CreatedDirMsg = super.CreateThreadMsgCreateDir();
        if (this.GetMovingFiles() && (anRet = CreatedDirMsg.ListPath(rToPath))[0] == 200 && (anRet[1] == 0 || anRet[1] == 12) && !rToPath.IsLocal()) {
            CRemoteFile fListFile = null;
            if (CreatedDirMsg.GetSUConnection() != null) {
                fListFile = CreatedDirMsg.GetSUConnection().GetListDir();
            }
            CreatedDirMsg.SetListFile(fListFile);
        }
        return CreatedDirMsg;
    }

    @Override
    protected void OnConfirmFailedToTransfer() {
        CPath rFromPath = this.GetFromPath(this.GetPathIndex());
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && rFromPath != null && rToPath != null) {
            String sDetails;
            Image rImage;
            long lThreadID = this.GetThread().getId();
            CConfirmTransferFailedDlg dlg = new CConfirmTransferFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            ImageIcon rIcon = CMainFrame.GetJARImage("Copy16.png");
            if (rIcon != null && (rImage = rIcon.getImage()) != null) {
                dlg.setIconImage(rImage);
            }
            String sTitle = "";
            String sMsg = "";
            if (this.GetMovingFiles()) {
                sTitle = CString.LoadString("IDS_CONFIRM_MOVE_FAILED_TITLE");
                sMsg = String.format(CString.LoadString("IDS_CONFIRM_MOVE_FAILED_FMT_MSG"), rFromPath.GetPath(), rToPath.GetPath());
            } else {
                sTitle = CString.LoadString("IDS_CONFIRM_COPY_FAILED_TITLE");
                sMsg = String.format(CString.LoadString("IDS_CONFIRM_COPY_FAILED_FMT_MSG"), rFromPath.GetPath(), rToPath.GetPath());
            }
            dlg.setTitle(sTitle);
            if (this.GetSUResult() == 3) {
                sMsg = this.GetMovingFiles() ? String.format("%s\r\n\r\n%s", sMsg, CString.LoadString("IDS_CONFIRM_MOVE_FAILED_FMT_MSG_PERM_DENIED")) : String.format("%s\r\n\r\n%s", sMsg, CString.LoadString("IDS_CONFIRM_COPY_FAILED_FMT_MSG_PERM_DENIED"));
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (rFromPath.IsLocal() && rToPath.IsLocal()) {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgCopy.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                case 1: {
                    this.OnSkip();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }
}

