/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmDeleteDlg;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmDeleteFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgPaths;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFrame;

public abstract class CThreadMsgDelete
extends CThreadMsgPaths {
    private boolean m_bCanDelReadOnly = false;
    private CPath m_rPrevDelReadOnly = null;
    private boolean m_bPrevDelReadOnly = false;
    private CPath m_rDelPath;
    private boolean m_bIsRenameReplace = false;
    private boolean m_bApplyToAllDelReadOnly = false;
    private int m_nApplyToAllDelReadOnlyOpt = 2;
    private boolean m_bCanDelete = false;
    private boolean m_bApplyToAllDelete = false;
    private int m_nApplyToAllDeleteOpt = 2;

    public CThreadMsgDelete(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        this(tThread, 8, rSource, rClientInfo, nCompressionType);
    }

    public CThreadMsgDelete(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgDelete(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgDelete) {
            this.Copy((CThreadMsgDelete)rCopyFrom, false);
        }
    }

    private void InitVars() {
    }

    public boolean Copy(CThreadMsgDelete rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetCanDelReadOnly(rCopyFrom.GetCanDelReadOnly())) {
                bChanged = true;
            }
            if (rCopyFrom.GetDeletePath() != null && this.SetDeletePath(rCopyFrom.GetDeletePath().clone())) {
                bChanged = true;
            }
            if (this.SetApplyToAllDelReadOnly(rCopyFrom.GetApplyToAllDelReadOnly())) {
                bChanged = true;
            }
            if (this.SetApplyToAllDelReadOnlyOpt(rCopyFrom.GetApplyToAllDelReadOnlyOpt())) {
                bChanged = true;
            }
            if (this.SetIsRenameReplace(rCopyFrom.IsRenameReplace())) {
                bChanged = true;
            }
            if (this.SetCanDelete(rCopyFrom.GetCanDeleteFlag())) {
                bChanged = true;
            }
            if (this.SetApplyToAllDelete(rCopyFrom.GetApplyToAllDelete())) {
                bChanged = true;
            }
            if (this.SetApplyToAllDeleteOpt(rCopyFrom.GetApplyToAllDeleteOpt())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    @Override
    public void ProcessEvent() {
        this.OnDelete();
    }

    private void OnDelete() {
        boolean bContinue = true;
        this.SetCancel(false);
        for (int nIdx = this.GetPathIndex(); nIdx < this.GetFromPathSize() && bContinue && !this.GetCancel(); ++nIdx) {
            this.SetErrorID(0);
            this.SetPathIndex(nIdx);
            CPath rPath = this.GetFromPath(nIdx);
            if (rPath == null) continue;
            this.SetHTTPCode(503);
            this.SetSUResult(1);
            this.SetDeletePath(rPath);
            int[] anRetCodes = this.Delete(rPath);
            if (anRetCodes == null || anRetCodes.length != 2) continue;
            this.SetHTTPCode(anRetCodes[0]);
            this.SetSUResult(anRetCodes[1]);
            boolean bl = bContinue = anRetCodes[0] == 200 && (anRetCodes[1] == 0 || anRetCodes[1] == 6);
            if (bContinue) {
                this.PostDelete(rPath);
                continue;
            }
            this.SetErrorID(20);
            this.PostEvent(3005, this);
        }
    }

    protected int[] Delete(CPath rPath) {
        int[] anRetCodes = new int[]{503, 1};
        if (rPath != null) {
            if (rPath.IsLocal()) {
                anRetCodes[0] = 200;
                anRetCodes[1] = this.Delete(new File(rPath.GetPath()));
            } else if (this.GetSUConnection() != null) {
                anRetCodes = rPath.IsDir() ? this.GetSUConnection().SendDeleteDir(rPath.GetPath()) : this.GetSUConnection().SendDeleteFile(rPath.GetPath());
            }
        }
        return anRetCodes;
    }

    private int Delete(File fFile) {
        int nRc = 1;
        if (fFile != null && fFile.exists()) {
            if (fFile.isDirectory()) {
                File[] afFiles = fFile.listFiles();
                if (afFiles.length > 0) {
                    int nTemp = 0;
                    for (int nIdx = 0; nIdx < afFiles.length && nTemp == 0 && !this.GetCancel(); ++nIdx) {
                        File fNext = afFiles[nIdx];
                        nRc = nTemp = this.Delete(fNext);
                    }
                    afFiles = fFile.listFiles();
                }
                if (afFiles.length < 1) {
                    nRc = fFile.delete() ? 0 : 1;
                }
            } else {
                nRc = fFile.delete() ? 0 : 1;
            }
        } else {
            nRc = 6;
        }
        return nRc;
    }

    @Override
    public void OnError() {
        this.ProcessError();
        if (this.GetSUResult() == 6) {
            CPath rDelPath = this.GetDeletePath();
            this.PostDelete(rDelPath);
        }
    }

    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 20: {
                CPath rDelPath = this.GetDelPath(true);
                this.OnConfirmFailedToDelete(rDelPath);
                break;
            }
            case 42: {
                this.OnConfirmDelete();
                break;
            }
            default: {
                if (!DEBUG) break;
                System.out.println("Unhandled error | CThreadMsgDelete.ProcessError");
            }
        }
    }

    public boolean SetCanDelReadOnly(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bCanDelReadOnly != bVal) {
            this.m_bCanDelReadOnly = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean GetCanDelReadOnly() {
        return this.m_bCanDelReadOnly;
    }

    protected boolean IsOverwritePathAvailable(CPath rTestPath) {
        boolean bIsAvailable = false;
        if (rTestPath != null) {
            bIsAvailable = rTestPath.IsLocal() ? this.IsLocalPathAvailable(rTestPath) : this.IsRemotePathAvailable(rTestPath);
        }
        return bIsAvailable;
    }

    protected boolean IsLocalPathAvailable(CPath rTestPath) {
        return false;
    }

    protected boolean IsRemotePathAvailable(CPath rTestPath) {
        return false;
    }

    protected void OnConfirmFailedToDelete(CPath rDelPath) {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && rDelPath != null) {
            String sDetails;
            long lThreadID = this.GetThread().getId();
            CConfirmDeleteFailedDlg dlg = new CConfirmDeleteFailedDlg((Frame)this.GetDeleteFrame(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_DELETE_FAILED_DEF_MSG");
            sMsg = this.GetSUResult() == 3 ? String.format(CString.LoadString("IDS_CONFIRM_DELETE_FAILED_PERM_DENIED"), rDelPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_DELETE_FAILED_FMT_MSG"), rDelPath.GetPath());
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (!rDelPath.IsLocal()) {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgDelete.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                case 1: {
                    this.OnSkip();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    public void OnCancel(boolean bPostEvent) {
        this.SetStop(false);
        this.SetCancel(true);
        this.SetCanDelReadOnly(false);
        if (bPostEvent) {
            this.PostEvent(3020, this);
        }
    }

    public void OnSkip() {
        this.OnInternalSkip();
        this.SetPathIndex(this.GetPathIndex() + 1);
        if (this.GetWorkerThread() != null) {
            this.GetWorkerThread().PostMessage(this);
        }
    }

    protected void OnInternalSkip() {
        this.SetStop(false);
        this.SetCancel(false);
        this.SetCanDelReadOnly(false);
        this.SetErrorID(0);
    }

    public void OnRetry() {
        this.SetStop(false);
        this.SetCancel(false);
        if (this.GetWorkerThread() != null) {
            this.GetWorkerThread().PostMessage(this);
        }
    }

    protected void PostDelete(CPath rDelPath) {
        this.SetDeletePath(rDelPath);
        CThreadMsgDelete rMsg = (CThreadMsgDelete)this.clone();
        rMsg.SetMsgID(8);
        this.PostEvent(3021, rMsg);
    }

    public CPath GetDeletePath() {
        return this.m_rDelPath;
    }

    protected boolean SetDeletePath(CPath rDelPath) {
        boolean bChanged = false;
        if (this.m_rDelPath != rDelPath) {
            this.m_rDelPath = rDelPath;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean SetIsRenameReplace(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsRenameReplace != bVal) {
            this.m_bIsRenameReplace = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsRenameReplace() {
        return this.m_bIsRenameReplace;
    }

    protected boolean GetApplyToAllDelReadOnly() {
        return this.m_bApplyToAllDelReadOnly;
    }

    protected boolean SetApplyToAllDelReadOnly(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bApplyToAllDelReadOnly != bVal) {
            this.m_bApplyToAllDelReadOnly = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected int GetApplyToAllDelReadOnlyOpt() {
        return this.m_nApplyToAllDelReadOnlyOpt;
    }

    protected boolean SetApplyToAllDelReadOnlyOpt(int nOpt) {
        boolean bChanged = false;
        if (this.m_nApplyToAllDelReadOnlyOpt != nOpt) {
            this.m_nApplyToAllDelReadOnlyOpt = nOpt;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean SetCanDelete(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bCanDelete != bVal) {
            this.m_bCanDelete = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean GetCanDeleteFlag() {
        return this.m_bCanDelete;
    }

    protected boolean GetApplyToAllDelete() {
        return this.m_bApplyToAllDelete;
    }

    protected boolean SetApplyToAllDelete(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bApplyToAllDelete != bVal) {
            this.m_bApplyToAllDelete = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected int GetApplyToAllDeleteOpt() {
        return this.m_nApplyToAllDeleteOpt;
    }

    protected boolean SetApplyToAllDeleteOpt(int nOpt) {
        boolean bChanged = false;
        if (this.m_nApplyToAllDeleteOpt != nOpt) {
            this.m_nApplyToAllDeleteOpt = nOpt;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean GetCanDelete() {
        if (this.GetApplyToAllDelete() && this.GetApplyToAllDeleteOpt() == 0) {
            this.SetCanDelete(true);
        }
        return this.GetCanDeleteFlag();
    }

    protected boolean GetDefConfirmDelete() {
        return true;
    }

    protected boolean GetConfirmDelete() {
        boolean bConfirmDelete = this.GetDefConfirmDelete();
        if (this.GetBaseThread() != null) {
            bConfirmDelete = this.GetBaseThread().GetConfirmDelete();
        }
        return bConfirmDelete;
    }

    public void OnDeleteConfirmed() {
        this.SetStop(false);
        this.SetCancel(false);
        this.SetCanDelete(true);
        if (this.GetWorkerThread() != null) {
            this.GetWorkerThread().PostMessage(this);
        }
    }

    protected void ResetFlags() {
        this.SetStop(false);
        this.SetCanDelete(false);
        this.SetCanDelReadOnly(false);
    }

    protected boolean VerifyDelete() {
        boolean bCanDelete = this.GetCanDelete();
        if (!bCanDelete) {
            bCanDelete = !this.GetConfirmDelete();
        }
        return bCanDelete;
    }

    protected CPath GetDelPath(boolean bIsFromPath) {
        CPath rDelPath = this.GetFromPath(this.GetPathIndex());
        if (!bIsFromPath) {
            rDelPath = this.GetToPath(this.GetPathIndex());
        }
        return rDelPath;
    }

    protected JFrame GetDeleteFrame() {
        return CMainFrame.GET_APP();
    }

    protected boolean GetShowConfirmDeleteSkipBtn() {
        boolean bShowSkipBtn = true;
        if (this.GetPathIndex() >= this.GetFromPathSize() - 1) {
            bShowSkipBtn = false;
        }
        return bShowSkipBtn;
    }

    protected boolean GetShowConfirmDeleteApplyToAllBtn() {
        return this.GetFromPathSize() > 1;
    }

    private void OnConfirmDelete() {
        CPath rDelPath = this.GetDelPath(true);
        if (rDelPath != null) {
            long lThreadID = -1L;
            if (this.GetThread() != null) {
                lThreadID = this.GetThread().getId();
            }
            if (this.GetApplyToAllDelete()) {
                this.OnConfirmDeleteOpt(this.GetApplyToAllDeleteOpt());
            } else {
                CConfirmDeleteDlg dlg = new CConfirmDeleteDlg((Frame)this.GetDeleteFrame(), true, lThreadID);
                String sMsg = String.format(CString.LoadString("IDS_CONFIRM_DEL_PERMANENT1"), rDelPath.GetPath());
                dlg.SetMainMsg(sMsg);
                boolean bShowSkipBtn = this.GetShowConfirmDeleteSkipBtn();
                dlg.ShowSkipBtn(bShowSkipBtn);
                dlg.ShowApplyToAllBtn(this.GetShowConfirmDeleteApplyToAllBtn());
                dlg.setVisible(true);
                this.SetApplyToAllDelete(dlg.GetApplyToAll());
                this.SetApplyToAllDeleteOpt(2);
                int nRc = dlg.GetExitCode();
                this.OnConfirmDeleteOpt(nRc);
            }
        } else if (DEBUG) {
            CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "DeletePath should never be NULL!", true);
        }
    }

    private void OnConfirmDeleteOpt(int nOpt) {
        switch (nOpt) {
            case 0: {
                this.SetApplyToAllDeleteOpt(0);
                this.OnDeleteConfirmed();
                break;
            }
            case 1: {
                this.SetApplyToAllDeleteOpt(1);
                this.OnSkip();
                break;
            }
            default: {
                this.OnCancel(true);
            }
        }
    }
}

