/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmListFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryItem;
import com.rhinosoft.fvjv.net.CListDirEvent;
import com.rhinosoft.fvjv.net.CSUConnection;
import com.rhinosoft.fvjv.net.IListDirListener;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgDelete;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileSystemView;

public abstract class CThreadMsgList
extends CThreadMsgDelete
implements IListDirListener {
    private CFile m_fListFile = null;
    private boolean m_bIsSetWorkingDir = false;
    private boolean m_bRecurSearch = false;
    private int m_nSearchStopIdx = -1;
    private JPopupMenu m_rPopupMenu;
    private boolean m_bExpandTreeNode = true;
    private boolean m_bRenameTreeNode = false;
    private CHistoryItem m_rHistoryItem;
    private boolean m_bDispatchListUpdates = true;
    private boolean m_bCanOverwrite = false;
    private boolean m_bApplyToAllOverwrite = false;
    private int m_nApplyToAllOverwriteOpt = 2;
    private CFile m_rPrevListDir;
    private String m_sPrevListPathPath;
    private long m_lPrevListPathSize;
    private File m_fComputerFile;
    private int m_nFromIdxBeforeExpandPaths = -1;

    public CThreadMsgList(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgList(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgList) {
            CThreadMsgList rMsg = (CThreadMsgList)rCopyFrom;
            this.Copy(rMsg, false);
            if (rMsg.m_fListFile != null) {
                this.m_fListFile = rMsg.m_fListFile.clone();
            }
        }
    }

    private void InitVars() {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().AddListDirListener(this);
        }
        this.ResetPrevListData();
    }

    protected void ResetPrevListData() {
        this.m_rPrevListDir = null;
        this.m_sPrevListPathPath = null;
        this.m_lPrevListPathSize = -1L;
    }

    public boolean Copy(CThreadMsgList rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetListFile(rCopyFrom.GetListFile())) {
                bChanged = true;
            }
            if (this.SetIsSetWorkingDir(rCopyFrom.IsSetWorkingDir())) {
                bChanged = true;
            }
            if (this.SetIsRecursiveSearch(rCopyFrom.IsRecursiveSearch())) {
                bChanged = true;
            }
            if (this.SetSearchStopIndex(rCopyFrom.GetSearchStopIndex())) {
                bChanged = true;
            }
            if (this.SetCrumbMenu(rCopyFrom.GetCrumbMenu())) {
                bChanged = true;
            }
            if (this.SetExpandTreeNode(rCopyFrom.GetExpandTreeNode())) {
                bChanged = true;
            }
            if (this.SetRenameTreeNode(rCopyFrom.GetRenameTreeNode())) {
                bChanged = true;
            }
            if (this.SetHistoryItem(rCopyFrom.GetHistoryItem())) {
                bChanged = true;
            }
            if (this.SetApplyToAllOverwrite(rCopyFrom.GetApplyToAllOverwrite())) {
                bChanged = true;
            }
            if (this.SetApplyToAllOverwriteOpt(rCopyFrom.GetApplyToAllOverwriteOpt())) {
                bChanged = true;
            }
            if (this.SetPrevListDir(rCopyFrom.GetPrevListDir())) {
                bChanged = true;
            }
            if (this.SetPrevListPath(rCopyFrom.GetPrevListPathPath(), rCopyFrom.GetPrevListPathSize())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    public boolean SetListFile(CFile fListFile) {
        boolean bChanged = false;
        if (this.m_fListFile != fListFile) {
            this.m_fListFile = fListFile;
            bChanged = true;
        }
        return bChanged;
    }

    public CFile GetListFile() {
        return this.m_fListFile;
    }

    public boolean IsSetWorkingDir() {
        return this.m_bIsSetWorkingDir;
    }

    public boolean SetIsSetWorkingDir(boolean bIsSetWorkingDir) {
        boolean bChanged = false;
        if (this.m_bIsSetWorkingDir != bIsSetWorkingDir) {
            this.m_bIsSetWorkingDir = bIsSetWorkingDir;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsRecursiveSearch() {
        return this.m_bRecurSearch;
    }

    public boolean SetIsRecursiveSearch(boolean bIsRecurSearch) {
        boolean bChanged = false;
        if (this.m_bRecurSearch != bIsRecurSearch) {
            this.m_bRecurSearch = bIsRecurSearch;
            bChanged = true;
        }
        return bChanged;
    }

    public int GetSearchStopIndex() {
        return this.m_nSearchStopIdx;
    }

    public boolean SetSearchStopIndex(int nSearchStopIdx) {
        boolean bChanged = false;
        if (this.m_nSearchStopIdx != nSearchStopIdx) {
            this.m_nSearchStopIdx = nSearchStopIdx;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean SetCrumbMenu(JPopupMenu rPopupMenu) {
        boolean bChanged = false;
        if (this.m_rPopupMenu != rPopupMenu) {
            this.m_rPopupMenu = rPopupMenu;
            bChanged = true;
        }
        return bChanged;
    }

    public JPopupMenu GetCrumbMenu() {
        return this.m_rPopupMenu;
    }

    public boolean GetExpandTreeNode() {
        return this.m_bExpandTreeNode;
    }

    public boolean SetExpandTreeNode(boolean bExpandTreeNode) {
        boolean bChanged = false;
        if (this.m_bExpandTreeNode != bExpandTreeNode) {
            this.m_bExpandTreeNode = bExpandTreeNode;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetRenameTreeNode() {
        return this.m_bRenameTreeNode;
    }

    public boolean SetRenameTreeNode(boolean bRenameTreeNode) {
        boolean bChanged = false;
        if (this.m_bRenameTreeNode != bRenameTreeNode) {
            this.m_bRenameTreeNode = bRenameTreeNode;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean SetHistoryItem(CHistoryItem rHistoryItem) {
        boolean bChanged = false;
        if (this.m_rHistoryItem != rHistoryItem) {
            this.m_rHistoryItem = rHistoryItem;
            bChanged = true;
        }
        return bChanged;
    }

    public CHistoryItem GetHistoryItem() {
        return this.m_rHistoryItem;
    }

    @Override
    public void ProcessEvent() {
        this.OnList(true);
    }

    @Override
    public void OnRecvParentFile(CListDirEvent rListEvent) {
        if (this.AllowListUpdates()) {
            this.PostEvent(4001, rListEvent.GetFile());
        }
    }

    @Override
    public void OnRecvChildFile(CListDirEvent rListEvent) {
        if (this.AllowListUpdates()) {
            this.PostEvent(4002, rListEvent.GetFile());
        }
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 30: {
                CPath rFromPath = this.GetFromPath(this.GetPathIndex());
                this.OnConfirmFailedToList(rFromPath);
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    protected boolean OnList(boolean bUpdateGUIStopBtn) {
        boolean bContinue = true;
        if (DEBUG) {
            System.out.println("CThreadMsgList.OnList -->");
        }
        if (bUpdateGUIStopBtn && this.GetSource() != null) {
            CRhinoEvent rEvent = new CRhinoEvent(this.GetSource(), 9114, true);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
        this.SetErrorID(0);
        this.SetHTTPCode(503);
        this.SetSUResult(1);
        this.SetListFile(null);
        int nIdx = this.GetPathIndex();
        CPath rPath = this.GetFromPath(nIdx);
        if (rPath != null) {
            if (this.GetMsgID() == 5) {
                int[] anRetCodes = this.ListPath(rPath);
                if (anRetCodes != null && anRetCodes.length == 2) {
                    this.SetHTTPCode(anRetCodes[0]);
                    this.SetSUResult(anRetCodes[1]);
                }
                if (this.GetCancel()) {
                    if (DEBUG) {
                        System.out.println("CThreadMsg.OnList | ListPath | Cancelled");
                    }
                    this.PostEvent(3020, this);
                    bContinue = false;
                } else {
                    if (DEBUG) {
                        System.out.printf("CThreadMsg.OnList | ListPath | RetCodes: %d, %d\r\n", this.GetHTTPCode(), this.GetSUResult());
                    }
                    if (this.GetHTTPCode() == 200 && this.GetSUResult() == 0) {
                        this.OnSendListOK();
                    } else {
                        this.SetErrorID(30);
                        this.PostEvent(3005, this);
                        bContinue = false;
                    }
                }
            } else if (this.GetMsgID() == 7) {
                this.PrepareTransfer(false);
            }
        }
        if (bUpdateGUIStopBtn && this.GetSource() != null) {
            CRhinoEvent rEvent = new CRhinoEvent(this.GetSource(), 9114, false);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
        if (DEBUG) {
            System.out.println("CThreadMsgList.OnList <--");
        }
        return bContinue;
    }

    public int[] ListPath(CPath rPath) {
        return this.ListPath(this.GetSUConnection(), rPath);
    }

    protected int[] ListPath(CSUConnection rSUConn, CPath rPath) {
        int[] anRetCodes = new int[]{503, 1};
        anRetCodes = rPath.IsLocal() ? this.ListPathLocal(rSUConn, rPath) : this.ListPathRemote(rSUConn, rPath);
        return anRetCodes;
    }

    protected void PostNewTransferEvent() {
        Object[] anItems = new Object[]{this, this.clone()};
        this.PostEvent(6050, anItems);
        this.PostEvent(2902, this.clone());
    }

    protected void PrepareTransfer(boolean bPostInitTransfer) {
        if (bPostInitTransfer) {
            this.PostNewTransferEvent();
        }
        if (!this.IsPrepDone()) {
            if (this.ExpandPaths()) {
                this.SetPathIndex(0);
                this.SetPrepDone(true);
                this.PostEvent(6053, this.clone());
            } else {
                this.PostEvent(6054, this);
            }
        }
    }

    protected boolean ExpandPath(CPath rPath) {
        return this.ExpandPath(rPath, true);
    }

    protected boolean ExpandPath(CPath rPath, boolean bAddAsPaths) {
        boolean bRet = true;
        if (rPath != null) {
            CPath rLinkPath;
            if (rPath.IsDir() && !this.GetCancel()) {
                if (!rPath.IsLocal()) {
                    int[] anRet = this.ListPath(rPath);
                    if (anRet != null && anRet[0] == 200 && anRet[1] == 0 && this.GetSUConnection() != null) {
                        CRemoteFile fDir = this.GetSUConnection().GetListDir();
                        if (fDir != null) {
                            if (!this.IsRecursiveSearch()) {
                                this.SetSearchStopIndex(this.GetPathIndex() + fDir.GetChildFileCount());
                            }
                            for (int nIdx = 0; nIdx < fDir.GetChildFileCount(); ++nIdx) {
                                CFile fFile = fDir.GetChildFile(nIdx);
                                if (fFile == null) continue;
                                if (bAddAsPaths) {
                                    CPath rNewPath = fFile.CreatePath();
                                    this.AddFromPath(rNewPath);
                                    continue;
                                }
                                this.AddFromPath(fFile);
                            }
                        } else {
                            if (DEBUG) {
                                System.out.println("CThreadMsgList.ListPath no SUConnection.ListDir!");
                            }
                            bRet = false;
                        }
                    } else {
                        if (DEBUG) {
                            System.out.println("CThreadMsgList.ListPath no result codes found!");
                        }
                        bRet = false;
                    }
                } else {
                    File[] afSubFiles = null;
                    File fDir = new File(rPath.GetPath());
                    if (fDir != null && fDir.exists()) {
                        afSubFiles = fDir.listFiles();
                    } else if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsRoot(fDir.getAbsolutePath()) && (fDir = CFileSystemUtils.GetFileSysUtils().GetJavaFile(rPath.GetPath())) != null && fDir.exists()) {
                        afSubFiles = fDir.listFiles();
                    }
                    if (afSubFiles != null) {
                        for (int nIdx = 0; nIdx < afSubFiles.length; ++nIdx) {
                            File fNext = afSubFiles[nIdx];
                            if (fNext == null || !fNext.exists()) continue;
                            CPath rNewPath = this.CreateResolvedLinkPath(fNext);
                            if (rNewPath == null) {
                                rNewPath = new CPath(fNext.getAbsolutePath(), fNext.isDirectory(), true, fNext.length());
                            }
                            if (bAddAsPaths) {
                                this.AddFromPath(rNewPath);
                                continue;
                            }
                            CLocalFile fLocal = new CLocalFile(new File(rNewPath.GetPath()));
                            this.AddFromPath(fLocal);
                        }
                    } else {
                        bRet = false;
                    }
                }
            } else if (rPath.IsLink() && (rLinkPath = this.CreateResolvedLinkPath(rPath.GetPath())) != null) {
                rPath.SetIsDir(rLinkPath.IsDir());
                rPath.SetPath(CString.EnsureLastCharIsNotASlash(rLinkPath.GetPrevPath()));
                rPath.SetPath(CString.EnsureLastCharIsNotASlash(rLinkPath.GetPath()));
                rPath.SetLinkPath(rLinkPath.GetLinkPath());
                rPath.SetSize(rLinkPath.GetSize());
                rPath.SetIsReadOnly(rLinkPath.IsReadOnly());
                rPath.SetLastModified(rLinkPath.GetLastModified());
                if (rPath.IsDir()) {
                    bRet = this.ExpandPath(rPath, true);
                }
            }
        }
        return bRet;
    }

    protected CPath CreateResolvedLinkPath(String sAbsFilePath) {
        return null;
    }

    protected CPath CreateResolvedLinkPath(File fChild) {
        CPath rRetPath = null;
        if (fChild != null) {
            rRetPath = new CPath(fChild.getAbsolutePath(), fChild.isDirectory(), true, fChild.length());
        }
        return rRetPath;
    }

    protected CPath CreateLinkPath(String sPrevPath, String sPath, String sLinkPath, boolean bIsDir, boolean bIsLocal, long lSize, boolean bIsReadOnly, long lLastModified) {
        CPath rPath = new CPath(sPrevPath, bIsDir, bIsLocal);
        rPath.SetPath(sPath);
        rPath.SetLinkPath(sLinkPath);
        rPath.SetSize(lSize);
        rPath.SetIsReadOnly(bIsReadOnly);
        rPath.SetLastModified(lLastModified);
        rPath.SetIsLink(true);
        return rPath;
    }

    protected boolean ExpandPaths() {
        boolean bRet = true;
        this.SetFromIndexBeforeExpandPaths(this.GetFromPathSize() - 1);
        for (int nIdx = this.GetPathIndex(); nIdx < this.GetFromPathSize() && bRet && !this.GetCancel(); ++nIdx) {
            this.SetPathIndex(nIdx);
            CPath rFromPath = this.GetFromPath(nIdx);
            if (this.ExpandPath(rFromPath)) continue;
            bRet = false;
        }
        return bRet;
    }

    @Override
    protected boolean IsLocalPathAvailable(CPath rTestPath) {
        boolean bIsAvailable = true;
        File fTemp = new File(rTestPath.GetPath());
        bIsAvailable = !fTemp.exists();
        return bIsAvailable;
    }

    protected boolean CanUsePrevListPath(String sTestPath) {
        boolean bCanUsePrevPath = false;
        if (this.GetPrevListDir() != null && sTestPath != null) {
            String sPrevPath = this.GetPrevListPathPath();
            if (sTestPath != null && sPrevPath != null && sTestPath.equals(sPrevPath)) {
                bCanUsePrevPath = true;
            }
        }
        return bCanUsePrevPath;
    }

    @Override
    protected boolean IsRemotePathAvailable(CPath rTestPath) {
        boolean bIsAvailable = false;
        boolean bListFile = true;
        if (this.GetApplyToAllOverwrite()) {
            switch (this.GetApplyToAllOverwriteOpt()) {
                case 0: {
                    bListFile = false;
                    bIsAvailable = true;
                    break;
                }
            }
        }
        if (bListFile && rTestPath != null) {
            CFile rParent = null;
            if (this.CanUsePrevListPath(rTestPath.GetPath())) {
                rParent = this.GetPrevListDir();
            } else {
                this.TurnOffListUpdates();
                int[] anRetCodes = this.ListPath(rTestPath);
                this.TurnOnListUpdates();
                if (anRetCodes[0] == 200 && anRetCodes[1] == 0) {
                    if (this.GetSUConnection() != null) {
                        rParent = this.GetSUConnection().GetListDir();
                        this.SetPrevListDir(rParent);
                        if (rParent != null && rParent.GetChildFileCount() == 1) {
                            CFile rListedFile = rParent.GetChildFile(0);
                            if (rListedFile != null) {
                                this.SetPrevListPath(rListedFile.GetPath(), rListedFile.GetSize());
                            }
                        } else {
                            this.SetPrevListPath(rTestPath.GetPath(), 0L);
                        }
                    }
                } else if (anRetCodes[0] == 200 && anRetCodes[1] == 6) {
                    bIsAvailable = true;
                }
            }
            if (rParent != null && rParent.GetChildFileCount() < 1 && !rTestPath.GetPath().equals(rParent.GetAbsFileName())) {
                bIsAvailable = true;
            }
        }
        return bIsAvailable;
    }

    public void TurnOnListUpdates() {
        this.m_bDispatchListUpdates = true;
    }

    public void TurnOffListUpdates() {
        this.m_bDispatchListUpdates = false;
    }

    protected boolean AllowListUpdates() {
        return this.m_bDispatchListUpdates;
    }

    protected void OnConfirmFailedToList(CPath rListPath) {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && rListPath != null) {
            String sDetails;
            long lThreadID = this.GetThread().getId();
            CConfirmListFailedDlg dlg = new CConfirmListFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_LIST_FAILED_DEF_MSG");
            sMsg = this.GetSUResult() == 3 ? String.format(CString.LoadString("IDS_CONFIRM_LIST_FAILED_FMT_MSG_PERM_DENIED"), rListPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_LIST_FAILED_FMT_MSG"), rListPath.GetPath());
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (!rListPath.IsLocal()) {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgList.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    protected boolean VerifyOverwrite(boolean bIgnoreDirs) {
        boolean bCanOverwrite = this.GetCanOverwrite();
        if (!bCanOverwrite) {
            CPath rToPath;
            boolean bl = bCanOverwrite = !this.GetConfirmOverwrite();
            if (!bCanOverwrite && (rToPath = this.GetToPath(this.GetPathIndex())) != null) {
                if (bIgnoreDirs && rToPath.IsDir()) {
                    bCanOverwrite = true;
                    this.SetCanOverwrite(true);
                } else {
                    bCanOverwrite = this.IsOverwritePathAvailable(this.GetToPath(this.GetPathIndex()));
                }
            }
        }
        return bCanOverwrite;
    }

    protected boolean GetConfirmOverwrite() {
        boolean bConfirmOverwrite = this.GetDefConfirmOverwrite();
        if (this.GetBaseThread() != null) {
            bConfirmOverwrite = this.GetBaseThread().GetConfirmOverwrite();
        }
        return bConfirmOverwrite;
    }

    public boolean SetCanOverwrite(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bCanOverwrite != bVal) {
            this.m_bCanOverwrite = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean GetCanOverwrite() {
        if (this.GetApplyToAllOverwrite() && this.GetApplyToAllOverwriteOpt() == 0) {
            this.SetCanOverwrite(true);
        }
        return this.m_bCanOverwrite;
    }

    public void OnOverwrite() {
        this.SetStop(false);
        this.SetCancel(false);
        this.SetCanOverwrite(true);
        this.SetCanDelReadOnly(true);
        if (this.GetWorkerThread() != null) {
            this.GetWorkerThread().PostMessage(this);
        }
    }

    protected boolean GetDefConfirmOverwrite() {
        return true;
    }

    protected void OnSendListOK() {
        this.SetListFile(this.GetSUConnection().GetListDir());
        this.PostEvent(3021, this.clone());
    }

    protected boolean GetApplyToAllOverwrite() {
        return this.m_bApplyToAllOverwrite;
    }

    protected boolean SetApplyToAllOverwrite(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bApplyToAllOverwrite != bVal) {
            this.m_bApplyToAllOverwrite = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    protected int GetApplyToAllOverwriteOpt() {
        return this.m_nApplyToAllOverwriteOpt;
    }

    protected boolean SetApplyToAllOverwriteOpt(int nOpt) {
        boolean bChanged = false;
        if (this.m_nApplyToAllOverwriteOpt != nOpt) {
            this.m_nApplyToAllOverwriteOpt = nOpt;
            bChanged = true;
        }
        return bChanged;
    }

    protected File GetJavaFile(String sAbsPath) {
        File fFile = null;
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            fFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sAbsPath);
        }
        return fFile;
    }

    protected void FireRecvParentLocal(CListDirEvent rEvent) {
        assert (rEvent != null);
        assert (this.GetSUConnection() != null);
        for (int nIdx = this.GetSUConnection().GetListDirListenerCount() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetSUConnection().GetListDirListener(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvParentFile(rEvent);
        }
    }

    protected void FireRecvChildLocal(CListDirEvent rEvent) {
        assert (rEvent != null);
        assert (this.GetSUConnection() != null);
        for (int nIdx = this.GetSUConnection().GetListDirListenerCount() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetSUConnection().GetListDirListener(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvChildFile(rEvent);
        }
    }

    protected int[] ListPathLocal(CSUConnection rSUConn, CPath rPath) {
        if (DEBUG) {
            System.out.println("CThreadMsgList.ListPath -->");
        }
        int[] anRetCodes = new int[]{200, 1};
        File fFile = null;
        File[] afFiles = null;
        if (rPath != null) {
            fFile = this.GetJavaFile(rPath.GetPath());
        }
        if (fFile != null && fFile.exists()) {
            String sAbsPath = rPath.GetPath();
            if (sAbsPath != null && sAbsPath.endsWith("lnk")) {
                CWindowsLink link = new CWindowsLink(sAbsPath);
                String sResolvedPath = link.GetResolvedPath();
                fFile = sResolvedPath != null && !sResolvedPath.isEmpty() ? new File(sResolvedPath) : null;
            }
            if (fFile != null && fFile.exists()) {
                CLocalFile fListFile = new CLocalFile(fFile);
                fListFile.SetIcon16(CFileSystemUtils.GetImage16(fFile));
                fListFile.SetIcon32(CFileSystemUtils.GetImage32(fFile));
                this.SetListFile(fListFile);
                this.FireRecvParentLocal(new CListDirEvent(fListFile));
                afFiles = fFile.listFiles();
                this.ListFilesLocal(afFiles);
                if (this.GetComputerFile() != null) {
                    CPath rComputerPath = new CPath(this.GetComputerFile().getAbsolutePath(), this.GetComputerFile().isDirectory(), true);
                    this.GetBaseThread().PostListDir(this.GetSource(), this.GetClientInfo(), rSUConn.GetCompressionType(), rComputerPath, false, false, false, null, null);
                    this.SetComputerFile(null);
                }
                anRetCodes[1] = this.GetCancel() ? 1 : (this.GetFromPathSize() == 0 ? 1 : 0);
            } else {
                anRetCodes[1] = 33;
            }
        } else {
            anRetCodes[1] = 33;
        }
        if (DEBUG) {
            System.out.println("CThreadMsgList.ListPath <--");
        }
        return anRetCodes;
    }

    private void ListFilesLocal(File[] afFiles) {
        if (afFiles != null) {
            Vector afChildFiles = new Vector();
            for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                File fFile = afFiles[nIdx];
                if (fFile == null) continue;
                if (this.IsComputerFile(fFile)) {
                    this.SetComputerFile(fFile);
                }
                String sPath = fFile.getAbsolutePath();
                boolean bIsDir = fFile.isDirectory();
                long lLen = fFile.length();
                long lLastMod = fFile.lastModified();
                this.AddFromPath(new CPath(sPath, bIsDir, true, lLen, lLastMod));
                if (this.GetListFile() != null) {
                    CLocalFile fLocalFile = this.CreateLocalFile(fFile);
                    this.GetListFile().AddChildFile(fLocalFile, false, false);
                    this.FireRecvChildLocal(new CListDirEvent(fLocalFile));
                }
                if (!fFile.isDirectory() || !this.IsRecursiveSearch()) continue;
                this.ListFilesLocal(fFile.listFiles());
            }
            CListDirEvent rEvent = new CListDirEvent(this.GetListFile());
            this.OnRecvChildFiles(rEvent);
            afChildFiles.clear();
            Object var2_2 = null;
        }
    }

    protected int[] ListPathRemote(CSUConnection rSUConn, CPath rPath) {
        if (DEBUG) {
            System.out.println("CThreadMsgList.ListPath -->");
        }
        int[] anRetCodes = new int[]{503, 1};
        if (rSUConn != null) {
            anRetCodes = rPath.IsDir() ? rSUConn.SendListDir(rPath.GetPath()) : rSUConn.SendListFile(rPath.GetPath());
        }
        if (DEBUG) {
            System.out.println("CThreadMsgList.ListPath <--");
        }
        return anRetCodes;
    }

    protected boolean SetPrevListDir(CFile rPrevListDir) {
        boolean bChanged = false;
        if (this.m_rPrevListDir != rPrevListDir) {
            this.m_rPrevListDir = rPrevListDir;
            bChanged = true;
        }
        return bChanged;
    }

    protected CFile GetPrevListDir() {
        return this.m_rPrevListDir;
    }

    protected boolean SetPrevListPath(String sPath, long lSize) {
        boolean bChanged = true;
        this.m_sPrevListPathPath = sPath;
        bChanged = true;
        if (this.m_lPrevListPathSize != lSize) {
            this.m_lPrevListPathSize = lSize;
            bChanged = true;
        }
        return bChanged;
    }

    protected String GetPrevListPathPath() {
        return this.m_sPrevListPathPath;
    }

    protected long GetPrevListPathSize() {
        return this.m_lPrevListPathSize;
    }

    private boolean IsComputerFile(File fFile) {
        boolean bIsComputer = false;
        if (fFile != null) {
            if (FileSystemView.getFileSystemView() != null) {
                bIsComputer = FileSystemView.getFileSystemView().isComputerNode(fFile);
            }
            if (!bIsComputer && fFile.getPath().contains("::{20D04FE0-3AEA-1069-A2D8-08002B30309D}")) {
                bIsComputer = true;
            }
        }
        return bIsComputer;
    }

    private void SetComputerFile(File fFile) {
        this.m_fComputerFile = fFile;
    }

    private File GetComputerFile() {
        return this.m_fComputerFile;
    }

    private void SetFromIndexBeforeExpandPaths(int nFromIndex) {
        this.m_nFromIdxBeforeExpandPaths = nFromIndex;
    }

    private int GetFromIndexBeforeExpandPaths() {
        return this.m_nFromIdxBeforeExpandPaths;
    }

    protected CPath GetFromPathBeforeExpandPaths(String sPath) {
        CPath rFromPathBeforeExpandPaths = null;
        if (sPath != null) {
            for (int nIdx = 0; nIdx <= this.GetFromIndexBeforeExpandPaths(); ++nIdx) {
                CPath rFromPath = this.GetFromPath(nIdx);
                if (rFromPath == null || rFromPath.GetPath() == null || !sPath.startsWith(rFromPath.GetPath())) continue;
                if (rFromPathBeforeExpandPaths != null) {
                    if (rFromPath.GetPath().length() >= rFromPathBeforeExpandPaths.GetPath().length()) continue;
                    rFromPathBeforeExpandPaths = rFromPath;
                    continue;
                }
                rFromPathBeforeExpandPaths = rFromPath;
            }
        }
        return rFromPathBeforeExpandPaths;
    }

    protected CLocalFile CreateLocalFile(File fFile) {
        CLocalFile fLocalFile = new CLocalFile(fFile);
        fLocalFile.SetDisplayName(FileSystemView.getFileSystemView().getSystemDisplayName(fFile));
        fLocalFile.SetIcon16(CFileSystemUtils.GetImage16(fFile));
        fLocalFile.SetIcon32(CFileSystemUtils.GetImage32(fFile));
        return fLocalFile;
    }

    @Override
    public void OnRecvChildFiles(CListDirEvent rListEvent) {
        if (this.AllowListUpdates()) {
            this.PostEvent(4003, rListEvent);
        }
    }
}

