/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmDeleteFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferOverwriteDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CTransferStatsEvent;
import com.rhinosoft.fvjv.net.ITransferStatsListener;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;

public abstract class CThreadMsgTransfer
extends CThreadMsgList
implements ITransferStatsListener {
    public static final boolean DEBUG_TRACK_STATS_READ;
    public static final boolean DEBUG_TRACK_STATS_OVERALL;
    private String m_sAbsTransferFrom;
    private String m_sAbsTransferTo;
    private long m_lFileRead = 0L;
    private long m_lFileTotal = 0L;
    private long m_lOverallRead = 0L;
    private long m_lOverallTotal = 0L;
    private long m_lBytesPerSec = 0L;
    private long m_lStartTime = 0L;
    private long m_lMarkerTime = 0L;
    private long m_lResumeStartIndex = 0L;
    private boolean m_bMovingFiles = false;
    private boolean m_bOpeningFiles = false;
    private boolean m_bPrevStopAtNextItem = false;
    private long m_lPrevFileRead = 0L;
    private boolean m_bStopAtNextItem = false;
    private boolean m_bMoveToNextItem = false;
    private CPath m_rPrevResumePath;
    private boolean m_bCanResume = false;
    private long m_lTransferred = 0L;
    private Vector<CPath> m_arDelDirs;
    private boolean m_bIsSearch;

    public CThreadMsgTransfer(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
        this.InitVars();
    }

    protected CThreadMsgTransfer(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgTransfer) {
            this.Copy((CThreadMsgTransfer)rCopyFrom, false);
        }
    }

    public abstract boolean IsDownload();

    protected abstract CFile CreateTargetDir(CPath var1);

    protected abstract boolean Transfer(CPath var1, CPath var2);

    protected abstract CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg var1);

    private void InitVars() {
        this.m_arDelDirs = new Vector();
    }

    public boolean Copy(CThreadMsgTransfer rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
                bChanged = true;
            }
            if (this.SetTransferFromPath(rCopyFrom.GetTransferFromPath())) {
                bChanged = true;
            }
            if (this.SetTransferToPath(rCopyFrom.GetTransferToPath())) {
                bChanged = true;
            }
            if (this.SetFileRead(rCopyFrom.GetFileRead())) {
                bChanged = true;
            }
            if (this.SetFileTotal(rCopyFrom.GetFileTotal())) {
                bChanged = true;
            }
            if (this.SetOverallRead(rCopyFrom.GetOverallRead())) {
                bChanged = true;
            }
            if (this.SetOverallTotal(rCopyFrom.GetOverallTotal())) {
                bChanged = true;
            }
            if (this.SetBytesPerSecond(rCopyFrom.GetBytesPerSecond())) {
                bChanged = true;
            }
            if (this.SetStartTime(rCopyFrom.GetStartTime())) {
                bChanged = true;
            }
            if (this.SetMarkerTime(rCopyFrom.GetMarkerTime())) {
                bChanged = true;
            }
            if (this.SetMovingFiles(rCopyFrom.GetMovingFiles())) {
                bChanged = true;
            }
            if (this.SetOpeningFiles(rCopyFrom.GetOpeningFiles())) {
                bChanged = true;
            }
            if (this.SetCanOverwrite(rCopyFrom.GetCanOverwrite())) {
                bChanged = true;
            }
            if (this.SetResumeStartIndex(rCopyFrom.GetResumeStartIndex())) {
                bChanged = true;
            }
            if (this.SetTransferred(rCopyFrom.GetTransferred())) {
                bChanged = true;
            }
            if (this.SetIsSearch(rCopyFrom.IsSearch())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    public boolean SetTransferFromPath(String sAbsDirPath) {
        boolean bChanged = false;
        if (this.m_sAbsTransferFrom == null || !this.m_sAbsTransferFrom.equals(sAbsDirPath)) {
            this.m_sAbsTransferFrom = sAbsDirPath;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetTransferFromPath() {
        return this.m_sAbsTransferFrom;
    }

    public boolean SetTransferToPath(String sAbsDirPath) {
        boolean bChanged = false;
        if (this.m_sAbsTransferTo == null || !this.m_sAbsTransferTo.equals(sAbsDirPath)) {
            this.m_sAbsTransferTo = sAbsDirPath;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetTransferToPath() {
        return this.m_sAbsTransferTo;
    }

    public boolean SetFileRead(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lFileRead != lNumOfBytes) {
            this.m_lFileRead = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetFileRead() {
        return this.m_lFileRead;
    }

    public boolean SetFileTotal(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lFileTotal != lNumOfBytes) {
            this.m_lFileTotal = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetFileTotal() {
        return this.m_lFileTotal;
    }

    public boolean SetOverallRead(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lOverallRead != lNumOfBytes) {
            this.m_lOverallRead = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetOverallRead() {
        return this.m_lOverallRead;
    }

    public boolean SetOverallTotal(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lOverallTotal != lNumOfBytes) {
            this.m_lOverallTotal = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetOverallTotal() {
        return this.m_lOverallTotal;
    }

    public boolean SetBytesPerSecond(long lBytesPerSec) {
        boolean bChanged = false;
        if (this.m_lBytesPerSec != lBytesPerSec) {
            this.m_lBytesPerSec = lBytesPerSec;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetBytesPerSecond() {
        return this.m_lBytesPerSec;
    }

    public boolean SetStartTime(long lTime) {
        boolean bChanged = false;
        if (this.m_lStartTime != lTime) {
            this.m_lStartTime = lTime;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetStartTime() {
        return this.m_lStartTime;
    }

    public boolean SetMarkerTime(long lTime) {
        boolean bChanged = false;
        if (this.m_lMarkerTime != lTime) {
            this.m_lMarkerTime = lTime;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetMarkerTime() {
        return this.m_lMarkerTime;
    }

    public boolean SetMovingFiles(boolean bMovingFiles) {
        boolean bChanged = false;
        if (this.m_bMovingFiles != bMovingFiles) {
            this.m_bMovingFiles = bMovingFiles;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetMovingFiles() {
        return this.m_bMovingFiles;
    }

    public boolean SetOpeningFiles(boolean bOpeningFiles) {
        boolean bChanged = false;
        if (this.m_bOpeningFiles != bOpeningFiles) {
            this.m_bOpeningFiles = bOpeningFiles;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean GetOpeningFiles() {
        return this.m_bOpeningFiles;
    }

    @Override
    public void ProcessEvent() {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().AddTransferStatsListener(this);
        }
        this.PostEvent(2902, this.clone());
        if (this.GetResume()) {
            if (DEBUG_TRACK_STATS_READ || DEBUG_TRACK_STATS_OVERALL) {
                System.out.printf("\r\n\r\nResuming...\r\n\r\n", new Object[0]);
            }
            this.StartTransfer();
        } else {
            this.PrepareTransfer(true);
            if (this.IsPrepDone()) {
                this.StartTransfer();
            }
        }
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().RemoveTransferStatsListener(this);
        }
    }

    @Override
    protected void PostNewTransferEvent() {
        boolean bPostRecvTransferNew = true;
        if (this.GetMsgID() == 23 || this.GetMsgID() == 22 || this.GetMsgID() == 20) {
            bPostRecvTransferNew = false;
        }
        if (bPostRecvTransferNew) {
            Object[] anItems = new Object[]{this, this.clone()};
            this.PostEvent(6050, anItems);
        }
        this.PostEvent(2902, this.clone());
    }

    @Override
    public void OnUpdateTransferStats(CTransferStatsEvent event) {
        this.SetFileRead(event.GetReadPos());
        this.SetFileTotal(event.GetReadMax());
        if (DEBUG_TRACK_STATS_READ) {
            System.out.printf("File Read: %d | File Total: %d\r\n", this.GetFileRead(), this.GetFileTotal());
            System.out.printf("Transferred: %d | Read: %d | Read Total: %d\r\n", event.GetTransferred(), event.GetReadPos(), event.GetReadMax());
        }
        long lOverallRead = this.GetOverallRead();
        if (event.GetRecalcOverall() && this.GetSUConnection() != null) {
            lOverallRead = 0L;
            for (int nIdx = 0; nIdx < this.GetFromPathSize() && nIdx < this.GetPathIndex(); ++nIdx) {
                CPath rPath = this.GetFromPath(nIdx);
                if (rPath == null) continue;
                lOverallRead += rPath.GetSize();
            }
            lOverallRead += event.GetReadPos();
            this.SetResumeStartIndex(event.GetResumeStartIndex());
        } else {
            lOverallRead += event.GetTransferred();
            this.SetResumeStartIndex(0L);
        }
        this.SetOverallRead(lOverallRead);
        if (DEBUG_TRACK_STATS_OVERALL) {
            System.out.printf("Overall Read: %d | Overall Total: %d | Resume Start: %d\r\n", this.GetOverallRead(), this.GetOverallTotal(), event.GetResumeStartIndex());
        }
        this.SetMarkerTime(System.currentTimeMillis());
        this.SetTransferred(this.GetTransferred() + event.GetTransferred());
        this.SetBytesPerSecond(event.GetBytesPerSecond());
        this.PostEvent(6052, this.clone());
    }

    private void StartTransfer() {
        boolean bContinue = true;
        this.SetCancel(false);
        this.SetStop(false);
        this.m_bPrevStopAtNextItem = this.GetStopAtNextItem();
        this.SetStopAtNextItem(false);
        Object sDestination = null;
        for (int nIdx = this.GetPathIndex(); nIdx < this.GetFromPathSize() && bContinue && !this.GetCancel() && !this.GetStopAtNextItem(); ++nIdx) {
            this.SetErrorID(0);
            this.SetHTTPCode(503);
            this.SetSUResult(1);
            this.InitPathInfo(nIdx);
            CPath rFromPath = this.GetFromPath(nIdx);
            CPath rToPath = this.GetToPath(nIdx);
            if (rFromPath != null && rToPath != null) {
                boolean bCanOverwrite = this.VerifyOverwrite(true);
                if (bCanOverwrite || this.GetResume()) {
                    bContinue = this.InitiateTransfer(rFromPath, rToPath);
                    if (bContinue) {
                        if (rFromPath.IsDir()) {
                            CThreadMsgCreateDir CreatedDirMsg = this.CreateThreadMsgCreateDir();
                            this.PostEvent(3021, CreatedDirMsg);
                            this.ResetFlags();
                            this.ResetPrevListData();
                            if (this.GetMovingFiles()) {
                                this.AddDelDir(rFromPath);
                            }
                        } else {
                            bContinue = this.OnTransferItemDone();
                            if (nIdx + 1 < this.GetFromPathSize()) {
                                this.SetFileRead(-1L);
                                this.SetFileTotal(-1L);
                            }
                        }
                        this.OnCheckMove(rFromPath);
                        continue;
                    }
                    this.SetErrorID(40);
                    bContinue = this.OnTransferItemFailed();
                    continue;
                }
                this.SetFileRead(0L);
                this.SetFileTotal(rFromPath.GetSize());
                this.PostEvent(6052, this.clone());
                this.SetErrorID(41);
                this.PostEvent(3005, this);
                bContinue = false;
                continue;
            }
            if (DEBUG) {
                System.out.println("ASSERT:  rFromPath or rToPath = null");
            }
            this.SetErrorID(40);
            this.PostEvent(3005, this);
            bContinue = false;
        }
        if (this.GetStopAtNextItem()) {
            this.SetErrorID(10);
            this.PostEvent(3005, this);
        }
        if (bContinue) {
            this.CheckOpAllDone();
        }
    }

    @Override
    protected boolean ExpandPath(CPath rPath) {
        this.AdjustOverallTotal(rPath);
        return super.ExpandPath(rPath);
    }

    protected void AdjustOverallTotal(CPath rPath) {
        if (rPath != null) {
            long lSize;
            block5: {
                lSize = rPath.GetSize();
                if (rPath.IsLocal() && rPath.IsLink()) {
                    CWindowsLink link;
                    String sAbsPrevPath = rPath.GetPrevPath();
                    String sAbsLinkPath = rPath.GetLinkPath();
                    if (sAbsPrevPath != null && sAbsLinkPath == null && (link = new CWindowsLink(sAbsPrevPath)) != null && link.GetResolvedPath() != null) {
                        try {
                            File fFile = new File(link.GetResolvedPath());
                            lSize = fFile.length();
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block5;
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.SetOverallTotal(this.GetOverallTotal() + lSize);
        }
    }

    @Override
    public void OnError() {
        this.ProcessError();
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 41: {
                this.OnConfirmOverwrite();
                break;
            }
            case 10: {
                break;
            }
            case 40: {
                this.OnConfirmFailedToTransfer();
                break;
            }
            case 43: {
                CPath rDelPath = this.GetDelPath(true);
                this.OnConfirmFailedToDelete(rDelPath);
                break;
            }
            case 20: {
                CPath rDelPath = this.GetDelPath(false);
                this.OnConfirmFailedToDelete(rDelPath);
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    public void SetResume(boolean bResume) {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().SetResume(bResume);
        }
    }

    public boolean GetResume() {
        boolean bResume = false;
        if (this.GetApplyToAllOverwrite() && this.GetApplyToAllOverwriteOpt() == 8) {
            this.SetResume(true);
        }
        if (this.GetSUConnection() != null) {
            bResume = this.GetSUConnection().GetResume();
        }
        return bResume;
    }

    public synchronized boolean GetStopAtNextItem() {
        return this.m_bStopAtNextItem;
    }

    public synchronized void SetStopAtNextItem(boolean bStopAtNextItem) {
        this.m_bStopAtNextItem = bStopAtNextItem;
        if (this.GetThread() != null) {
            this.PostEvent(9024, this.GetThread().getId());
        }
    }

    public synchronized boolean GetMoveToNextItem() {
        return this.m_bMoveToNextItem;
    }

    public synchronized void SetMoveToNextItem(boolean bMoveToNextItem, boolean bSetCancel) {
        this.m_bMoveToNextItem = bMoveToNextItem;
        if (bSetCancel) {
            this.SetCancel(true);
        }
    }

    protected boolean IsTargetLocal(int nPathIdx) {
        boolean bIsTargetLocal = true;
        if (this.GetMsgID() == 24) {
            bIsTargetLocal = false;
        }
        return bIsTargetLocal;
    }

    private void InitPathInfo(int nPathIdx) {
        CPath rSourcePath;
        if (this.GetPathIndex() != nPathIdx) {
            this.SetPathIndex(nPathIdx);
        }
        if (this.GetToPath(nPathIdx) == null && (rSourcePath = this.GetFromPath(nPathIdx)) != null) {
            boolean bIsTargetLocal = this.IsTargetLocal(nPathIdx);
            String sDestination = null;
            if (rSourcePath.IsLink()) {
                sDestination = rSourcePath.GetPrevPath();
            } else if (this.IsSearch()) {
                CPath rFromPathBeforeExpandPaths;
                String sSourcePath = rSourcePath.GetPath();
                if (rSourcePath.IsLink()) {
                    sSourcePath = rSourcePath.GetPrevPath();
                }
                if ((rFromPathBeforeExpandPaths = this.GetFromPathBeforeExpandPaths(sSourcePath)) != null) {
                    String sParentPath = rFromPathBeforeExpandPaths.GetPath();
                    sParentPath = CString.MakeForwardSlashes(sParentPath);
                    int nLastIdx = (sParentPath = CString.EnsureLastCharIsNotAForwardSlash(sParentPath)).lastIndexOf(47);
                    if (nLastIdx >= 0 && nLastIdx < sParentPath.length()) {
                        sParentPath = sParentPath.substring(0, nLastIdx);
                    }
                    if (sParentPath != null) {
                        String sRelPath = sSourcePath.substring(sParentPath.length());
                        sRelPath = CString.MakeForwardSlashes(sRelPath);
                        sRelPath = CString.EnsureFirstCharIsAForwardSlash(sRelPath);
                        String sToPath = this.GetTransferToPath();
                        sToPath = CString.MakeForwardSlashes(sToPath);
                        sToPath = CString.EnsureLastCharIsNotAForwardSlash(sToPath);
                        sToPath = sToPath + sRelPath;
                        if (DEBUG) {
                            System.out.printf("Parent Path:  %s | Source Path: %s | RelPath: %s\r\nToPath: %s\r\n", sParentPath, sSourcePath, sRelPath, sToPath);
                        }
                        sDestination = sToPath;
                        if (this.GetMsgID() == 21 || this.GetMsgID() == 23 || this.GetMsgID() == 22 || this.GetMsgID() == 20 && !rSourcePath.IsLocal()) {
                            sDestination = sDestination.replace("/", File.separator);
                        }
                    }
                }
            } else {
                sDestination = CBaseThread.FmtDestinationPath(this.GetTransferFromPath(), rSourcePath.GetPath(), this.GetTransferToPath(), this.IsDownload());
            }
            if (this.GetMsgID() == 20 && (bIsTargetLocal = rSourcePath.IsLocal()) && sDestination != null) {
                sDestination = sDestination.replace('/', File.separatorChar);
            }
            if (sDestination != null && !sDestination.isEmpty()) {
                CPath rToPath = new CPath(sDestination, rSourcePath.IsDir(), bIsTargetLocal, rSourcePath.GetSize());
                this.SetToPath(nPathIdx, rToPath);
            }
        }
    }

    protected boolean InitiateTransfer(CPath rFromPath, CPath rToPath) {
        boolean bSuccessful = false;
        if (rFromPath != null && rToPath != null) {
            if (rFromPath.IsDir()) {
                CFile fCreatedDir = this.CreateTargetDir(rToPath);
                this.SetListFile(fCreatedDir);
                bSuccessful = fCreatedDir != null;
            } else {
                bSuccessful = this.Transfer(rFromPath, rToPath);
            }
        }
        return bSuccessful;
    }

    protected boolean IsLastItem() {
        return this.GetPathIndex() >= this.GetFromPathSize() - 1;
    }

    protected void CheckOpAllDone() {
        if (this.IsLastItem()) {
            this.OnCheckMove(null);
            this.PostOpAllDone();
        }
    }

    protected void PostOpAllDone() {
        this.SetPathIndex(this.GetFromPathSize() - 1);
        this.PostEvent(3022, this);
    }

    private void OnConfirmOverwriteOpt(int nOpt) {
        switch (nOpt) {
            case 0: {
                this.SetApplyToAllOverwriteOpt(0);
                this.OnOverwrite();
                break;
            }
            case 1: {
                this.SetApplyToAllOverwriteOpt(1);
                this.OnSkip();
                break;
            }
            case 8: {
                this.SetApplyToAllOverwriteOpt(8);
                this.OnResume();
                break;
            }
            default: {
                this.OnCancel(true);
            }
        }
    }

    private void OnConfirmOverwrite() {
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (rToPath != null) {
            long lThreadID = -1L;
            if (this.GetThread() != null) {
                lThreadID = this.GetThread().getId();
            }
            if (this.GetApplyToAllOverwrite()) {
                this.OnConfirmOverwriteOpt(this.GetApplyToAllOverwriteOpt());
            } else {
                CConfirmTransferOverwriteDlg dlg = new CConfirmTransferOverwriteDlg((Frame)this.GetDeleteFrame(), true, lThreadID);
                String sMsg = String.format(CString.LoadString("IDS_CONFIRM_OVERWRITE_DLG_MSG1"), rToPath.GetPath());
                dlg.SetMainMsg(sMsg);
                String sBtnMsg = CString.LoadString("IDS_CONFIRM_OVERWRITE_DLG_MSG2");
                dlg.SetBtnMsg(sBtnMsg);
                boolean bShowSkipBtn = true;
                if (this.GetPathIndex() >= this.GetFromPathSize() - 1) {
                    bShowSkipBtn = false;
                }
                dlg.ShowSkipBtn(bShowSkipBtn);
                boolean bShowResume = this.CanResume();
                dlg.ShowResumeBtn(bShowResume);
                dlg.ShowApplyToAllBtn(this.GetFromPathSize() > 1);
                dlg.setVisible(true);
                this.SetApplyToAllOverwrite(dlg.GetApplyToAll());
                this.SetApplyToAllOverwriteOpt(2);
                int nRc = dlg.GetExitCode();
                this.OnConfirmOverwriteOpt(nRc);
            }
        }
    }

    protected boolean CanResume() {
        boolean bCanResume = false;
        CPath rFromPath = this.GetFromPath(this.GetPathIndex());
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (rFromPath != null && rToPath != null && (rFromPath.IsLocal() && !rToPath.IsLocal() || !rFromPath.IsLocal() && rToPath.IsLocal())) {
            if (rToPath == this.m_rPrevResumePath) {
                bCanResume = this.m_bCanResume;
            } else {
                if (rToPath.IsLocal()) {
                    File fToFile = new File(rToPath.GetPath());
                    if (fToFile != null && fToFile.exists()) {
                        bCanResume = fToFile.length() > 0L && fToFile.length() < rFromPath.GetSize();
                    }
                } else {
                    CFile fChildFile;
                    CFile rParent = null;
                    if (this.CanUsePrevListPath(rToPath.GetPath())) {
                        rParent = this.GetPrevListDir();
                    } else {
                        this.TurnOffListUpdates();
                        int[] anRetCodes = this.ListPath(rToPath);
                        this.TurnOnListUpdates();
                        if (anRetCodes[0] == 200 && anRetCodes[1] == 0 && this.GetSUConnection() != null) {
                            rParent = this.GetSUConnection().GetListDir();
                            this.SetPrevListDir(rParent);
                            if (rParent != null && rParent.GetChildFileCount() == 1) {
                                CFile rListedFile = rParent.GetChildFile(0);
                                if (rListedFile != null) {
                                    this.SetPrevListPath(rListedFile.GetPath(), rListedFile.GetSize());
                                }
                            } else {
                                this.SetPrevListPath(rToPath.GetPath(), 0L);
                            }
                        }
                    }
                    if (rParent != null && rParent.GetChildFileCount() == 1 && (fChildFile = rParent.GetChildFile(0)) != null) {
                        bCanResume = fChildFile.GetSize() > 0L && fChildFile.GetSize() < rFromPath.GetSize();
                    }
                }
                this.m_rPrevResumePath = rToPath;
                this.m_bCanResume = bCanResume;
            }
        }
        return bCanResume;
    }

    public void OnResume() {
        this.SetStop(false);
        this.SetCancel(false);
        this.SetResume(true);
        this.SetCanOverwrite(true);
        this.SetCanDelReadOnly(true);
        this.ResetPrevListData();
        Thread tThread = this.GetThread();
        if (tThread != null && tThread instanceof CBaseThread) {
            CBaseThread tTransferThread = (CBaseThread)tThread;
            tTransferThread.PostMessage(this);
        }
    }

    @Override
    public void OnOverwrite() {
        this.SetResume(false);
        super.OnOverwrite();
    }

    @Override
    protected void ResetFlags() {
        super.ResetFlags();
        this.SetStop(false);
        this.SetResume(false);
        this.SetCanOverwrite(false);
    }

    protected boolean OnTransferItemDone() {
        boolean bContinue = true;
        this.PostEvent(3021, this.clone());
        this.ResetFlags();
        this.ResetPrevListData();
        return bContinue;
    }

    protected boolean OnTransferItemFailed() {
        boolean bContinue = false;
        if (this.GetMoveToNextItem()) {
            this.OnInternalSkip();
            bContinue = true;
        } else {
            CRemoteFile fDir;
            this.TurnOffListUpdates();
            int[] anRc = this.ListPath(this.GetToPath(this.GetPathIndex()));
            this.TurnOnListUpdates();
            if (anRc != null && anRc[0] == 200 && anRc[1] == 0 && this.GetSUConnection() != null && (fDir = this.GetSUConnection().GetListDir()) != null && fDir.GetChildFileCount() == 1) {
                this.SetListFile(fDir.GetChildFile(0));
            }
            if (this.GetStop()) {
                this.SetErrorID(10);
                this.PostEvent(3005, this);
            } else if (this.GetCancel()) {
                this.PostEvent(3020, this);
            } else {
                this.PostEvent(3005, this);
            }
        }
        return bContinue;
    }

    @Override
    protected void OnConfirmFailedToDelete(CPath rDelPath) {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
            long lThreadID = this.GetThread().getId();
            CConfirmDeleteFailedDlg dlg = new CConfirmDeleteFailedDlg((Frame)this.GetDeleteFrame(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_DELETE_FAILED_DEF_MSG");
            if (rDelPath != null) {
                sMsg = this.GetMovingFiles() ? String.format(CString.LoadString("IDS_CONFIRM_TRANSFER_DELETE_FAILED_FMT_MSG1"), rDelPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_DELETE_FAILED_FMT_MSG"), rDelPath.GetPath());
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = rDelPath != null && !rDelPath.IsLocal() ? CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult()) : String.format("%s", CThreadMsgTransfer.GetSUError(this.GetSUResult()));
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                case 1: {
                    this.OnSkip();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    @Override
    protected void OnInternalSkip() {
        super.OnInternalSkip();
        this.SetResume(false);
        this.SetCanOverwrite(false);
        this.SetMoveToNextItem(false, false);
        CPath rFromPath = this.GetFromPath(this.GetPathIndex());
        if (rFromPath != null) {
            this.SetOverallRead(this.GetOverallRead() - this.GetFileRead() + rFromPath.GetSize());
            this.SetFileRead(rFromPath.GetSize());
        }
        this.PostEvent(6052, this.clone());
    }

    @Override
    public void OnCancel(boolean bPostEvent) {
        super.OnCancel(false);
        this.SetResume(false);
        this.SetCanOverwrite(false);
        if (bPostEvent) {
            this.PostEvent(3020, this);
        }
    }

    protected void OnConfirmFailedToTransfer() {
        CPath rFromPath = this.GetFromPath(this.GetPathIndex());
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (CMainFrame.GET_APP() != null && this.GetThread() != null && rFromPath != null && rToPath != null) {
            String sDetails;
            Image rImage;
            long lThreadID = this.GetThread().getId();
            CConfirmTransferFailedDlg dlg = new CConfirmTransferFailedDlg((Frame)this.GetDeleteFrame(), true, lThreadID);
            ImageIcon rIcon = null;
            rIcon = rFromPath.IsLocal() ? CMainFrame.GetJARImage("Upload.png") : CMainFrame.GetJARImage("Download.png");
            if (rIcon != null && (rImage = rIcon.getImage()) != null) {
                dlg.setIconImage(rImage);
            }
            String sMsg = String.format(CString.LoadString("IDS_CONFIRM_TRANSFER_FAILED_FMT_MSG"), rFromPath.GetPath(), rToPath.GetPath());
            if (this.GetSUResult() == 3) {
                if (rFromPath.IsLocal() && !rToPath.IsLocal()) {
                    sMsg = String.format("%s\r\n\r\n%s", sMsg, CString.LoadString("IDS_CONFIRM_TRANSFER_FAILED_FMT_MSG_UPLOAD_PERM_DENIED"));
                } else if (!rFromPath.IsLocal() && rToPath.IsLocal()) {
                    sMsg = String.format("%s\r\n\r\n%s", sMsg, CString.LoadString("IDS_CONFIRM_TRANSFER_FAILED_FMT_MSG_DOWNLOAD_PERM_DENIED"));
                }
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            if (rFromPath.IsLocal() && rToPath.IsLocal()) {
                sDetails = String.format("%s\r\n\r\n%s", CThreadMsgTransfer.GetSUError(this.GetSUResult()), CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            } else {
                sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
                sDetails = String.format("%s\r\n\r\n%s", sDetails, CString.LoadString("IDS_PLEASE_CONTACT_SUPPORT"));
            }
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                case 1: {
                    this.OnSkip();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    @Override
    public void OnRetry() {
        this.SetOverallRead(this.GetOverallRead() - this.GetFileRead());
        this.SetFileRead(0L);
        super.OnRetry();
    }

    protected CThreadMsgCreateDir CreateThreadMsgCreateDir() {
        CThreadMsgCreateDir rCreatedDirMsg = this.CreateThreadMsgCreateDir(this);
        rCreatedDirMsg.AddFromPath(this.GetToPath(this.GetPathIndex()));
        rCreatedDirMsg.SetPathIndex(0);
        rCreatedDirMsg.SetListFile(this.GetListFile());
        return rCreatedDirMsg;
    }

    @Override
    protected boolean GetConfirmOverwrite() {
        boolean bNotifyUser = this.GetDefConfirmOverwrite();
        bNotifyUser = this.GetOpeningFiles() ? false : super.GetConfirmOverwrite();
        return bNotifyUser;
    }

    public boolean SetResumeStartIndex(long lIndex) {
        boolean bChanged = false;
        if (this.m_lResumeStartIndex != lIndex) {
            this.m_lResumeStartIndex = lIndex;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetResumeStartIndex() {
        return this.m_lResumeStartIndex;
    }

    public long GetTransferred() {
        return this.m_lTransferred;
    }

    public boolean SetTransferred(long lTransferred) {
        boolean bChanged = false;
        if (this.m_lTransferred != lTransferred) {
            this.m_lTransferred = lTransferred;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean CheckDeleteDir(String sAbsPath, boolean bIsLocal) {
        boolean bContinue = true;
        boolean bCanDelDir = false;
        CPath rPath = new CPath(sAbsPath, true, bIsLocal);
        if (rPath.IsLocal()) {
            File fTemp = new File(rPath.GetPath());
            if (fTemp.exists()) {
                File[] afList = fTemp.listFiles();
                if (afList == null || afList.length < 1) {
                    bCanDelDir = true;
                }
            } else {
                bContinue = true;
            }
        } else {
            int[] anRet = this.ListPath(rPath);
            if (anRet[0] == 200) {
                CRemoteFile fListFile;
                if (anRet[1] == 6) {
                    bContinue = true;
                } else if (anRet[1] == 0 && this.GetSUConnection() != null && (fListFile = this.GetSUConnection().GetListDir()) != null && fListFile.GetChildFileCount() < 1) {
                    bCanDelDir = true;
                }
            }
        }
        if (bCanDelDir) {
            this.SetDeletePath(rPath);
            int[] anRetCodes = this.Delete(rPath);
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUResult(anRetCodes[1]);
                boolean bl = bContinue = anRetCodes[0] == 200 && (anRetCodes[1] == 0 || anRetCodes[1] == 6);
                if (bContinue) {
                    this.PostDelete(rPath);
                } else {
                    this.SetErrorID(20);
                    this.PostEvent(3005, this);
                }
            }
        }
        return bContinue;
    }

    private boolean AddDelDir(CPath rDelDir) {
        boolean bAdded = false;
        if (this.m_arDelDirs != null) {
            bAdded = this.m_arDelDirs.add(rDelDir);
        }
        return bAdded;
    }

    private int GetDelDirIdx(CPath rDelDir) {
        int nIdx = -1;
        if (this.m_arDelDirs != null) {
            nIdx = this.m_arDelDirs.indexOf(rDelDir);
        }
        return nIdx;
    }

    private CPath GetDelDir(int nIdx) {
        CPath rPath = null;
        if (this.m_arDelDirs != null) {
            rPath = this.m_arDelDirs.get(nIdx);
        }
        return rPath;
    }

    private CPath RemoveDelDir(int nIdx) {
        CPath rPath = null;
        if (this.m_arDelDirs != null) {
            rPath = this.m_arDelDirs.remove(nIdx);
        }
        return rPath;
    }

    private void OnCheckDelDirRemove(CPath rDelDir) {
        if (rDelDir != null) {
            CRemoteFile rDir;
            this.TurnOffListUpdates();
            int[] anRc = this.ListPath(rDelDir);
            this.TurnOnListUpdates();
            if (anRc[0] == 200 && anRc[1] == 0 && this.GetSUConnection() != null && (rDir = this.GetSUConnection().GetListDir()) != null && rDir.GetChildFileCount() < 1) {
                anRc = this.Delete(rDelDir);
                if (anRc[0] == 200 && (anRc[1] == 0 || anRc[1] == 6)) {
                    this.PostDelete(rDelDir.clone());
                }
                this.RemoveDelDir(this.GetDelDirIdx(rDelDir));
            }
        }
    }

    private void OnCheckMove(CPath rNextPath) {
        if (this.GetMovingFiles()) {
            if (rNextPath == null) {
                if (this.m_arDelDirs != null && this.m_arDelDirs.size() > 0) {
                    for (int nIdx = this.m_arDelDirs.size() - 1; nIdx >= 0; --nIdx) {
                        CPath rDelDir = this.m_arDelDirs.get(nIdx);
                        if (rDelDir == null) continue;
                        this.OnCheckDelDirRemove(rDelDir);
                    }
                }
            } else if (rNextPath.IsDir()) {
                String sNextPath = rNextPath.GetPath();
                if (sNextPath != null && this.m_arDelDirs != null && this.m_arDelDirs.size() > 0) {
                    for (int nIdx = this.m_arDelDirs.size() - 1; nIdx >= 0; --nIdx) {
                        String sDelDirPath;
                        CPath rDelDir = this.m_arDelDirs.get(nIdx);
                        if (rDelDir == null || (sDelDirPath = rDelDir.GetPath()) == null || sNextPath.startsWith(sDelDirPath)) continue;
                        this.OnCheckDelDirRemove(rDelDir);
                    }
                }
            } else {
                int[] anRc = this.Delete(rNextPath);
                if (anRc[0] == 200 && (anRc[1] == 0 || anRc[1] == 6)) {
                    this.PostDelete(rNextPath.clone());
                }
            }
        }
    }

    private String ResolveToPath(String sAbsLink, String sAbsLinkTarget) {
        String sToPath = null;
        String sTransferFrom = this.GetTransferFromPath();
        String sTransferTo = this.GetTransferToPath();
        if (sAbsLink != null && sAbsLinkTarget != null && sTransferFrom != null && sTransferTo != null) {
            int nLastSlashIdx;
            sTransferFrom = CString.MakeForwardSlashes(sTransferFrom);
            sTransferTo = CString.MakeForwardSlashes(sTransferTo);
            sAbsLink = CString.MakeForwardSlashes(sAbsLink);
            sAbsLinkTarget = CString.MakeForwardSlashes(sAbsLinkTarget);
            String sRelPath = "";
            if (sAbsLink.startsWith(sTransferFrom)) {
                sRelPath = sAbsLink.substring(sTransferFrom.length());
            }
            sRelPath = (nLastSlashIdx = sRelPath.lastIndexOf(47)) >= 0 && nLastSlashIdx < sRelPath.length() ? sRelPath.substring(0, nLastSlashIdx) : "";
            String sName = sAbsLinkTarget;
            nLastSlashIdx = sName.lastIndexOf(47);
            if (nLastSlashIdx >= 0 && nLastSlashIdx < sName.length()) {
                sName = sName.substring(nLastSlashIdx, sName.length());
            }
            sToPath = CString.EnsureLastCharIsAForwardSlash(sTransferTo);
            sToPath = sToPath + CString.EnsureFirstCharIsNotAForwardSlash(sRelPath);
            sToPath = CString.EnsureLastCharIsAForwardSlash(sToPath);
            sToPath = sToPath + CString.EnsureFirstCharIsNotAForwardSlash(sName);
        }
        return sToPath;
    }

    @Override
    protected CPath CreateResolvedLinkPath(String sAbsFilePath) {
        File fTarget;
        CWindowsLink link;
        String sTargetPath;
        CPath rRetPath = null;
        String sResolvedPath = null;
        if (sAbsFilePath != null && CPath.IsWindowsLink(sAbsFilePath) && (sTargetPath = (link = new CWindowsLink(sAbsFilePath)).GetResolvedPath()) != null && !sTargetPath.isEmpty() && (fTarget = new File(sTargetPath)) != null && (sResolvedPath = fTarget.getAbsolutePath()) != null) {
            String sToPath = this.ResolveToPath(sAbsFilePath, sResolvedPath);
            Object sLinkPath = null;
            rRetPath = this.CreateLinkPath(sToPath, sResolvedPath, sAbsFilePath, fTarget.isDirectory(), true, fTarget.length(), !fTarget.canWrite(), fTarget.lastModified());
        }
        return rRetPath;
    }

    @Override
    protected CPath CreateResolvedLinkPath(File fChild) {
        CPath rRetPath = null;
        String sResolvedPath = null;
        if (fChild != null) {
            String sPath = fChild.getAbsolutePath();
            if (CPath.IsWindowsLink(sPath)) {
                File fTarget;
                CWindowsLink link = new CWindowsLink(sPath);
                String sTargetPath = link.GetResolvedPath();
                if (sTargetPath != null && !sTargetPath.isEmpty() && (fTarget = new File(sTargetPath)) != null && (sResolvedPath = fTarget.getAbsolutePath()) != null) {
                    String sToPath = this.ResolveToPath(sPath, sResolvedPath);
                    String sLinkPath = sPath;
                    rRetPath = this.CreateLinkPath(sToPath, sResolvedPath, sLinkPath, fTarget.isDirectory(), true, fTarget.length(), !fTarget.canWrite(), fTarget.lastModified());
                }
            } else {
                String sLinkRoot = "";
                for (int nIdx = this.GetPathIndex(); nIdx >= 0 && rRetPath == null; --nIdx) {
                    int nLastSlashIdx;
                    CPath rPrevFrom = this.GetFromPath(nIdx);
                    if (rPrevFrom == null || !rPrevFrom.IsLink()) continue;
                    String sFromPath = rPrevFrom.GetPath();
                    String sToPath = rPrevFrom.GetPrevPath();
                    String sMarker = rPrevFrom.GetLinkPath();
                    sPath = CString.MakeForwardSlashes(sPath);
                    sFromPath = CString.MakeForwardSlashes(sFromPath);
                    sToPath = CString.MakeForwardSlashes(sToPath);
                    if ((sMarker = CString.MakeForwardSlashes(sMarker)) == null || sMarker.isEmpty() || sFromPath == null || !sPath.startsWith(sFromPath)) continue;
                    String sFromParent = this.GetTransferFromPath();
                    sFromParent = CString.MakeForwardSlashes(sFromParent);
                    String sRelPath = "";
                    if (sMarker.startsWith(sFromParent)) {
                        sRelPath = sMarker.substring(sFromParent.length());
                    }
                    sRelPath = (nLastSlashIdx = sRelPath.lastIndexOf(47)) >= 0 && nLastSlashIdx < sRelPath.length() ? sRelPath.substring(0, nLastSlashIdx) : "";
                    String sRelPath2 = "";
                    String sName = "";
                    if (sPath.startsWith(sFromPath)) {
                        nLastSlashIdx = sFromPath.lastIndexOf(47);
                        if (nLastSlashIdx >= 0 && nLastSlashIdx < sFromPath.length()) {
                            sRelPath2 = sFromPath.substring(nLastSlashIdx, sFromPath.length());
                        }
                        sName = sPath.substring(sFromPath.length(), sPath.length());
                    }
                    String sToPath2 = CString.EnsureLastCharIsAForwardSlash(this.GetTransferToPath());
                    sToPath2 = sToPath2 + CString.EnsureFirstCharIsNotAForwardSlash(sRelPath);
                    sToPath2 = CString.EnsureLastCharIsAForwardSlash(sToPath2);
                    sToPath2 = sToPath2 + CString.EnsureFirstCharIsNotAForwardSlash(sRelPath2);
                    sToPath2 = CString.EnsureLastCharIsAForwardSlash(sToPath2);
                    sToPath2 = sToPath2 + CString.EnsureFirstCharIsNotAForwardSlash(sName);
                    rRetPath = this.CreateLinkPath(sToPath2, fChild.getAbsolutePath(), null, fChild.isDirectory(), true, fChild.length(), !fChild.canWrite(), fChild.lastModified());
                }
            }
        }
        return rRetPath;
    }

    public boolean IsSearch() {
        return this.m_bIsSearch;
    }

    public boolean SetIsSearch(boolean bIsSearch) {
        boolean bChanged = false;
        if (this.m_bIsSearch != bIsSearch) {
            bChanged = true;
            this.m_bIsSearch = bIsSearch;
        }
        return bChanged;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_STATS_READ = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_STATS_OVERALL = false;
    }
}

