/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.local;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.net.CTransferStatsEvent;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.local.CThreadMsgCreateDirLocal;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class CThreadMsgThumbLocal
extends CThreadMsgThumb {
    private MediaTracker m_MediaTracker = new MediaTracker(new JPanel());

    public CThreadMsgThumbLocal(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, int nThumbWidth, int nThumbHeight, boolean bIsPreview) {
        super(tThread, rSource, rClientInfo, nCompressionType, nThumbWidth, nThumbHeight, bIsPreview);
        this.InitVars();
    }

    protected CThreadMsgThumbLocal(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgThumbLocal) {
            this.Copy((CThreadMsgThumbLocal)rCopyFrom, false);
        }
    }

    private void InitVars() {
    }

    public boolean Copy(CThreadMsgThumbLocal rCopyFrom, boolean bCallSuper) {
        boolean bChanged = false;
        if (rCopyFrom != null && bCallSuper && super.Copy(rCopyFrom, bCallSuper)) {
            bChanged = true;
        }
        return bChanged;
    }

    @Override
    public Object clone() {
        return new CThreadMsgThumbLocal(this);
    }

    @Override
    protected int[] RetrieveThumb(String sFromPath, long lFromSize, String sToPath, int nThumbWidth, int nThumbHeight) {
        int[] anRetCodes = null;
        anRetCodes = new int[]{200, 1};
        ImageIcon rRetImage = this.GetScaledImage(sFromPath, nThumbWidth, nThumbHeight);
        if (rRetImage != null) {
            anRetCodes[1] = 0;
            this.SetThumbImage(new ImageIcon(CFileSystemUtils.GetFileSysUtils().IconToImage(rRetImage)));
            CPath rSourcePath = this.GetFromPath(this.GetPathIndex());
            CTransferStatsEvent event = new CTransferStatsEvent(rSourcePath.GetSize(), rSourcePath.GetSize(), rSourcePath.GetSize(), 0L, sToPath);
            this.OnUpdateTransferStats(event);
        }
        return anRetCodes;
    }

    private ImageIcon GetScaledImage(String sAbsPath, int nWidth, int nHeight) {
        ImageIcon iRetImage = null;
        sAbsPath = CString.MakeForwardSlashes(sAbsPath);
        Image rImage = Toolkit.getDefaultToolkit().createImage(sAbsPath);
        this.m_MediaTracker.addImage(rImage, 1);
        this.m_MediaTracker.checkID(1, true);
        try {
            this.m_MediaTracker.waitForID(1);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!this.m_MediaTracker.isErrorAny()) {
            iRetImage = new ImageIcon(rImage);
            Image rScaledImage = CUtils.CreateScaledImage(null, rImage, nWidth, nHeight, CUtils.SCALE_OPTION.SHRINK);
            iRetImage = new ImageIcon(rScaledImage);
        }
        this.m_MediaTracker.removeImage(rImage, 1);
        return iRetImage;
    }

    @Override
    protected void PostNewTransferEvent() {
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirLocal rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirLocal(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }
}

