/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCopy;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;

public class CThreadMsgCopyRemote
extends CThreadMsgCopy {
    public CThreadMsgCopyRemote(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgCopyRemote(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgCopyRemote) {
            this.Copy((CThreadMsgCopyRemote)rCopyFrom, false);
        }
    }

    @Override
    public Object clone() {
        return new CThreadMsgCopyRemote(this);
    }

    @Override
    public boolean IsDownload() {
        return false;
    }

    @Override
    protected CFile CreateTargetDir(CPath rPath) {
        int[] anRet = CThreadMsgCreateDirRemote.CreateDir(this, this.GetSUConnection(), rPath);
        return this.GetListFile();
    }

    @Override
    protected int[] CopyFile(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes = new int[]{503, 1};
        if (this.GetMovingFiles()) {
            this.CheckFileReplace(new CPath(rToPath.GetPath(), rToPath.IsDir(), true));
            if (this.GetSUConnection() != null) {
                anRetCodes = this.GetSUConnection().SendRenamePath(rFromPath.GetPath(), rToPath.GetPath());
            }
            if (anRetCodes[0] == 200 && anRetCodes[1] == 0) {
                this.PostDelete(rFromPath);
            }
        } else if (DEBUG) {
            System.out.println("Remote File System does not support this at this time.");
        }
        return anRetCodes;
    }

    @Override
    protected boolean OnTransferItemDone() {
        boolean bContinue = true;
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (rToPath != null) {
            CRemoteFile fDir;
            CRemoteFile fListFile = null;
            int[] anListCodes = null;
            if (this.GetSUConnection() != null) {
                this.TurnOffListUpdates();
                anListCodes = rToPath.IsDir() ? this.GetSUConnection().SendListDir(rToPath.GetPath()) : this.GetSUConnection().SendListFile(rToPath.GetPath());
                this.TurnOnListUpdates();
            }
            if (anListCodes != null && anListCodes[0] == 200 && anListCodes[1] == false && this.GetSUConnection() != null && (fDir = this.GetSUConnection().GetListDir()) != null) {
                fListFile = !rToPath.IsDir() ? (CRemoteFile)fDir.GetChildFile(0) : fDir;
            }
            boolean bl = bContinue = fListFile != null;
            if (!bContinue) {
                this.SetErrorID(30);
                this.PostEvent(3005, this);
            }
            this.SetListFile(fListFile);
        }
        if (bContinue) {
            this.PostEvent(3021, this.clone());
            this.ResetFlags();
            this.ResetPrevListData();
        }
        return bContinue;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirRemote rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirRemote(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }
}

