/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgTransferRemote;
import java.io.File;

public class CThreadMsgDownloadRemote
extends CThreadMsgTransferRemote {
    private boolean m_bIsMedia = false;

    public CThreadMsgDownloadRemote(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        this(tThread, 21, rSource, rClientInfo, nCompressionType);
    }

    public CThreadMsgDownloadRemote(Thread tThread, int nMsgID, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, nMsgID, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgDownloadRemote(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgDownloadRemote) {
            CThreadMsgDownloadRemote rMsgFrom = (CThreadMsgDownloadRemote)rCopyFrom;
            this.Copy(rMsgFrom, false);
            boolean bChanged = false;
            if (this.SetIsMedia(rMsgFrom.IsMedia())) {
                boolean bl = true;
            }
        }
    }

    @Override
    public boolean IsDownload() {
        return true;
    }

    @Override
    public Object clone() {
        return new CThreadMsgDownloadRemote(this);
    }

    @Override
    protected boolean IsOverwritePathAvailable(CPath rToPath) {
        return this.IsLocalPathAvailable(rToPath);
    }

    @Override
    protected boolean Transfer(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes;
        boolean bContinue = false;
        if (this.GetStartTime() <= 0L || this.GetResume()) {
            this.SetStartTime(System.currentTimeMillis());
        }
        if (rFromPath != null && rToPath != null && (anRetCodes = this.DownloadFile(rFromPath.GetPath(), rFromPath.GetSize(), rToPath.GetPath())) != null && anRetCodes.length == 2) {
            this.SetHTTPCode(anRetCodes[0]);
            this.SetSUResult(anRetCodes[1]);
            if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                bContinue = true;
            }
        }
        return bContinue;
    }

    protected int[] DownloadFile(String sFromPath, long lFromSize, String sToPath) {
        int[] anRetCodes = null;
        if (this.GetSUConnection() != null) {
            long lResumeStartIdx = -1L;
            if (this.CanUsePrevListPath(sToPath)) {
                lResumeStartIdx = this.GetPrevListPathSize();
            }
            if (this.IsMedia()) {
                this.PostEvent(8030, sToPath);
            }
            anRetCodes = this.GetSUConnection().SendDownload(sFromPath, lFromSize, sToPath, false, 0, 0, lResumeStartIdx);
        }
        return anRetCodes;
    }

    @Override
    protected CFile CreateTargetDir(CPath rPath) {
        CLocalFile fCreatedDir = null;
        if (rPath != null) {
            this.SetHTTPCode(200);
            File fNewDir = new File(rPath.GetPath());
            if (fNewDir != null) {
                if (!fNewDir.exists()) {
                    fNewDir = CFileSystemUtils.GetFileSysUtils().CreateAllDirs(fNewDir.getAbsolutePath());
                    if (fNewDir.exists()) {
                        this.SetSUResult(0);
                        fCreatedDir = new CLocalFile(fNewDir);
                    }
                } else {
                    fCreatedDir = new CLocalFile(fNewDir);
                    this.SetSUResult(0);
                }
            }
        }
        return fCreatedDir;
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirRemote rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirRemote(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }

    public boolean SetIsMedia(boolean bIsMedia) {
        boolean bChanged = false;
        if (this.m_bIsMedia != bIsMedia) {
            this.m_bIsMedia = bIsMedia;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsMedia() {
        return this.m_bIsMedia;
    }
}

