/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.threads.remote;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmListFailedDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgCreateDirRemote;
import java.awt.Frame;

public class CThreadMsgUploadRemote
extends CThreadMsgTransfer {
    private static long m_lTransferID = 0x7FFFFFFFFFFFFFFEL;

    public CThreadMsgUploadRemote(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        super(tThread, 24, rSource, rClientInfo, nCompressionType);
    }

    protected CThreadMsgUploadRemote(CWorkerThreadID rCopyFrom) {
        super(rCopyFrom);
        if (rCopyFrom instanceof CThreadMsgUploadRemote) {
            this.Copy((CThreadMsgUploadRemote)rCopyFrom, false);
        }
    }

    @Override
    public boolean IsDownload() {
        return false;
    }

    @Override
    public Object clone() {
        return new CThreadMsgUploadRemote(this);
    }

    @Override
    protected boolean IsOverwritePathAvailable(CPath rToPath) {
        return this.IsRemotePathAvailable(rToPath);
    }

    @Override
    protected CFile CreateTargetDir(CPath rPath) {
        int[] anRet = CThreadMsgCreateDirRemote.CreateDir(this, this.GetSUConnection(), rPath);
        return this.GetListFile();
    }

    @Override
    protected boolean Transfer(CPath rFromPath, CPath rToPath) {
        int[] anRetCodes;
        boolean bContinue = false;
        if (this.GetStartTime() <= 0L || this.GetResume()) {
            this.SetStartTime(System.currentTimeMillis());
        }
        if (rFromPath != null && rToPath != null && (anRetCodes = this.UploadFile(rFromPath.GetPath(), rFromPath.GetSize(), rToPath.GetPath())) != null && anRetCodes.length == 2) {
            this.SetHTTPCode(anRetCodes[0]);
            this.SetSUResult(anRetCodes[1]);
            if ((anRetCodes[0] == 200 || anRetCodes[0] == 206) && anRetCodes[1] == 0) {
                bContinue = true;
            }
        }
        return bContinue;
    }

    protected int[] UploadFile(String sFromPath, long lFromSize, String sToPath) {
        int[] anRetCodes = null;
        if (this.GetSUConnection() != null) {
            long lResumeStartIdx = -1L;
            if (this.CanUsePrevListPath(sToPath)) {
                lResumeStartIdx = this.GetPrevListPathSize();
            } else if (this.GetApplyToAllOverwrite() && this.GetApplyToAllOverwriteOpt() == 0) {
                lResumeStartIdx = 0L;
            }
            anRetCodes = this.GetSUConnection().SendUpload(CThreadMsgUploadRemote.GetNewTransferID(), sFromPath, lFromSize, sToPath, lResumeStartIdx);
        }
        return anRetCodes;
    }

    public static long GetNewTransferID() {
        return --m_lTransferID;
    }

    @Override
    protected boolean GetDefConfirmOverwrite() {
        return true;
    }

    @Override
    protected boolean OnTransferItemDone() {
        boolean bContinue = true;
        CPath rToPath = this.GetToPath(this.GetPathIndex());
        if (rToPath != null) {
            CRemoteFile fDir;
            CRemoteFile fListFile = null;
            int[] anListCodes = null;
            if (this.GetSUConnection() != null) {
                this.TurnOffListUpdates();
                anListCodes = rToPath.IsDir() ? this.GetSUConnection().SendListDir(rToPath.GetPath()) : this.GetSUConnection().SendListFile(rToPath.GetPath());
                this.TurnOnListUpdates();
            }
            if (anListCodes != null && anListCodes[0] == 200 && anListCodes[1] == false && this.GetSUConnection() != null && (fDir = this.GetSUConnection().GetListDir()) != null) {
                fListFile = !rToPath.IsDir() ? (CRemoteFile)fDir.GetChildFile(0) : fDir;
            }
            boolean bl = bContinue = fListFile != null;
            if (!bContinue) {
                this.SetErrorID(48);
                this.PostEvent(3005, this);
            }
            this.SetListFile(fListFile);
        }
        if (bContinue) {
            this.PostEvent(3021, this.clone());
            this.ResetFlags();
            this.ResetPrevListData();
        }
        return bContinue;
    }

    @Override
    protected void ProcessError() {
        switch (this.GetErrorID()) {
            case 48: {
                CPath rListPath = this.GetToPath(this.GetPathIndex());
                this.OnConfirmFailedToList(rListPath);
                break;
            }
            default: {
                super.ProcessError();
            }
        }
    }

    @Override
    protected void OnConfirmFailedToList(CPath rListPath) {
        if (CMainFrame.GET_APP() != null && this.GetThread() != null) {
            long lThreadID = this.GetThread().getId();
            CConfirmListFailedDlg dlg = new CConfirmListFailedDlg((Frame)CMainFrame.GET_APP(), true, lThreadID);
            String sMsg = CString.LoadString("IDS_CONFIRM_LIST_FAILED_DEF_MSG");
            if (rListPath != null) {
                sMsg = this.GetErrorID() == 48 ? String.format(CString.LoadString("IDS_CONFIRM_TRANSFER_LIST_FAILED_FMT_MSG"), rListPath.GetPath()) : String.format(CString.LoadString("IDS_CONFIRM_LIST_FAILED_FMT_MSG"), rListPath.GetPath());
            }
            dlg.SetMainMsg(sMsg);
            String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
            dlg.SetBtnMsg(sBtnMsg);
            String sDetails = CThreadMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUResult());
            dlg.SetDetailMsg(sDetails);
            dlg.setVisible(true);
            switch (dlg.GetExitCode()) {
                case 0: {
                    this.OnRetry();
                    break;
                }
                default: {
                    this.OnCancel(true);
                }
            }
        }
    }

    @Override
    protected CThreadMsgCreateDir CreateThreadMsgCreateDir(CThreadMsg rCopyFrom) {
        CThreadMsgCreateDirRemote rMsg = null;
        if (rCopyFrom != null) {
            rMsg = new CThreadMsgCreateDirRemote(rCopyFrom.GetThread(), rCopyFrom.GetSource(), rCopyFrom.GetClientInfo(), rCopyFrom.GetCompressionType(), false);
        }
        return rMsg;
    }
}

