/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.media;

import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.events.CMainEventQueue;
import com.rhinosoft.media.CRhinoMediaPlayer;
import java.net.URI;

public class CMediaThreadMsg
extends CWorkerThreadID {
    public static final int ID_MSG_MEDIA_LOAD_URI = 60;
    public static final int ID_MSG_MEDIA_PLAY = 61;
    public static final int ID_MSG_MEDIA_STOP = 62;
    private CRhinoMediaPlayer m_rPlayer;
    private URI m_rURI;
    private boolean m_bPlayWhenLoaded;

    public CMediaThreadMsg(Thread tThread, int nMsgID, Object rSource) {
        super(tThread, nMsgID, rSource);
        this.InitVars();
    }

    private void InitVars() {
        this.m_bPlayWhenLoaded = false;
    }

    private URI GetURI() {
        return this.m_rURI;
    }

    public void SetURI(URI rURI) {
        this.m_rURI = rURI;
    }

    public boolean GetPlayWhenLoaded() {
        return this.m_bPlayWhenLoaded;
    }

    public void SetPlayWhenLoaded(boolean bPlayWhenLoaded) {
        this.m_bPlayWhenLoaded = bPlayWhenLoaded;
    }

    private CRhinoMediaPlayer GetPlayer() {
        return this.m_rPlayer;
    }

    public void SetPlayer(CRhinoMediaPlayer rPlayer) {
        this.m_rPlayer = rPlayer;
    }

    @Override
    public void ProcessEvent() {
        switch (this.GetMsgID()) {
            case 60: {
                this.OnLoadURI();
                break;
            }
            case 61: {
                this.OnPlay();
                break;
            }
            case 62: {
                this.OnStop();
                break;
            }
        }
    }

    private void OnLoadURI() {
        if (this.GetPlayer() != null) {
            int nEventID = 8041;
            if (this.GetPlayer().LoadURI(this.GetURI())) {
                nEventID = 8040;
            }
            CMainEventQueue.PostEvent(new CRhinoEvent(this.GetSource(), nEventID, this));
        }
    }

    private void OnPlay() {
        if (this.GetPlayer() != null) {
            this.GetPlayer().Play();
        }
    }

    private void OnStop() {
        if (this.GetPlayer() != null) {
            this.GetPlayer().Stop();
        }
    }
}

