// Serv-U-Strings.h - Contains #defines for each string value contained in Serv-U RES
//

/////////////////////////////////////////////////////////////////////////////
// Serv-U-Setup strings

#define IDS_OLDREGGIE_COMMENT           					101
#define IDS_OLDREGGIE_HEADER            					102
#define IDS_SERVER_SECURITY_REQD        					103
#define IDS_DIR_CACHE_OBSOLETE          					104
#define IDS_SEND_RECV_BUFFERS           					105
#define IDS_LINKS_DEPRECATED            					106
#define IDS_NO_GROUP_ADMIN              					107
#define IDS_SHUTTING_DOWN               					108
#define IDS_UPDATING_DATA               					109
#define IDS_BACKING_UP                  					110
#define IDS_CHECKING_REGGIE             					111
#define IDS_UPNP_DISCOVER               					112
#define IDS_UN_HEADER                   					113
#define IDS_UN_COMMENT                  					114
#define IDS_TRAY_PASSWORD_SET           					115
#define IDS_LOCK_IN_HOME_CHANGE         					116
#define IDS_ODBC_DOMAIN_UPGRADED        					117
#define IDS_BETA_HEADING                					118
#define IDS_BETA_COMMENT                					119
#define IDS_MSG_TAGS_CHANGED            					120

/////////////////////////////////////////////////////////////////////////////
// password recovery message strings
#define IDS_PWDREC_SUBJECT            						200
#define IDS_PWDREC_MESSAGE            						201

/////////////////////////////////////////////////////////////////////////////
// Serv-U-RES strings

#define IDS_SERVICE_DESC                					9319
#define IDS_SUEXE_SERVICE_DESC          					9320
#define IDS_ON                          					9321
#define IDS_OFF                         					9322
#define IDS_BLANK                       					9323
#define IDS_SSH_CHANGE_PASSWORD_PROMPT						9325
#define IDS_EVENT											9326
#define IDS_USER_WELCOME_MESSAGE							9327
#define IDS_DATA1_SUEVENT_ID_USER_LOGIN						9328
#define IDS_DATA2_SUEVENT_ID_USER_LOGIN						9329
#define IDS_DATA1_SUEVENT_ID_USER_LOGOUT					9330
#define IDS_DATA2_SUEVENT_ID_USER_LOGOUT					9331
#define IDS_DATA1_SUEVENT_ID_USER_LOGIN_FAILURE				9332
#define IDS_DATA2_SUEVENT_ID_USER_LOGIN_FAILURE				9333
#define IDS_DATA1_SUEVENT_ID_USER_ADDED						9334
#define IDS_DATA2_SUEVENT_ID_USER_ADDED						9335
#define IDS_DATA1_SUEVENT_ID_IP_BLOCKED						9336
#define IDS_DATA2_SUEVENT_ID_IP_BLOCKED						9337
#define IDS_DATA1_SUEVENT_ID_IP_BLOCKED_TIME				9338
#define IDS_DATA2_SUEVENT_ID_IP_BLOCKED_TIME				9339
#define IDS_DATA1_SUEVENT_ID_FILE_UPLOAD					9340
#define IDS_DATA2_SUEVENT_ID_FILE_UPLOAD					9341
#define IDS_DATA1_SUEVENT_ID_FILE_DOWNLOAD					9342
#define IDS_DATA2_SUEVENT_ID_FILE_DOWNLOAD					9343
#define IDS_DATA1_SUEVENT_ID_FILE_DELETE					9344
#define IDS_DATA2_SUEVENT_ID_FILE_DELETE					9345
#define IDS_DATA1_SUEVENT_ID_FILE_MOVE						9346
#define IDS_DATA2_SUEVENT_ID_FILE_MOVE						9347
#define IDS_DATA1_SUEVENT_ID_DIR_CREATE						9348
#define IDS_DATA2_SUEVENT_ID_DIR_CREATE						9349
#define IDS_DATA1_SUEVENT_ID_DIR_DELETE						9350
#define IDS_DATA2_SUEVENT_ID_DIR_DELETE						9351
#define IDS_DATA1_SUEVENT_ID_DIR_MOVE						9352
#define IDS_DATA2_SUEVENT_ID_DIR_MOVE						9353

/////////////////////////////////////////////////////////////////////////////
// Serv-U-FTP-Responses strings

// general response strings
#define IDS_LIST_USER										12500
#define IDS_LIST_GROUP										12501
#define IDS_LIST_TOTAL										12502

// global FTP command responses
// 200's
#define IDS_FTPRESP_HELLO									12520
#define IDS_FTPRESP_SYSOP_MESSAGE							12521
#define IDS_FTPRESP_COMMAND_OKAY							12522
#define IDS_FTPRESP_CMD_UNIMPLEMENTED						12523
#define IDS_FTPRESP_TRANSFER_COMPLETE						12524
#define IDS_FTPRESP_COMPRESSED_TRANSFER_COMPLETE			12525

// 300's
#define IDS_FTPRESP_TRANSFER_STATUS							12590

// 400's
#define IDS_FTPRESP_TOO_MANY_USERS							12600
#define IDS_FTPRESP_CONNECTION_TIMED_OUT					12601
#define IDS_FTPRESP_SERVER_GOING_DOWN						12602
#define IDS_FTPRESP_SERVER_TEMP_UNAVAIL						12603
#define IDS_FTPRESP_EXCEEDED_MAX_SESSION_TIME				12604
#define IDS_FTPRESP_TOO_MANY_COMMANDS_BEFORE_LOGIN			12605
#define IDS_FTPRESP_TOO_MANY_SESSIONS_IP					12606
#define IDS_FTPRESP_IP_TEMPORARILY_BLOCKED					12607
#define IDS_FTPRESP_DATA_CONNECTION_IN_USE					12608
#define IDS_FTPRESP_OUT_OF_NETWORK_SOCKETS					12609
#define IDS_FTPRESP_CANNOT_OPEN_DATA_CONNECTION				12610
#define IDS_FTPRESP_DATA_CONN_CLOSED_TRANS_ABORTED			12611
#define IDS_FTPRESP_DATA_CONN_CLOSED_SYSOP_ABORTED			12612
#define IDS_FTPRESP_DATA_CONN_SSL_NEG_FAILED				12613
#define IDS_FTPRESP_DATA_CONN_UNEXPECTEDLY_CLOSED			12614
#define IDS_FTPRESP_DATA_CONN_NOT_SPECIFIED					12615
#define IDS_FTPRESP_TRANSFER_ABORTED						12616
#define IDS_FTPRESP_COMMAND_PENDING							12617
#define IDS_FTPRESP_COMMAND_ABORTED							12618
#define IDS_FTPRESP_INTERNAL_ERROR							12619
															
// 500's
#define IDS_FTPRESP_CMD_UNKNOWN								12700
#define IDS_FTPRESP_MISSING_RESPONSE_STRING_FMT				12701
#define IDS_FTPRESP_SYNTAX_ERROR_PARAMETERS					12702
#define IDS_FTPRESP_INVALID_PATH							12703
#define IDS_FTPRESP_CMD_DISABLED							12704
#define IDS_FTPRESP_BAD_SEQUENCE_OF_COMMANDS				12705
#define IDS_FTPRESP_CMD_NOT_IMPL_FOR_PARAM					12706
#define IDS_FTPRESP_NOT_LOGGED_IN							12707
#define IDS_FTPRESP_LOGIN_TOO_MANY_INVALID_TRIES			12708
#define IDS_FTPRESP_PASSWORD_EXPIRED						12709
#define IDS_FTPRESP_UNAUTHORIZED_IP							12710
#define IDS_FTPRESP_HOME_DIR_MISSING						12711
#define IDS_FTPRESP_INVALID_OPT_SECURE_DATA_REQ				12712
#define IDS_FTPRESP_PATHNAME_PERMISSION_DENIED				12713
#define IDS_FTPRESP_PATHNAME_NO_SUCH_FILE_OR_DIR			12714
#define IDS_FTPRESP_FILE_DOES_NOT_EXIST						12715
#define IDS_FTPRESP_DIR_DOES_NOT_EXIST						12716
#define IDS_FTPRESP_SERVER_STOP_PENDING						12717
#define IDS_FTPRESP_FILE_IS_DIR								12718
#define IDS_FTPRESP_DIR_IS_FILE								12719
#define IDS_FTPRESP_PATH_IS_PORT							12720
#define IDS_FTPRESP_CANT_REST_EMPTY_FILE					12721
#define IDS_FTPRESP_CANT_REST_BEYOND_EOF					12722
#define IDS_FTPRESP_CANT_SET_FILE_POS						12723
#define IDS_FTPRESP_NO_FILES_FOUND							12724
#define IDS_FTPRESP_CANT_CHANGE_DATE_TIME					12725
#define IDS_FTPRESP_RNTO_ALREADY_EXISTS						12726

// general FTP command strings
#define IDS_FTPCMND_BINARY									12800
#define IDS_FTPCMND_ASCII									12801
#define IDS_UNLIMITED										12802
#define IDS_NA												12803
#define IDS_USER											12804
#define IDS_SESSION											12805
#define IDS_FILES											12806
#define IDS_KB												12807

// OPTS messages
#define IDS_FTPRESP_OPTS_SYNTAX								12820
#define IDS_FTPRESP_OPTS_INVALID_OPTION						12821
#define IDS_FTPRESP_OPTS_INVALID_SUBCOMMAND					12822

// OPTS MODE messages
#define IDS_FTPCMND_OPTS_MODE_SYNTAX						12830
#define IDS_FTPRESP_OPTS_MODE_Z								12831

// OPTS MLST messages
#define IDS_FTPCMND_OPTS_MLST_SYNTAX						12840
#define IDS_FTPRESP_OPTS_MLST_OPTS							12841
#define IDS_FTPRESP_OPTS_MLST_INVALID_OPTIONS				12842

// OPTS UTF8 messages
#define IDS_FTPCMND_OPTS_UTF8_SYNTAX						12845
#define IDS_FTPRESP_OPTS_UTF8								12846

// CLNT messages
#define IDS_FTPCMND_CLNT_SYNTAX								12850
#define IDS_FEATDESC_CLNT									12851
#define	IDS_FTPRESP_CLIENT_NOTED							12852

// CSID messages
#define IDS_FTPCMND_CSID_SYNTAX								12855
#define IDS_FEATDESC_CSID									12856
#define	IDS_FTPRESP_CSID_OKAY								12857

// MODE messages
#define IDS_FTPCMND_MODE_SYNTAX								12860
#define IDS_FEATDESC_MODE									12861
#define IDS_FTPRESP_MODE_OKAY								12862

// NOOP messages
#define IDS_FTPCMND_NOOP_SYNTAX								12870

// HELP messages
#define IDS_FTPCMND_HELP_SYNTAX								12880
#define IDS_FTPRESP_HELP_INVALID_COMMAND					12881
#define IDS_FTPRESP_HELP_UNAVAIL							12882
#define IDS_FTPRESP_HELP_SYNTAX								12883
#define IDS_FTPRESP_HELP_FIRST								12884
#define IDS_FTPRESP_HELP_LAST								12885

// FEAT messages
#define IDS_FTPCMND_FEAT_SYNTAX								12890
#define IDS_FTPRESP_FEAT_FIRST								12891
#define IDS_FTPRESP_FEAT_LAST								12892

// HOST messages
#define IDS_FTPCMND_HOST_SYNTAX								12900
#define IDS_FEATDESC_HOST									12901
#define IDS_FTPRESP_HOST_INVALID_PARAMETER					12902
#define IDS_FTPRESP_HOST_DOMAIN_NOT_FOUND					12903
#define IDS_FTPRESP_HOST_ALREADY_LOGGED_IN					12904
#define IDS_FTPRESP_HOST_UNAUTHORIZED_IP					12905

// USER messages
#define IDS_FTPCMND_USER_SYNTAX								13100
#define IDS_FTPRESP_USER_LOGGED_IN							13101
#define IDS_FTPRESP_USER_NAME_OKAY_NEED_PASSWORD			13102
#define IDS_FTPRESP_USER_NAME_OKAY_NEED_EMAILADDR			13103
#define IDS_FTPRESP_USER_OKAY_SKEY_PASSWORD					13104
#define IDS_FTPRESP_USER_NO_ANONYMOUS						13105
#define IDS_FTPRESP_USER_NEED_SECURE						13106
#define IDS_FTPRESP_USER_INVALID							13107

// PASS messages
#define IDS_FTPCMND_PASS_SYNTAX								13120
#define IDS_FTPRESP_PASS_OKAY								13121
#define IDS_FTPRESP_PASS_PASSWORD_EXPIRED_CHANGE			13122
#define IDS_FTPRESP_PASS_CANT_FIND_HOME						13123
#define IDS_FTPRESP_PASS_USE_REAL_EMAIL_ADDR				13124
#define IDS_FTPRESP_PASS_NO_FTP								13125
#define IDS_FTPRESP_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN		13126
#define IDS_FTPRESP_USER_UNAVAILABLE						13127

// REIN messages
#define IDS_FTPCMND_REIN_SYNTAX								13140
#define IDS_FTPRESP_REIN_OKAY								13141

// QUIT messages
#define IDS_FTPCMND_QUIT_SYNTAX								13150
#define IDS_FTPRESP_QUIT_OKAY								13151

// ABOR messages
#define IDS_FTPCMND_ABOR_SYNTAX								13160
#define IDS_FTPRESP_ABOR_OKAY								13161

// SYST messages
#define IDS_FTPCMND_SYST_SYNTAX								13170
#define IDS_FTPRESP_SYST_OKAY								13171

// STAT messages
#define IDS_FTPCMND_STAT_SYNTAX								13185
#define IDS_FTPRESP_STAT_FIRST								13186
#define IDS_FTPRESP_STAT_LAST								13187
#define IDS_FTPCMND_STAT_RATIO								13188
#define IDS_FTPCMND_STAT_RATIO_CREDIT						13189
#define IDS_FTPCMND_STAT_QUOTA								13190
#define IDS_FTPCMND_STAT_ACTIVE_UPLOAD						13191
#define IDS_FTPCMND_STAT_ACTIVE_DOWNLOAD					13192

// AUTH messages
#define IDS_FTPCMND_AUTH_SYNTAX								13210
#define IDS_FEATDESC_AUTH									13211
#define IDS_FTPRESP_AUTH_OKAY_INITIALIZING_SSL				13212
#define IDS_FTPRESP_AUTH_OKAY_ALREADY_HAVE_SSL				13213
#define IDS_FTPRESP_AUTH_UNKNOWN_MECHANISM					13214
#define IDS_FTPRESP_AUTH_CANT_OPEN_CERT_FILE				13215
#define IDS_FTPRESP_AUTH_CANT_OPEN_PRIVATE_KEY_FILE			13216
#define IDS_FTPRESP_AUTH_CANT_LOAD_TRUSTED_CA_FILE			13217

// PBSZ messages
#define IDS_FTPCMND_PBSZ_SYNTAX								13220
#define IDS_FEATDESC_PBSZ									13221
#define IDS_FTPRESP_PBSZ_IS_ZERO							13222
#define IDS_FTPRESP_PBSZ_SET_TO								13223
#define IDS_FTPRESP_PBSZ_SSL_REQ_BEFORE						13224

// PROT messages
#define IDS_FTPCMND_PROT_SYNTAX								13230
#define IDS_FEATDESC_PROT									13231
#define IDS_FTPRESP_PROT_P_OKAY								13232
#define IDS_FTPRESP_PROT_C_OKAY								13233
#define IDS_FTPRESP_PROT_COMMAND_NOT_SECURE					13234
#define IDS_FTPRESP_PROT_CANNOT_OPEN_DATA					13235

// CCC messages
#define IDS_FTPCMND_CCC_SYNTAX								13240
#define IDS_FEATDESC_CCC									13241
#define IDS_FTPRESP_CCC_OKAY								13242
#define IDS_FTPRESP_CCC_COMMAND_NOT_SECURE					13243

// SSCN messages
#define IDS_FTPCMND_SSCN_SYNTAX								13250
#define IDS_FEATDESC_SSCN									13251
#define IDS_FTPRESP_SSCN_SERVER_METHOD						13252
#define IDS_FTPRESP_SSCN_CLIENT_METHOD						13253

// CWD messages
#define IDS_FTPCMND_CWD_SYNTAX								13260
#define IDS_FTPRESP_CWD_DIR_CHANGED							13261
#define IDS_FTPRESP_CWD_CANNOT_CHANGE_PATH_TO_PORT			13262

// CDUP messages
#define IDS_FTPCMND_CDUP_SYNTAX								13265

// PWD messages
#define IDS_FTPCMND_PWD_SYNTAX								13270
#define IDS_FTPRESP_PWD_OKAY								13271

// MKD messages
#define IDS_FTPCMND_MKD_SYNTAX								13275
#define IDS_FTPRESP_MKD_OKAY								13276
#define IDS_FTPRESP_MKD_UNABLE_TO_CREATE					13277
#define IDS_FTPRESP_MKD_CANNOT_CREATE_PORT					13278
#define IDS_FTPRESP_MKD_ALREADY_EXISTS						13279

// RMD messages
#define IDS_FTPCMND_RMD_SYNTAX								13285
#define IDS_FTPRESP_RMD_OKAY								13286
#define IDS_FTPRESP_RMD_CANNOT_DELETE_DIRECTORY				13287
#define IDS_FTPRESP_RMD_CANNOT_REMOVE_PORT					13288

// RMDA messages
#define IDS_FTPCMND_RMDA_SYNTAX								13290
#define IDS_FEATDESC_RMDA									13291

// PORT messages
#define IDS_FTPCMND_PORT_SYNTAX								13295
#define IDS_FTPRESP_PORT_OKAY								13296
#define IDS_FTPRESP_PORT_ONLY_CLIENT_IP_ALLOWED				13297
#define IDS_FTPRESP_PORT_INVALID_PORT_NUMBER				13298
#define IDS_FTPRESP_PORT_BAD_SEQUENCE_OF_COMMANDS			13299

// EPRT messages
#define IDS_FTPCMND_EPRT_SYNTAX								13300
#define IDS_FEATDESC_EPRT									13301
#define IDS_FTPRESP_EPRT_OKAY								13302
#define IDS_FTPRESP_EPRT_ONLY_CLIENT_IP_ALLOWED				13303
#define IDS_FTPRESP_EPRT_INVALID_PORT_NUMBER				13304
#define IDS_FTPRESP_EPRT_PROTOCOL_NOT_SUPPORTED				13305
#define IDS_FTPRESP_EPRT_BAD_SEQUENCE_OF_COMMANDS			13306

// PASV messages
#define IDS_FTPCMND_PASV_SYNTAX								13307
#define IDS_FTPRESP_PASV_OKAY								13308
#define IDS_FTPRESP_PASV_UNABLE_TOSETUP_LISTEN_SOCK			13309
#define IDS_FTPRESP_PASV_TOO_MANY_PASV_REQUESTS				13310
#define IDS_FTPRESP_PASV_ONLY_CLIENT_IP_ALLOWED				13311
#define IDS_FTPRESP_PASV_BAD_SEQUENCE_OF_COMMANDS			13312

// EPSV messages
#define IDS_FTPCMND_EPSV_SYNTAX								13313
#define IDS_FEATDESC_EPSV									13314
#define IDS_FTPRESP_EPSV_OKAY								13315
#define IDS_FTPRESP_EPSV_UNABLE_TOSETUP_LISTEN_SOCK			13316
#define IDS_FTPRESP_EPSV_TOO_MANY_PASV_REQUESTS				13317
#define IDS_FTPRESP_EPSV_ONLY_CLIENT_IP_ALLOWED				13318
#define IDS_FTPRESP_EPSV_PROTOCOL_NOT_SUPPORTED				13319
#define IDS_FTPRESP_EPSV_PROTOCOL_1_NOT_SUPPORTED			13320
#define IDS_FTPRESP_EPSV_PROTOCOL_2_NOT_SUPPORTED			13321

// TYPE messages
#define IDS_FTPCMND_TYPE_SYNTAX								13322
#define IDS_FTPRESP_TYPE_SET_A								13323
#define IDS_FTPRESP_TYPE_SET_I								13324

// RETR messages
#define IDS_FTPCMND_RETR_SYNTAX								13325
#define IDS_FTPRESP_RETR_OPENING_DATA_CONNECTION			13326
#define IDS_FTPRESP_RETR_DATA_CONN_CLOSED_BY_CLIENT			13327
#define IDS_FTPRESP_RETR_CANT_OPEN_FILE						13328
#define IDS_FTPRESP_RETR_INSUFFICIENT_CREDIT				13329

// STOR messages
#define IDS_FTPCMND_STOR_SYNTAX								13340
#define IDS_FTPRESP_STOR_OPENING_DATA_CONNECTION			13341
#define IDS_FTPRESP_STOR_CANT_WRITE							13342
#define IDS_FTPRESP_STOR_INSUFFICIENT_DISK_QUOTA			13343
#define IDS_FTPRESP_STOR_INSUFFICIENT_DISK_SPACE			13344
#define IDS_FTPRESP_STOR_FILE_TOO_LARGE						13345
#define IDS_FTPRESP_STOR_CANT_CREATE_FILE					13346

// STOU messages
#define IDS_FTPCMND_STOU_SYNTAX								13355
#define IDS_FTPRESP_STOU_OPENING_DATA_CONNECTION			13356
#define IDS_FTPRESP_STOU_CANT_CREATE_UNIQUE_NAME			13357

// THMB messages
#define IDS_FTPCMND_THMB_SYNTAX								13365
#define IDS_FEATDESC_THMB									13366
#define IDS_FTPRESP_THMB_OPENING_DATA_CONNECTION			13367
#define IDS_FTPRESP_THMB_CANT_LOAD_GDI_PLUS					13368
#define IDS_FTPRESP_THMB_CANT_CREATE_THUMBNAIL				13369
#define IDS_FTPRESP_THMB_CANT_SAVE_THUMBNAIL				13370

// STRU messages
#define IDS_FTPCMND_STRU_SYNTAX								13375
#define IDS_FTPRESP_STRU_F_OKAY								13376
#define IDS_FTPRESP_STRU_R_OKAY								13377
#define IDS_FTPRESP_STRU_P_OKAY								13378

// APPE messages
#define IDS_FTPCMND_APPE_SYNTAX								13380
#define IDS_FTPRESP_APPE_CANT_RESTART						13381

// ALLO messages
#define IDS_FTPCMND_ALLO_SYNTAX								13385
#define IDS_FTPRESP_ALLO_OKAY								13386
#define IDS_FTPRESP_ALLO_NOT_ENOUGH_SPACE					13387

// REST messages
#define IDS_FTPCMND_REST_SYNTAX								13395
#define IDS_FEATDESC_REST									13396
#define IDS_FTPRESP_REST_RESTARTING_AT						13397

// SIZE messages
#define IDS_FTPCMND_SIZE_SYNTAX								13405
#define IDS_FEATDESC_SIZE									13406
#define IDS_FTPRESP_SIZE_OKAY								13407
#define IDS_FTPRESP_SIZE_CANT_GET_SIZE_OF_PORT				13408

// DSIZ messages
#define IDS_FTPCMND_DSIZ_SYNTAX								13410
#define IDS_FEATDESC_DSIZ									13411
#define IDS_FTPRESP_DSIZ_OKAY								13412
#define IDS_FTPRESP_DSIZ_CANT_GET_SIZE_OF_PORT				13413

// AVBL messages
#define IDS_FTPCMND_AVBL_SYNTAX								13415
#define IDS_FEATDESC_AVBL									13416
#define IDS_FTPRESP_AVBL_OKAY								13417
#define IDS_FTPRESP_AVBL_CANT_GET_AVBL_OF_PORT				13418

// RNFR messages
#define IDS_FTPCMND_RNFR_SYNTAX								13420
#define IDS_FTPRESP_RNFR_OKAY								13421

// RNTO messages
#define IDS_FTPCMND_RNTO_SYNTAX								13425
#define IDS_FTPRESP_RNTO_OKAY								13426
#define IDS_FTPRESP_RNTO_CANNOT_RENAME_TO_PORT				13427
#define IDS_FTPRESP_RNTO_UNABLE_TO_RENAME					13428

// DELE messages
#define IDS_FTPCMND_DELE_SYNTAX								13430
#define IDS_FTPRESP_DELE_OKAY								13431
#define IDS_FTPRESP_DELE_CANNOT_DELETE_FILE					13432
#define IDS_FTPRESP_DELE_CANNOT_DELETE_A_PORT				13433

// MDTM messages
#define IDS_FTPCMND_MDTM_SYNTAX								13440
#define IDS_FEATDESC_MDTM									13441
#define IDS_FTPRESP_MDTM_OKAY								13442
#define IDS_FTPRESP_MDTM_DATE_TIME_CHANGE_OKAY				13443
#define IDS_FTPRESP_MDTM_CANT_DETERMINE_DATE_TIME			13444
#define IDS_FTPRESP_MDTM_CANT_DO_PORT						13445
#define IDS_FTPRESP_MDTM_CANT_SET_TO_FUTURE					13446

// XCRC messages
#define IDS_FTPCMND_XCRC_SYNTAX								13455
#define IDS_FEATDESC_XCRC									13456
#define IDS_FTPRESP_XCRC_OKAY								13457
#define IDS_FTPRESP_XCRC_CANNOT_READ_FROM_FILE				13458

// LIST messages
#define IDS_FTPCMND_LIST_SYNTAX								13465
#define IDS_FTPRESP_LIST_OKAY								13466
#define IDS_FTPRESP_LIST_CANNOT_LIST_PORT					13467
#define IDS_FTPRESP_LIST_DATA_CONN_CLOSED_ABORTED			13468

// MLST messages
#define IDS_FTPCMND_MLST_SYNTAX								13475
#define IDS_FEATDESC_MLST									13476
#define IDS_FTPRESP_MLST_OKAY								13477

// MLSD messages
#define IDS_FTPCMND_MLSD_SYNTAX								13485
#define IDS_FTPRESP_MLSD_OKAY								13486
#define IDS_FTPRESP_MLSD_WILDCARDS_NOT_ALLOWED				13487
#define IDS_FTPRESP_MLSD_PATHNAME_NOT_DIRECTORY				13488

// SITE messages
#define	IDS_FTPCMND_SITE_SYNTAX								13494

// SITE PSWD messages
#define IDS_FTPCMND_SITE_PSWD_SYNTAX						13495
#define IDS_FTPRESP_SITE_PSWD_OKAY							13496
#define IDS_FTPRESP_SITE_PSWD_NO_OLD_PASSWORD_MATCH			13497
#define IDS_FTPRESP_SITE_PSWD_PASSWORD_TOO_SHORT			13498
#define IDS_FTPRESP_SITE_PSWD_NOT_COMPLEX					13499
#define IDS_FTPRESP_SITE_PSWD_OLD_NEW_MATCH					13500
#define IDS_FTPRESP_SITE_PSWD_INVALID_PARAMETERS			13501
#define IDS_FTPRESP_SITE_PSWD_CANT_CHANGE_PASSWORD			13502
#define IDS_FTPRESP_SITE_PSWD_CANT_CHANGE_ANONYMOUS			13503

// SITE SET TRANSFERPROGRESS messages
#define IDS_FTPCMND_SITE_SET_SYNTAX							13510
#define IDS_FTPRESP_SITE_SET_TRANSFER_PROG_OKAY				13511

// SITE ZONE messages
#define IDS_FTPCMND_SITE_ZONE_SYNTAX						13530
#define IDS_FTPRESP_SITE_ZONE_OKAY							13531
#define IDS_FTPRESP_SITE_ZONE_CANT_GET_TZ					13532

// SITE CHMOD messages
#define IDS_FTPCMND_SITE_CHMOD_SYNTAX						13540
#define IDS_FTPRESP_SITE_CHMOD_OKAY							13541
#define IDS_FTPRESP_SITE_CHMOD_CANT_CHANGE					13542

// SITE MSG messages
#define IDS_FTPCMND_SITE_MSG_SYNTAX							13550
#define IDS_FTPRESP_SITE_MSG_OKAY							13551

// SITE EXEC messages
#define IDS_FTPCMND_SITE_EXEC_SYNTAX						13560
#define IDS_FTPRESP_SITE_EXEC_OKAY							13561
#define IDS_FTPRESP_SITE_EXEC_COMMAND_LINE					13562
#define IDS_FTPRESP_SITE_EXEC_PORTS							13563

// NLST messages
#define	IDS_FTPCMND_NLST_SYNTAX								13570

// MFMT messages
#define IDS_FTPCMND_MFMT_SYNTAX								13580
#define IDS_FEATDESC_MFMT									13581
#define IDS_FTPRESP_MFMT_OKAY								13582

// MFCT messages
#define IDS_FTPCMND_MFCT_SYNTAX								13590
#define IDS_FEATDESC_MFCT									13591
#define IDS_FTPRESP_MFCT_OKAY								13592

// MFF messages
#define IDS_FTPCMND_MFF_SYNTAX								13600
#define IDS_FEATDESC_MFF									13601
#define IDS_FTPRESP_MFF_OKAY								13602
#define IDS_FTPRESP_MFF_INVALID_FACT						13603

/////////////////////////////////////////////////////////////////////////////
// Serv-U-SSH strings

// general
#define IDS_SSH_LANGUAGE									14950

// authentication
#define IDS_SSH_PROTERR_PASSWORD_EXPECTED					15000
#define IDS_SSH_PROTERR_EXPECTED_AUTH_TYPE					15001
#define IDS_SSH_PROTERR_EXPECTED_PUBLIC_KEY_AUTH			15002
#define IDS_SSH_PROTERR_EXPECTED_SSH_CONNECTION				15003
#define IDS_SSH_PROTERR_PACKET_TOO_LARGE					15004
#define IDS_SSH_INVALID_CLIENT_PROTOCOL_ID					15005
#define IDS_SSH_UNABLE_TO_CHOOSE_CRYPTOS					15006
#define IDS_SSH_UNABLE_TO_USE_CLIENT_KEYS_SIG				15007
#define IDS_SSH_INVALID_KEY_EXCHANGE_VALUE					15008
#define IDS_SSH_INVALID_STATE								15009
#define IDS_SSH_INVALID_PUBLIC_KEY							15010
#define IDS_SSH_INVALID_SERVICE_REQUEST						15011
#define IDS_SSH_CLIENT_DISCONNECT_REQUEST_FMT				15012
#define IDS_SSH_INVALID_GLOBAL_REQUEST						15013

// channel results
#define IDS_SSH_CHANNEL_FAILURE								15020

// SSH_FXP_STAT error strings
// NOTE: when adding to these, remember to add to Serv-U-Log.h as well
#define IDS_SSH_FX_FIRST									15100
#define IDS_SSH_FX_OK										15100
#define IDS_SSH_FX_EOF										15101
#define IDS_SSH_FX_NO_SUCH_FILE								15102
#define IDS_SSH_FX_PERMISSION_DENIED						15103
#define IDS_SSH_FX_FAILURE									15104
#define IDS_SSH_FX_BAD_MESSAGE								15105
#define IDS_SSH_FX_NO_CONNECTION							15106
#define IDS_SSH_FX_CONNECTION_LOST							15107
#define IDS_SSH_FX_OP_UNSUPPORTED							15108
#define IDS_SSH_FX_INVALID_HANDLE							15109
#define IDS_SSH_FX_NO_SUCH_PATH								15110
#define IDS_SSH_FX_FILE_ALREADY_EXISTS						15111
#define IDS_SSH_FX_WRITE_PROTECT							15112
#define IDS_SSH_FX_NO_MEDIA									15113
#define IDS_SSH_FX_NO_SPACE_ON_FILESYSTEM					15114
#define IDS_SSH_FX_QUOTA_EXCEEDED							15115
#define IDS_SSH_FX_UNKNOWN_PRINCIPLE						15116
#define IDS_SSH_FX_LOCK_CONFlICT							15117
#define IDS_SSH_FX_DIR_NOT_EMPTY							15118
#define IDS_SSH_FX_NOT_A_DIRECTORY							15119
#define IDS_SSH_FX_INVALID_FILENAME							15120
#define IDS_SSH_FX_LINK_LOOP								15121
#define IDS_SSH_FX_CANNOT_DELETE							15122
#define IDS_SSH_FX_INVALID_PARAMETER						15123
#define IDS_SSH_FX_FILE_IS_A_DIRECTORY						15124
#define IDS_SSH_FX_BYTE_RANGE_LOCK_CONFLICT					15125
#define IDS_SSH_FX_BYTE_RANGE_LOCK_REFUSED					15126
#define IDS_SSH_FX_DELETE_PENDING							15127
#define IDS_SSH_FX_FILE_CORRUPT								15128
#define IDS_SSH_FX_OWNER_INVALID							15129
#define IDS_SSH_FX_GROUP_INVALID							15130
#define IDS_SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK				15131
#define IDS_SSH_FX_UNKNOWN_ERROR							15132

// disconnect reason code
#define IDS_SSHDIS_HOST_NOT_ALLOWED_TO_CONNECT				15200
#define IDS_SSHDIS_PROTOCOL_ERROR							15201
#define IDS_SSHDIS_KEY_EXCHANGE_FAILED						15202
#define IDS_SSHDIS_HOST_AUTHENTICATION_FAILED				15203
#define IDS_SSHDIS_MAC_ERROR								15204
#define IDS_SSHDIS_COMPRESSION_ERROR						15205
#define IDS_SSHDIS_SERVICE_NOT_AVAILABLE					15206
#define IDS_SSHDIS_PROTOCOL_VERSION_NOT_SUPPORTED			15207
#define IDS_SSHDIS_HOST_KEY_NOT_VERIFIABLE					15208
#define IDS_SSHDIS_CONNECTION_LOST							15209
#define IDS_SSHDIS_BY_APPLICATION							15210
#define IDS_SSHDIS_TOO_MANY_CONNECTIONS						15211
#define IDS_SSHDIS_AUTH_CANCELLED_BY_USER					15212
#define IDS_SSHDIS_NO_MORE_AUTH_METHODS_AVAILABLE			15213
#define IDS_SSHDIS_ILLEGAL_USER_NAME						15214

/////////////////////////////////////////////////////////////////////////////
// HTTP strings

// HTTP errors
// DO NOT TRANSLATE THESE STRINGS, they are used internally only
#define IDS_SU_HTTP_OK										16200
#define IDS_SU_HTTP_CREATED									16201
#define IDS_SU_HTTP_ACCEPTED								16202
#define IDS_SU_HTTP_NO_CONTENT								16204
#define IDS_SU_HTTP_PARTIAL_CONTENT							16206
#define IDS_SU_HTTP_MOVED_PERMANENTLY						16301
#define IDS_SU_HTTP_MOVED_TEMPORARILY						16302
#define IDS_SU_HTTP_NOT_MODIFIED							16304
#define IDS_SU_HTTP_BAD_REQUEST								16400
#define IDS_SU_HTTP_UNAUTHORIZED							16401
#define IDS_SU_HTTP_FORBIDDEN								16403
#define IDS_SU_HTTP_NOT_FOUND								16404
#define IDS_SU_HTTP_INTERNAL_SERVER_ERROR					16500
#define IDS_SU_HTTP_NOT_IMPLEMENTED							16501
#define IDS_SU_HTTP_BAD_GATEWAY								16502
#define IDS_SU_HTTP_SERVICE_UNAVAILABLE						16503

// general
#define IDS_SU_HTTP_FIRST									16000

// misc. strings
#define IDS_SU_HTTP_ENCRYPTED								16600

/////////////////////////////////////////////////////////////////////////////
// Serv-U-Tray strings

// general
#define IDS_SU_TRAY_FIRST									17000

// tray pop-up menu
#define IDS_SU_TRAY_MENU_START_ADMIN						17000
#define IDS_SU_TRAY_MENU_START_SU							17001
#define IDS_SU_TRAY_MENU_STOP_SU							17002
#define IDS_SU_TRAY_MENU_THEMES								17003
#define	IDS_SU_TRAY_MENU_SHOW_NOTIFICATIONS					17004
#define	IDS_SU_TRAY_MENU_START_AUTOMATICALLY				17005
#define	IDS_SU_TRAY_MENU_START_SERV_U_SERVICE				17006
#define	IDS_SU_TRAY_MENU_USE_BROWSER						17007
#define IDS_SU_TRAY_MENU_KB									17008
#define IDS_SU_TRAY_MENU_SUPPORT							17009
#define IDS_SU_TRAY_MENU_ABOUT								17010
#define IDS_SU_TRAY_MENU_REGISTER							17011
#define IDS_SU_TRAY_MENU_EXIT_TRAY							17012

// sub-menus
#define IDS_SU_TRAY_MENU_DEFAULT_THEME						17020
#define IDS_SU_TRAY_MENU_DEFAULT_NO_ANI_THEME				17021
#define IDS_SU_TRAY_MENU_CLASSIC_THEME						17022
#define IDS_SU_TRAY_MENU_CUSTOM_THEME						17023
#define IDS_SU_TRAY_MENU_THEME_EDITOR						17024

// server states
#define IDS_SERVER_STATE_NOT_RUNNING						17050
#define IDS_SERVER_STATE_RUNNING							17051
#define IDS_SERVER_STATE_RUNNING_LISTEN_ERROR				17052
#define IDS_SERVER_STATE_SESSION_CONNECTED					17053
#define IDS_SERVER_STATE_TRANSFERRING						17054
#define IDS_SERVER_STATE_PAST_TRIAL							17055

// management console
#define IDS_SERVER_UP_TIME_FMT								17070
#define IDS_SERVER_SESSIONS_FMT								17071
#define IDS_SERVER_TRANSFER_STATS_FMT						17072
#define IDS_SU_TRAY_BYTES_FMT								17073
#define IDS_SU_TRAY_KB_FMT									17074
#define IDS_SU_TRAY_MB_FMT									17075
#define IDS_SU_TRAY_GB_FMT									17076
#define IDS_SU_TRAY_DOMAINS_FMT								17077

// misc. strings
#define IDS_SU_TRAY_STATE									17090
#define IDS_SU_TRAY_IMAGES									17091
#define IDS_TRAY_THEME_FILE_OPEN_FILTERS					17092
#define IDS_TRAY_THEME_FILEARCH_OPEN_FILTERS				17093
#define IDS_SERVU_THEMES_DIR								17094
#define IDS_TRAY_USER_THEME_DIR_TIP							17095
#define IDS_DELETE_CREATED_DIRS_FMT							17096
#define IDS_UNABLE_TO_LOAD_SELECTED_THEME					17097
#define IDS_UNABLE_TO_STORE_THEME							17098
#define IDS_THEME_CHANGED_SAVE								17099
#define IDS_SU_TRAY_FILE_NAME								17100
#define IDS_SU_TRAY_DURATION								17101
#define IDS_SU_TRAY_INVALID_ICON							17102
#define IDS_TRAY_ALL_IMAGE_FILES							17103
#define IDS_TRAY_ALL_FILES									17104
#define IDS_TRAY_THEME_ARCHIVEFILE_OPEN_FILTERS				17105
#define IDS_UNABLE_TO_LOAD_ZLIB								17106
#define IDS_UNABLE_TO_CREATE_THEME_ARCHIVE_FILE				17107
#define IDS_UNABLE_TO_OPEN_THEME_ARCHIVE_FILE				17108
#define IDS_THEME_ARCHIVED									17109
#define IDS_THEME_IMPORTED									17110
#define IDS_THEME_FILE_DESC									17111
#define IDS_THEME_ARCHIVE_FILE_DESC							17112
#define IDS_IMPORT_ARCHIVE_FILE								17113
#define IDS_MANAGEMENT_CONSOLE								17114
#define IDS_TRAY_SERVER_NOT_LISTENING_HTTP_HTTPS			17115
#define IDS_MANAGEMENT_CONSOLE_ALREADY_RUNNING				17116
#define IDS_USERS_ARE_CONNECTED_SERVICE_CHANGE				17117
#define IDS_CANNOT_EXEC_SERVICE_SETTING_NOT_CHANGED			17118

// tray tooltip
#define IDS_SU_TRAY_TT_STATUS_FMT							17200
#define IDS_SU_TRAY_TT_RECVD_FMT							17201
#define IDS_SU_TRAY_TT_SENT_FMT								17202
#define IDS_SU_TRAY_TT_BPS_FMT								17203
#define IDS_SU_TRAY_TT_KBS_FMT								17204
#define IDS_SU_TRAY_TT_MBS_FMT								17205
#define IDS_SU_TRAY_TT_GBS_FMT								17206
#define IDS_SU_TRAY_TT_64_CHARS_FMT							17207
#define IDS_SU_TRAY_TT_STOPPED								17208
#define IDS_SU_TRAY_STATUS_CHANGED							17209
#define IDS_SU_TRAY_STATUS_ONLINE							17210
#define IDS_SU_TRAY_STATUS_OFFLINE							17211
#define IDS_SU_TRAY_UPDATE									17212
#define IDS_SU_TRAY_UPDATE_AVAILABLE						17213
#define IDS_SU_TRAY_STATUS_BETA_EXPIRED						17214
#define IDS_SU_TRAY_LICENSE_VIOLATION						17215
#define IDS_SU_TRAY_LICENSE_VIOLATION_NO_CONNS				17216

// trial / reggie baloon tip strings
#define IDS_SU_TRAY_REGBAL_PAST_TRIAL_TITLE					17240
#define IDS_SU_TRAY_REGBAL_PAST_TRIAL_BODY					17241
#define IDS_SU_TRAY_REGBAL_NEAR_TRIAL_END_TITLE				17242
#define IDS_SU_TRAY_REGBAL_NEAR_TRIAL_END_BODY_FMT			17243
#define IDS_SU_TRAY_REGBAL_NEAR_UPDATE_END_TITLE			17244
#define IDS_SU_TRAY_REGBAL_NEAR_UPDATE_END_BODY_FMT			17245

/////////////////////////////////////////////////////////////////////////////
// Serv-U-Log strings

// system log strings
#define IDS_LOG_SERVER_START_WELCOME_FMT					18000
#define IDS_LOG_SERVER_START_BUILD_DATE_FMT					18001
#define IDS_LOG_SERVER_OS_FMT								18002
#define IDS_LOG_SERVER_OPENSSL_INIT_OKAY					18003
#define IDS_LOG_SERVER_OPENSSL_INIT_FAIL					18004
#define IDS_LOG_SERVER_OPENSSL_FIPS_MODE_ON					18005
#define IDS_LOG_SERVER_OPENSSL_FIPS_MODE_OFF				18006
#define IDS_LOG_SERVER_OPENSSL_FIPS_MODE_NOT_SUPPORTED		18007
#define IDS_LOG_SERVER_STOPPING								18008
#define IDS_LOG_SERVER_STOP									18009
#define IDS_LOG_CMD_LISTENING_FMT							18010
#define IDS_LOG_CMD_NOT_LISTENING_IN_USE_FMT				18011
#define IDS_LOG_CMD_NOT_LISTENING_FMT						18012
#define IDS_LOG_CMD_NOT_LISTENING_ADDR_NOT_AVAIL_FMT		18013
#define IDS_LOG_CMD_CLOSED_FMT								18014
#define IDS_LOG_PERM_DATA_LISTENING_FMT						18015
#define IDS_LOG_PERM_DATA_NOT_LISTENING_FMT					18016
#define IDS_LOG_PERM_DATA_NOT_LISTENING_IN_USE_FMT			18017
#define IDS_LOG_PERM_DATA_NOT_LISTENING_ADDR_NOT_AVAIL_FMT	18018
#define IDS_LOG_PERM_DATA_CLOSED_FMT						18019
#define IDS_LOG_DOMAIN_STARTED								18020
#define IDS_LOG_DOMAIN_STOPPED								18021
#define IDS_LOG_SERVER_START_BETA_EXPIRED_FMT				18022
#define IDS_LOG_SERVER_START_BETA_NOTICE_FMT				18023
#define IDS_LOG_EVENT_COULD_NOT_EXEC_FMT					18024
#define IDS_LOG_EVENT_COULD_NOT_EMAIL_FMT					18025
#define IDS_LOG_SOCKET_TIME_OUT_FMT							18026
#define IDS_LOG_EMAIL_RETRY_FMT								18027
#define IDS_LOG_EMAIL_CANT_CONNECT_FMT						18028
#define IDS_LOG_EMAIL_SSL_CONNECT_FAIL_FMT					18029
#define IDS_LOG_WINSOCK_INIT_FMT							18030
#define IDS_LOG_WINSOCK_INIT_FAILED_FMT						18031
#define IDS_LOG_SSL_DATA_SOCKET_TIME_OUT					18032

// UPnP log strings
#define IDS_LOG_UPNP_FOUND_DEVICE_FMT						18100
#define IDS_LOG_UPNP_DEVICE_DISCOVERY_COMPLETE_FMT			18101
#define IDS_LOG_UPNP_MAP_SUCCESSFUL_FMT						18102
#define IDS_LOG_UPNP_MAP_ERROR_FMT							18103
#define IDS_LOG_UPNP_DELETE_MAP_SUCCESSFUL_FMT				18104
#define IDS_LOG_UPNP_DELETE_MAP_ERROR_FMT					18105
#define IDS_LOG_UPNP_DELETE_MAPS_SUCCESSFUL_FMT				18106
#define IDS_LOG_UPNP_MAPS_SUCCESSFUL_FMT					18107
#define IDS_LOG_UPNP_DELETE_MAPS_ERROR_FMT					18108
#define IDS_LOG_UPNP_MAPS_ERROR_FMT							18109
#define IDS_LOG_UPNP_TIMEOUT								18110
#define IDS_LOG_UPNP_NA										18111
#define IDS_LOG_UPNP_DEAD_DEVICE_FMT						18112
#define IDS_LOG_UPNP_NO_DEVICES_REMAIN						18113
#define IDS_LOG_UPNP_DEVICE_REDISCOVERY_FMT					18114
#define IDS_LOG_UPNP_DEVICE_INSPECTION						18115

// socket types (these MUST remain sequential)
#define IDS_LOG_FTP_TYPE									18200
#define IDS_LOG_FTPS_TYPE									18201
#define IDS_LOG_SSH_TYPE									18202
#define IDS_LOG_HTTP_TYPE									18203
#define IDS_LOG_HTTPS_TYPE									18204
// NOTE: if adding new values be sure to change the values below
#define IDS_LOG_LISTEN_TYPE_FIRST							IDS_LOG_FTP_TYPE
#define IDS_LOG_LISTEN_TYPE_LAST							IDS_LOG_HTTPS_TYPE

// session log strings
#define IDS_LOG_RECEIVING_FILE_FMT							18300
#define IDS_LOG_RECEIVED_FILE_FMT							18301
#define IDS_LOG_SENDING_FILE_FMT							18302
#define IDS_LOG_SENDING_THUMBNAIL_FMT						18303
#define IDS_LOG_SENT_FILE_FMT								18304
#define IDS_LOG_SENT_THUMBNAIL_FMT							18305
#define IDS_LOG_FILE_DELETED_FMT							18306
#define IDS_LOG_FILE_DIR_RENAME_FMT							18307
#define IDS_LOG_DIR_CREATE_FMT								18308
#define IDS_LOG_DIR_DELETE_FMT								18309
#define IDS_LOG_IP_ADDRESS_REVERSE_DNS_FMT					18310

// SSH log command strings
#define IDS_SSH_UNEXPECTED_MESSAGE_FMT						18400
#define IDS_SSH2_MSG_USERAUTH_REQUEST_FMT					18401
#define IDS_SSH_STATUS_COMMAND_FMT							18402
#define IDS_SSH_FXP_INIT_FMT								18403
#define IDS_SSH_FXP_OPEN_FMT								18404
#define IDS_SSH_FXP_CLOSE_FMT								18405
#define IDS_SSH_FXP_READ_FMT								18406
#define IDS_SSH_FXP_WRITE_FMT								18407
#define IDS_SSH_FXP_STAT_FMT								18408
#define IDS_SSH_FXP_FSTAT_FMT								18409
#define IDS_SSH_FXP_SETSTAT_FMT								18410
#define IDS_SSH_FXP_FSETSTAT_FMT							18411
#define IDS_SSH_FXP_OPENDIR_FMT								18412
#define IDS_SSH_FXP_READDIR_FMT								18413
#define IDS_SSH_FXP_REMOVE_FMT								18414
#define IDS_SSH_FXP_MKDIR_FMT								18415
#define IDS_SSH_FXP_RMDIR_FMT								18416
#define IDS_SSH_FXP_REALPATH_FMT							18417
#define IDS_SSH_FXP_RENAME_FMT								18418
#define IDS_SSH_FXP_READLINK_FMT							18419
#define IDS_SSH2_MSG_GLOBAL_REQUEST_FMT						18420

// SSH login reply strings
#define IDS_SSH2_MSG_USERAUTH_SUCCESS						18490
#define IDS_SSH2_MSG_USERAUTH_FAILURE						18491
#define IDS_SSH2_MSG_USERAUTH_PASSWD_CHANGEREQ				18492

// SSH log reply strings
#define IDS_SSH_STATUS_REPLY_FMT							18500
#define IDS_SSH_FXP_INIT_REPLY_FMT							18501
#define IDS_SSH_FXP_OPEN_REPLY_FMT							18502
#define IDS_SSH_FXP_OPENDIR_REPLY_FMT						18503
#define IDS_SSH_FXP_READDIR_REPLY_FMT						18504
#define IDS_SSH_FXP_REALPATH_REPLY_FMT						18505
#define IDS_SSH_FXP_ATTRS_REPLY_FMT							18506
#define IDS_SSH_FXP_DATA_REPLY_FMT							18507
#define IDS_SSH2_MSG_REQUEST_FAILURE_REPLY_FMT				18508

// SSH_FXP_STAT error strings
// NOTE: when adding to these, remember to add to Serv-U-SSH.h as well
#define IDS_SSH_FX_FIRST_ERRSTR								18600
#define IDS_SSH_FX_OK_ERRSTR								18600
#define IDS_SSH_FX_EOF_ERRSTR								18601
#define IDS_SSH_FX_NO_SUCH_FILE_ERRSTR						18602
#define IDS_SSH_FX_PERMISSION_DENIED_ERRSTR					18603
#define IDS_SSH_FX_FAILURE_ERRSTR							18604
#define IDS_SSH_FX_BAD_MESSAGE_ERRSTR						18605
#define IDS_SSH_FX_NO_CONNECTION_ERRSTR						18606
#define IDS_SSH_FX_CONNECTION_LOST_ERRSTR					18607
#define IDS_SSH_FX_OP_UNSUPPORTED_ERRSTR					18608
#define IDS_SSH_FX_INVALID_HANDLE_ERRSTR					18609
#define IDS_SSH_FX_NO_SUCH_PATH_ERRSTR						18610
#define IDS_SSH_FX_FILE_ALREADY_EXISTS_ERRSTR				18611
#define IDS_SSH_FX_WRITE_PROTECT_ERRSTR						18612
#define IDS_SSH_FX_NO_MEDIA_ERRSTR							18613
#define IDS_SSH_FX_NO_SPACE_ON_FILESYSTEM_ERRSTR			18614
#define IDS_SSH_FX_QUOTA_EXCEEDED_ERRSTR					18615
#define IDS_SSH_FX_UNKNOWN_PRINCIPLE_ERRSTR					18616
#define IDS_SSH_FX_LOCK_CONFlICT_ERRSTR						18617
#define IDS_SSH_FX_DIR_NOT_EMPTY_ERRSTR						18618
#define IDS_SSH_FX_NOT_A_DIRECTORY_ERRSTR					18619
#define IDS_SSH_FX_INVALID_FILENAME_ERRSTR					18620
#define IDS_SSH_FX_LINK_LOOP_ERRSTR							18621
#define IDS_SSH_FX_CANNOT_DELETE_ERRSTR						18622
#define IDS_SSH_FX_INVALID_PARAMETER_ERRSTR					18623
#define IDS_SSH_FX_FILE_IS_A_DIRECTORY_ERRSTR				18624
#define IDS_SSH_FX_BYTE_RANGE_LOCK_CONFLICT_ERRSTR			18625
#define IDS_SSH_FX_BYTE_RANGE_LOCK_REFUSED_ERRSTR			18626
#define IDS_SSH_FX_DELETE_PENDING_ERRSTR					18627
#define IDS_SSH_FX_FILE_CORRUPT_ERRSTR						18628
#define IDS_SSH_FX_OWNER_INVALID_ERRSTR						18629
#define IDS_SSH_FX_GROUP_INVALID_ERRSTR						18630
#define IDS_SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK_ERRSTR		18631
#define IDS_SSH_FX_UNKNOWN_ERROR_ERRSTR						18632

// HTTP log command strings
#define IDS_HTTP_LOGIN_FMT									19000
#define IDS_HTTP_LOGIN_DOMAIN_FMT							19001
#define IDS_HTTP_LOGOUT										19002
#define IDS_HTTP_LIST_FMT									19003
#define IDS_HTTP_DOWNLOAD_FMT								19004
#define IDS_HTTP_DOWNLOAD_THUMBNAIL_FMT						19005
#define IDS_HTTP_UPLOAD_FMT									19006
#define IDS_HTTP_DELETE_FMT									19007
#define IDS_HTTP_DELETE_DIR_FMT								19008
#define IDS_HTTP_CREATE_DIR_FMT								19009
#define IDS_HTTP_RENAME_FMT									19010
#define IDS_HTTP_START_FVJV									19011
#define IDS_HTTP_START_ADMIN								19012
#define IDS_HTTP_NOOP										19013
#define IDS_HTTP_ADMIN_COMMAND_FMT							19014
#define IDS_HTTP_ADMIN_COMMAND_OBJECT_FMT					19015
#define IDS_HTTP_ADMIN_COMMAND_OBJECT_ID_FMT				19016
#define IDS_HTTP_BUILD_PLAYLIST_FMT							19017
#define IDS_HTTP_GET_PLAYLIST_FMT							19018
#define IDS_HTTP_SPACE_AVAILABLE_FMT						19019
#define IDS_HTTP_DIRECTORY_SIZE_FMT							19020

// other HTTP replies
#define IDS_HTTP_RETR_ERROR_REPLY_FMT						19050
#define IDS_HTTP_STOR_ERROR_REPLY_FMT						19051

// HTTP log reply strings
#define IDS_HTTP_REPLY_OFFSET								19000
#define IDS_HTTP_OKAY_REPLY									19200
#define IDS_HTTP_CREATED_REPLY								19201
#define IDS_HTTP_ACCEPTED_REPLY								19202
#define IDS_HTTP_NO_CONTENT_REPLY							19204
#define IDS_HTTP_OKAY_REPLY_FMT								19299
#define IDS_HTTP_MOVED_PERMANENTLY_REPLY					19301
#define IDS_HTTP_MOVED_TEMPORARILY_REPLY					19302
#define IDS_HTTP_NOT_MODIFIED_REPLY							19304
#define IDS_HTTP_BAD_REQUEST_REPLY							19400
#define IDS_HTTP_UNAUTHORIZED_REPLY							19401
#define IDS_HTTP_FORBIDDEN_REPLY							19403
#define IDS_HTTP_NOT_FOUND_REPLY							19404
#define IDS_HTTP_INTERNAL_SERVER_ERROR_REPLY				19500
#define IDS_HTTP_NOT_IMPLEMENTED_REPLY						19501
#define IDS_HTTP_BAD_GATEWAY_REPLY							19502
#define IDS_HTTP_SERVICE_UNAVAILABLE_REPLY					19503

// system log strings
#define IDS_SYSLOG_OPENED_INTEGRATION_DLL_FMT				19890
#define IDS_SYSLOG_CLOSED_INTEGRATION_DLL_FMT				19891
#define IDS_SYSLOG_CANT_LOAD_INTEGRATION_DLL_FMT			19892
#define IDS_SYSLOG_CANT_LOAD_INTEGRATION_DLL__NO_LIC_FMT	19893

// security log strings
#define IDS_SECLOG_CONNECTED_FMT							19900
#define IDS_SECLOG_IP_BANNED_FMT							19901
#define IDS_SECLOG_CLOSED_SESSION							19902
#define IDS_SECLOG_IDLE_TIMEOUT								19903
#define IDS_SECLOG_SESSION_TIMEOUT							19904
#define IDS_SECLOG_SSL_ACCEPT_FAILED_FMT					19905
#define IDS_SECLOG_USER_ADMIN_DENIED_FMT					19906
#define IDS_SECLOG_USER_SERVER_ADMIN_FMT					19907
#define IDS_SECLOG_USER_DOMAIN_ADMIN_FMT					19908
#define IDS_SECLOG_USER_GROUP_ADMIN_FMT						19909
#define IDS_SECLOG_USER_PASSWORD_CHANGE_FMT					19910
#define IDS_SECLOG_PASSWORD_WRONG_TOO_MANY_TIMES_FMT		19911
#define IDS_SECLOG_USER_IP_BANNED_FMT						19912
#define IDS_SECLOG_USER_NO_HOME_FMT							19913
#define IDS_SECLOG_USER_LOGGED_IN_FMT						19914
#define IDS_SECLOG_USER_LOGGED_OUT_FMT						19915
#define IDS_SECLOG_ANONYMOUS_USER_LOGGED_IN_FMT				19916
#define IDS_SECLOG_BLOCKING_IP_FMT							19917
#define IDS_SECLOG_BLOCKING_IP_FOR_FMT						19918
#define IDS_SECLOG_ADMIN_OPERATION_DENIED_FMT				19919
#define IDS_SECLOG_LIC_NO_REMOTE_ADMIN_FMT					19920
#define IDS_SECLOG_LIC_TOO_MANY_SESSIONS_FMT				19921
#define IDS_SECLOG_LIC_NET_REGGIE_VIOLATION_FMT				19922
#define IDS_SECLOG_LIC_NET_REGGIE_VIOLATION2_FMT			19923
#define IDS_SECLOG_LIC_VALID_ID_PRESENT						19924
#define IDS_SECLOG_LIC_PAST_TRIAL							19925
#define IDS_SECLOG_SSL_CANT_OPEN_CERT_FILE_FMT				19926
#define IDS_SECLOG_SSL_CANT_OPEN_PRIVATE_KEY_FILE_FMT		19927
#define IDS_SECLOG_SSL_CANT_LOAD_TRUSTED_CA_FILE_FMT		19928
#define IDS_SECLOG_FAILED_LOGIN_FMT							19929
#define IDS_SECLOG_CONNECTION_ACCEPTED_FMT					19930
#define IDS_SECLOG_CONNECTION_DENIED_FMT					19931
#define	IDS_SECLOG_SSL_CLIENT_ERROR							19932
#define	IDS_SECLOG_USER_REQUESTED_PASSWORD_RECOVERY_FMT		19933
#define IDS_SECLOG_INTEGRATION_CONNECTION_DENIED_FMT		19934

// ODBC
#define IDS_ODBC_ERROR										20000

// triggered event log strings
#define IDS_TELOG_EVENT_FMT									20010
#define IDS_TELOG_EMAIL_FMT									20011
#define IDS_TELOG_BALLOON_TIP_FMT							20012
#define IDS_TELOG_EXEC_FMT									20013
#define IDS_TELOG_EMAIL_ADDRESS_FMT							20014
