/*
 * Decompiled with CFR 0.152.
 */
package DBstep;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class iMsgServer2000 {
    private String FError = "";
    private int FFileSize = 0;
    private boolean FMd5Error = false;
    private byte[] FMsgFile;
    private String FMsgText = "";
    private byte[] FStream;
    private String FVersion = "DBSTEP V3.0";
    static final byte[] PADDING = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int S11 = 7;
    static final int S12 = 12;
    static final int S13 = 17;
    static final int S14 = 22;
    static final int S21 = 5;
    static final int S22 = 9;
    static final int S23 = 14;
    static final int S24 = 20;
    static final int S31 = 4;
    static final int S32 = 11;
    static final int S33 = 16;
    static final int S34 = 23;
    static final int S41 = 6;
    static final int S42 = 10;
    static final int S43 = 15;
    static final int S44 = 21;
    private String TableBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private String VERSION = "DBSTEP V3.0";
    private byte[] buffer;
    private long[] count;
    private byte[] digest;
    private String digestHexStr;
    private long[] state;

    public iMsgServer2000() {
        this.FError = new String();
        this.FVersion = new String();
        this.state = new long[4];
        this.count = new long[2];
        this.buffer = new byte[64];
        this.digest = new byte[16];
    }

    private void Decode(long[] output, byte[] input, int len) {
        int i = 0;
        int j = 0;
        while (j < len) {
            output[i] = iMsgServer2000.b2iu(input[j]) | iMsgServer2000.b2iu(input[j + 1]) << 8 | iMsgServer2000.b2iu(input[j + 2]) << 16 | iMsgServer2000.b2iu(input[j + 3]) << 24;
            ++i;
            j += 4;
        }
    }

    public String DecodeBase64(String Value) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] d = new byte[4];
        try {
            int count = 0;
            byte[] x = Value.getBytes();
            while (count < x.length) {
                int n = 0;
                while (n <= 3) {
                    if (count >= x.length) {
                        d[n] = 64;
                    } else {
                        int y = this.TableBase64.indexOf(x[count]);
                        if (y < 0) {
                            y = 65;
                        }
                        d[n] = (byte)y;
                    }
                    ++count;
                    ++n;
                }
                o.write((byte)(((d[0] & 0x3F) << 2) + ((d[1] & 0x30) >> 4)));
                if (d[2] == 64) continue;
                o.write((byte)(((d[1] & 0xF) << 4) + ((d[2] & 0x3C) >> 2)));
                if (d[3] == 64) continue;
                o.write((byte)(((d[2] & 3) << 6) + (d[3] & 0x3F)));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
        }
        return o.toString();
    }

    public boolean DecodeBase64ToFile(String Value, String FileName) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        boolean mResult = false;
        byte[] d = new byte[4];
        try {
            int count = 0;
            byte[] x = Value.getBytes();
            while (count < x.length) {
                int n = 0;
                while (n <= 3) {
                    if (count >= x.length) {
                        d[n] = 64;
                    } else {
                        int y = this.TableBase64.indexOf(x[count]);
                        if (y < 0) {
                            y = 65;
                        }
                        d[n] = (byte)y;
                    }
                    ++count;
                    ++n;
                }
                o.write((byte)(((d[0] & 0x3F) << 2) + ((d[1] & 0x30) >> 4)));
                if (d[2] == 64) continue;
                o.write((byte)(((d[1] & 0xF) << 4) + ((d[2] & 0x3C) >> 2)));
                if (d[3] == 64) continue;
                o.write((byte)(((d[2] & 3) << 6) + (d[3] & 0x3F)));
            }
            FileOutputStream mFile = new FileOutputStream(FileName);
            byte[] mBuffer = o.toByteArray();
            int mSize = mBuffer.length;
            mFile.write(mBuffer, 0, mSize);
            mFile.close();
            mResult = true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            mResult = false;
            System.out.println(e.toString());
        }
        return mResult;
    }

    public boolean DelFile(String FileName) {
        File mFile = new File(FileName);
        if (mFile.exists()) {
            mFile.delete();
        }
        return true;
    }

    public boolean DelTree(String FilePath) {
        File mFile = new File(FilePath);
        if (mFile.isDirectory()) {
            mFile.delete();
        }
        return true;
    }

    private void Encode(byte[] output, long[] input, int len) {
        int i = 0;
        int j = 0;
        while (j < len) {
            output[j] = (byte)(input[i] & 0xFFL);
            output[j + 1] = (byte)(input[i] >>> 8 & 0xFFL);
            output[j + 2] = (byte)(input[i] >>> 16 & 0xFFL);
            output[j + 3] = (byte)(input[i] >>> 24 & 0xFFL);
            ++i;
            j += 4;
        }
    }

    public String EncodeBase64(String Value) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] d = new byte[4];
        try {
            int count = 0;
            byte[] x = Value.getBytes();
            while (count < x.length) {
                byte c = x[count];
                d[0] = (byte)((c & 0xFC) >> 2);
                d[1] = (byte)((c & 3) << 4);
                if (++count < x.length) {
                    c = x[count];
                    d[1] = (byte)(d[1] + (byte)((c & 0xF0) >> 4));
                    d[2] = (byte)((c & 0xF) << 2);
                    if (++count < x.length) {
                        c = x[count];
                        ++count;
                        d[2] = (byte)(d[2] + ((c & 0xC0) >> 6));
                        d[3] = (byte)(c & 0x3F);
                    } else {
                        d[3] = 64;
                    }
                } else {
                    d[2] = 64;
                    d[3] = 64;
                }
                int n = 0;
                while (n <= 3) {
                    o.write(this.TableBase64.charAt(d[n]));
                    ++n;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
        }
        return o.toString();
    }

    private long F(long x, long y, long z) {
        return x & y | (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private long FF(long a, long b, long c, long d, long x, long s, long ac) {
        a += this.F(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    protected String FormatHead(String vString) {
        if (vString.length() > 16) {
            return vString.substring(0, 16);
        }
        int i = vString.length() + 1;
        while (i < 17) {
            vString = vString.concat(" ");
            ++i;
        }
        return vString;
    }

    private long G(long x, long y, long z) {
        return x & z | y & (z ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private long GG(long a, long b, long c, long d, long x, long s, long ac) {
        a += this.G(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    public int GetFieldCount() {
        int i = 0;
        int j = 0;
        i = this.FMsgText.indexOf("\r\n", i + 1);
        while (i != -1) {
            ++j;
            i = this.FMsgText.indexOf("\r\n", i + 1);
        }
        return j;
    }

    public String GetFieldName(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldName = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1) {
            mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k);
            n = mFieldString.indexOf("=", 0);
            if (n != -1) {
                mReturn = mFieldName = mFieldString.substring(0, n);
            }
        }
        return mReturn;
    }

    public String GetFieldText() {
        return this.FMsgText.toString();
    }

    public String GetFieldValue(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldValue = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1) {
            mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k);
            n = mFieldString.indexOf("=", 0);
            if (n != -1) {
                mFieldValue = mFieldString.substring(n + 1, mFieldString.length());
                mReturn = this.DecodeBase64(mFieldValue);
            }
        }
        return mReturn;
    }

    public String GetMsgByName(String FieldName) {
        int i = 0;
        int j = 0;
        String mReturn = "";
        String mFieldName = FieldName.trim().concat("=");
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1) {
            j = this.FMsgText.indexOf("\r\n", i + 1);
            i += mFieldName.length();
            if (j != -1) {
                String mFieldValue = this.FMsgText.substring(i, j);
                mReturn = this.DecodeBase64(mFieldValue);
                return mReturn;
            }
            return mReturn;
        }
        return mReturn;
    }

    private long H(long x, long y, long z) {
        return x ^ y ^ z;
    }

    private long HH(long a, long b, long c, long d, long x, long s, long ac) {
        a += this.H(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    private long I(long x, long y, long z) {
        return y ^ (x | z ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private long II(long a, long b, long c, long d, long x, long s, long ac) {
        a += this.I(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    public int LoadFilePoint(String FileName) {
        int i = 0;
        int j = 0;
        int mSize = 0;
        String mText = "";
        String mReturn = "-1";
        String mFieldName = "INDEX=";
        try {
            File mFile = new File(FileName + ".fp");
            mSize = (int)mFile.length();
            byte[] mBuffer = new byte[mSize];
            FileInputStream mStream = new FileInputStream(mFile);
            mStream.read(mBuffer, 0, mSize);
            mStream.close();
            mText = new String(mBuffer);
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            return Integer.parseInt(mReturn);
        }
        i = mText.indexOf(mFieldName);
        if (i != -1) {
            j = mText.indexOf("\r\n", i + 1);
            i += mFieldName.length();
            if (j != -1) {
                mReturn = mText.substring(i, j - i);
                return Integer.parseInt(mReturn);
            }
            return Integer.parseInt(mReturn);
        }
        return Integer.parseInt(mReturn);
    }

    private String MD5Stream(byte[] Value) {
        this.md5Init();
        this.md5Update(Value, Value.length);
        this.md5Final();
        this.digestHexStr = "";
        int i = 0;
        while (i < 16) {
            this.digestHexStr = this.digestHexStr + iMsgServer2000.byteHEX(this.digest[i]);
            ++i;
        }
        return this.digestHexStr;
    }

    public boolean MKDirectory(String FilePath) {
        File mFile = new File(FilePath);
        mFile.mkdirs();
        return mFile.isDirectory();
    }

    public boolean MakeDirectory(String FilePath) {
        File mFile = new File(FilePath);
        mFile.mkdirs();
        return mFile.isDirectory();
    }

    public void MsgError(String Value) {
        this.FError = this.FMd5Error ? "[01]" + Value : Value;
    }

    public String MsgError() {
        return this.FError;
    }

    public void MsgErrorClear() {
        this.FError = "";
    }

    public void MsgFileBody(byte[] Value) {
        this.FMsgFile = Value;
        this.FFileSize = this.FMsgFile.length;
    }

    public byte[] MsgFileBody() {
        return this.FMsgFile;
    }

    public void MsgFileClear() {
        this.FFileSize = 0;
        this.FMsgFile = null;
    }

    public boolean MsgFileLoad(String FileName) {
        try {
            File mFile = new File(FileName);
            int mSize = (int)mFile.length();
            int mRead = 0;
            this.FMsgFile = new byte[mSize];
            FileInputStream mStream = new FileInputStream(mFile);
            while (mRead < mSize) {
                mRead += mStream.read(this.FMsgFile, mRead, mSize - mRead);
            }
            mStream.close();
            this.FFileSize = mSize;
            return true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean MsgFileSave(String FileName) {
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mFile.write(this.FMsgFile);
            mFile.close();
            return true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
            return false;
        }
    }

    public void MsgFileSize(int value) {
        this.FFileSize = value;
    }

    public int MsgFileSize() {
        return this.FFileSize;
    }

    public void MsgTextBody(String Value) {
        this.FMsgText = Value;
    }

    public String MsgTextBody() {
        return this.FMsgText;
    }

    public void MsgTextClear() {
        this.FMsgText = "";
    }

    private boolean MsgToStream() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position = 0;
        try {
            Position = 0;
            BodySize = this.FMsgText.getBytes().length;
            ErrorSize = this.FError.getBytes().length;
            FileSize = this.FFileSize;
            ByteArrayOutputStream mBuffer = new ByteArrayOutputStream(HeadSize + BodySize + ErrorSize + FileSize);
            String HeadString = this.FormatHead(this.FVersion) + this.FormatHead(String.valueOf(BodySize)) + this.FormatHead(String.valueOf(ErrorSize)) + this.FormatHead(String.valueOf(FileSize));
            mBuffer.write(HeadString.getBytes(), Position, HeadSize);
            Position += HeadSize;
            if (BodySize > 0) {
                mBuffer.write(this.FMsgText.getBytes());
            }
            Position += BodySize;
            if (ErrorSize > 0) {
                mBuffer.write(this.FError.getBytes());
            }
            Position += ErrorSize;
            if (FileSize > 0) {
                mBuffer.write(this.FMsgFile);
            }
            Position += FileSize;
            mBuffer.close();
            this.FStream = mBuffer.toByteArray();
            return true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
            return false;
        }
    }

    public void MsgVariant(byte[] mStream) {
        this.FStream = mStream;
        if (this.FError == "") {
            this.StreamToMsg();
        }
    }

    public byte[] MsgVariant() {
        this.MsgToStream();
        return this.FStream;
    }

    public String MsgVersion() {
        return this.FVersion;
    }

    public boolean RMDirectory(String FilePath) {
        File mFile = new File(FilePath);
        if (mFile.isDirectory()) {
            mFile.delete();
        }
        return true;
    }

    public byte[] ReadPackage(HttpServletRequest request) {
        int totalRead = 0;
        int readBytes = 0;
        int totalBytes = 0;
        try {
            totalBytes = request.getContentLength();
            this.FStream = new byte[totalBytes];
            while (totalRead < totalBytes) {
                request.getInputStream();
                readBytes = request.getInputStream().read(this.FStream, totalRead, totalBytes - totalRead);
                totalRead += readBytes;
            }
            if (this.FError == "") {
                this.StreamToMsg();
            }
        }
        catch (Exception e) {
            System.out.println("ReadPackage:" + e.toString());
        }
        return this.FStream;
    }

    public boolean SaveFilePoint(String FileName, int FCount) {
        boolean i = false;
        boolean j = false;
        int mSize = 0;
        String mFieldName = "INDEX=";
        String mCount = "";
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mCount = mFieldName + FCount + "\r\n";
            byte[] mBuffer = mCount.getBytes();
            mSize = mBuffer.length;
            mFile.write(mBuffer, 0, mSize);
            mFile.close();
            return true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println("SaveFilePoint:" + this.FError);
            return false;
        }
    }

    public boolean SaveFromFile(String FileName, int FileCount) {
        int mIndex = 0;
        String mPkName = "";
        mPkName = FileName + ".fp";
        this.DelFile(mPkName);
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mIndex = 0;
            while (mIndex <= FileCount) {
                mPkName = FileName + "." + mIndex;
                File nTemp = new File(mPkName);
                FileInputStream mTemp = new FileInputStream(nTemp);
                byte[] mBuffer = new byte[(int)nTemp.length()];
                mTemp.read(mBuffer, 0, (int)nTemp.length());
                mFile.write(mBuffer, 0, (int)nTemp.length());
                mTemp.close();
                nTemp.delete();
                ++mIndex;
            }
            mFile.close();
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println("SaveFromFile:" + this.FError);
            return false;
        }
        return true;
    }

    public boolean SaveFromStream(String FileName, int Index) {
        String mPkName = "";
        mPkName = FileName + ".fp";
        this.DelFile(mPkName);
        if (Index == 0) {
            this.DelFile(FileName);
        }
        try {
            RandomAccessFile mFile = new RandomAccessFile(FileName, "rw");
            mFile.seek(mFile.length());
            mFile.write(this.FMsgFile);
            mFile.close();
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println("SaveFromStream:" + this.FError);
            return false;
        }
        return true;
    }

    public boolean SavePackage(String FileName) {
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mFile.write(this.FStream);
            mFile.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void SendPackage(HttpServletResponse response) {
        try {
            ServletOutputStream OutBinarry = response.getOutputStream();
            OutBinarry.write(this.MsgVariant());
            OutBinarry.flush();
            OutBinarry.close();
        }
        catch (Exception e) {
            System.out.println("SendPackage:" + e.toString());
        }
    }

    public void SetMsgByName(String FieldName, String FieldValue) {
        String mFieldText = "";
        String mFieldHead = "";
        String mFieldNill = "";
        int i = 0;
        int j = 0;
        boolean f = false;
        if (FieldName.compareToIgnoreCase("STATUS") == 0 && this.FMd5Error) {
            FieldValue = "[01]" + FieldValue;
        }
        String mFieldName = FieldName.trim().concat("=");
        String mFieldValue = this.EncodeBase64(FieldValue);
        mFieldText = mFieldName + mFieldValue + "\r\n";
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1 && (j = this.FMsgText.indexOf("\r\n", i + 1)) != -1) {
            mFieldHead = this.FMsgText.substring(0, i);
            mFieldNill = this.FMsgText.substring(j + 2);
            f = true;
        }
        this.FMsgText = f ? mFieldHead + mFieldText + mFieldNill : this.FMsgText.concat(mFieldText);
    }

    private boolean StreamToMsg() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position = 0;
        String Md5Value = "";
        String Md5Calcu = "";
        this.FMd5Error = false;
        try {
            Position = 0;
            String HeadString = new String(this.FStream, Position, HeadSize);
            this.FVersion = HeadString.substring(0, 15);
            BodySize = Integer.parseInt(HeadString.substring(16, 31).trim());
            ErrorSize = Integer.parseInt(HeadString.substring(32, 47).trim());
            this.FFileSize = FileSize = Integer.parseInt(HeadString.substring(48, 63).trim());
            Position += HeadSize;
            if (BodySize > 0) {
                this.FMsgText = new String(this.FStream, Position, BodySize);
            }
            Position += BodySize;
            if (ErrorSize > 0) {
                this.FError = new String(this.FStream, Position, ErrorSize);
            }
            Position += ErrorSize;
            this.FMsgFile = new byte[FileSize];
            if (FileSize > 0) {
                int i = 0;
                while (i < FileSize) {
                    this.FMsgFile[i] = this.FStream[i + Position];
                    ++i;
                }
                if (this.FStream.length >= (Position += FileSize) + 32) {
                    Md5Value = new String(this.FStream, Position, 32);
                    Md5Calcu = this.MD5Stream(this.FMsgFile);
                    System.out.println("From Client:" + Md5Value);
                    System.out.println("From Server:" + Md5Calcu);
                    if (Md5Value.compareToIgnoreCase(Md5Calcu) != 0) {
                        this.SetMsgByName("DBSTEP", "ERROR");
                        this.FMd5Error = true;
                    } else {
                        this.FMd5Error = false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
            return false;
        }
    }

    public byte[] ToDocument(byte[] Value) {
        byte[] mIntBuf = new byte[]{0, 0, 0, 0};
        byte[] mFlagBuf = new byte[]{68, 73, 82, 71};
        byte[] mOutBuf = null;
        int HeadFlag = 0;
        int Signature = 0;
        int WordSize = 0;
        int PageSize = 0;
        int FlagSize = 0;
        try {
            HeadFlag = iMsgServer2000.byteToInt(mFlagBuf);
            ByteArrayInputStream mStream = new ByteArrayInputStream(Value);
            mStream.read(mIntBuf, 0, 4);
            Signature = iMsgServer2000.byteToInt(mIntBuf);
            mStream.read(mIntBuf, 0, 4);
            WordSize = iMsgServer2000.byteToInt(mIntBuf);
            mStream.read(mIntBuf, 0, 4);
            PageSize = iMsgServer2000.byteToInt(mIntBuf);
            mStream.read(mIntBuf, 0, 4);
            FlagSize = iMsgServer2000.byteToInt(mIntBuf);
            if (Signature != HeadFlag) {
                mStream.reset();
                WordSize = mStream.available();
            }
            mOutBuf = new byte[WordSize];
            mStream.read(mOutBuf, 0, WordSize);
            return mOutBuf;
        }
        catch (Exception e) {
            this.FError = this.FError + e.toString();
            System.out.println(e.toString());
            return mOutBuf;
        }
    }

    public static String Version(String SoftwareName) {
        String mVersion = "0,0,0,0";
        if (SoftwareName.equalsIgnoreCase("HandWrite") || SoftwareName.equalsIgnoreCase("")) {
            mVersion = "4,0,0,8";
        }
        if (SoftwareName.equalsIgnoreCase("iWebSignature")) {
            mVersion = "5,8,0,0";
        }
        return mVersion;
    }

    public static String Version() {
        return "4,0,0,8";
    }

    public static String VersionEx(String SoftwareName) {
        String mVersionEx = "\u9519\u8bef\u7248\u672c";
        if (SoftwareName.equalsIgnoreCase("HandWrite") || SoftwareName.equalsIgnoreCase("")) {
            mVersionEx = "\u9ad8\u7ea7\u7248\u672c";
        }
        if (SoftwareName.equalsIgnoreCase("iWebSignature")) {
            mVersionEx = "\u6807\u51c6\u7248\u672c";
        }
        return mVersionEx;
    }

    public static String VersionEx() {
        return "\u9ad8\u7ea7\u7248\u672c";
    }

    private static long b2iu(byte b) {
        return b < 0 ? (long)(b & 0xFF) : (long)b;
    }

    private static String byteHEX(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    private static int byteToInt(byte[] b) {
        int s = 0;
        int i = 3;
        while (i > 0) {
            s = b[i] >= 0 ? (s += b[i]) : s + 256 + b[i];
            s *= 256;
            --i;
        }
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        return s;
    }

    private String getMD5ofStr(String inbuf) {
        this.md5Init();
        this.md5Update(inbuf.getBytes(), inbuf.length());
        this.md5Final();
        this.digestHexStr = "";
        int i = 0;
        while (i < 16) {
            this.digestHexStr = this.digestHexStr + iMsgServer2000.byteHEX(this.digest[i]);
            ++i;
        }
        return this.digestHexStr;
    }

    private void md5Final() {
        byte[] bits = new byte[8];
        this.Encode(bits, this.count, 8);
        int index = (int)(this.count[0] >>> 3) & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.md5Update(PADDING, padLen);
        this.md5Update(bits, 8);
        this.Encode(this.digest, this.state, 16);
    }

    private void md5Init() {
        this.count[0] = 0L;
        this.count[1] = 0L;
        this.state[0] = 1732584193L;
        this.state[1] = 4023233417L;
        this.state[2] = 2562383102L;
        this.state[3] = 271733878L;
    }

    private void md5Memcpy(byte[] output, byte[] input, int outpos, int inpos, int len) {
        int i = 0;
        while (i < len) {
            output[outpos + i] = input[inpos + i];
            ++i;
        }
    }

    private void md5Transform(byte[] block) {
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long[] x = new long[16];
        this.Decode(x, block, 64);
        a = this.FF(a, b, c, d, x[0], 7L, 3614090360L);
        d = this.FF(d, a, b, c, x[1], 12L, 3905402710L);
        c = this.FF(c, d, a, b, x[2], 17L, 606105819L);
        b = this.FF(b, c, d, a, x[3], 22L, 3250441966L);
        a = this.FF(a, b, c, d, x[4], 7L, 4118548399L);
        d = this.FF(d, a, b, c, x[5], 12L, 1200080426L);
        c = this.FF(c, d, a, b, x[6], 17L, 2821735955L);
        b = this.FF(b, c, d, a, x[7], 22L, 4249261313L);
        a = this.FF(a, b, c, d, x[8], 7L, 1770035416L);
        d = this.FF(d, a, b, c, x[9], 12L, 2336552879L);
        c = this.FF(c, d, a, b, x[10], 17L, 4294925233L);
        b = this.FF(b, c, d, a, x[11], 22L, 2304563134L);
        a = this.FF(a, b, c, d, x[12], 7L, 1804603682L);
        d = this.FF(d, a, b, c, x[13], 12L, 4254626195L);
        c = this.FF(c, d, a, b, x[14], 17L, 2792965006L);
        b = this.FF(b, c, d, a, x[15], 22L, 1236535329L);
        a = this.GG(a, b, c, d, x[1], 5L, 4129170786L);
        d = this.GG(d, a, b, c, x[6], 9L, 3225465664L);
        c = this.GG(c, d, a, b, x[11], 14L, 643717713L);
        b = this.GG(b, c, d, a, x[0], 20L, 3921069994L);
        a = this.GG(a, b, c, d, x[5], 5L, 3593408605L);
        d = this.GG(d, a, b, c, x[10], 9L, 38016083L);
        c = this.GG(c, d, a, b, x[15], 14L, 3634488961L);
        b = this.GG(b, c, d, a, x[4], 20L, 3889429448L);
        a = this.GG(a, b, c, d, x[9], 5L, 568446438L);
        d = this.GG(d, a, b, c, x[14], 9L, 3275163606L);
        c = this.GG(c, d, a, b, x[3], 14L, 4107603335L);
        b = this.GG(b, c, d, a, x[8], 20L, 1163531501L);
        a = this.GG(a, b, c, d, x[13], 5L, 2850285829L);
        d = this.GG(d, a, b, c, x[2], 9L, 4243563512L);
        c = this.GG(c, d, a, b, x[7], 14L, 1735328473L);
        b = this.GG(b, c, d, a, x[12], 20L, 2368359562L);
        a = this.HH(a, b, c, d, x[5], 4L, 4294588738L);
        d = this.HH(d, a, b, c, x[8], 11L, 2272392833L);
        c = this.HH(c, d, a, b, x[11], 16L, 1839030562L);
        b = this.HH(b, c, d, a, x[14], 23L, 4259657740L);
        a = this.HH(a, b, c, d, x[1], 4L, 2763975236L);
        d = this.HH(d, a, b, c, x[4], 11L, 1272893353L);
        c = this.HH(c, d, a, b, x[7], 16L, 4139469664L);
        b = this.HH(b, c, d, a, x[10], 23L, 3200236656L);
        a = this.HH(a, b, c, d, x[13], 4L, 681279174L);
        d = this.HH(d, a, b, c, x[0], 11L, 3936430074L);
        c = this.HH(c, d, a, b, x[3], 16L, 3572445317L);
        b = this.HH(b, c, d, a, x[6], 23L, 76029189L);
        a = this.HH(a, b, c, d, x[9], 4L, 3654602809L);
        d = this.HH(d, a, b, c, x[12], 11L, 3873151461L);
        c = this.HH(c, d, a, b, x[15], 16L, 530742520L);
        b = this.HH(b, c, d, a, x[2], 23L, 3299628645L);
        a = this.II(a, b, c, d, x[0], 6L, 4096336452L);
        d = this.II(d, a, b, c, x[7], 10L, 1126891415L);
        c = this.II(c, d, a, b, x[14], 15L, 2878612391L);
        b = this.II(b, c, d, a, x[5], 21L, 4237533241L);
        a = this.II(a, b, c, d, x[12], 6L, 1700485571L);
        d = this.II(d, a, b, c, x[3], 10L, 2399980690L);
        c = this.II(c, d, a, b, x[10], 15L, 4293915773L);
        b = this.II(b, c, d, a, x[1], 21L, 2240044497L);
        a = this.II(a, b, c, d, x[8], 6L, 1873313359L);
        d = this.II(d, a, b, c, x[15], 10L, 4264355552L);
        c = this.II(c, d, a, b, x[6], 15L, 2734768916L);
        b = this.II(b, c, d, a, x[13], 21L, 1309151649L);
        a = this.II(a, b, c, d, x[4], 6L, 4149444226L);
        d = this.II(d, a, b, c, x[11], 10L, 3174756917L);
        c = this.II(c, d, a, b, x[2], 15L, 718787259L);
        b = this.II(b, c, d, a, x[9], 21L, 3951481745L);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    private void md5Update(byte[] inbuf, int inputLen) {
        int i;
        byte[] block = new byte[64];
        int index = (int)(this.count[0] >>> 3) & 0x3F;
        this.count[0] = this.count[0] + (long)(inputLen << 3);
        if (this.count[0] < (long)(inputLen << 3)) {
            this.count[1] = this.count[1] + 1L;
        }
        this.count[1] = this.count[1] + (long)(inputLen >>> 29);
        int partLen = 64 - index;
        if (inputLen >= partLen) {
            this.md5Memcpy(this.buffer, inbuf, index, 0, partLen);
            this.md5Transform(this.buffer);
            i = partLen;
            while (i + 63 < inputLen) {
                this.md5Memcpy(block, inbuf, 0, i, 64);
                this.md5Transform(block);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        this.md5Memcpy(this.buffer, inbuf, index, i, inputLen - i);
    }
}

