/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import sun.misc.MessageUtils;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static Object deref(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static void set(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference<Object>(object));
    }

    private static byte[] safeTrim(byte[] byArray, int n, Charset charset) {
        if (n == byArray.length && (System.getSecurityManager() == null || charset.getClass().getClassLoader0() == null)) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n);
    }

    private static char[] safeTrim(char[] cArray, int n, Charset charset) {
        if (n == cArray.length && (System.getSecurityManager() == null || charset.getClass().getClassLoader0() == null)) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n);
    }

    private static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    private static Charset lookupCharset(String string) {
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            MessageUtils.err("WARNING: Default charset " + string + " not supported, using ISO-8859-1 instead");
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    stringDecoder = new StringDecoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringDecoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static char[] decode(Charset charset, byte[] byArray, int n, int n2) {
        StringDecoder stringDecoder = new StringDecoder(charset, charset.name());
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        return stringDecoder.decode(byArray2, n, n2);
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        String string = Charset.defaultCharset().name();
        try {
            return StringCoding.decode(string, byArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.decode("ISO-8859-1", byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    stringEncoder = new StringEncoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringEncoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(cArray, n, n2);
    }

    static byte[] encode(Charset charset, char[] cArray, int n, int n2) {
        StringEncoder stringEncoder = new StringEncoder(charset, charset.name());
        char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
        return stringEncoder.encode(cArray2, n, n2);
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        String string = Charset.defaultCharset().name();
        try {
            return StringCoding.encode(string, cArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.encode("ISO-8859-1", cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final String requestedCharsetName;

        private StringEncoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.ce.maxBytesPerChar());
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(byArray, byteBuffer.position(), this.cs);
        }
    }

    private static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final CharsetDecoder cd;

        private StringDecoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = StringCoding.scale(n2, this.cd.maxCharsPerByte());
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(cArray, charBuffer.position(), this.cs);
        }
    }
}

