/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private final Comparator<? super K> comparator;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet = null;
    private transient KeySet<K> navigableKeySet = null;
    private transient NavigableMap<K, V> descendingMap = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        this.comparator = null;
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            if (TreeMap.valEquals(object, entry.value)) {
                return true;
            }
            entry = TreeMap.successor(entry);
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return TreeMap.key(this.getFirstEntry());
    }

    @Override
    public K lastKey() {
        return TreeMap.key(this.getLastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n = map.size();
        if (this.size == 0 && n != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && ((Object)comparator).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    final Entry<K, V> getEntry(Object object) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(object);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        Comparable comparable = (Comparable)object;
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = comparable.compareTo(entry.key);
            if (n < 0) {
                entry = entry.left;
                continue;
            }
            if (n > 0) {
                entry = entry.right;
                continue;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getEntryUsingComparator(Object object) {
        Object object2 = object;
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            Entry<K, V> entry = this.root;
            while (entry != null) {
                int n = comparator.compare(object2, entry.key);
                if (n < 0) {
                    entry = entry.left;
                    continue;
                }
                if (n > 0) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
        }
        return null;
    }

    final Entry<K, V> getCeilingEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.right) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getFloorEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.left) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getHigherEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right != null) {
                entry = entry.right;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.right) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    final Entry<K, V> getLowerEntry(K k) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n = this.compare(k, entry.key);
            if (n > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left != null) {
                entry = entry.left;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.left) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Object object;
        int n;
        Entry<K, V> entry;
        Entry<K, V> entry2 = this.root;
        if (entry2 == null) {
            this.root = new Entry<K, V>(k, v, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            do {
                entry = entry2;
                n = comparator.compare(k, entry2.key);
                if (n < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        } else {
            if (k == null) {
                throw new NullPointerException();
            }
            object = (Comparable)k;
            do {
                entry = entry2;
                n = object.compareTo(entry2.key);
                if (n < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        }
        object = new Entry<K, V>(k, v, entry);
        if (n < 0) {
            entry.left = object;
        } else {
            entry.right = object;
        }
        this.fixAfterInsertion((Entry<K, V>)object);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object v = entry.value;
        this.deleteEntry(entry);
        return v;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        treeMap.navigableKeySet = null;
        treeMap.descendingMap = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return TreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return TreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> entry = this.getFirstEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> entry = this.getLastEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        return TreeMap.exportEntry(this.getLowerEntry(k));
    }

    @Override
    public K lowerKey(K k) {
        return TreeMap.keyOrNull(this.getLowerEntry(k));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        return TreeMap.exportEntry(this.getFloorEntry(k));
    }

    @Override
    public K floorKey(K k) {
        return TreeMap.keyOrNull(this.getFloorEntry(k));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        return TreeMap.exportEntry(this.getCeilingEntry(k));
    }

    @Override
    public K ceilingKey(K k) {
        return TreeMap.keyOrNull(this.getCeilingEntry(k));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        return TreeMap.exportEntry(this.getHigherEntry(k));
    }

    @Override
    public K higherKey(K k) {
        return TreeMap.keyOrNull(this.getHigherEntry(k));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> keySet = this.navigableKeySet;
        return keySet != null ? keySet : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> navigableMap = this.descendingMap;
        return navigableMap != null ? navigableMap : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        return new AscendingSubMap(this, false, k, bl, false, k2, bl2);
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        return new AscendingSubMap(this, true, null, true, false, k, bl);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        return new AscendingSubMap(this, false, k, bl, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return this.headMap(k, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return this.tailMap(k, true);
    }

    Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    static final boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    static <K, V> K keyOrNull(Entry<K, V> entry) {
        return entry == null ? null : (K)entry.key;
    }

    static <K> K key(Entry<K, ?> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    final Entry<K, V> getFirstEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    final Entry<K, V> getLastEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            Entry entry2 = entry.left;
            while (entry2.right != null) {
                entry2 = entry2.right;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.left) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        return entry == null ? true : entry.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        return entry == null ? null : entry.parent;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        return entry == null ? null : entry.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        return entry == null ? null : entry.right;
    }

    private void rotateLeft(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.right;
            entry.right = entry2.left;
            if (entry2.left != null) {
                entry2.left.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.left == entry) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry2.left = entry;
            entry.parent = entry2;
        }
    }

    private void rotateRight(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.left;
            entry.left = entry2.right;
            if (entry2.right != null) {
                entry2.right.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.right == entry) {
                entry.parent.right = entry2;
            } else {
                entry.parent.left = entry2;
            }
            entry2.right = entry;
            entry.parent = entry2;
        }
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry<K, V> entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry<K, V> entry2;
        ++this.modCount;
        --this.size;
        if (entry.left != null && entry.right != null) {
            entry2 = TreeMap.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry<K, V> entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.size = n;
        this.root = this.buildFromSorted(0, 0, n - 1, TreeMap.computeRedLevel(n), iterator, objectInputStream, v);
    }

    private final Entry<K, V> buildFromSorted(int n, int n2, int n3, int n4, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        V v2;
        Object object;
        Entry<Object, V> entry;
        if (n3 < n2) {
            return null;
        }
        int n5 = (n2 + n3) / 2;
        Entry<K, V> entry2 = null;
        if (n2 < n5) {
            entry2 = this.buildFromSorted(n + 1, n2, n5 - 1, n4, iterator, objectInputStream, v);
        }
        if (iterator != null) {
            if (v == null) {
                entry = (Entry<Object, V>)iterator.next();
                object = entry.getKey();
                v2 = entry.getValue();
            } else {
                object = iterator.next();
                v2 = v;
            }
        } else {
            object = objectInputStream.readObject();
            v2 = v != null ? v : objectInputStream.readObject();
        }
        entry = new Entry<Object, V>(object, v2, null);
        if (n == n4) {
            entry.color = false;
        }
        if (entry2 != null) {
            entry.left = entry2;
            entry2.parent = entry;
        }
        if (n5 < n3) {
            Entry<K, V> entry3 = this.buildFromSorted(n + 1, n5 + 1, n3, n4, iterator, objectInputStream, v);
            entry.right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            ++n2;
            n3 = n3 / 2 - 1;
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> left = null;
        Entry<K, V> right = null;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K k, V v, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.parent = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return TreeMap.valEquals(this.key, entry.getKey()) && TreeMap.valEquals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;

        private SubMap() {
        }

        private Object readResolve() {
            return new AscendingSubMap(TreeMap.this, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new InternalError();
        }

        @Override
        public K lastKey() {
            throw new InternalError();
        }

        @Override
        public K firstKey() {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            throw new InternalError();
        }

        @Override
        public Comparator<? super K> comparator() {
            throw new InternalError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, k2, bl2, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap ascendingSubMap = this.descendingMapView;
            return ascendingSubMap != null ? ascendingSubMap : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new DescendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            return this.absLower(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            return this.absHigher(k);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, k, bl, false, k2, bl2);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap descendingSubMap = this.descendingMapView;
            return descendingSubMap != null ? descendingSubMap : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new AscendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            return this.absHigher(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            return this.absLower(k);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView = null;
        transient EntrySetView entrySetView = null;
        transient KeySet<K> navigableKeySetView = null;

        NavigableSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            if (!bl && !bl3) {
                if (treeMap.compare(k, k2) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!bl) {
                    treeMap.compare(k, k);
                }
                if (!bl3) {
                    treeMap.compare(k2, k2);
                }
            }
            this.m = treeMap;
            this.fromStart = bl;
            this.lo = k;
            this.loInclusive = bl2;
            this.toEnd = bl3;
            this.hi = k2;
            this.hiInclusive = bl4;
        }

        final boolean tooLow(Object object) {
            int n;
            return !this.fromStart && ((n = this.m.compare(object, this.lo)) < 0 || n == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object object) {
            int n;
            return !this.toEnd && ((n = this.m.compare(object, this.hi)) > 0 || n == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object object) {
            return !this.tooLow(object) && !this.tooHigh(object);
        }

        final boolean inClosedRange(Object object) {
            return !(!this.fromStart && this.m.compare(object, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, object) < 0);
        }

        final boolean inRange(Object object, boolean bl) {
            return bl ? this.inRange(object) : this.inClosedRange(object);
        }

        final Entry<K, V> absLowest() {
            Entry<K, V> entry = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        final Entry<K, V> absHighest() {
            Entry<K, V> entry = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        final Entry<K, V> absCeiling(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Entry<K, V> entry = this.m.getCeilingEntry(k);
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        final Entry<K, V> absHigher(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Entry<K, V> entry = this.m.getHigherEntry(k);
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        final Entry<K, V> absFloor(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Entry<K, V> entry = this.m.getFloorEntry(k);
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        final Entry<K, V> absLower(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Entry<K, V> entry = this.m.getLowerEntry(k);
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        final Entry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        final Entry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        abstract Entry<K, V> subLowest();

        abstract Entry<K, V> subHighest();

        abstract Entry<K, V> subCeiling(K var1);

        abstract Entry<K, V> subHigher(K var1);

        abstract Entry<K, V> subFloor(K var1);

        abstract Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.inRange(object) && this.m.containsKey(object);
        }

        @Override
        public final V put(K k, V v) {
            if (!this.inRange(k)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(k, v);
        }

        @Override
        public final V get(Object object) {
            return !this.inRange(object) ? null : (V)this.m.get(object);
        }

        @Override
        public final V remove(Object object) {
            return !this.inRange(object) ? null : (V)this.m.remove(object);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K k) {
            return TreeMap.exportEntry(this.subCeiling(k));
        }

        @Override
        public final K ceilingKey(K k) {
            return TreeMap.keyOrNull(this.subCeiling(k));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K k) {
            return TreeMap.exportEntry(this.subHigher(k));
        }

        @Override
        public final K higherKey(K k) {
            return TreeMap.keyOrNull(this.subHigher(k));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K k) {
            return TreeMap.exportEntry(this.subFloor(k));
        }

        @Override
        public final K floorKey(K k) {
            return TreeMap.keyOrNull(this.subFloor(k));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K k) {
            return TreeMap.exportEntry(this.subLower(k));
        }

        @Override
        public final K lowerKey(K k) {
            return TreeMap.keyOrNull(this.subLower(k));
        }

        @Override
        public final K firstKey() {
            return TreeMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return TreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return TreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return TreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> entry = this.subLowest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                ((TreeMap)this.m).deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> entry = this.subHighest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                ((TreeMap)this.m).deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> keySet = this.navigableKeySetView;
            return keySet != null ? keySet : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K> {
            DescendingSubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapKeyIterator
        extends SubMapIterator<K> {
            SubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class SubMapIterator<T>
        implements Iterator<T> {
            Entry<K, V> lastReturned;
            Entry<K, V> next;
            final K fenceKey;
            int expectedModCount;

            SubMapIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = entry;
                this.fenceKey = entry2 == null ? null : entry2.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            final Entry<K, V> nextEntry() {
                Entry entry = this.next;
                if (entry == null || entry.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.successor(entry);
                this.lastReturned = entry;
                return entry;
            }

            final Entry<K, V> prevEntry() {
                Entry entry = this.next;
                if (entry == null || entry.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.predecessor(entry);
                this.lastReturned = entry;
                return entry;
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                Entry entry = NavigableSubMap.this.absLowest();
                return entry == null || NavigableSubMap.this.tooHigh(entry.key);
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!NavigableSubMap.this.inRange(k)) {
                    return false;
                }
                Entry entry2 = NavigableSubMap.this.m.getEntry(k);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!NavigableSubMap.this.inRange(k)) {
                    return false;
                }
                Entry entry2 = NavigableSubMap.this.m.getEntry(k);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(entry2);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        Entry<K, V> next;
        Entry<K, V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(Entry<K, V> entry) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.successor(entry);
            this.lastReturned = entry;
            return entry;
        }

        final Entry<K, V> prevEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.predecessor(entry);
            this.lastReturned = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> navigableMap) {
            this.m = navigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            this.m.remove(object);
            return this.size() != n;
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return new TreeSet<E>(this.m.subMap(e, bl, e2, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return new TreeSet<E>(this.m.headMap(e, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return new TreeSet<E>(this.m.tailMap(e, bl));
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return this.subSet(e, true, e2, false);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return this.headSet(e, false);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return this.tailSet(e, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new TreeSet<E>(this.m.descendingMap());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(TreeMap.this.getFirstEntry());
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = entry.getValue();
            Entry entry2 = TreeMap.this.getEntry(entry.getKey());
            return entry2 != null && TreeMap.valEquals(entry2.getValue(), v);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = entry.getValue();
            Entry entry2 = TreeMap.this.getEntry(entry.getKey());
            if (entry2 != null && TreeMap.valEquals(entry2.getValue(), v)) {
                TreeMap.this.deleteEntry(entry2);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(TreeMap.this.getFirstEntry());
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return TreeMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Entry entry = TreeMap.this.getFirstEntry();
            while (entry != null) {
                if (TreeMap.valEquals(entry.getValue(), object)) {
                    TreeMap.this.deleteEntry(entry);
                    return true;
                }
                entry = TreeMap.successor(entry);
            }
            return false;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }
    }
}

