/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.ConfigurationSpi;
import sun.security.jca.GetInstance;

public abstract class Configuration {
    private static Configuration configuration;
    private static ClassLoader contextClassLoader;

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("createLoginConfiguration." + string));
        }
    }

    protected Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (configuration == null) {
                String string = null;
                string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("login.configuration.provider");
                    }
                });
                if (string == null) {
                    string = "com.sun.security.auth.login.ConfigFile";
                }
                try {
                    final String string2 = string;
                    configuration = (Configuration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                            return Class.forName(string2, true, contextClassLoader).newInstance();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof InstantiationException) {
                        throw (SecurityException)new SecurityException("Configuration error:" + exception.getCause().getMessage() + "\n").initCause(exception.getCause());
                    }
                    throw (SecurityException)new SecurityException("Configuration error: " + exception.toString() + "\n").initCause(exception);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configuration;
        }
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.configuration = configuration;
    }

    public static Configuration getInstance(String string, Parameters parameters) throws NoSuchAlgorithmException {
        Configuration.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, string, parameters);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Configuration.handleException(noSuchAlgorithmException);
        }
    }

    public static Configuration getInstance(String string, Parameters parameters, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Configuration.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, string, (Object)parameters, string2);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Configuration.handleException(noSuchAlgorithmException);
        }
    }

    public static Configuration getInstance(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Configuration.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Configuration", ConfigurationSpi.class, string, (Object)parameters, provider);
            return new ConfigDelegate((ConfigurationSpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Configuration.handleException(noSuchAlgorithmException);
        }
    }

    private static Configuration handleException(NoSuchAlgorithmException noSuchAlgorithmException) throws NoSuchAlgorithmException {
        Throwable throwable = noSuchAlgorithmException.getCause();
        if (throwable instanceof IllegalArgumentException) {
            throw (IllegalArgumentException)throwable;
        }
        throw noSuchAlgorithmException;
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public void refresh() {
    }

    static {
        contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static interface Parameters {
    }

    private static class ConfigDelegate
    extends Configuration {
        private ConfigurationSpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private ConfigDelegate(ConfigurationSpi configurationSpi, Provider provider, String string, Parameters parameters) {
            this.spi = configurationSpi;
            this.p = provider;
            this.type = string;
            this.params = parameters;
        }

        public String getType() {
            return this.type;
        }

        public Parameters getParameters() {
            return this.params;
        }

        public Provider getProvider() {
            return this.p;
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
            return this.spi.engineGetAppConfigurationEntry(string);
        }

        public void refresh() {
            this.spi.engineRefresh();
        }
    }
}

