/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.Position;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicListUI
extends ListUI {
    private static final Object BASELINE_COMPONENT_KEY = new Object();
    protected JList list = null;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    private int listHeight;
    private int listWidth;
    private int layoutOrientation;
    private int columnCount;
    private int preferredHeight;
    private int rowsPerColumn;
    private long timeFactor = 1000L;
    private boolean isFileList = false;
    private boolean isLeftToRight = true;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;
    private static final int componentOrientationChanged = 1024;
    private static final int DROP_LINE_THICKNESS = 2;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;
    private static final TransferHandler defaultTransferHandler = new ListTransferHandler();

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPreviousColumn"));
        lazyActionMap.put(new Actions("selectPreviousColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousColumnChangeLead"));
        lazyActionMap.put(new Actions("selectNextColumn"));
        lazyActionMap.put(new Actions("selectNextColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectNextColumnChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousRow"));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead"));
        lazyActionMap.put(new Actions("selectNextRow"));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection"));
        lazyActionMap.put(new Actions("selectNextRowChangeLead"));
        lazyActionMap.put(new Actions("selectFirstRow"));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection"));
        lazyActionMap.put(new Actions("selectFirstRowChangeLead"));
        lazyActionMap.put(new Actions("selectLastRow"));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection"));
        lazyActionMap.put(new Actions("selectLastRowChangeLead"));
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
        lazyActionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        lazyActionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        lazyActionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (this.isFileList) {
            int n7 = Math.min(n5, component.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                n3 += n5 - n7;
            }
            n5 = n7;
        }
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Shape shape = graphics.getClip();
        this.paintImpl(graphics, jComponent);
        graphics.setClip(shape);
        this.paintDropLine(graphics);
    }

    private void paintImpl(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        int n3;
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || (n3 = listModel.getSize()) == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            n2 = this.convertLocationToColumn(rectangle.x, rectangle.y);
            n = this.convertLocationToColumn(rectangle.x + rectangle.width, rectangle.y);
        } else {
            n2 = this.convertLocationToColumn(rectangle.x + rectangle.width, rectangle.y);
            n = this.convertLocationToColumn(rectangle.x, rectangle.y);
        }
        int n4 = rectangle.y + rectangle.height;
        int n5 = BasicListUI.adjustIndex(this.list.getLeadSelectionIndex(), this.list);
        int n6 = this.layoutOrientation == 2 ? this.columnCount : 1;
        for (int i = n2; i <= n; ++i) {
            int n7;
            int n8 = this.getRowCount(i);
            int n9 = this.getModelIndex(i, n7);
            Rectangle rectangle2 = this.getCellBounds(this.list, n9, n9);
            if (rectangle2 == null) {
                return;
            }
            for (n7 = this.convertLocationToRowInColumn(rectangle.y, i); n7 < n8 && rectangle2.y < n4 && n9 < n3; n9 += n6, ++n7) {
                rectangle2.height = this.getHeight(i, n7);
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.paintCell(graphics, n9, rectangle2, listCellRenderer, listModel, listSelectionModel, n5);
                rectangle2.y += rectangle2.height;
            }
        }
        this.rendererPane.removeAll();
    }

    private void paintDropLine(Graphics graphics) {
        JList.DropLocation dropLocation = this.list.getDropLocation();
        if (dropLocation == null || !dropLocation.isInsert()) {
            return;
        }
        Color color = DefaultLookup.getColor(this.list, this, "List.dropLineColor", null);
        if (color != null) {
            graphics.setColor(color);
            Rectangle rectangle = this.getDropLineRect(dropLocation);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private Rectangle getDropLineRect(JList.DropLocation dropLocation) {
        int n = this.list.getModel().getSize();
        if (n == 0) {
            Insets insets = this.list.getInsets();
            if (this.layoutOrientation == 2) {
                if (this.isLeftToRight) {
                    return new Rectangle(insets.left, insets.top, 2, 20);
                }
                return new Rectangle(this.list.getWidth() - 2 - insets.right, insets.top, 2, 20);
            }
            return new Rectangle(insets.left, insets.top, this.list.getWidth() - insets.left - insets.right, 2);
        }
        Rectangle rectangle = null;
        int n2 = dropLocation.getIndex();
        boolean bl = false;
        if (this.layoutOrientation == 2) {
            if (n2 == n) {
                bl = true;
            } else if (n2 != 0 && this.convertModelToRow(n2) != this.convertModelToRow(n2 - 1)) {
                Rectangle rectangle2 = this.getCellBounds(this.list, n2 - 1);
                Rectangle rectangle3 = this.getCellBounds(this.list, n2);
                Point point = dropLocation.getDropPoint();
                if (this.isLeftToRight) {
                    bl = Point2D.distance(rectangle2.x + rectangle2.width, rectangle2.y + (int)((double)rectangle2.height / 2.0), point.x, point.y) < Point2D.distance(rectangle3.x, rectangle3.y + (int)((double)rectangle3.height / 2.0), point.x, point.y);
                } else {
                    boolean bl2 = bl = Point2D.distance(rectangle2.x, rectangle2.y + (int)((double)rectangle2.height / 2.0), point.x, point.y) < Point2D.distance(rectangle3.x + rectangle3.width, rectangle3.y + (int)((double)rectangle2.height / 2.0), point.x, point.y);
                }
            }
            if (bl) {
                rectangle = this.getCellBounds(this.list, --n2);
                rectangle.x = this.isLeftToRight ? (rectangle.x += rectangle.width) : (rectangle.x -= 2);
            } else {
                rectangle = this.getCellBounds(this.list, n2);
                if (!this.isLeftToRight) {
                    rectangle.x += rectangle.width - 2;
                }
            }
            if (rectangle.x >= this.list.getWidth()) {
                rectangle.x = this.list.getWidth() - 2;
            } else if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            rectangle.width = 2;
        } else if (this.layoutOrientation == 1) {
            if (n2 == n) {
                rectangle = this.getCellBounds(this.list, --n2);
                rectangle.y += rectangle.height;
            } else if (n2 != 0 && this.convertModelToColumn(n2) != this.convertModelToColumn(n2 - 1)) {
                Rectangle rectangle4 = this.getCellBounds(this.list, n2 - 1);
                Rectangle rectangle5 = this.getCellBounds(this.list, n2);
                Point point = dropLocation.getDropPoint();
                if (Point2D.distance(rectangle4.x + (int)((double)rectangle4.width / 2.0), rectangle4.y + rectangle4.height, point.x, point.y) < Point2D.distance(rectangle5.x + (int)((double)rectangle5.width / 2.0), rectangle5.y, point.x, point.y)) {
                    rectangle = this.getCellBounds(this.list, --n2);
                    rectangle.y += rectangle.height;
                } else {
                    rectangle = this.getCellBounds(this.list, n2);
                }
            } else {
                rectangle = this.getCellBounds(this.list, n2);
            }
            if (rectangle.y >= this.list.getHeight()) {
                rectangle.y = this.list.getHeight() - 2;
            }
            rectangle.height = 2;
        } else {
            if (n2 == n) {
                rectangle = this.getCellBounds(this.list, --n2);
                rectangle.y += rectangle.height;
            } else {
                rectangle = this.getCellBounds(this.list, n2);
            }
            if (rectangle.y >= this.list.getHeight()) {
                rectangle.y = this.list.getHeight() - 2;
            }
            rectangle.height = 2;
        }
        return rectangle;
    }

    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        int n3 = this.list.getFixedCellHeight();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Component component = (Component)uIDefaults.get(BASELINE_COMPONENT_KEY);
        if (component == null) {
            ListCellRenderer listCellRenderer = (ListCellRenderer)UIManager.get("List.cellRenderer");
            if (listCellRenderer == null) {
                listCellRenderer = new DefaultListCellRenderer();
            }
            component = listCellRenderer.getListCellRendererComponent(this.list, "a", -1, false, false);
            uIDefaults.put(BASELINE_COMPONENT_KEY, component);
        }
        component.setFont(this.list.getFont());
        if (n3 == -1) {
            n3 = component.getPreferredSize().height;
        }
        return component.getBaseline(Integer.MAX_VALUE, n3) + this.list.getInsets().top;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth * this.columnCount + insets.left + insets.right;
        int n3 = this.layoutOrientation != 0 ? this.preferredHeight : ((rectangle = this.getCellBounds(this.list, n)) != null ? rectangle.y + rectangle.height + insets.bottom : 0);
        return new Dimension(n2, n3);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.list, BasicListUI.class, "List.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.list, this, "List.focusInputMap");
            if (this.isLeftToRight || (inputMap = (InputMap)DefaultLookup.get(this.list, this, "List.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
    }

    protected void installListeners() {
        ListSelectionModel listSelectionModel;
        TransferHandler transferHandler = this.list.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.list.setTransferHandler(defaultTransferHandler);
            if (this.list.getDropTarget() instanceof UIResource) {
                this.list.setDropTarget(null);
            }
        }
        this.focusListener = this.createFocusListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.list.addFocusListener(this.focusListener);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.addKeyListener(this.getHandler());
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionListener);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeFocusListener(this.focusListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.removeKeyListener(this.getHandler());
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        }
        this.focusListener = null;
        this.mouseInputListener = null;
        this.listSelectionListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void installDefaults() {
        Long l;
        Color color;
        Color color2;
        this.list.setLayout(null);
        LookAndFeel.installBorder(this.list, "List.border");
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        LookAndFeel.installProperty(this.list, "opaque", Boolean.TRUE);
        if (this.list.getCellRenderer() == null) {
            this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
        if ((color2 = this.list.getSelectionBackground()) == null || color2 instanceof UIResource) {
            this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        }
        if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
            this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
        this.timeFactor = (l = (Long)UIManager.get("List.timeFactor")) != null ? l : 1000L;
        this.updateIsFileList();
    }

    private void updateIsFileList() {
        boolean bl = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        if (bl != this.isFileList) {
            Font font;
            this.isFileList = bl;
            Font font2 = this.list.getFont();
            if ((font2 == null || font2 instanceof UIResource) && (font = UIManager.getFont(bl ? "FileChooser.listFont" : "List.font")) != null && font != font2) {
                this.list.setFont(font);
            }
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.list);
        if (this.list.getFont() instanceof UIResource) {
            this.list.setFont(null);
        }
        if (this.list.getForeground() instanceof UIResource) {
            this.list.setForeground(null);
        }
        if (this.list.getBackground() instanceof UIResource) {
            this.list.setBackground(null);
        }
        if (this.list.getSelectionBackground() instanceof UIResource) {
            this.list.setSelectionBackground(null);
        }
        if (this.list.getSelectionForeground() instanceof UIResource) {
            this.list.setSelectionForeground(null);
        }
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
        if (this.list.getTransferHandler() instanceof UIResource) {
            this.list.setTransferHandler(null);
        }
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.layoutOrientation = this.list.getLayoutOrientation();
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
        this.columnCount = 1;
        this.updateLayoutStateNeeded = 1;
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.listHeight = -1;
        this.listWidth = -1;
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        this.list = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertLocationToModel(point.x, point.y);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n, n);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (n3 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n3);
        if (rectangle == null) {
            return null;
        }
        if (n3 == n4) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n4);
        if (rectangle2 != null) {
            if (this.layoutOrientation == 2) {
                int n5;
                int n6 = this.convertModelToRow(n3);
                if (n6 != (n5 = this.convertModelToRow(n4))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    private Rectangle getCellBounds(JList jList, int n) {
        int n2;
        int n3;
        this.maybeUpdateLayoutState();
        int n4 = this.convertModelToRow(n);
        int n5 = this.convertModelToColumn(n);
        if (n4 == -1 || n5 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n6 = this.cellWidth;
        int n7 = insets.top;
        switch (this.layoutOrientation) {
            case 1: 
            case 2: {
                n3 = this.isLeftToRight ? insets.left + n5 * this.cellWidth : jList.getWidth() - insets.right - (n5 + 1) * this.cellWidth;
                n7 += this.cellHeight * n4;
                n2 = this.cellHeight;
                break;
            }
            default: {
                n3 = insets.left;
                if (this.cellHeights == null) {
                    n7 += this.cellHeight * n4;
                } else if (n4 >= this.cellHeights.length) {
                    n7 = 0;
                } else {
                    for (int i = 0; i < n4; ++i) {
                        n7 += this.cellHeights[i];
                    }
                }
                n6 = jList.getWidth() - (insets.left + insets.right);
                n2 = this.getRowHeight(n);
            }
        }
        return new Rectangle(n3, n7, n6, n2);
    }

    protected int getRowHeight(int n) {
        return this.getHeight(0, n);
    }

    protected int convertYToRow(int n) {
        return this.convertLocationToRow(0, n, false);
    }

    protected int convertRowToY(int n) {
        if (n >= this.getRowCount(0) || n < 0) {
            return -1;
        }
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        return rectangle.y;
    }

    private int getHeight(int n, int n2) {
        if (n < 0 || n > this.columnCount || n2 < 0) {
            return -1;
        }
        if (this.layoutOrientation != 0) {
            return this.cellHeight;
        }
        if (n2 >= this.list.getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (n2 < this.cellHeights.length ? this.cellHeights[n2] : -1);
    }

    private int convertLocationToRow(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.list.getModel().getSize();
        if (n4 <= 0) {
            return -1;
        }
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int n5;
            int n6 = n5 = this.cellHeight == 0 ? 0 : (n2 - insets.top) / this.cellHeight;
            if (bl) {
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 >= n4) {
                    n5 = n4 - 1;
                }
            }
            return n5;
        }
        if (n4 > this.cellHeights.length) {
            return -1;
        }
        int n7 = insets.top;
        int n8 = 0;
        if (bl && n2 < n7) {
            return 0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (n2 >= n7 && n2 < n7 + this.cellHeights[n3]) {
                return n8;
            }
            n7 += this.cellHeights[n3];
            ++n8;
        }
        return n3 - 1;
    }

    private int convertLocationToRowInColumn(int n, int n2) {
        int n3 = 0;
        if (this.layoutOrientation != 0) {
            n3 = this.isLeftToRight ? n2 * this.cellWidth : this.list.getWidth() - (n2 + 1) * this.cellWidth - this.list.getInsets().right;
        }
        return this.convertLocationToRow(n3, n, true);
    }

    private int convertLocationToModel(int n, int n2) {
        int n3 = this.convertLocationToRow(n, n2, true);
        int n4 = this.convertLocationToColumn(n, n2);
        if (n3 >= 0 && n4 >= 0) {
            return this.getModelIndex(n4, n3);
        }
        return -1;
    }

    private int getRowCount(int n) {
        if (n < 0 || n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 0 || n == 0 && this.columnCount == 1) {
            return this.list.getModel().getSize();
        }
        if (n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 1) {
            if (n < this.columnCount - 1) {
                return this.rowsPerColumn;
            }
            return this.list.getModel().getSize() - (this.columnCount - 1) * this.rowsPerColumn;
        }
        int n2 = this.columnCount - (this.columnCount * this.rowsPerColumn - this.list.getModel().getSize());
        if (n >= n2) {
            return Math.max(0, this.rowsPerColumn - 1);
        }
        return this.rowsPerColumn;
    }

    private int getModelIndex(int n, int n2) {
        switch (this.layoutOrientation) {
            case 1: {
                return Math.min(this.list.getModel().getSize() - 1, this.rowsPerColumn * n + Math.min(n2, this.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(this.list.getModel().getSize() - 1, n2 * this.columnCount + n);
            }
        }
        return n2;
    }

    private int convertLocationToColumn(int n, int n2) {
        if (this.cellWidth > 0) {
            if (this.layoutOrientation == 0) {
                return 0;
            }
            Insets insets = this.list.getInsets();
            int n3 = this.isLeftToRight ? (n - insets.left) / this.cellWidth : (this.list.getWidth() - n - insets.right - 1) / this.cellWidth;
            if (n3 < 0) {
                return 0;
            }
            if (n3 >= this.columnCount) {
                return this.columnCount - 1;
            }
            return n3;
        }
        return 0;
    }

    private int convertModelToRow(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.columnCount > 1 && this.rowsPerColumn > 0) {
            if (this.layoutOrientation == 1) {
                return n % this.rowsPerColumn;
            }
            return n / this.columnCount;
        }
        return n;
    }

    private int convertModelToColumn(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.rowsPerColumn > 0 && this.columnCount > 1) {
            if (this.layoutOrientation == 1) {
                return n / this.rowsPerColumn;
            }
            return n % this.columnCount;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                for (int i = 0; i < n4; ++i) {
                    Object object = listModel.getElementAt(i);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, i, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n != -1) continue;
                    this.cellHeights[i] = dimension.height;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[n4];
                }
                for (int i = 0; i < n4; ++i) {
                    this.cellHeights[i] = 0;
                }
            }
        }
        this.columnCount = 1;
        if (this.layoutOrientation != 0) {
            this.updateHorizontalLayoutState(n2, n);
        }
    }

    private void updateHorizontalLayoutState(int n, int n2) {
        int n3;
        int n4 = this.list.getVisibleRowCount();
        int n5 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        this.listHeight = this.list.getHeight();
        this.listWidth = this.list.getWidth();
        if (n5 == 0) {
            this.columnCount = 0;
            this.rowsPerColumn = 0;
            this.preferredHeight = insets.top + insets.bottom;
            return;
        }
        if (n2 != -1) {
            n3 = n2;
        } else {
            int n6 = 0;
            if (this.cellHeights.length > 0) {
                n6 = this.cellHeights[this.cellHeights.length - 1];
                for (int i = this.cellHeights.length - 2; i >= 0; --i) {
                    n6 = Math.max(n6, this.cellHeights[i]);
                }
            }
            n3 = this.cellHeight = n6;
            this.cellHeights = null;
        }
        this.rowsPerColumn = n5;
        if (n4 > 0) {
            this.rowsPerColumn = n4;
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
            if (this.layoutOrientation == 2) {
                this.rowsPerColumn = n5 / this.columnCount;
                if (n5 % this.columnCount > 0) {
                    ++this.rowsPerColumn;
                }
            }
        } else if (this.layoutOrientation == 1 && n3 != 0) {
            this.rowsPerColumn = Math.max(1, (this.listHeight - insets.top - insets.bottom) / n3);
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
        } else if (this.layoutOrientation == 2 && this.cellWidth > 0 && this.listWidth > 0) {
            this.columnCount = Math.max(1, (this.listWidth - insets.left - insets.right) / this.cellWidth);
            this.rowsPerColumn = n5 / this.columnCount;
            if (n5 % this.columnCount > 0) {
                ++this.rowsPerColumn;
            }
        }
        this.preferredHeight = this.rowsPerColumn * this.cellHeight + insets.top + insets.bottom;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseInputListener createMouseInputListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return this.getHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private static int adjustIndex(int n, JList jList) {
        return n < jList.getModel().getSize() ? n : -1;
    }

    static class ListTransferHandler
    extends TransferHandler
    implements UIResource {
        ListTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JList) {
                JList jList = (JList)jComponent;
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray == null || objectArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string = object == null ? "" : object.toString();
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    private class Handler
    implements FocusListener,
    KeyListener,
    ListDataListener,
    ListSelectionListener,
    MouseInputListener,
    PropertyChangeListener,
    DragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean dragPressDidSelection;

        private Handler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            JList jList = (JList)keyEvent.getSource();
            ListModel listModel = jList.getModel();
            if (listModel.getSize() == 0 || keyEvent.isAltDown() || BasicGraphicsUtils.isMenuShortcutKeyDown(keyEvent) || this.isNavigationKey(keyEvent)) {
                return;
            }
            boolean bl = true;
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            int n2 = BasicListUI.adjustIndex(jList.getLeadSelectionIndex(), BasicListUI.this.list);
            if (l - this.lastTime < BasicListUI.this.timeFactor) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n2;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n2;
                this.prefix = this.typedString = "" + c;
            }
            this.lastTime = l;
            if (n2 < 0 || n2 >= listModel.getSize()) {
                bl = false;
                n2 = 0;
            }
            if ((n = jList.getNextMatch(this.prefix, n2, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            } else if (bl && (n = jList.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.isNavigationKey(keyEvent)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private boolean isNavigationKey(KeyEvent keyEvent) {
            InputMap inputMap = BasicListUI.this.list.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            return inputMap != null && inputMap.get(keyStroke) != null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "model") {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string == "selectionModel") {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string == "cellRenderer") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string == "font") {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                BasicListUI.this.redrawList();
            } else if (string == "prototypeCellValue") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                BasicListUI.this.redrawList();
            } else if (string == "fixedCellHeight") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                BasicListUI.this.redrawList();
            } else if (string == "fixedCellWidth") {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                BasicListUI.this.redrawList();
            } else if (string == "cellRenderer") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string == "selectionForeground") {
                BasicListUI.this.list.repaint();
            } else if (string == "selectionBackground") {
                BasicListUI.this.list.repaint();
            } else if ("layoutOrientation" == string) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                BasicListUI.this.layoutOrientation = BasicListUI.this.list.getLayoutOrientation();
                BasicListUI.this.redrawList();
            } else if ("visibleRowCount" == string) {
                if (BasicListUI.this.layoutOrientation != 0) {
                    BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                    BasicListUI.this.redrawList();
                }
            } else if ("componentOrientation" == string) {
                BasicListUI.this.isLeftToRight = BasicListUI.this.list.getComponentOrientation().isLeftToRight();
                BasicListUI.this.updateLayoutStateNeeded |= 0x400;
                BasicListUI.this.redrawList();
                InputMap inputMap = BasicListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicListUI.this.list, 0, inputMap);
            } else if ("List.isFileList" == string) {
                BasicListUI.this.updateIsFileList();
                BasicListUI.this.redrawList();
            } else if ("dropLocation" == string) {
                JList.DropLocation dropLocation = (JList.DropLocation)propertyChangeEvent.getOldValue();
                this.repaintDropLocation(dropLocation);
                this.repaintDropLocation(BasicListUI.this.list.getDropLocation());
            }
        }

        private void repaintDropLocation(JList.DropLocation dropLocation) {
            if (dropLocation == null) {
                return;
            }
            Rectangle rectangle = dropLocation.isInsert() ? BasicListUI.this.getDropLineRect(dropLocation) : BasicListUI.this.getCellBounds(BasicListUI.this.list, dropLocation.getIndex());
            if (rectangle != null) {
                BasicListUI.this.list.repaint(rectangle);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
            }
            BasicListUI.this.redrawList();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            BasicListUI.this.redrawList();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.redrawList();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.maybeUpdateLayoutState();
            int n = BasicListUI.this.list.getModel().getSize();
            int n2 = Math.min(n - 1, Math.max(listSelectionEvent.getFirstIndex(), 0));
            int n3 = Math.min(n - 1, Math.max(listSelectionEvent.getLastIndex(), 0));
            Rectangle rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n2, n3);
            if (rectangle != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicListUI.this.list)) {
                return;
            }
            boolean bl = BasicListUI.this.list.getDragEnabled();
            boolean bl2 = true;
            if (bl) {
                int n = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, mouseEvent.getPoint());
                if (n != -1 && DragRecognitionSupport.mousePressed(mouseEvent)) {
                    this.dragPressDidSelection = false;
                    if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                        return;
                    }
                    if (!mouseEvent.isShiftDown() && BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                        return;
                    }
                    bl2 = false;
                    this.dragPressDidSelection = true;
                }
            } else {
                BasicListUI.this.list.setValueIsAdjusting(true);
            }
            if (bl2) {
                SwingUtilities2.adjustFocus(BasicListUI.this.list);
            }
            this.adjustSelection(mouseEvent);
        }

        private void adjustSelection(MouseEvent mouseEvent) {
            int n = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, mouseEvent.getPoint());
            if (n < 0) {
                if (BasicListUI.this.isFileList && mouseEvent.getID() == 501 && (!mouseEvent.isShiftDown() || BasicListUI.this.list.getSelectionMode() == 0)) {
                    BasicListUI.this.list.clearSelection();
                }
            } else {
                boolean bl;
                int n2 = BasicListUI.adjustIndex(BasicListUI.this.list.getAnchorSelectionIndex(), BasicListUI.this.list);
                if (n2 == -1) {
                    n2 = 0;
                    bl = false;
                } else {
                    bl = BasicListUI.this.list.isSelectedIndex(n2);
                }
                if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                    if (mouseEvent.isShiftDown()) {
                        if (bl) {
                            BasicListUI.this.list.addSelectionInterval(n2, n);
                        } else {
                            BasicListUI.this.list.removeSelectionInterval(n2, n);
                            if (BasicListUI.this.isFileList) {
                                BasicListUI.this.list.addSelectionInterval(n, n);
                                BasicListUI.this.list.getSelectionModel().setAnchorSelectionIndex(n2);
                            }
                        }
                    } else if (BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown()) {
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void dragStarting(MouseEvent mouseEvent) {
            if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                int n = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, mouseEvent.getPoint());
                BasicListUI.this.list.addSelectionInterval(n, n);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicListUI.this.list)) {
                return;
            }
            if (BasicListUI.this.list.getDragEnabled()) {
                DragRecognitionSupport.mouseDragged(mouseEvent, this);
                return;
            }
            if (mouseEvent.isShiftDown() || BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                return;
            }
            int n = BasicListUI.this.locationToIndex(BasicListUI.this.list, mouseEvent.getPoint());
            if (n != -1) {
                if (BasicListUI.this.isFileList) {
                    return;
                }
                Rectangle rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n);
                if (rectangle != null) {
                    BasicListUI.this.list.scrollRectToVisible(rectangle);
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicListUI.this.list)) {
                return;
            }
            if (BasicListUI.this.list.getDragEnabled()) {
                MouseEvent mouseEvent2 = DragRecognitionSupport.mouseReleased(mouseEvent);
                if (mouseEvent2 != null) {
                    SwingUtilities2.adjustFocus(BasicListUI.this.list);
                    if (!this.dragPressDidSelection) {
                        this.adjustSelection(mouseEvent2);
                    }
                }
            } else {
                BasicListUI.this.list.setValueIsAdjusting(false);
            }
        }

        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicListUI.adjustIndex(BasicListUI.this.list.getLeadSelectionIndex(), BasicListUI.this.list);
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        private static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        private static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        private static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JList jList = (JList)actionEvent.getSource();
            BasicListUI basicListUI = (BasicListUI)BasicLookAndFeel.getUIOfType(jList.getUI(), BasicListUI.class);
            if (string == SELECT_PREVIOUS_COLUMN) {
                this.changeSelection(jList, 1, this.getNextColumnIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_PREVIOUS_COLUMN_EXTEND) {
                this.changeSelection(jList, 2, this.getNextColumnIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextColumnIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_NEXT_COLUMN) {
                this.changeSelection(jList, 1, this.getNextColumnIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_NEXT_COLUMN_EXTEND) {
                this.changeSelection(jList, 2, this.getNextColumnIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_NEXT_COLUMN_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextColumnIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_PREVIOUS_ROW) {
                this.changeSelection(jList, 1, this.getNextIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_PREVIOUS_ROW_EXTEND) {
                this.changeSelection(jList, 2, this.getNextIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_PREVIOUS_ROW_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextIndex(jList, basicListUI, -1), -1);
            } else if (string == SELECT_NEXT_ROW) {
                this.changeSelection(jList, 1, this.getNextIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_NEXT_ROW_EXTEND) {
                this.changeSelection(jList, 2, this.getNextIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_NEXT_ROW_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextIndex(jList, basicListUI, 1), 1);
            } else if (string == SELECT_FIRST_ROW) {
                this.changeSelection(jList, 1, 0, -1);
            } else if (string == SELECT_FIRST_ROW_EXTEND) {
                this.changeSelection(jList, 2, 0, -1);
            } else if (string == SELECT_FIRST_ROW_CHANGE_LEAD) {
                this.changeSelection(jList, 0, 0, -1);
            } else if (string == SELECT_LAST_ROW) {
                this.changeSelection(jList, 1, jList.getModel().getSize() - 1, 1);
            } else if (string == SELECT_LAST_ROW_EXTEND) {
                this.changeSelection(jList, 2, jList.getModel().getSize() - 1, 1);
            } else if (string == SELECT_LAST_ROW_CHANGE_LEAD) {
                this.changeSelection(jList, 0, jList.getModel().getSize() - 1, 1);
            } else if (string == SCROLL_UP) {
                this.changeSelection(jList, 1, this.getNextPageIndex(jList, -1), -1);
            } else if (string == SCROLL_UP_EXTEND) {
                this.changeSelection(jList, 2, this.getNextPageIndex(jList, -1), -1);
            } else if (string == SCROLL_UP_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextPageIndex(jList, -1), -1);
            } else if (string == SCROLL_DOWN) {
                this.changeSelection(jList, 1, this.getNextPageIndex(jList, 1), 1);
            } else if (string == SCROLL_DOWN_EXTEND) {
                this.changeSelection(jList, 2, this.getNextPageIndex(jList, 1), 1);
            } else if (string == SCROLL_DOWN_CHANGE_LEAD) {
                this.changeSelection(jList, 0, this.getNextPageIndex(jList, 1), 1);
            } else if (string == SELECT_ALL) {
                this.selectAll(jList);
            } else if (string == CLEAR_SELECTION) {
                this.clearSelection(jList);
            } else if (string == ADD_TO_SELECTION) {
                int n = BasicListUI.adjustIndex(jList.getSelectionModel().getLeadSelectionIndex(), jList);
                if (!jList.isSelectedIndex(n)) {
                    int n2 = jList.getSelectionModel().getAnchorSelectionIndex();
                    jList.setValueIsAdjusting(true);
                    jList.addSelectionInterval(n, n);
                    jList.getSelectionModel().setAnchorSelectionIndex(n2);
                    jList.setValueIsAdjusting(false);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                int n = BasicListUI.adjustIndex(jList.getSelectionModel().getLeadSelectionIndex(), jList);
                if (jList.isSelectedIndex(n)) {
                    jList.removeSelectionInterval(n, n);
                } else {
                    jList.addSelectionInterval(n, n);
                }
            } else if (string == EXTEND_TO) {
                this.changeSelection(jList, 2, BasicListUI.adjustIndex(jList.getSelectionModel().getLeadSelectionIndex(), jList), 0);
            } else if (string == MOVE_SELECTION_TO) {
                this.changeSelection(jList, 1, BasicListUI.adjustIndex(jList.getSelectionModel().getLeadSelectionIndex(), jList), 0);
            }
        }

        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD || string == SELECT_NEXT_COLUMN_CHANGE_LEAD || string == SELECT_PREVIOUS_ROW_CHANGE_LEAD || string == SELECT_NEXT_ROW_CHANGE_LEAD || string == SELECT_FIRST_ROW_CHANGE_LEAD || string == SELECT_LAST_ROW_CHANGE_LEAD || string == SCROLL_UP_CHANGE_LEAD || string == SCROLL_DOWN_CHANGE_LEAD) {
                return object != null && ((JList)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void clearSelection(JList jList) {
            jList.clearSelection();
        }

        private void selectAll(JList jList) {
            int n = jList.getModel().getSize();
            if (n > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                int n2 = BasicListUI.adjustIndex(listSelectionModel.getLeadSelectionIndex(), jList);
                if (listSelectionModel.getSelectionMode() == 0) {
                    if (n2 == -1) {
                        int n3 = BasicListUI.adjustIndex(jList.getMinSelectionIndex(), jList);
                        n2 = n3 == -1 ? 0 : n3;
                    }
                    jList.setSelectionInterval(n2, n2);
                    jList.ensureIndexIsVisible(n2);
                } else {
                    jList.setValueIsAdjusting(true);
                    int n4 = BasicListUI.adjustIndex(listSelectionModel.getAnchorSelectionIndex(), jList);
                    jList.setSelectionInterval(0, n - 1);
                    SwingUtilities2.setLeadAnchorWithoutSelection(listSelectionModel, n4, n2);
                    jList.setValueIsAdjusting(false);
                }
            }
        }

        private int getNextPageIndex(JList jList, int n) {
            Rectangle rectangle;
            if (jList.getModel().getSize() == 0) {
                return -1;
            }
            int n2 = -1;
            Rectangle rectangle2 = jList.getVisibleRect();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            int n3 = BasicListUI.adjustIndex(listSelectionModel.getLeadSelectionIndex(), jList);
            Rectangle rectangle3 = rectangle = n3 == -1 ? new Rectangle() : jList.getCellBounds(n3, n3);
            if (jList.getLayoutOrientation() == 1 && jList.getVisibleRowCount() <= 0) {
                if (!jList.getComponentOrientation().isLeftToRight()) {
                    n = -n;
                }
                if (n < 0) {
                    rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                    Point point = new Point(rectangle2.x - 1, rectangle.y);
                    n2 = jList.locationToIndex(point);
                    Rectangle rectangle4 = jList.getCellBounds(n2, n2);
                    if (rectangle2.intersects(rectangle4)) {
                        point.x = rectangle4.x - 1;
                        n2 = jList.locationToIndex(point);
                        rectangle4 = jList.getCellBounds(n2, n2);
                    }
                    if (rectangle4.y != rectangle.y) {
                        point.x = rectangle4.x + rectangle4.width;
                        n2 = jList.locationToIndex(point);
                    }
                } else {
                    rectangle2.x = rectangle.x;
                    Point point = new Point(rectangle2.x + rectangle2.width, rectangle.y);
                    n2 = jList.locationToIndex(point);
                    Rectangle rectangle5 = jList.getCellBounds(n2, n2);
                    if (rectangle2.intersects(rectangle5)) {
                        point.x = rectangle5.x + rectangle5.width;
                        n2 = jList.locationToIndex(point);
                        rectangle5 = jList.getCellBounds(n2, n2);
                    }
                    if (rectangle5.y != rectangle.y) {
                        point.x = rectangle5.x - 1;
                        n2 = jList.locationToIndex(point);
                    }
                }
            } else if (n < 0) {
                Point point = new Point(rectangle.x, rectangle2.y);
                n2 = jList.locationToIndex(point);
                if (n3 <= n2) {
                    point.y = rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                    n2 = jList.locationToIndex(point);
                    Rectangle rectangle6 = jList.getCellBounds(n2, n2);
                    if (rectangle6.y < rectangle2.y) {
                        point.y = rectangle6.y + rectangle6.height;
                        n2 = jList.locationToIndex(point);
                        rectangle6 = jList.getCellBounds(n2, n2);
                    }
                    if (rectangle6.y >= rectangle.y) {
                        point.y = rectangle.y - 1;
                        n2 = jList.locationToIndex(point);
                    }
                }
            } else {
                Point point = new Point(rectangle.x, rectangle2.y + rectangle2.height - 1);
                n2 = jList.locationToIndex(point);
                Rectangle rectangle7 = jList.getCellBounds(n2, n2);
                if (rectangle7.y + rectangle7.height > rectangle2.y + rectangle2.height) {
                    point.y = rectangle7.y - 1;
                    n2 = jList.locationToIndex(point);
                    rectangle7 = jList.getCellBounds(n2, n2);
                    n2 = Math.max(n2, n3);
                }
                if (n3 >= n2) {
                    rectangle2.y = rectangle.y;
                    point.y = rectangle2.y + rectangle2.height - 1;
                    n2 = jList.locationToIndex(point);
                    rectangle7 = jList.getCellBounds(n2, n2);
                    if (rectangle7.y + rectangle7.height > rectangle2.y + rectangle2.height) {
                        point.y = rectangle7.y - 1;
                        n2 = jList.locationToIndex(point);
                        rectangle7 = jList.getCellBounds(n2, n2);
                    }
                    if (rectangle7.y <= rectangle.y) {
                        point.y = rectangle.y + rectangle.height;
                        n2 = jList.locationToIndex(point);
                    }
                }
            }
            return n2;
        }

        private void changeSelection(JList jList, int n, int n2, int n3) {
            if (n2 >= 0 && n2 < jList.getModel().getSize()) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (n == 0 && jList.getSelectionMode() != 2) {
                    n = 1;
                }
                this.adjustScrollPositionIfNecessary(jList, n2, n3);
                if (n == 2) {
                    int n4 = BasicListUI.adjustIndex(listSelectionModel.getAnchorSelectionIndex(), jList);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    jList.setSelectionInterval(n4, n2);
                } else if (n == 1) {
                    jList.setSelectedIndex(n2);
                } else {
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n2);
                }
            }
        }

        private void adjustScrollPositionIfNecessary(JList jList, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            Rectangle rectangle = jList.getCellBounds(n, n);
            Rectangle rectangle2 = jList.getVisibleRect();
            if (rectangle != null && !rectangle2.contains(rectangle)) {
                if (jList.getLayoutOrientation() == 1 && jList.getVisibleRowCount() <= 0) {
                    if (jList.getComponentOrientation().isLeftToRight()) {
                        if (n2 > 0) {
                            int n3 = Math.max(0, rectangle.x + rectangle.width - rectangle2.width);
                            int n4 = jList.locationToIndex(new Point(n3, rectangle.y));
                            Rectangle rectangle3 = jList.getCellBounds(n4, n4);
                            if (rectangle3.x < n3 && rectangle3.x < rectangle.x) {
                                rectangle3.x += rectangle3.width;
                                n4 = jList.locationToIndex(rectangle3.getLocation());
                                rectangle3 = jList.getCellBounds(n4, n4);
                            }
                            rectangle = rectangle3;
                        }
                        rectangle.width = rectangle2.width;
                    } else if (n2 > 0) {
                        int n5 = rectangle.x + rectangle2.width;
                        int n6 = jList.locationToIndex(new Point(n5, rectangle.y));
                        Rectangle rectangle4 = jList.getCellBounds(n6, n6);
                        if (rectangle4.x + rectangle4.width > n5 && rectangle4.x > rectangle.x) {
                            rectangle4.width = 0;
                        }
                        rectangle.x = Math.max(0, rectangle4.x + rectangle4.width - rectangle2.width);
                        rectangle.width = rectangle2.width;
                    } else {
                        rectangle.x += Math.max(0, rectangle.width - rectangle2.width);
                        rectangle.width = Math.min(rectangle.width, rectangle2.width);
                    }
                } else if (n2 > 0 && (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height)) {
                    int n7 = Math.max(0, rectangle.y + rectangle.height - rectangle2.height);
                    int n8 = jList.locationToIndex(new Point(rectangle.x, n7));
                    Rectangle rectangle5 = jList.getCellBounds(n8, n8);
                    if (rectangle5.y < n7 && rectangle5.y < rectangle.y) {
                        rectangle5.y += rectangle5.height;
                        n8 = jList.locationToIndex(rectangle5.getLocation());
                        rectangle5 = jList.getCellBounds(n8, n8);
                    }
                    rectangle = rectangle5;
                    rectangle.height = rectangle2.height;
                } else {
                    rectangle.height = Math.min(rectangle.height, rectangle2.height);
                }
                jList.scrollRectToVisible(rectangle);
            }
        }

        private int getNextColumnIndex(JList jList, BasicListUI basicListUI, int n) {
            if (jList.getLayoutOrientation() != 0) {
                int n2 = BasicListUI.adjustIndex(jList.getLeadSelectionIndex(), jList);
                int n3 = jList.getModel().getSize();
                if (n2 == -1) {
                    return 0;
                }
                if (n3 == 1) {
                    return 0;
                }
                if (basicListUI == null || basicListUI.columnCount <= 1) {
                    return -1;
                }
                int n4 = basicListUI.convertModelToColumn(n2);
                int n5 = basicListUI.convertModelToRow(n2);
                if ((n4 += n) >= basicListUI.columnCount || n4 < 0) {
                    return -1;
                }
                int n6 = basicListUI.getRowCount(n4);
                if (n5 >= n6) {
                    return -1;
                }
                return basicListUI.getModelIndex(n4, n5);
            }
            return -1;
        }

        private int getNextIndex(JList jList, BasicListUI basicListUI, int n) {
            int n2 = BasicListUI.adjustIndex(jList.getLeadSelectionIndex(), jList);
            int n3 = jList.getModel().getSize();
            if (n2 == -1) {
                if (n3 > 0) {
                    n2 = n > 0 ? 0 : n3 - 1;
                }
            } else if (n3 == 1) {
                n2 = 0;
            } else if (jList.getLayoutOrientation() == 2) {
                if (basicListUI != null) {
                    n2 += basicListUI.columnCount * n;
                }
            } else {
                n2 += n;
            }
            return n2;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicListUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.getHandler().intervalAdded(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.getHandler().intervalRemoved(listDataEvent);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.getHandler().contentsChanged(listDataEvent);
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.getHandler().valueChanged(listSelectionEvent);
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            BasicListUI.this.getHandler().repaintCellFocus();
        }

        public void focusGained(FocusEvent focusEvent) {
            BasicListUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicListUI.this.getHandler().focusLost(focusEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseMoved(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicListUI.this.getHandler().mouseReleased(mouseEvent);
        }
    }
}

