<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import="net.sz600.tool.*" %>
<%@ page import="net.sz600.formEngine2.*" %>
<%@ page import="net.sz600.weboffice.*" %>
<%@ page import="java.io.*,java.text.*,java.util.*,java.sql.*,javax.servlet.*,javax.servlet.http.*" %>
<%@ include file="/sessionInfo.jsp"%>
<%

  String mDescript="";
  String mFileName="";

  String mHttpUrlName=request.getRequestURI();
  String mScriptName=request.getServletPath();
  String mServerName="OfficeServer.jsp";

  String mServerUrl="http://"+request.getServerName()+":"+request.getServerPort()+mHttpUrlName.substring(0,mHttpUrlName.lastIndexOf(mScriptName))+"/share/weboffice/"+mServerName;//取得OfficeServer文件的完整URL

  String mRecordID=request.getParameter("RecordID");
  String mFileType=request.getParameter("FileType");
  String type= SzConvert.toZeroStr(request.getParameter("type"));

  //System.out.println(mFilePath);
  String mEditType="1";
  String mUserName="Administrator";


  //取得模式
  if ( mEditType==null)
  {
    mEditType="2";		// 2 起草
  }
  //取得类型
  if ( mFileType==null)
  {
    mFileType=".doc";	// 默认为.doc文档
  }
  //取得用户名
  if (mUserName==null)
  {
    mUserName="金格科技";
  }

  //取得模板
  if ( mRecordID==null)
  {
    mRecordID="";	// 默认没有模板
  }

  //打开数据库
  String sBDID = "0";
	iTemplate template = new iTemplate();
  String s_info[] = template.getInfo(mRecordID, mFileType);
  if (s_info != null) {
	  mRecordID = s_info[0];
	  mFileName = s_info[1];
	  mFileType = s_info[2];
	  mDescript = s_info[3];
	  sBDID = s_info[4];
  }
	
  
	BdFormControl formControl = new BdFormControl();
	String moduleName = SzConvert.strWriteData(request.getParameter("module"));
	boolean isFormEngine = formControl.isFormEngine(moduleName);
	boolean isDocumentEngine = formControl.isDocumentEngine(moduleName);	
	
  String mPrintFilePath = SzConvert.toSpaceStr(request.getParameter("FilePath"));
  String mPrintFileName = "";
  

  if (!mPrintFilePath.equals("")) {
	  mFileName = "打印模板" + mPrintFilePath;
	  session.setAttribute("PrintFilePath",  mPrintFilePath);
	  mPrintFilePath = "http://"+request.getServerName()+":"+request.getServerPort()+mHttpUrlName.substring(0,mHttpUrlName.lastIndexOf(mScriptName))+ "/" + mPrintFilePath;
	  //System.out.println(mPrintFilePath);
		mPrintFileName = iWebOfficeNew.CURRENT_TEMP_PATH + "PrintFilePath" + iDLID_SESSION + ".doc";
	  
	  mDescript = "打印模板";
  }
  

%>

<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link href="<%=strSkin_SESSION%>/css2007.css" rel="stylesheet" type="text/css">
<script language="javascript" for=WebOffice event="OnMenuClick(vIndex,vCaption)">
   if (vIndex==1){  //打开本地文件
      WebOpenLocal();
   }
   if (vIndex==2){  //保存本地文件
      WebSaveLocal();
   }
   if (vIndex==4){  //保存并退出
     SaveDocument();    //保存正文
     webform.submit();  //提交表单
   }
   if (vIndex==6){  //打印文档
      WebOpenPrint();
   }
</script>

<script language=javascript>

//作用：显示操作状态
function StatusMsg(mString){
  StatusBar.innerText=mString;
}

//作用：载入iWebOffice
function Load(){
  try{

  	//以下属性必须设置，实始化iWebOffice
  	webform.WebOffice.WebUrl="<%=mServerUrl%>";    //WebUrl:系统服务器路径，与服务器文件交互操作，如保存、打开文档，重要文件
  	webform.WebOffice.RecordID="<%=mRecordID%>";   //RecordID:本文档记录编号
  	webform.WebOffice.Template="<%=mRecordID%>";   //Template:模板编号
  	webform.WebOffice.FileName="<%=mFileName%>";   //FileName:文档名称
  	webform.WebOffice.FileType="<%=mFileType%>";   //FileType:文档类型  .doc  .xls  .wps
 	 	webform.WebOffice.EditType="<%=mEditType%>";   //EditType:编辑类型  方式一、方式二  <参考技术文档>
  	webform.WebOffice.UserName="<%=mUserName%>";   //UserName:操作用户名

  	//以下属性可以不要
  	webform.WebOffice.ShowMenu="1";  //ShowMenu:1 显示菜单  0 隐藏菜单
  	webform.WebOffice.AppendMenu("1","打开本地文件(&L)");
  	webform.WebOffice.AppendMenu("2","保存本地文件(&S)");
  	webform.WebOffice.AppendMenu("3","-");
  	//webform.WebOffice.AppendMenu("4","保存并退出(&E)");
  	webform.WebOffice.AppendMenu("5","-");
  	webform.WebOffice.AppendMenu("6","打印文档(&P)");
  	webform.WebOffice.DisableMenu("宏;选项;帮助");  //禁止菜单
  

  	webform.WebOffice.WebOpen();  	//打开该文档    交互OfficeServer的OPTION="LOADTEMPLATE"
  	StatusMsg(webform.WebOffice.Status);
  }catch(e){}

  var vPath = "<%=mPrintFilePath%>";
  var vName = "<%=mPrintFileName%>";
  if (vPath != "" ) {
  		WebDownLoadFile(vPath, vName);
  }
  
}

//作用：退出iWebOffice
function UnLoad(){
  try{
  if (!webform.WebOffice.WebClose()){
     StatusMsg(webform.WebOffice.Status);
  }else{
     StatusMsg("关闭文档...");
  }
  }catch(e){}
}


//作用：打开文档
function LoadDocument(){
  StatusMsg("正在打开文档...");
  if (!webform.WebOffice.WebLoadTemplate()){  //交互OfficeServer的OPTION="LOADTEMPLATE"
     StatusMsg(webform.WebOffice.Status);
  }else{
     StatusMsg(webform.WebOffice.Status);
  }
}

//作用：保存文档
function SaveDocument(){
  //检查名称不能为空
  if (!notSpace(webform.FileName, "模板名称")) {
      return false;
  }  

  webform.WebOffice.WebClearMessage();            //清空iWebOffice变量
  /*
  //2016-03-30增加：保存excel模板时，不能调用bookmarks
  if (!webform.WebOffice.WebSaveBookMarks()){    //交互OfficeServer的OPTION="SAVEBOOKMARKS"
     StatusMsg(webform.WebOffice.Status);
     return false;
  }
  */
  //webform.WebOffice.WebSetMsgByName("MyDefine1","自定义变量值1");  //设置变量MyDefine1="自定义变量值1"，变量可以设置多个  在WebSaveTemplate()时，一起提交到OfficeServer中
  if (!webform.WebOffice.WebSaveTemplate()){    //交互OfficeServer的OPTION="SAVETEMPLATE"
     StatusMsg(webform.WebOffice.Status);
     //alert("ff");
     return false;
  }else{
     StatusMsg(webform.WebOffice.Status);
     webform.submit();
     return true;
  }
  
}

//作用：填充模板
function LoadBookmarks(){
  StatusMsg("正在填充模扳...");
  if (!webform.WebOffice.WebLoadBookmarks()){    //交互OfficeServer的OPTION="LOADBOOKMARKS"
     StatusMsg(webform.WebOffice.Status);
  }else{
     StatusMsg(webform.WebOffice.Status);
  }
}

//作用：设置书签值  vbmName:标签名称，vbmValue:标签值   标签名称注意大小写
function SetBookmarks(vbmName,vbmValue){
  if (!webform.WebOffice.WebSetBookmarks(vbmName,vbmValue)){
     StatusMsg(webform.WebOffice.Status);
  }else{
     StatusMsg(webform.WebOffice.Status);
  }
}

//作用：根据标签名称获取标签值  vbmName:标签名称
function GetBookmarks(vbmName){
  var vbmValue;
  vbmValue=webform.WebOffice.WebGetBookmarks(vbmName);
  return vbmValue;
}

//作用：打印文档
function WebOpenPrint(){
  try{
    webform.WebOffice.WebOpenPrint();
    StatusMsg(webform.WebOffice.Status);
  }catch(e){}
}

//作用：页面设置
function WebOpenPageSetup(){
   try{
	if (webform.WebOffice.FileType==".doc"){
	  webform.WebOffice.WebObject.Application.Dialogs(178).Show();
	}
	if(webform.WebOffice.FileType==".xls"){
	  webform.WebOffice.WebObject.Application.Dialogs(7).Show();
	}
   }catch(e){

   }
}

//作用：标签管理
function WebOpenBookMarks(){
  try{
    webform.WebOffice.WebOpenBookmarks();    //交互OfficeServer的OPTION="LISTBOOKMARKS"
    StatusMsg(webform.WebOffice.Status);
  }catch(e){}
}

//作用：存为本地文件
function WebSaveLocal(){
  try{
    webform.WebOffice.WebSaveLocal();
    StatusMsg(webform.WebOffice.Status);
  }catch(e){}
}

//作用：打开本地文件
function WebOpenLocal(){
  try{
    webform.WebOffice.WebOpenLocal();
    StatusMsg(webform.WebOffice.Status);
  }catch(e){}
}

//作用：打开远程文件
function WebDownLoadFile(path, name){
  //path = "http://localhost:8080/oa/share\\wordtemp\\jianhua1.doc";
  //alert(path + "==" + name);
  webform.WebOffice.WebMkDirectory("<%=iWebOfficeNew.CURRENT_TEMP_PATH%>");
  mResult=webform.WebOffice.WebDownLoadFile(path,name);
  if (mResult){
    webform.WebOffice.WebOpenLocalFile(name);
    //alert("成功");
  }else{
    //alert("失败");
  }
}

</script>
</head>
<body bgcolor="#ffffff" onload="Load()" onunload="UnLoad()"> <!--引导和退出iWebOffice-->

<%  if (!moduleName.equals("")) { %>
<%@ include file="/xml/formEngine2/title.jsp"%>
<% } else { %>
<%@ include file="/share/title.jsp"%>
<% } %>

<table width="100%">
  <tr>
    <td>
      <%=SzPageHelp.button("保存","javascript:SaveDocument();")%>
      <%=SzPageHelp.button("打印文档","javascript:WebOpenPrint();")%>
      <%//=SzPageHelp.button("定义标签","javascript:WebOpenBookMarks();")%>
      <%//=SzPageHelp.button("填充模版","javascript:LoadBookmarks();")%>
      <%=SzPageHelp.button("重调文档","javascript:LoadDocument();")%>
      <%=SzPageHelp.button("打开文件","javascript:WebOpenLocal();")%>
      <%=SzPageHelp.button("保存文件","javascript:WebSaveLocal();")%>
      <%=SzPageHelp.backButton()%>
    </td>
  </tr>
</table>

<form name="webform" method="post" action="TemplateSave.jsp" onsubmit="return SaveDocument();"> <!--保存iWebOffice后提交表单信息-->
<input type="hidden" name="RecordID" value="<%=mRecordID%>">
<input type="hidden" name="module" value="<%=moduleName%>">
<input type="hidden" name="type" value="<%=type%>">

<table border=0  cellspacing='0' cellpadding='0' width=100% height=100% align=center class=TBStyle>
<tr>
  <td align=left class="TDTitleStyle">所属表单</td>
  <td>
  <%	 
	ArrayList list = formControl.getFormArrayhasWord();
  out.println(SzPageHelp.selectArrayList(list,"BDID", sBDID, "所属表单", "txtClass2", ""));
  %>
  </td>
</tr>
<tr>
  <td align=left class="TDTitleStyle">模版名</td>
  <td><input type="text" name="FileName" value="<%=mFileName%>" <%if (!mPrintFilePath.equals("")) { out.println("class='txtClass2R' readonly "); } else { out.println("class='txtClass2' "); } %> >
  </td>
</tr>

<tr>
  <td align=left class="TDTitleStyle">说明</td>
  <td><input type="text" name="Descript" value="<%=mDescript%>" class="txtClass2" >
  </td>
</tr>

<tr>
  <td class="TDStyle"  height="1300" colspan="2">
        <table border=0 cellspacing='0' cellpadding='0' width='100%' height='100%' >
        <tr>
          <td bgcolor="menu">
            <!--调用iWebOffice，注意版本号，可用于升级-->
            <script src="../iWebOffice2003.js"></script>
          </td>
        </tr>
        <tr>
          <td bgcolor=menu height='20'>
						<div id=StatusBar style="display:none;">状态栏</div>
          </td>
        </tr>
        </table>
  </td>
</tr>
</table>

</form>

</body>
</html>
<script language="javascript" src="../../../share/js/commonTool.js"></script>
<script language="javascript">

</script>
