Scriptname FNISeffect2ScriptPinups extends activemagiceffect  

FNISRingAddScript Property FNISquest Auto
MiscObject property FNIScoin Auto
Spell property FNISSpell2 Auto
Idle property IdleForceDefaultState Auto
Message property TestMessage Auto 

Actor Target

Armor Property FNISPlayIdleRing Auto

EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	int n = 0
;	DEBUG.TRACE("Effect 2 Start")	

	Target = akTarget
	if ( akTarget == Game.GetPlayer() )
		Game.ForceThirdPerson()
		akTarget.UnequipItem(FNISPlayIdleRing, false, true)
	else
		n = Target.getitemcount(FNIScoin)
		if ( n == 0 )											; NPC has tokens?
			StartSubQuest(Target)								; start the subQuest
		endif
	endif

	Utility.Wait(0.2)

	if ( FNISquest.NextIdle <= 80 )
		akTarget.PlayIdle(FNISquest.FNISidle[FNISquest.NextIdle])
;		TestMessage.Show(1,FNISquest.NextIdle)
	else
		akTarget.PlayIdle(FNISquest.FNISidle[0])
;		Debug.Notification("FNIS: idle1 activated (DEFAULT - wrong value?)")
	endif
	
ENDEVENT


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	int n
	Target = akTarget
	
	if ( akTarget != Game.GetPlayer() )								; only if NPC:
		n = Target.getitemcount(FNIScoin)
		if ( n > 0 )												; has tokens: idle in progress
			Target.removeitem(FNIScoin,n)							; remove tokens
			if ( n <= 10 )
				FNISquest.SubQuest[n].Stop()						; stop the subQuest
				FNISquest.FNISnpc[n].PlayIdle(IdleForceDefaultState); reset idle
				FNISquest.QuestCnt[n] = 0							; free quest slot
				FNISquest.FNISnpc[n] = None							; remove NPC ref
;				TestMessage.Show(n,0)
			endif
		endif
	endif
ENDEVENT
	

Function StartSubQuest(Actor akTarget)
	int n
	int questind = 0
	int oldest = 9999
	int oldslot = 0
	int newest = 0

	n = 1
	while ( n <= 10 )
		if ( FNISquest.QuestCnt[n] == 0 )
			if ( questind == 0 )
				questind = n						; found 1st stopped quest
			endif
		else
			if ( FNISquest.QuestCnt[n] < oldest )
				oldest = FNISquest.QuestCnt[n]		; lowest quest count so far (oldest quest)
				oldslot = n
			endif
			if ( FNISquest.QuestCnt[n] > newest )
				newest = FNISquest.QuestCnt[n]		; highest quest count so far (newest quest)
			endif
		endif
		
		n = n + 1
	endWhile
	
	if ( questind == 0 )										; no empty slot
		FNISquest.SubQuest[oldslot].Stop()						; stop oldest quest
		n = FNISquest.FNISnpc[oldslot].getitemcount(FNIScoin)
		FNISquest.FNISnpc[oldslot].removeitem(FNIScoin, n)		; remove all tokens from NPC
		FNISquest.FNISnpc[oldslot].PlayIdle(IdleForceDefaultState); reset idle
		FNISquest.QuestCnt[oldslot] = newest + 1				; reserve quest
;		TestMessage.Show(oldslot,0)
		Utility.Wait(0.3)										; let the quest finish
		FNISquest.FNISnpc[oldslot].EvaluatePackage()			; let old NPC resume (???)
		questind = oldslot
	endif

	FNISquest.QuestCnt[questind] = newest + 1					; +1 quest count for newest quest
	FNISquest.FNISnpc[questind] = akTarget						; new NPC
	akTarget.additem (FNIScoin, questind)						; give him tokens
	FNISquest.SubQuest[questind].Start()						; start the subQuest
;	TestMessage.Show(questind,1)
EndFunction

