Scriptname HDTWeapon_AutoEquipper extends ObjectReference  

; Unsheathed version
Armor Property WeapOut  Auto  
; Sheathed version
Armor Property WeapSheathed  Auto
; ground version
weapon property WeapGround auto


; add/remove armor versions when weapon is taken/dropped
Event OnContainerChanged(ObjectReference akNewContainer, ObjectReference akOldContainer)
  if akOldContainer.getitemcount(WeapOut) > 0
    akOldContainer.removeItem(WeapOut,1,true)
  endif
  if akOldContainer.getitemcount(WeapSheathed) > 0
    akOldContainer.removeItem(WeapSheathed,1,true)
  endif
  if akNewContainer as Actor
    if akNewContainer.getitemcount(WeapOut) == 0
      akNewContainer.addItem(WeapOut,1,true)
    endif
    if akNewContainer.getitemcount(WeapSheathed) == 0
      akNewContainer.addItem(WeapSheathed,1,true)
    endif
  else
    akNewContainer.addItem(WeapGround,1,true)
    Delete()
  endif
endevent  

Event OnEquipped(Actor akActor)
  akActor.EquipItem(WeapSheathed,false,true)
endevent

Event OnUnequipped(Actor akActor)
  akActor.UnEquipItem(WeapSheathed,false,true)
  akActor.UnEquipItem(WeapOut,false,true)
endevent