#include "NiRTTI.h"
#include "NiObjects.h"

NiObject * DoNiRTTICast(NiObject * src, const NiRTTI * typeInfo)
{
	if(src)
		for(NiRTTI * iter = src->GetRTTI(); iter; iter = iter->parent)
			if(iter == typeInfo)
				return src;

	return NULL;
}

const NiRTTI *	NiRTTI_BGSDecalNode = (NiRTTI *)0x012E5BDC;
const NiRTTI *	NiRTTI_BSAnimGroupSequence = (NiRTTI *)0x012E5CE4;
const NiRTTI *	NiRTTI_BSSplatterExtraData = (NiRTTI *)0x012E6C50;
const NiRTTI *	NiRTTI_BGSAddonNodeSoundHandleExtra = (NiRTTI *)0x012E71D4;
const NiRTTI *	NiRTTI_REFRSyncController = (NiRTTI *)0x01B10688;
const NiRTTI *	NiRTTI_bhkCartTether = (NiRTTI *)0x01B114C8;
const NiRTTI *	NiRTTI_bhkTiltPreventAction = (NiRTTI *)0x01B114D0;
const NiRTTI *	NiRTTI_bhkWheelAction = (NiRTTI *)0x01B114DC;
const NiRTTI *	NiRTTI_BSFaceGenAnimationData = (NiRTTI *)0x01B1A294;
const NiRTTI *	NiRTTI_BSFaceGenModelExtraData = (NiRTTI *)0x01B1DEF8;
const NiRTTI *	NiRTTI_BSFaceGenBaseMorphExtraData = (NiRTTI *)0x01B1DF04;
const NiRTTI *	NiRTTI_BSFaceGenMorphData = (NiRTTI *)0x01B1DF0C;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHead = (NiRTTI *)0x01B1DF14;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHair = (NiRTTI *)0x01B1DF1C;
const NiRTTI *	NiRTTI_BSFaceGenNiNode = (NiRTTI *)0x01B1DF44;
const NiRTTI *	NiRTTI_BSTempEffect = (NiRTTI *)0x01B20F60;
const NiRTTI *	NiRTTI_BSTempEffectDebris = (NiRTTI *)0x01B20F68;
const NiRTTI *	NiRTTI_BSTempEffectGeometryDecal = (NiRTTI *)0x01B20F70;
const NiRTTI *	NiRTTI_BSTempEffectParticle = (NiRTTI *)0x01B20F78;
const NiRTTI *	NiRTTI_BSTempEffectSimpleDecal = (NiRTTI *)0x01B20F94;
const NiRTTI *	NiRTTI_BSTempEffectSPG = (NiRTTI *)0x01B20F9C;
const NiRTTI *	NiRTTI_bhkAutoWater = (NiRTTI *)0x01B2DAE4;
const NiRTTI *	NiRTTI_ModelReferenceEffect = (NiRTTI *)0x01B2E20C;
const NiRTTI *	NiRTTI_ReferenceEffect = (NiRTTI *)0x01B2E240;
const NiRTTI *	NiRTTI_ShaderReferenceEffect = (NiRTTI *)0x01B2E254;
const NiRTTI *	NiRTTI_SummonPlacementEffect = (NiRTTI *)0x01B2E280;
const NiRTTI *	NiRTTI_SceneGraph = (NiRTTI *)0x01B382F0;
const NiRTTI *	NiRTTI_BSDoorHavokController = (NiRTTI *)0x01B39288;
const NiRTTI *	NiRTTI_BSPlayerDistanceCheckController = (NiRTTI *)0x01B39290;
const NiRTTI *	NiRTTI_BSSimpleScaleController = (NiRTTI *)0x01B39298;
const NiRTTI *	NiRTTI_DebugTextExtraData = (NiRTTI *)0x01B8D52C;
const NiRTTI *	NiRTTI_NiControllerManager = (NiRTTI *)0x01B90490;
const NiRTTI *	NiRTTI_NiControllerSequence = (NiRTTI *)0x01B904A8;
const NiRTTI *	NiRTTI_NiMultiTargetTransformController = (NiRTTI *)0x01B904B8;
const NiRTTI *	NiRTTI_NiBlendInterpolator = (NiRTTI *)0x01B904D0;
const NiRTTI *	NiRTTI_NiInterpController = (NiRTTI *)0x01B904E0;
const NiRTTI *	NiRTTI_BSMultiTargetTreadTransfController = (NiRTTI *)0x01B90508;
const NiRTTI *	NiRTTI_NiColorData = (NiRTTI *)0x01B90510;
const NiRTTI *	NiRTTI_NiFloatData = (NiRTTI *)0x01B90518;
const NiRTTI *	NiRTTI_NiFloatInterpolator = (NiRTTI *)0x01B90520;
const NiRTTI *	NiRTTI_NiColorInterpolator = (NiRTTI *)0x01B90528;
const NiRTTI *	NiRTTI_NiGeomMorpherController = (NiRTTI *)0x01B90C2C;
const NiRTTI *	NiRTTI_NiPathInterpolator = (NiRTTI *)0x01B90C44;
const NiRTTI *	NiRTTI_NiTransformInterpolator = (NiRTTI *)0x01B90C54;
const NiRTTI *	NiRTTI_NiSingleInterpController = (NiRTTI *)0x01B90C5C;
const NiRTTI *	NiRTTI_NiBlendTransformInterpolator = (NiRTTI *)0x01B90C80;
const NiRTTI *	NiRTTI_NiBlendFloatInterpolator = (NiRTTI *)0x01B90C88;
const NiRTTI *	NiRTTI_NiFloatExtraDataController = (NiRTTI *)0x01B90C90;
const NiRTTI *	NiRTTI_NiBlendAccumTransformInterpolator = (NiRTTI *)0x01B90CA0;
const NiRTTI *	NiRTTI_NiTransformController = (NiRTTI *)0x01B90CB0;
const NiRTTI *	NiRTTI_NiInterpolator = (NiRTTI *)0x01B90CC0;
const NiRTTI *	NiRTTI_BSBlendTreadTransfInterpolator = (NiRTTI *)0x01B90CE0;
const NiRTTI *	NiRTTI_NiKeyBasedInterpolator = (NiRTTI *)0x01B90CF0;
const NiRTTI *	NiRTTI_NiMorphData = (NiRTTI *)0x01B90D30;
const NiRTTI *	NiRTTI_NiPosData = (NiRTTI *)0x01B90D38;
const NiRTTI *	NiRTTI_NiTransformData = (NiRTTI *)0x01B90D64;
const NiRTTI *	NiRTTI_BSFrustumFOVController = (NiRTTI *)0x01B90DD0;
const NiRTTI *	NiRTTI_BSTreadTransfInterpolator = (NiRTTI *)0x01B90DE0;
const NiRTTI *	NiRTTI_BSRotAccumTransfInterpolator = (NiRTTI *)0x01B90DF0;
const NiRTTI *	NiRTTI_BSLookIKNote = (NiRTTI *)0x01B90DF8;
const NiRTTI *	NiRTTI_BSGrabIKNote = (NiRTTI *)0x01B90E00;
const NiRTTI *	NiRTTI_BSAnimNote = (NiRTTI *)0x01B90E08;
const NiRTTI *	NiRTTI_BSAnimNotes = (NiRTTI *)0x01B90E10;
const NiRTTI *	NiRTTI_NiVisController = (NiRTTI *)0x01B90E20;
const NiRTTI *	NiRTTI_NiUVData = (NiRTTI *)0x01B90E28;
const NiRTTI *	NiRTTI_NiUVController = (NiRTTI *)0x01B90E38;
const NiRTTI *	NiRTTI_NiTextKeyExtraData = (NiRTTI *)0x01B90E40;
const NiRTTI *	NiRTTI_NiStringPalette = (NiRTTI *)0x01B90E48;
const NiRTTI *	NiRTTI_NiSequenceStreamHelper = (NiRTTI *)0x01B90E50;
const NiRTTI *	NiRTTI_NiSequence = (NiRTTI *)0x01B90E60;
const NiRTTI *	NiRTTI_NiRotData = (NiRTTI *)0x01B90E70;
const NiRTTI *	NiRTTI_NiRollController = (NiRTTI *)0x01B90E80;
const NiRTTI *	NiRTTI_NiQuaternionInterpolator = (NiRTTI *)0x01B90E90;
const NiRTTI *	NiRTTI_NiPoint3Interpolator = (NiRTTI *)0x01B90E98;
const NiRTTI *	NiRTTI_NiPathController = (NiRTTI *)0x01B90EB0;
const NiRTTI *	NiRTTI_NiLookAtInterpolator = (NiRTTI *)0x01B90EC0;
const NiRTTI *	NiRTTI_NiLookAtController = (NiRTTI *)0x01B90ED0;
const NiRTTI *	NiRTTI_NiLightDimmerController = (NiRTTI *)0x01B90EE0;
const NiRTTI *	NiRTTI_NiLightColorController = (NiRTTI *)0x01B90EF0;
const NiRTTI *	NiRTTI_NiKeyframeManager = (NiRTTI *)0x01B90F04;
const NiRTTI *	NiRTTI_NiFloatsExtraDataPoint3Controller = (NiRTTI *)0x01B90F0C;
const NiRTTI *	NiRTTI_NiFloatsExtraDataController = (NiRTTI *)0x01B90F14;
const NiRTTI *	NiRTTI_NiColorExtraDataController = (NiRTTI *)0x01B90F1C;
const NiRTTI *	NiRTTI_NiBSplineTransformInterpolator = (NiRTTI *)0x01B90F2C;
const NiRTTI *	NiRTTI_NiBSplinePoint3Interpolator = (NiRTTI *)0x01B90F34;
const NiRTTI *	NiRTTI_NiBSplineFloatInterpolator = (NiRTTI *)0x01B90F3C;
const NiRTTI *	NiRTTI_NiBSplineCompTransformInterpolator = (NiRTTI *)0x01B90F4C;
const NiRTTI *	NiRTTI_NiBSplineCompPoint3Interpolator = (NiRTTI *)0x01B90F54;
const NiRTTI *	NiRTTI_NiBSplineCompFloatInterpolator = (NiRTTI *)0x01B90F5C;
const NiRTTI *	NiRTTI_NiBSplineCompColorInterpolator = (NiRTTI *)0x01B90F64;
const NiRTTI *	NiRTTI_NiBSplineColorInterpolator = (NiRTTI *)0x01B90F6C;
const NiRTTI *	NiRTTI_NiBSplineData = (NiRTTI *)0x01B90F74;
const NiRTTI *	NiRTTI_NiBSplineBasisData = (NiRTTI *)0x01B90F7C;
const NiRTTI *	NiRTTI_NiBoolTimelineInterpolator = (NiRTTI *)0x01B90F84;
const NiRTTI *	NiRTTI_NiBoolInterpolator = (NiRTTI *)0x01B90F8C;
const NiRTTI *	NiRTTI_NiBoolData = (NiRTTI *)0x01B90F94;
const NiRTTI *	NiRTTI_NiBoneLODController = (NiRTTI *)0x01B90FA4;
const NiRTTI *	NiRTTI_NiBlendQuaternionInterpolator = (NiRTTI *)0x01B90FB4;
const NiRTTI *	NiRTTI_NiBlendPoint3Interpolator = (NiRTTI *)0x01B90FBC;
const NiRTTI *	NiRTTI_NiBlendColorInterpolator = (NiRTTI *)0x01B90FC4;
const NiRTTI *	NiRTTI_NiBlendBoolInterpolator = (NiRTTI *)0x01B90FCC;
const NiRTTI *	NiRTTI_NiExtraDataController = (NiRTTI *)0x01B91074;
const NiRTTI *	NiRTTI_NiFloatInterpController = (NiRTTI *)0x01B9107C;
const NiRTTI *	NiRTTI_NiBoolInterpController = (NiRTTI *)0x01B91084;
const NiRTTI *	NiRTTI_NiFloatController = (NiRTTI *)0x01B9108C;
const NiRTTI *	NiRTTI_NiPoint3InterpController = (NiRTTI *)0x01B91094;
const NiRTTI *	NiRTTI_NiBSplineInterpolator = (NiRTTI *)0x01B9109C;
const NiRTTI *	NiRTTI_NiNode = (NiRTTI *)0x01B910F0;
const NiRTTI *	NiRTTI_NiAVObject = (NiRTTI *)0x01B91100;
const NiRTTI *	NiRTTI_NiObject = (NiRTTI *)0x01B9111C;
const NiRTTI *	NiRTTI_NiObjectNET = (NiRTTI *)0x01B91284;
const NiRTTI *	NiRTTI_NiSwitchNode = (NiRTTI *)0x01B912DC;
const NiRTTI *	NiRTTI_NiStringsExtraData = (NiRTTI *)0x01B912E4;
const NiRTTI *	NiRTTI_NiRenderer = (NiRTTI *)0x01B91410;
const NiRTTI *	NiRTTI_NiCamera = (NiRTTI *)0x01B91420;
const NiRTTI *	NiRTTI_NiTriShape = (NiRTTI *)0x01B91430;
const NiRTTI *	NiRTTI_NiTriStrips = (NiRTTI *)0x01B91440;
const NiRTTI *	NiRTTI_NiProperty = (NiRTTI *)0x01B92448;
const NiRTTI *	NiRTTI_NiAlphaProperty = (NiRTTI *)0x01B92454;
const NiRTTI *	NiRTTI_NiLight = (NiRTTI *)0x01B92474;
const NiRTTI *	NiRTTI_NiAdditionalGeometryData = (NiRTTI *)0x01B92484;
const NiRTTI *	NiRTTI_NiSourceTexture = (NiRTTI *)0x01B92494;
const NiRTTI *	NiRTTI_BSDismemberSkinInstance = (NiRTTI *)0x01B924D8;
const NiRTTI *	NiRTTI_NiStringExtraData = (NiRTTI *)0x01B924E0;
const NiRTTI *	NiRTTI_BSFlattenedBoneTree = (NiRTTI *)0x01B924F0;
const NiRTTI *	NiRTTI_NiTimeController = (NiRTTI *)0x01B92508;
const NiRTTI *	NiRTTI_NiGeometryData = (NiRTTI *)0x01B92530;
const NiRTTI *	NiRTTI_NiExtraData = (NiRTTI *)0x01B92538;
const NiRTTI *	NiRTTI_NiPointLight = (NiRTTI *)0x01B92548;
const NiRTTI *	NiRTTI_NiTriShapeData = (NiRTTI *)0x01B92550;
const NiRTTI *	NiRTTI_BSPackedAdditionalGeometryData = (NiRTTI *)0x01B92564;
const NiRTTI *	NiRTTI_NiLines = (NiRTTI *)0x01B92574;
const NiRTTI *	NiRTTI_NiTexture = (NiRTTI *)0x01B9260C;
const NiRTTI *	NiRTTI_NiDefaultAVObjectPalette = (NiRTTI *)0x01B9275C;
const NiRTTI *	NiRTTI_NiBillboardNode = (NiRTTI *)0x01B92770;
const NiRTTI *	NiRTTI_NiDirectionalLight = (NiRTTI *)0x01B92780;
const NiRTTI *	NiRTTI_NiPixelData = (NiRTTI *)0x01B92788;
const NiRTTI *	NiRTTI_NiCullingProcess = (NiRTTI *)0x01B92798;
const NiRTTI *	NiRTTI_NiSkinPartition = (NiRTTI *)0x01B927A8;
const NiRTTI *	NiRTTI_NiSkinInstance = (NiRTTI *)0x01B927B8;
const NiRTTI *	NiRTTI_NiSkinData = (NiRTTI *)0x01B927D0;
const NiRTTI *	NiRTTI_NiTriStripsData = (NiRTTI *)0x01B927D8;
const NiRTTI *	NiRTTI_BSSegmentedTriShape = (NiRTTI *)0x01B927EC;
const NiRTTI *	NiRTTI_BSSegmentedLandTriShape = (NiRTTI *)0x01B92800;
const NiRTTI *	NiRTTI_NiParticles = (NiRTTI *)0x01B92814;
const NiRTTI *	NiRTTI_NiScreenElementsData = (NiRTTI *)0x01B9281C;
const NiRTTI *	NiRTTI_NiScreenElements = (NiRTTI *)0x01B9282C;
const NiRTTI *	NiRTTI_NiAVObjectPalette = (NiRTTI *)0x01B92838;
const NiRTTI *	NiRTTI_NiGeometry = (NiRTTI *)0x01B9284C;
const NiRTTI *	NiRTTI_NiFloatsExtraData = (NiRTTI *)0x01B92854;
const NiRTTI *	NiRTTI_NiColorExtraData = (NiRTTI *)0x01B9285C;
const NiRTTI *	NiRTTI_NiTriBasedGeom = (NiRTTI *)0x01B9286C;
const NiRTTI *	NiRTTI_NiVertWeightsExtraData = (NiRTTI *)0x01B9288C;
const NiRTTI *	NiRTTI_NiTriBasedGeomData = (NiRTTI *)0x01B9289C;
const NiRTTI *	NiRTTI_NiLinesData = (NiRTTI *)0x01B928A4;
const NiRTTI *	NiRTTI_NiPalette = (NiRTTI *)0x01B92910;
const NiRTTI *	NiRTTI_NiParticlesData = (NiRTTI *)0x01B92A10;
const NiRTTI *	NiRTTI_BSLODTriShape = (NiRTTI *)0x01B92A2C;
const NiRTTI *	NiRTTI_NiVectorExtraData = (NiRTTI *)0x01B92A34;
const NiRTTI *	NiRTTI_NiTriStripsDynamicData = (NiRTTI *)0x01B92A3C;
const NiRTTI *	NiRTTI_NiTriShapeDynamicData = (NiRTTI *)0x01B92A44;
const NiRTTI *	NiRTTI_NiSwitchStringExtraData = (NiRTTI *)0x01B92A4C;
const NiRTTI *	NiRTTI_NiSpotLight = (NiRTTI *)0x01B92A5C;
const NiRTTI *	NiRTTI_NiSourceCubeMap = (NiRTTI *)0x01B92A6C;
const NiRTTI *	NiRTTI_NiShadeProperty = (NiRTTI *)0x01B92A74;
const NiRTTI *	NiRTTI_NiPersistentSrcTextureRendererData = (NiRTTI *)0x01B92A84;
const NiRTTI *	NiRTTI_NiParticleMeshesData = (NiRTTI *)0x01B92A94;
const NiRTTI *	NiRTTI_NiParticleMeshes = (NiRTTI *)0x01B92AA4;
const NiRTTI *	NiRTTI_NiIntegersExtraData = (NiRTTI *)0x01B92AAC;
const NiRTTI *	NiRTTI_NiIntegerExtraData = (NiRTTI *)0x01B92AB4;
const NiRTTI *	NiRTTI_NiFogProperty = (NiRTTI *)0x01B92ABC;
const NiRTTI *	NiRTTI_NiFloatExtraData = (NiRTTI *)0x01B92AC8;
const NiRTTI *	NiRTTI_NiBSPNode = (NiRTTI *)0x01B92AD8;
const NiRTTI *	NiRTTI_NiBooleanExtraData = (NiRTTI *)0x01B92AE0;
const NiRTTI *	NiRTTI_NiBinaryExtraData = (NiRTTI *)0x01B92AE8;
const NiRTTI *	NiRTTI_NiAmbientLight = (NiRTTI *)0x01B92AF8;
const NiRTTI *	NiRTTI_NiAlphaAccumulator = (NiRTTI *)0x01B92B08;
const NiRTTI *	NiRTTI_NiBackToFrontAccumulator = (NiRTTI *)0x01B92B4C;
const NiRTTI *	NiRTTI_NiAccumulator = (NiRTTI *)0x01B92B5C;
const NiRTTI *	NiRTTI_BSMultiBound = (NiRTTI *)0x01B97EE8;
const NiRTTI *	NiRTTI_BSMultiBoundOBB = (NiRTTI *)0x01B97EF0;
const NiRTTI *	NiRTTI_BSMultiBoundAABB = (NiRTTI *)0x01B97EF8;
const NiRTTI *	NiRTTI_BSMultiBoundRoom = (NiRTTI *)0x01B97F00;
const NiRTTI *	NiRTTI_BSXFlags = (NiRTTI *)0x01B97F08;
const NiRTTI *	NiRTTI_BSValueNode = (NiRTTI *)0x01B97F18;
const NiRTTI *	NiRTTI_BSTempNodeManager = (NiRTTI *)0x01B97F20;
const NiRTTI *	NiRTTI_BSTempNode = (NiRTTI *)0x01B97F28;
const NiRTTI *	NiRTTI_BSRangeNode = (NiRTTI *)0x01B97F74;
const NiRTTI *	NiRTTI_BSOcclusionShape = (NiRTTI *)0x01B9C258;
const NiRTTI *	NiRTTI_BSWindModifier = (NiRTTI *)0x01B9C2D0;
const NiRTTI *	NiRTTI_BSBlastNode = (NiRTTI *)0x01B9C4F4;
const NiRTTI *	NiRTTI_BSDebrisNode = (NiRTTI *)0x01B9C4FC;
const NiRTTI *	NiRTTI_BSDamageStage = (NiRTTI *)0x01B9C504;
const NiRTTI *	NiRTTI_BSPSysArrayEmitter = (NiRTTI *)0x01B9C514;
const NiRTTI *	NiRTTI_PArrayPoint = (NiRTTI *)0x01B9C51C;
const NiRTTI *	NiRTTI_BSCullingProcess = (NiRTTI *)0x01B9C52C;
const NiRTTI *	NiRTTI_BSMultiStreamInstanceTriShape = (NiRTTI *)0x01B9C534;
const NiRTTI *	NiRTTI_BSMultiBoundShape = (NiRTTI *)0x01B9C54C;
const NiRTTI *	NiRTTI_BSMultiBoundSphere = (NiRTTI *)0x01B9C554;
const NiRTTI *	NiRTTI_BSOcclusionPlane = (NiRTTI *)0x01B9C55C;
const NiRTTI *	NiRTTI_BSOcclusionBox = (NiRTTI *)0x01B9C564;
const NiRTTI *	NiRTTI_BSPortal = (NiRTTI *)0x01B9C56C;
const NiRTTI *	NiRTTI_BSPortalSharedNode = (NiRTTI *)0x01B9C574;
const NiRTTI *	NiRTTI_BSBehaviorGraphExtraData = (NiRTTI *)0x01B9C57C;
const NiRTTI *	NiRTTI_BSBodyMorphOffsetsExtraData = (NiRTTI *)0x01B9C588;
const NiRTTI *	NiRTTI_NiBSBoneLODController = (NiRTTI *)0x01B9C590;
const NiRTTI *	NiRTTI_BSParticleSystemManager = (NiRTTI *)0x01B9C598;
const NiRTTI *	NiRTTI_BSFurnitureMarkerNode = (NiRTTI *)0x01B9C5B0;
const NiRTTI *	NiRTTI_BSBound = (NiRTTI *)0x01B9C5F0;
const NiRTTI *	NiRTTI_BSMultiBoundNode = (NiRTTI *)0x01B9C66C;
const NiRTTI *	NiRTTI_BSAnimInteractionMarker = (NiRTTI *)0x01B9C674;
const NiRTTI *	NiRTTI_BSBoneMap = (NiRTTI *)0x01B9C684;
const NiRTTI *	NiRTTI_BSPSysMultiTargetEmitterCtlr = (NiRTTI *)0x01B9C690;
const NiRTTI *	NiRTTI_BSSceneGraph = (NiRTTI *)0x01B9C6A0;
const NiRTTI *	NiRTTI_BSGeometryListCullingProcess = (NiRTTI *)0x01B9DC60;
const NiRTTI *	NiRTTI_BSProceduralLightningController = (NiRTTI *)0x01B9DC6C;
const NiRTTI *	NiRTTI_BSInvMarker = (NiRTTI *)0x01B9DC74;
const NiRTTI *	NiRTTI_BSReference = (NiRTTI *)0x01B9DC84;
const NiRTTI *	NiRTTI_BSNodeReferences = (NiRTTI *)0x01B9DC8C;
const NiRTTI *	NiRTTI_BSNonUniformScaleExtraData = (NiRTTI *)0x01B9DC94;
const NiRTTI *	NiRTTI_BSLagBoneController = (NiRTTI *)0x01B9DCA0;
const NiRTTI *	NiRTTI_BSBoneLODExtraData = (NiRTTI *)0x01B9DCA8;
const NiRTTI *	NiRTTI_BSPSysScaleModifier = (NiRTTI *)0x01B9DCBC;
const NiRTTI *	NiRTTI_BSPSysSubTexModifier = (NiRTTI *)0x01B9DCCC;
const NiRTTI *	NiRTTI_BSPSysStripUpdateModifier = (NiRTTI *)0x01B9DCD4;
const NiRTTI *	NiRTTI_BSMultiBoundCapsule = (NiRTTI *)0x01B9DCDC;
const NiRTTI *	NiRTTI_BSMasterParticleSystem = (NiRTTI *)0x01B9DCE4;
const NiRTTI *	NiRTTI_BSWArray = (NiRTTI *)0x01B9DCEC;
const NiRTTI *	NiRTTI_BSParentVelocityModifier = (NiRTTI *)0x01B9DCF8;
const NiRTTI *	NiRTTI_BSDecalPlacementVectorExtraData = (NiRTTI *)0x01B9DD00;
const NiRTTI *	NiRTTI_BSNiNode = (NiRTTI *)0x01B9DD08;
const NiRTTI *	NiRTTI_BSInstanceTriShape = (NiRTTI *)0x01B9DD10;
const NiRTTI *	NiRTTI_BSMultiIndexTriShape = (NiRTTI *)0x01B9DD18;
const NiRTTI *	NiRTTI_BSLODMultiIndexTriShape = (NiRTTI *)0x01B9DD20;
const NiRTTI *	NiRTTI_BSFadeNode = (NiRTTI *)0x01BA72B8;
const NiRTTI *	NiRTTI_BSShaderProperty = (NiRTTI *)0x01BA743C;
const NiRTTI *	NiRTTI_BSTreeNode = (NiRTTI *)0x01BA7444;
const NiRTTI *	NiRTTI_BSLeafAnimNode = (NiRTTI *)0x01BA7454;
const NiRTTI *	NiRTTI_ShadowSceneNode = (NiRTTI *)0x01BA81C4;
const NiRTTI *	NiRTTI_BSLightingShaderProperty = (NiRTTI *)0x01BA82E0;
const NiRTTI *	NiRTTI_BSGrassShaderProperty = (NiRTTI *)0x01BA8304;
const NiRTTI *	NiRTTI_BSShaderAccumulator = (NiRTTI *)0x01BA8460;
const NiRTTI *	NiRTTI_BSGrassShader = (NiRTTI *)0x01BA848C;
const NiRTTI *	NiRTTI_BSEffectShaderProperty = (NiRTTI *)0x01BA849C;
const NiRTTI *	NiRTTI_BSWaterShaderProperty = (NiRTTI *)0x01BA84B4;
const NiRTTI *	NiRTTI_BSBloodSplatterShader = (NiRTTI *)0x01BA84DC;
const NiRTTI *	NiRTTI_BSBloodSplatterShaderProperty = (NiRTTI *)0x01BA84E4;
const NiRTTI *	NiRTTI_BSParticleShaderProperty = (NiRTTI *)0x01BA8520;
const NiRTTI *	NiRTTI_BSParticleShaderGeometry = (NiRTTI *)0x01BA8528;
const NiRTTI *	NiRTTI_BSLightingShader = (NiRTTI *)0x01BA857C;
const NiRTTI *	NiRTTI_BSTextureSet = (NiRTTI *)0x01BA85A8;
const NiRTTI *	NiRTTI_BSShaderTextureSet = (NiRTTI *)0x01BA85B0;
const NiRTTI *	NiRTTI_BSSkyShader = (NiRTTI *)0x01BA86B0;
const NiRTTI *	NiRTTI_BSSkyShaderProperty = (NiRTTI *)0x01BA87EC;
const NiRTTI *	NiRTTI_BSFadeNodeCuller = (NiRTTI *)0x01BA87F4;
const NiRTTI *	NiRTTI_BSEffectShader = (NiRTTI *)0x01BA880C;
const NiRTTI *	NiRTTI_BSDistantTreeShader = (NiRTTI *)0x01BA881C;
const NiRTTI *	NiRTTI_BSDistantTreeShaderProperty = (NiRTTI *)0x01BA8824;
const NiRTTI *	NiRTTI_BSWaterShader = (NiRTTI *)0x01BABDA8;
const NiRTTI *	NiRTTI_BSCubeMapCamera = (NiRTTI *)0x01BABDB0;
const NiRTTI *	NiRTTI_BSClearZNode = (NiRTTI *)0x01BABDC8;
const NiRTTI *	NiRTTI_BSFogProperty = (NiRTTI *)0x01BABDD0;
const NiRTTI *	NiRTTI_BSUtilityShader = (NiRTTI *)0x01BABE38;
const NiRTTI *	NiRTTI_BSParticleShader = (NiRTTI *)0x01BABEC0;
const NiRTTI *	NiRTTI_BSOrderedNode = (NiRTTI *)0x01BABEC8;
const NiRTTI *	NiRTTI_BSPSysLODModifier = (NiRTTI *)0x01BABED0;
const NiRTTI *	NiRTTI_BSPSysSimpleColorModifier = (NiRTTI *)0x01BABED8;
const NiRTTI *	NiRTTI_BSNiAlphaPropertyTestRefController = (NiRTTI *)0x01BABEE0;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyColorController = (NiRTTI *)0x01BABEEC;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyFloatController = (NiRTTI *)0x01BABF1C;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyColorController = (NiRTTI *)0x01BABF2C;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyUShortController = (NiRTTI *)0x01BABF3C;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyFloatController = (NiRTTI *)0x01BABFA8;
const NiRTTI *	NiRTTI_BSShader = (NiRTTI *)0x01BABFB8;
const NiRTTI *	NiRTTI_BSImagespaceShader = (NiRTTI *)0x01BAC054;
const NiRTTI *	NiRTTI_NiDX9Renderer = (NiRTTI *)0x01BAE458;
const NiRTTI *	NiRTTI_NiDX92DBufferData = (NiRTTI *)0x01BB099C;
const NiRTTI *	NiRTTI_NiDX9TextureBufferData = (NiRTTI *)0x01BB09A4;
const NiRTTI *	NiRTTI_NiDX9DepthStencilBufferData = (NiRTTI *)0x01BB09AC;
const NiRTTI *	NiRTTI_NiDX9ImplicitDepthStencilBufferData = (NiRTTI *)0x01BB09B4;
const NiRTTI *	NiRTTI_NiDX9Direct3DDepthStencilBufferData = (NiRTTI *)0x01BB09BC;
const NiRTTI *	NiRTTI_NiDX9AdditionalDepthStencilBufferData = (NiRTTI *)0x01BB09C4;
const NiRTTI *	NiRTTI_NiDX9OnscreenBufferData = (NiRTTI *)0x01BB09D8;
const NiRTTI *	NiRTTI_NiDX9ImplicitBufferData = (NiRTTI *)0x01BB09E0;
const NiRTTI *	NiRTTI_NiDX9SwapChainBufferData = (NiRTTI *)0x01BB09E8;
const NiRTTI *	NiRTTI_NiDX9SwapChainDepthStencilBufferData = (NiRTTI *)0x01BB09F0;
const NiRTTI *	NiRTTI_NiDX9Direct3DTexture = (NiRTTI *)0x01BB0A90;
const NiRTTI *	NiRTTI_NiDX9PersistentSrcTextureRendererData = (NiRTTI *)0x01BB0A98;
const NiRTTI *	NiRTTI_NiParticleSystem = (NiRTTI *)0x01BB0AC4;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlr = (NiRTTI *)0x01BB0AD4;
const NiRTTI *	NiRTTI_NiPSysGravityModifier = (NiRTTI *)0x01BB0AE4;
const NiRTTI *	NiRTTI_BSPSysHavokUpdateModifier = (NiRTTI *)0x01BB0AF4;
const NiRTTI *	NiRTTI_NiMeshParticleSystem = (NiRTTI *)0x01BB0B08;
const NiRTTI *	NiRTTI_NiPSysCylinderEmitter = (NiRTTI *)0x01BB0B28;
const NiRTTI *	NiRTTI_NiPSysData = (NiRTTI *)0x01BB0B38;
const NiRTTI *	NiRTTI_NiPSysEmitter = (NiRTTI *)0x01BB0B48;
const NiRTTI *	NiRTTI_BSStripParticleSystem = (NiRTTI *)0x01BB0B58;
const NiRTTI *	NiRTTI_NiPSysModifier = (NiRTTI *)0x01BB0B68;
const NiRTTI *	NiRTTI_NiPSysVolumeEmitter = (NiRTTI *)0x01BB0B78;
const NiRTTI *	NiRTTI_NiPSysModifierCtlr = (NiRTTI *)0x01BB0B88;
const NiRTTI *	NiRTTI_BSStripPSysData = (NiRTTI *)0x01BB0B98;
const NiRTTI *	NiRTTI_NiPSysMeshUpdateModifier = (NiRTTI *)0x01BB0BAC;
const NiRTTI *	NiRTTI_NiMeshPSysData = (NiRTTI *)0x01BB0BBC;
const NiRTTI *	NiRTTI_NiPSysUpdateCtlr = (NiRTTI *)0x01BB0BCC;
const NiRTTI *	NiRTTI_NiPSysMeshEmitter = (NiRTTI *)0x01BB0BEC;
const NiRTTI *	NiRTTI_BSPSysInheritVelocityModifier = (NiRTTI *)0x01BB0BFC;
const NiRTTI *	NiRTTI_BSPSysRecycleBoundModifier = (NiRTTI *)0x01BB0C10;
const NiRTTI *	NiRTTI_NiPSysVortexFieldModifier = (NiRTTI *)0x01BB0C20;
const NiRTTI *	NiRTTI_NiPSysTurbulenceFieldModifier = (NiRTTI *)0x01BB0C30;
const NiRTTI *	NiRTTI_NiPSysSphericalCollider = (NiRTTI *)0x01BB0C40;
const NiRTTI *	NiRTTI_NiPSysSphereEmitter = (NiRTTI *)0x01BB0C50;
const NiRTTI *	NiRTTI_NiPSysSpawnModifier = (NiRTTI *)0x01BB0C60;
const NiRTTI *	NiRTTI_NiPSysRotationModifier = (NiRTTI *)0x01BB0C78;
const NiRTTI *	NiRTTI_NiPSysResetOnLoopCtlr = (NiRTTI *)0x01BB0C88;
const NiRTTI *	NiRTTI_NiPSysRadialFieldModifier = (NiRTTI *)0x01BB0C98;
const NiRTTI *	NiRTTI_NiPSysPositionModifier = (NiRTTI *)0x01BB0CA8;
const NiRTTI *	NiRTTI_NiPSysPlanarCollider = (NiRTTI *)0x01BB0CC0;
const NiRTTI *	NiRTTI_NiPSysModifierActiveCtlr = (NiRTTI *)0x01BB0CD0;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedVarCtlr = (NiRTTI *)0x01BB0CE0;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedCtlr = (NiRTTI *)0x01BB0CF0;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleVarCtlr = (NiRTTI *)0x01BB0D00;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleCtlr = (NiRTTI *)0x01BB0D10;
const NiRTTI *	NiRTTI_NiPSysGrowFadeModifier = (NiRTTI *)0x01BB0D20;
const NiRTTI *	NiRTTI_NiPSysGravityStrengthCtlr = (NiRTTI *)0x01BB0D30;
const NiRTTI *	NiRTTI_NiPSysGravityFieldModifier = (NiRTTI *)0x01BB0D40;
const NiRTTI *	NiRTTI_NiPSysFieldMaxDistanceCtlr = (NiRTTI *)0x01BB0D50;
const NiRTTI *	NiRTTI_NiPSysFieldMagnitudeCtlr = (NiRTTI *)0x01BB0D60;
const NiRTTI *	NiRTTI_NiPSysFieldAttenuationCtlr = (NiRTTI *)0x01BB0D70;
const NiRTTI *	NiRTTI_NiPSysEmitterSpeedCtlr = (NiRTTI *)0x01BB0D80;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleVarCtlr = (NiRTTI *)0x01BB0D90;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleCtlr = (NiRTTI *)0x01BB0DA0;
const NiRTTI *	NiRTTI_NiPSysEmitterLifeSpanCtlr = (NiRTTI *)0x01BB0DB0;
const NiRTTI *	NiRTTI_NiPSysEmitterInitialRadiusCtlr = (NiRTTI *)0x01BB0DC0;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationVarCtlr = (NiRTTI *)0x01BB0DD0;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationCtlr = (NiRTTI *)0x01BB0DE0;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlrData = (NiRTTI *)0x01BB0DE8;
const NiRTTI *	NiRTTI_NiPSysDragModifier = (NiRTTI *)0x01BB0DF8;
const NiRTTI *	NiRTTI_NiPSysDragFieldModifier = (NiRTTI *)0x01BB0E08;
const NiRTTI *	NiRTTI_NiPSysColorModifier = (NiRTTI *)0x01BB0E18;
const NiRTTI *	NiRTTI_NiPSysColliderManager = (NiRTTI *)0x01BB0E28;
const NiRTTI *	NiRTTI_NiPSysBoxEmitter = (NiRTTI *)0x01BB0E38;
const NiRTTI *	NiRTTI_NiPSysBoundUpdateModifier = (NiRTTI *)0x01BB0E48;
const NiRTTI *	NiRTTI_NiPSysBombModifier = (NiRTTI *)0x01BB0E58;
const NiRTTI *	NiRTTI_NiPSysAgeDeathModifier = (NiRTTI *)0x01BB0E68;
const NiRTTI *	NiRTTI_NiPSysAirFieldSpreadCtlr = (NiRTTI *)0x01BB0E78;
const NiRTTI *	NiRTTI_NiPSysAirFieldModifier = (NiRTTI *)0x01BB0E88;
const NiRTTI *	NiRTTI_NiPSysAirFieldInheritVelocityCtlr = (NiRTTI *)0x01BB0E98;
const NiRTTI *	NiRTTI_NiPSysAirFieldAirFrictionCtlr = (NiRTTI *)0x01BB0EA8;
const NiRTTI *	NiRTTI_NiPSysFieldModifier = (NiRTTI *)0x01BB0EB8;
const NiRTTI *	NiRTTI_NiPSysCollider = (NiRTTI *)0x01BB0EC8;
const NiRTTI *	NiRTTI_NiPSysModifierBoolCtlr = (NiRTTI *)0x01BB0ED8;
const NiRTTI *	NiRTTI_NiPSysModifierFloatCtlr = (NiRTTI *)0x01BB0EE8;
const NiRTTI *	NiRTTI_bhkWorldObject = (NiRTTI *)0x01BB0EFC;
const NiRTTI *	NiRTTI_bhkCollisionObject = (NiRTTI *)0x01BB0F04;
const NiRTTI *	NiRTTI_bhkWorld = (NiRTTI *)0x01BB5E2C;
const NiRTTI *	NiRTTI_bhkNiCollisionObject = (NiRTTI *)0x01BB6A98;
const NiRTTI *	NiRTTI_bhkAttachmentCollisionObject = (NiRTTI *)0x01BB6B80;
const NiRTTI *	NiRTTI_WeaponObject = (NiRTTI *)0x01BB6B90;
const NiRTTI *	NiRTTI_bhkRigidBody = (NiRTTI *)0x01BB6BA4;
const NiRTTI *	NiRTTI_bhkWorldM = (NiRTTI *)0x01BB6BD0;
const NiRTTI *	NiRTTI_bhkPCollisionObject = (NiRTTI *)0x01BB6BF0;
const NiRTTI *	NiRTTI_bhkRefObject = (NiRTTI *)0x01BB6C00;
const NiRTTI *	NiRTTI_bhkSerializable = (NiRTTI *)0x01BB6C08;
const NiRTTI *	NiRTTI_bhkShape = (NiRTTI *)0x01BB6C24;
const NiRTTI *	NiRTTI_bhkEntity = (NiRTTI *)0x01BB6C30;
const NiRTTI *	NiRTTI_bhkPhantom = (NiRTTI *)0x01BB6C3C;
const NiRTTI *	NiRTTI_bhkAabbPhantom = (NiRTTI *)0x01BB6C48;
const NiRTTI *	NiRTTI_bhkSphereRepShape = (NiRTTI *)0x01BB6C54;
const NiRTTI *	NiRTTI_bhkConvexShape = (NiRTTI *)0x01BB6C60;
const NiRTTI *	NiRTTI_bhkShapePhantom = (NiRTTI *)0x01BB6C80;
const NiRTTI *	NiRTTI_bhkSimpleShapePhantom = (NiRTTI *)0x01BB6C94;
const NiRTTI *	NiRTTI_hkPackedNiTriStripsData = (NiRTTI *)0x01BB6C9C;
const NiRTTI *	NiRTTI_bhkBvTreeShape = (NiRTTI *)0x01BB6CBC;
const NiRTTI *	NiRTTI_bhkPackedNiTriStripsShape = (NiRTTI *)0x01BB6CC8;
const NiRTTI *	NiRTTI_bhkNiTriStripsShape = (NiRTTI *)0x01BB6CD4;
const NiRTTI *	NiRTTI_bhkCapsuleShape = (NiRTTI *)0x01BB6CF0;
const NiRTTI *	NiRTTI_bhkRigidBodyT = (NiRTTI *)0x01BB6D4C;
const NiRTTI *	NiRTTI_bhkBlendCollisionObject = (NiRTTI *)0x01BB6D5C;
const NiRTTI *	NiRTTI_bhkBoxShape = (NiRTTI *)0x01BB6D78;
const NiRTTI *	NiRTTI_bhkSphereShape = (NiRTTI *)0x01BB6D90;
const NiRTTI *	NiRTTI_bhkAvoidBox = (NiRTTI *)0x01BB6DA8;
const NiRTTI *	NiRTTI_bhkMalleableConstraint = (NiRTTI *)0x01BB6DD8;
const NiRTTI *	NiRTTI_bhkLimitedHingeConstraint = (NiRTTI *)0x01BB6DE4;
const NiRTTI *	NiRTTI_bhkConstraint = (NiRTTI *)0x01BB6DF8;
const NiRTTI *	NiRTTI_bhkPrismaticConstraint = (NiRTTI *)0x01BB831C;
const NiRTTI *	NiRTTI_bhkAction = (NiRTTI *)0x01BB8328;
const NiRTTI *	NiRTTI_bhkUnaryAction = (NiRTTI *)0x01BB8334;
const NiRTTI *	NiRTTI_bhkTriSampledHeightFieldBvTreeShape = (NiRTTI *)0x01BB8340;
const NiRTTI *	NiRTTI_bhkCachingShapePhantom = (NiRTTI *)0x01BB8380;
const NiRTTI *	NiRTTI_bhkSPCollisionObject = (NiRTTI *)0x01BB8390;
const NiRTTI *	NiRTTI_bhkRagdollTemplateData = (NiRTTI *)0x01BB83A0;
const NiRTTI *	NiRTTI_bhkRagdollTemplate = (NiRTTI *)0x01BB83A8;
const NiRTTI *	NiRTTI_bhkMouseSpringAction = (NiRTTI *)0x01BB83EC;
const NiRTTI *	NiRTTI_bhkHingeConstraint = (NiRTTI *)0x01BB83FC;
const NiRTTI *	NiRTTI_bhkGroupConstraint = (NiRTTI *)0x01BBA24C;
const NiRTTI *	NiRTTI_bhkPoseArray = (NiRTTI *)0x01BBA254;
const NiRTTI *	NiRTTI_bhkExtraData = (NiRTTI *)0x01BBA25C;
const NiRTTI *	NiRTTI_bhkBlendController = (NiRTTI *)0x01BBA264;
const NiRTTI *	NiRTTI_bhkSpringAction = (NiRTTI *)0x01BBA270;
const NiRTTI *	NiRTTI_bhkOrientHingedBodyAction = (NiRTTI *)0x01BBA27C;
const NiRTTI *	NiRTTI_bhkMotorAction = (NiRTTI *)0x01BBA288;
const NiRTTI *	NiRTTI_bhkLiquidAction = (NiRTTI *)0x01BBA294;
const NiRTTI *	NiRTTI_bhkDashpotAction = (NiRTTI *)0x01BBA2B0;
const NiRTTI *	NiRTTI_bhkAngularDashpotAction = (NiRTTI *)0x01BBA2BC;
const NiRTTI *	NiRTTI_bhkBreakableConstraint = (NiRTTI *)0x01BBA2C8;
const NiRTTI *	NiRTTI_bhkWheelConstraint = (NiRTTI *)0x01BBA2D4;
const NiRTTI *	NiRTTI_bhkStiffSpringConstraint = (NiRTTI *)0x01BBA2E0;
const NiRTTI *	NiRTTI_bhkRagdollLimitsConstraint = (NiRTTI *)0x01BBA2EC;
const NiRTTI *	NiRTTI_bhkRagdollConstraint = (NiRTTI *)0x01BBA2F8;
const NiRTTI *	NiRTTI_bhkFixedConstraint = (NiRTTI *)0x01BBA30C;
const NiRTTI *	NiRTTI_bhkHingeLimitsConstraint = (NiRTTI *)0x01BBA318;
const NiRTTI *	NiRTTI_bhkBallSocketConstraintChain = (NiRTTI *)0x01BBA324;
const NiRTTI *	NiRTTI_bhkBallAndSocketConstraint = (NiRTTI *)0x01BBA330;
const NiRTTI *	NiRTTI_bhkListShape = (NiRTTI *)0x01BBA344;
const NiRTTI *	NiRTTI_bhkTransformShape = (NiRTTI *)0x01BBA358;
const NiRTTI *	NiRTTI_bhkMoppBvTreeShape = (NiRTTI *)0x01BBA368;
const NiRTTI *	NiRTTI_bhkTriangleShape = (NiRTTI *)0x01BBA374;
const NiRTTI *	NiRTTI_bhkPlaneShape = (NiRTTI *)0x01BBA384;
const NiRTTI *	NiRTTI_bhkMultiSphereShape = (NiRTTI *)0x01BBA394;
const NiRTTI *	NiRTTI_bhkCylinderShape = (NiRTTI *)0x01BBA3A8;
const NiRTTI *	NiRTTI_bhkConvexVerticesShape = (NiRTTI *)0x01BBA3B8;
const NiRTTI *	NiRTTI_bhkConvexTranslateShape = (NiRTTI *)0x01BBA3D0;
const NiRTTI *	NiRTTI_bhkConvexTransformShape = (NiRTTI *)0x01BBA3E0;
const NiRTTI *	NiRTTI_bhkConvexSweepShape = (NiRTTI *)0x01BBA3EC;
const NiRTTI *	NiRTTI_bhkCompressedMeshShape = (NiRTTI *)0x01BBA3F8;
const NiRTTI *	NiRTTI_bhkCompressedMeshShapeData = (NiRTTI *)0x01BBA400;
const NiRTTI *	NiRTTI_bhkGenericConstraint = (NiRTTI *)0x01BBA424;
const NiRTTI *	NiRTTI_bhkCollisionBox = (NiRTTI *)0x01BBA438;
const NiRTTI *	NiRTTI_bhkShapeCollection = (NiRTTI *)0x01BBA444;
const NiRTTI *	NiRTTI_bhkCharControllerShape = (NiRTTI *)0x01BBA464;
const NiRTTI *	NiRTTI_bhkPositionConstraintMotor = (NiRTTI *)0x01BBB584;
const NiRTTI *	NiRTTI_bhkVelocityConstraintMotor = (NiRTTI *)0x01BBB58C;
const NiRTTI *	NiRTTI_bhkSpringDamperConstraintMotor = (NiRTTI *)0x01BBB594;
const NiRTTI *	NiRTTI_bhkCharacterProxy = (NiRTTI *)0x01BBBCE4;
const NiRTTI *	NiRTTI_bhkCharacterRigidBody = (NiRTTI *)0x01BBBCFC;
const NiRTTI *	NiRTTI_bhkBinaryAction = (NiRTTI *)0x01BBCAF8;
const NiRTTI *	NiRTTI_bhkConstraintChain = (NiRTTI *)0x01BBCB04;
const NiRTTI *	NiRTTI_bhkHeightFieldShape = (NiRTTI *)0x01BBCB10;
const NiRTTI *	NiRTTI_bhkPointToPathConstraint = (NiRTTI *)0x01BBE53C;
const NiRTTI *	NiRTTI_NiCollisionData = (NiRTTI *)0x01BBE8F0;
const NiRTTI *	NiRTTI_NiDepthStencilBuffer = (NiRTTI *)0x01BBFB78;
const NiRTTI *	NiRTTI_NiRenderedCubeMap = (NiRTTI *)0x01BBFB88;
const NiRTTI *	NiRTTI_NiRenderTargetGroup = (NiRTTI *)0x01BBFB98;
const NiRTTI *	NiRTTI_NiRenderedTexture = (NiRTTI *)0x01BBFBAC;
const NiRTTI *	NiRTTI_NiShaderDeclaration = (NiRTTI *)0x01BBFBB4;
const NiRTTI *	NiRTTI_Ni2DBuffer = (NiRTTI *)0x01BBFBC4;
const NiRTTI *	NiRTTI_NiCollisionObject = (NiRTTI *)0x01BBFBD4;
const NiRTTI *	NiRTTI_BSTextureData = (NiRTTI *)0x01BBFBF4;
const NiRTTI *	NiRTTI_BSParabolicCullingProcess = (NiRTTI *)0x01BBFC00;
