/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirUtil {
    public static void copyToDir(Directory in, Directory out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String[] fileNames) throws DirectoryException {
        int i = 0;
        while (i < fileNames.length) {
            DirUtil.copyToDir(in, out, fileNames[i]);
            ++i;
        }
    }

    public static void copyToDir(Directory in, Directory out, String fileName) throws DirectoryException {
        try {
            if (in.containsDir(fileName)) {
                in.getDir(fileName).copyToDir(out.createDir(fileName));
            } else {
                BrutIO.copyAndClose(in.getFileInput(fileName), out.getFileOutput(fileName));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
    }

    public static void copyToDir(Directory in, File out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String[] fileNames) throws DirectoryException {
        int i = 0;
        while (i < fileNames.length) {
            DirUtil.copyToDir(in, out, fileNames[i]);
            ++i;
        }
    }

    public static void copyToDir(Directory in, File out, String fileName) throws DirectoryException {
        try {
            if (in.containsDir(fileName)) {
                OS.rmdir(new File(out, fileName));
                in.getDir(fileName).copyToDir(new File(out, fileName));
            } else {
                File outFile = new File(out, fileName);
                outFile.getParentFile().mkdirs();
                BrutIO.copyAndClose(in.getFileInput(fileName), new FileOutputStream(outFile));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
        catch (BrutException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
    }
}

