/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import brut.directory.ZipExtFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ZipRODirectory
extends AbstractDirectory {
    private ZipExtFile mZipFile;
    private String mPath;

    public ZipRODirectory(String zipFileName) throws DirectoryException {
        this(zipFileName, "");
    }

    public ZipRODirectory(File zipFile) throws DirectoryException {
        this(zipFile, "");
    }

    public ZipRODirectory(ZipExtFile zipFile) {
        this(zipFile, "");
    }

    public ZipRODirectory(String zipFileName, String path) throws DirectoryException {
        this(new File(zipFileName), path);
    }

    public ZipRODirectory(File zipFile, String path) throws DirectoryException {
        try {
            this.mZipFile = new ZipExtFile(zipFile);
        }
        catch (IOException e) {
            throw new DirectoryException(e);
        }
        this.mPath = path;
    }

    public ZipRODirectory(ZipExtFile zipFile, String path) {
        this.mZipFile = zipFile;
        this.mPath = path;
    }

    @Override
    protected AbstractDirectory createDirLocal(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputStream getFileInputLocal(String name) throws DirectoryException {
        try {
            this.mZipFile.getEntry(String.valueOf(this.getPath()) + name).getGeneralPurposeBit().useEncryption(false);
            return this.getZipFile().getInputStream(this.mZipFile.getEntry(String.valueOf(this.getPath()) + name));
        }
        catch (IOException e) {
            throw new PathNotExist(name, e);
        }
    }

    @Override
    protected OutputStream getFileOutputLocal(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void loadDirs() {
        this.loadAll();
    }

    @Override
    protected void loadFiles() {
        this.loadAll();
    }

    @Override
    protected void removeFileLocal(String name) {
        throw new UnsupportedOperationException();
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        int prefixLen = this.getPath().length();
        Enumeration entries = this.getZipFile().getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            entry.getGeneralPurposeBit().useEncryption(false);
            String name = entry.getName();
            if (name.equals(this.getPath()) || !name.startsWith(this.getPath())) continue;
            String subname = name.substring(prefixLen);
            int pos = subname.indexOf(47);
            if (pos == -1) {
                if (!entry.isDirectory()) {
                    this.mFiles.add(subname);
                    continue;
                }
            } else {
                subname = subname.substring(0, pos);
            }
            if (this.mDirs.containsKey(subname)) continue;
            ZipRODirectory dir = new ZipRODirectory(this.getZipFile(), String.valueOf(this.getPath()) + subname + '/');
            this.mDirs.put(subname, dir);
        }
    }

    private String getPath() {
        return this.mPath;
    }

    private ZipExtFile getZipFile() {
        return this.mZipFile;
    }
}

