/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class OS {
    public static void rmdir(File dir) throws BrutException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                OS.rmdir(file);
            } else {
                file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static void rmfile(String file) throws BrutException {
        File del = new File(file);
        del.delete();
    }

    public static void rmdir(String dir) throws BrutException {
        OS.rmdir(new File(dir));
    }

    public static void cpdir(File src, File dest) throws BrutException {
        dest.mkdirs();
        File[] files = src.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            File destFile = new File(String.valueOf(dest.getPath()) + File.separatorChar + file.getName());
            if (file.isDirectory()) {
                OS.cpdir(file, destFile);
            } else {
                try {
                    FileInputStream in = new FileInputStream(file);
                    FileOutputStream out = new FileOutputStream(destFile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    throw new BrutException("Could not copy file: " + file, ex);
                }
            }
            ++i;
        }
    }

    public static void cpdir(String src, String dest) throws BrutException {
        OS.cpdir(new File(src), new File(dest));
    }

    public static void exec(String[] cmd) throws BrutException {
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(cmd);
            new StreamForwarder(ps.getInputStream(), System.err).start();
            new StreamForwarder(ps.getErrorStream(), System.err).start();
            if (ps.waitFor() != 0) {
                throw new BrutException("could not exec command: " + Arrays.toString(cmd));
            }
        }
        catch (IOException ex) {
            throw new BrutException("could not exec command: " + Arrays.toString(cmd), ex);
        }
        catch (InterruptedException ex) {
            throw new BrutException("could not exec command: " + Arrays.toString(cmd), ex);
        }
    }

    public static File createTempDirectory() throws BrutException {
        try {
            File tmp = File.createTempFile("BRUT", null);
            if (!tmp.delete()) {
                throw new BrutException("Could not delete tmp file: " + tmp.getAbsolutePath());
            }
            if (!tmp.mkdir()) {
                throw new BrutException("Could not create tmp dir: " + tmp.getAbsolutePath());
            }
            return tmp;
        }
        catch (IOException ex) {
            throw new BrutException("Could not create tmp dir", ex);
        }
    }

    static class StreamForwarder
    extends Thread {
        private final InputStream mIn;
        private final OutputStream mOut;

        public StreamForwarder(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.mIn));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.mOut));
                while ((line = in.readLine()) != null) {
                    out.write(line);
                    out.newLine();
                }
                out.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

