/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar;

import java.util.Arrays;

public class Method {
    private String desc;
    private String name;
    private String owner;
    private String[] parameterTypes;
    private String returnType;

    public Method(String owner, String name, String[] parameterTypes, String returnType) {
        this.owner = owner;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public String getDesc() {
        if (this.desc == null) {
            StringBuilder ps = new StringBuilder("(");
            if (this.parameterTypes != null) {
                String[] stringArray = this.parameterTypes;
                int n = this.parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    ps.append(t);
                    ++n2;
                }
            }
            ps.append(")").append(this.returnType);
            this.desc = ps.toString();
        }
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public String toString() {
        return String.valueOf(this.getOwner()) + "." + this.getName() + this.getDesc();
    }
}

