/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.reader.io.DataIn;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(DataIn in, StringBuilder sb) throws UTFDataFormatException {
        sb.setLength(0);
        while (true) {
            int b;
            char a;
            if ((a = (char)in.readUByte()) == '\u0000') {
                return sb.toString();
            }
            if (a < '\u0080') {
                sb.append(a);
                continue;
            }
            if ((a & 0xE0) == 192) {
                b = in.readUByte();
                if ((b & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                sb.append((char)((a & 0x1F) << 6 | b & 0x3F));
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = in.readUByte();
            int c = in.readUByte();
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            sb.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (shortLength && result > 65535L) {
                throw new UTFDataFormatException("String more than 65535 UTF bytes long");
            }
            ++i;
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
            } else if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
            } else {
                dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
                dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
            }
            ++i;
        }
    }

    public static byte[] encode(String s) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s);
        return result;
    }
}

