/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import ds.tree.RadixTree;
import ds.tree.RadixTreeImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ClassFileNameHandler {
    private static final int MAX_FILENAME_LENGTH = 245;
    private PackageNameEntry top;
    private String fileExtension;
    private boolean modifyWindowsReservedFilenames;
    private static Pattern reservedFileNameRegex = Pattern.compile("^CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9]$", 2);

    public ClassFileNameHandler(File path, String fileExtension) {
        this.top = new PackageNameEntry(path);
        this.fileExtension = fileExtension;
        this.modifyWindowsReservedFilenames = ClassFileNameHandler.testForWindowsReservedFileNames(path);
    }

    public File getUniqueFilenameForClass(String className) {
        if (className.charAt(0) != 'L' || className.charAt(className.length() - 1) != ';') {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        int packageElementCount = 1;
        int i = 1;
        while (i < className.length() - 1) {
            if (className.charAt(i) == '/') {
                ++packageElementCount;
            }
            ++i;
        }
        String[] packageElements = new String[packageElementCount];
        int elementIndex = 0;
        int elementStart = 1;
        int i2 = 1;
        while (i2 < className.length() - 1) {
            if (className.charAt(i2) == '/') {
                if (i2 - elementStart == 0) {
                    throw new RuntimeException("Not a valid dalvik class name");
                }
                String packageElement = className.substring(elementStart, i2);
                if (this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(packageElement)) {
                    packageElement = String.valueOf(packageElement) + "#";
                }
                if (packageElement.length() > 245) {
                    packageElement = ClassFileNameHandler.shortenPathComponent(packageElement, 245);
                }
                packageElements[elementIndex++] = packageElement;
                elementStart = ++i2;
            }
            ++i2;
        }
        if (elementStart >= className.length() - 1) {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        String packageElement = className.substring(elementStart, className.length() - 1);
        if (this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(packageElement)) {
            packageElement = String.valueOf(packageElement) + "#";
        }
        if (packageElement.length() + this.fileExtension.length() > 245) {
            packageElement = ClassFileNameHandler.shortenPathComponent(packageElement, 245 - this.fileExtension.length());
        }
        packageElements[elementIndex] = packageElement;
        return this.top.addUniqueChild(packageElements, 0);
    }

    @Nonnull
    static String shortenPathComponent(@Nonnull String pathComponent, int maxLength) {
        int toRemove = pathComponent.length() - maxLength + 1;
        int firstIndex = pathComponent.length() / 2 - toRemove / 2;
        return String.valueOf(pathComponent.substring(0, firstIndex)) + "#" + pathComponent.substring(firstIndex + toRemove);
    }

    private static boolean testForWindowsReservedFileNames(File path) {
        String[] reservedNames;
        String[] stringArray = reservedNames = new String[]{"aux", "con", "com1", "com9", "lpt1", "com9"};
        int n = reservedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedName = stringArray[n2];
            File f = new File(path, String.valueOf(reservedName) + ".smali");
            if (!f.exists()) {
                try {
                    FileWriter writer = new FileWriter(f);
                    writer.write("test");
                    writer.flush();
                    writer.close();
                    f.delete();
                }
                catch (IOException ex) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isReservedFileName(String className) {
        return reservedFileNameRegex.matcher(className).matches();
    }

    private class ClassNameEntry
    extends FileSystemEntry {
        public ClassNameEntry(File parent, String name) {
            super(new File(parent, name));
        }

        @Override
        public File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            assert (false);
            return this.file;
        }
    }

    private abstract class FileSystemEntry {
        public final File file;

        public FileSystemEntry(File file) {
            this.file = file;
        }

        public abstract File addUniqueChild(String[] var1, int var2);

        public FileSystemEntry makeVirtual(File parent) {
            return new VirtualGroupEntry(this, parent);
        }
    }

    private class PackageNameEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> children;

        public PackageNameEntry(File parent, String name) {
            super(new File(parent, name));
            this.children = new RadixTreeImpl<FileSystemEntry>();
        }

        public PackageNameEntry(File path) {
            super(path);
            this.children = new RadixTreeImpl<FileSystemEntry>();
        }

        @Override
        public synchronized File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            String elementName;
            if (pathElementsIndex == pathElements.length - 1) {
                elementName = pathElements[pathElementsIndex];
                elementName = String.valueOf(elementName) + ClassFileNameHandler.this.fileExtension;
            } else {
                elementName = pathElements[pathElementsIndex];
            }
            String elementNameLower = elementName.toLowerCase();
            FileSystemEntry existingEntry = this.children.find(elementNameLower);
            if (existingEntry != null) {
                FileSystemEntry virtualEntry = existingEntry;
                if (!(existingEntry instanceof VirtualGroupEntry)) {
                    if (existingEntry.file.getName().equals(elementName)) {
                        if (pathElementsIndex == pathElements.length - 1) {
                            return existingEntry.file;
                        }
                        return existingEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
                    }
                    virtualEntry = existingEntry.makeVirtual(this.file);
                    this.children.replace(elementNameLower, virtualEntry);
                }
                return virtualEntry.addUniqueChild(pathElements, pathElementsIndex);
            }
            if (pathElementsIndex == pathElements.length - 1) {
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, elementName);
                this.children.insert(elementNameLower, classNameEntry);
                return classNameEntry.file;
            }
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, elementName);
            this.children.insert(elementNameLower, packageNameEntry);
            return packageNameEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
        }
    }

    private class VirtualGroupEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> groupEntries;
        private int isCaseSensitive;

        public VirtualGroupEntry(FileSystemEntry firstChild, File parent) {
            super(parent);
            this.groupEntries = new RadixTreeImpl<FileSystemEntry>();
            this.isCaseSensitive = -1;
            this.groupEntries.insert(firstChild.file.getName(), firstChild);
        }

        @Override
        public File addUniqueChild(String[] pathElements, int pathElementsIndex) {
            FileSystemEntry existingEntry;
            String elementName = pathElements[pathElementsIndex];
            if (pathElementsIndex == pathElements.length - 1) {
                elementName = String.valueOf(elementName) + ClassFileNameHandler.this.fileExtension;
            }
            if ((existingEntry = this.groupEntries.find(elementName)) != null) {
                if (pathElementsIndex == pathElements.length - 1) {
                    return existingEntry.file;
                }
                return existingEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
            }
            if (pathElementsIndex == pathElements.length - 1) {
                String fileName = !this.isCaseSensitive() ? String.valueOf(pathElements[pathElementsIndex]) + "." + (this.groupEntries.getSize() + 1L) + ClassFileNameHandler.this.fileExtension : elementName;
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, fileName);
                this.groupEntries.insert(elementName, classNameEntry);
                return classNameEntry.file;
            }
            String fileName = !this.isCaseSensitive() ? String.valueOf(pathElements[pathElementsIndex]) + "." + (this.groupEntries.getSize() + 1L) : elementName;
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, fileName);
            this.groupEntries.insert(elementName, packageNameEntry);
            return packageNameEntry.addUniqueChild(pathElements, pathElementsIndex + 1);
        }

        private boolean isCaseSensitive() {
            if (this.isCaseSensitive != -1) {
                return this.isCaseSensitive == 1;
            }
            File path = this.file;
            if (path.exists() && path.isFile()) {
                path = path.getParentFile();
            }
            if (!this.file.exists() && !this.file.mkdirs()) {
                return false;
            }
            try {
                boolean result = this.testCaseSensitivity(path);
                this.isCaseSensitive = result ? 1 : 0;
                return result;
            }
            catch (IOException ex) {
                return false;
            }
        }

        /*
         * Loose catch block
         */
        private boolean testCaseSensitivity(File path) throws IOException {
            File f2;
            File f;
            block40: {
                block39: {
                    block38: {
                        block37: {
                            int num = 1;
                            do {
                                f = new File(path, "test." + num);
                                f2 = new File(path, "TEST." + num++);
                            } while (f.exists() || f2.exists());
                            try {
                                FileWriter writer = new FileWriter(f);
                                writer.write("test");
                                writer.flush();
                                writer.close();
                            }
                            catch (IOException ex) {
                                try {
                                    f.delete();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw ex;
                            }
                            if (!f2.exists()) break block37;
                            try {
                                f.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                f2.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return false;
                        }
                        if (!f2.createNewFile()) break block38;
                        try {
                            f.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            f2.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return true;
                    }
                    CharBuffer buf = CharBuffer.allocate(32);
                    FileReader reader = new FileReader(f2);
                    while (reader.read(buf) != -1 && buf.length() < 4) {
                    }
                    if (buf.length() != 4 || !buf.toString().equals("test")) break block39;
                    try {
                        f.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        f2.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
                if ($assertionsDisabled) break block40;
                throw new AssertionError();
            }
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                f2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
            catch (FileNotFoundException ex) {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    f2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
                catch (Throwable throwable) {
                    try {
                        f.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        f2.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        @Override
        public FileSystemEntry makeVirtual(File parent) {
            return this;
        }
    }
}

