/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.Hex;

public final class Utf8Utils {
    private static final ThreadLocal<char[]> localBuffer = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                bytes[outAt] = (byte)c;
                ++outAt;
            } else if (c < '\u0800') {
                bytes[outAt] = (byte)(c >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c & 0x3F | 0x80);
                outAt += 2;
            } else {
                bytes[outAt] = (byte)(c >> 12 & 0xF | 0xE0);
                bytes[outAt + 1] = (byte)(c >> 6 & 0x3F | 0x80);
                bytes[outAt + 2] = (byte)(c & 0x3F | 0x80);
                outAt += 3;
            }
            ++i;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(byte[] bytes, int start, int length) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < length) {
            chars = new char[length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at = start;
        while (length > 0) {
            char out;
            int v0 = bytes[at] & 0xFF;
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v0 == 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int v2 = bytes[at + 2] & 0xFF;
                    if ((v2 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v0, at);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length) {
        return Utf8Utils.utf8BytesWithUtf16LengthToString(bytes, start, utf16Length, null);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length, @Nullable int[] readLength) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < utf16Length) {
            chars = new char[utf16Length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at = 0;
        at = start;
        while (utf16Length > 0) {
            char out;
            int v0 = bytes[at] & 0xFF;
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (v0 == 0) {
                        return Utf8Utils.throwBadUtf8(v0, at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    int v1 = bytes[at + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at + 1);
                    }
                    int v2 = bytes[at + 2] & 0xFF;
                    if ((v2 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v2, at + 2);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v0, at);
                }
            }
            chars[outAt] = out;
            ++outAt;
            --utf16Length;
        }
        if (readLength != null && readLength.length > 0) {
            readLength[0] = at - start;
            readLength[0] = at - start;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }
}

