/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter__
extends Writer {
    protected final Writer writer;
    protected final char[] buffer = new char[16];
    protected int indentLevel = 0;
    protected boolean beginningOfLine;
    protected static final String newLine = System.getProperty("line.separator");
    protected int line = 1;

    public int GetLine() {
        return this.line;
    }

    public IndentingWriter__(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(int chr) throws IOException {
        if (chr == 10) {
            this.writer.write(newLine);
            this.beginningOfLine = true;
            ++this.line;
        } else {
            if (this.beginningOfLine) {
                int i = 0;
                while (i < this.indentLevel) {
                    this.writer.write(32);
                    ++i;
                }
            }
            this.beginningOfLine = false;
            this.writer.write(chr);
        }
    }

    @Override
    public void write(char[] chars) throws IOException {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char chr = cArray[n2];
            this.write(chr);
            ++n2;
        }
    }

    @Override
    public void write(char[] chars, int start, int len) throws IOException {
        len = start + len;
        while (start < len) {
            this.write(chars[start++]);
        }
    }

    @Override
    public void write(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void write(String str, int start, int len) throws IOException {
        len = start + len;
        while (start < len) {
            this.write(str.charAt(start++));
        }
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.write(charSequence.toString());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int start, int len) throws IOException {
        this.write(charSequence.subSequence(start, len).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void indent(int indentAmount) {
        this.indentLevel += indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void deindent(int indentAmount) {
        this.indentLevel -= indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void printLongAsHex(long value) throws IOException {
        int bufferIndex = 0;
        do {
            int digit;
            this.buffer[bufferIndex++] = (digit = (int)(value & 0xFL)) < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97);
        } while ((value >>>= 4) != 0L);
        while (bufferIndex > 0) {
            this.write(this.buffer[--bufferIndex]);
        }
    }

    public void printIntAsDec(int value) throws IOException {
        int bufferIndex = 0;
        boolean negative = value < 0;
        do {
            int digit = value % 10;
            this.buffer[bufferIndex++] = (char)(digit + 48);
        } while ((value /= 10) != 0);
        if (negative) {
            this.write(45);
        }
        while (bufferIndex > 0) {
            this.write(this.buffer[--bufferIndex]);
        }
    }
}

