/*
 * Decompiled with CFR 0.152.
 */
package com.sv.smali.Item;

import com.sv.smali.ClrMethodItem;
import com.sv.smali.ClrRender.ClrLongRenderer;
import com.sv.smali.ClrRender.ClrReferenceFormatter;
import com.sv.smali.MethodDefine;
import com.sv.view.SmaliTextWriter;
import java.io.Serializable;
import org.jf.dexlib2.ReferenceType;
import org.jf.dexlib2.VerificationError;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.instruction.FieldOffsetInstruction;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.VtableIndexInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.UnknownInstruction;
import org.jf.dexlib2.iface.reference.Reference;

public class ItemInstructionMethod
extends ClrMethodItem
implements Serializable {
    protected final MethodDefine methodDef;
    public final Instruction instruction;

    public ItemInstructionMethod(MethodDefine methodDefine, int n2, Instruction instruction) {
        super(n2);
        this.methodDef = methodDefine;
        this.instruction = instruction;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    @Override
    public boolean writeTo(SmaliTextWriter smaliTextWriter) {
        boolean bl = false;
        if (this.instruction instanceof ReferenceInstruction) {
            try {
                Reference reference = ((ReferenceInstruction)this.instruction).getReference();
            }
            catch (DexBackedDexFile.InvalidItemIndex invalidItemIndex) {
                bl = true;
                smaliTextWriter.write("#invalid ");
                smaliTextWriter.write(ReferenceType.toString(this.instruction.getOpcode().referenceType));
                smaliTextWriter.write(" index: ");
                smaliTextWriter.printIntAsDec(invalidItemIndex.getInvalidIndex(), SmaliTextWriter.CLRLABEL);
                smaliTextWriter.write("#");
            }
        }
        switch (this.instruction.getOpcode().format) {
            case Format10t: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeTargetLabel(smaliTextWriter);
                return true;
            }
            case Format10x: {
                if (this.instruction instanceof UnknownInstruction) {
                    smaliTextWriter.write("#unknown opcode: 0x");
                    smaliTextWriter.printUnsignedLongAsHex(((UnknownInstruction)this.instruction).getOriginalOpcode(), SmaliTextWriter.CLRLABEL);
                    smaliTextWriter.write(10);
                }
                this.writeOpcode(smaliTextWriter);
                return true;
            }
            case Format11n: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeLiteral(smaliTextWriter);
                return true;
            }
            case Format11x: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                return true;
            }
            case Format12x: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                return true;
            }
            case Format20bc: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeVerificationErrorType(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeReference(smaliTextWriter);
                return true;
            }
            case Format20t: 
            case Format30t: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeTargetLabel(smaliTextWriter);
                return true;
            }
            case Format21c: 
            case Format31c: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeReference(smaliTextWriter);
                return true;
            }
            case Format21ih: 
            case Format21lh: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeLiteral(smaliTextWriter);
                return true;
            }
            case Format21t: 
            case Format31t: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeTargetLabel(smaliTextWriter);
                return true;
            }
            case Format22b: 
            case Format22s: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeLiteral(smaliTextWriter);
                return true;
            }
            case Format22c: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeReference(smaliTextWriter);
                return true;
            }
            case Format22cs: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeFieldOffset(smaliTextWriter);
                return true;
            }
            case Format22t: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeTargetLabel(smaliTextWriter);
                return true;
            }
            case Format22x: 
            case Format32x: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                return true;
            }
            case Format23x: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeFirstRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeSecondRegister(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeThirdRegister(smaliTextWriter);
                return true;
            }
            case Format35c: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeReference(smaliTextWriter);
                return true;
            }
            case Format35mi: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeInlineIndex(smaliTextWriter);
                return true;
            }
            case Format35ms: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeVtableIndex(smaliTextWriter);
                return true;
            }
            case Format3rc: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRangeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeReference(smaliTextWriter);
                return true;
            }
            case Format3rmi: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRangeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeInlineIndex(smaliTextWriter);
                return true;
            }
            case Format3rms: {
                this.writeOpcode(smaliTextWriter);
                smaliTextWriter.write(32);
                this.writeInvokeRangeRegisters(smaliTextWriter);
                smaliTextWriter.write(", ");
                this.writeVtableIndex(smaliTextWriter);
                return true;
            }
        }
        assert (false);
        return false;
    }

    public boolean writeTo1() {
        boolean bl = false;
        switch (this.instruction.getOpcode().format) {
            case Format10t: {
                return true;
            }
            case Format10x: {
                return true;
            }
            case Format11n: {
                this.writeLiteral1();
                return true;
            }
            case Format11x: {
                return true;
            }
            case Format12x: {
                return true;
            }
            case Format20bc: {
                return true;
            }
            case Format20t: 
            case Format30t: {
                return true;
            }
            case Format21c: 
            case Format31c: {
                return true;
            }
            case Format21ih: 
            case Format21lh: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeLiteral1();
                return true;
            }
            case Format21t: 
            case Format31t: {
                return true;
            }
            case Format22b: 
            case Format22s: {
                this.writeLiteral1();
                return true;
            }
            case Format22c: {
                return true;
            }
            case Format22cs: {
                return true;
            }
            case Format22t: {
                return true;
            }
            case Format22x: 
            case Format32x: {
                return true;
            }
            case Format23x: {
                return true;
            }
            case Format35c: {
                return true;
            }
            case Format35mi: {
                return true;
            }
            case Format35ms: {
                return true;
            }
            case Format3rc: {
                return true;
            }
            case Format3rmi: {
                return true;
            }
            case Format3rms: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    protected void writeOpcode(SmaliTextWriter smaliTextWriter) {
        SmaliTextWriter.beginningOfLine = true;
        smaliTextWriter.write(this.instruction.getOpcode().name, SmaliTextWriter.CLRINS);
    }

    protected void writeTargetLabel(SmaliTextWriter smaliTextWriter) {
        throw new RuntimeException();
    }

    protected void writeRegister(SmaliTextWriter smaliTextWriter, int n2) {
        MethodDefine.clrregisterFormatter.writeTo(smaliTextWriter, n2);
    }

    protected void writeFirstRegister(SmaliTextWriter smaliTextWriter) {
        this.writeRegister(smaliTextWriter, ((OneRegisterInstruction)this.instruction).getRegisterA());
    }

    protected void writeSecondRegister(SmaliTextWriter smaliTextWriter) {
        this.writeRegister(smaliTextWriter, ((TwoRegisterInstruction)this.instruction).getRegisterB());
    }

    public Instruction GetInstruction() {
        return this.instruction;
    }

    protected void writeThirdRegister(SmaliTextWriter smaliTextWriter) {
        this.writeRegister(smaliTextWriter, ((ThreeRegisterInstruction)this.instruction).getRegisterC());
    }

    protected void writeInvokeRegisters(SmaliTextWriter smaliTextWriter) {
        FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)this.instruction;
        int n2 = fiveRegisterInstruction.getRegisterCount();
        smaliTextWriter.write(123, SmaliTextWriter.CLRMEMNAME);
        switch (n2) {
            case 1: {
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterC());
                break;
            }
            case 2: {
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterC());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterD());
                break;
            }
            case 3: {
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterC());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterD());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterE());
                break;
            }
            case 4: {
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterC());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterD());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterE());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterF());
                break;
            }
            case 5: {
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterC());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterD());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterE());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterF());
                smaliTextWriter.write(", ");
                this.writeRegister(smaliTextWriter, fiveRegisterInstruction.getRegisterG());
            }
        }
        smaliTextWriter.write(125, SmaliTextWriter.CLRMEMNAME);
    }

    protected void writeInvokeRangeRegisters(SmaliTextWriter smaliTextWriter) {
        RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)this.instruction;
        int n2 = registerRangeInstruction.getRegisterCount();
        if (n2 == 0) {
            smaliTextWriter.write("{}");
        } else {
            int n3 = registerRangeInstruction.getStartRegister();
            MethodDefine.clrregisterFormatter.writeRegisterRange(smaliTextWriter, n3, n3 + n2 - 1);
        }
    }

    protected void writeLiteral1() {
        ClrLongRenderer.writeSignedIntOrLongTo1(((WideLiteralInstruction)this.instruction).getWideLiteral());
    }

    protected void writeLiteral(SmaliTextWriter smaliTextWriter) {
        ClrLongRenderer.writeSignedIntOrLongTo(smaliTextWriter, ((WideLiteralInstruction)this.instruction).getWideLiteral());
    }

    protected void writeFieldOffset(SmaliTextWriter smaliTextWriter) {
        smaliTextWriter.write("field@0x");
        smaliTextWriter.printUnsignedLongAsHex(((FieldOffsetInstruction)this.instruction).getFieldOffset());
    }

    protected void writeInlineIndex(SmaliTextWriter smaliTextWriter) {
        smaliTextWriter.write("inline@");
        smaliTextWriter.printIntAsDec(((InlineIndexInstruction)this.instruction).getInlineIndex(), SmaliTextWriter.CLRLABEL);
    }

    protected void writeVtableIndex(SmaliTextWriter smaliTextWriter) {
        smaliTextWriter.write("vtable@");
        smaliTextWriter.printIntAsDec(((VtableIndexInstruction)this.instruction).getVtableIndex(), SmaliTextWriter.CLRLABEL);
    }

    protected void writeReference(SmaliTextWriter smaliTextWriter) {
        try {
            ClrReferenceFormatter.writeReference(smaliTextWriter, this.instruction.getOpcode().referenceType, ((ReferenceInstruction)this.instruction).getReference());
        }
        catch (DexBackedDexFile.InvalidItemIndex invalidItemIndex) {
            smaliTextWriter.write(ReferenceType.toString(this.instruction.getOpcode().referenceType), SmaliTextWriter.CLRPREDEFINE);
            smaliTextWriter.write("@");
            smaliTextWriter.printIntAsDec(invalidItemIndex.getInvalidIndex(), SmaliTextWriter.CLRLABEL);
        }
    }

    protected void writeVerificationErrorType(SmaliTextWriter smaliTextWriter) {
        int n2 = ((Instruction20bc)this.instruction).getVerificationError();
        smaliTextWriter.write(VerificationError.getVerificationErrorName(n2));
    }
}

