/*
 * Decompiled with CFR 0.152.
 */
package com.sv.view.dialog;

import brut.directory.ZipExtFile;
import com.sv.view.AwtFrame;
import com.sv.view.GlobalConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import sun.security.pkcs.PKCS7;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CertDialog
extends JDialog {
    ZipExtFile dn = null;
    JTextPane do;

    public void insert(String string, AttributeSet attributeSet) {
        Document document = this.do.getDocument();
        try {
            document.insertString(document.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("BadLocationException:   " + badLocationException);
        }
    }

    public void setDocs(String string, Color color) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, 15);
        StyleConstants.setBackground(simpleAttributeSet, GlobalConfig.cBack);
        StyleConstants.setForeground(simpleAttributeSet, color);
        this.insert(string, simpleAttributeSet);
    }

    public CertDialog(Frame frame, String string) {
        super(frame, "Certification");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AwtFrame.class.getResource("/res/logo.png")));
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(800, 600);
        Point point = frame.getLocation();
        point.x += 100;
        point.y += 100;
        this.setLocation(point);
        try {
            this.dn = new ZipExtFile(string);
            Enumeration<ZipArchiveEntry> enumeration = this.dn.getEntries();
            int n2 = 0;
            this.do = new JTextPane();
            this.do.setBackground(GlobalConfig.cBack);
            JScrollPane jScrollPane = new JScrollPane(this.do);
            this.getContentPane().add((Component)jScrollPane, "Center");
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = enumeration.nextElement();
                String string2 = zipArchiveEntry.getName().toUpperCase();
                if (!string2.startsWith("META-INF/") || !string2.endsWith(".RSA") && !string2.endsWith(".DSA")) continue;
                ZipArchiveEntry zipArchiveEntry2 = this.dn.getEntry(string2);
                InputStream inputStream = this.dn.getInputStream(zipArchiveEntry2);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                try {
                    byte[] byArray = new byte[1024];
                    int n3 = 0;
                    while ((n3 = bufferedInputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n3);
                    }
                    bufferedInputStream.close();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    PKCS7 pKCS7 = new PKCS7(byArray2);
                    X509Certificate x509Certificate = pKCS7.getCertificates()[0];
                    this.setDocs(string2 + "\n", GlobalConfig.cBlue);
                    this.setDocs("Subject: \t" + x509Certificate.getSubjectDN() + "\n", GlobalConfig.cFore);
                    this.setDocs("Issuer:  \t" + x509Certificate.getIssuerDN() + "\n", GlobalConfig.cFore);
                    this.setDocs("StartTime: \t" + x509Certificate.getNotBefore() + "\n", GlobalConfig.cFore);
                    this.setDocs("EndTime: \t" + x509Certificate.getNotAfter() + "\n", GlobalConfig.cFore);
                    this.setDocs("Version:     \tV" + Integer.toString(x509Certificate.getVersion()) + "\n", GlobalConfig.cFore);
                    this.setDocs("Algorithm:     " + x509Certificate.getSigAlgName() + "\n", GlobalConfig.cFore);
                    this.setDocs("Algorithm OID:  " + x509Certificate.getSigAlgOID() + "\n", GlobalConfig.cFore);
                    this.setDocs("Type:     \t" + x509Certificate.getType() + "\n", GlobalConfig.cFore);
                    this.setDocs("Serial:   \t" + x509Certificate.getSerialNumber().toString(16) + "\n", GlobalConfig.cFore);
                    this.setDocs("PublicKey:\n" + x509Certificate.getPublicKey().toString() + "\n", GlobalConfig.cFore);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
            this.dn.close();
            if (n2 == 0) {
                this.setDocs("No Certification\n", Color.BLACK);
            } else if (n2 > 1) {
                this.setDocs(">>>>>>>>>>>>More Than One Certification>>>>>>>>>>>>>>>>>>>\n", Color.BLACK);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

