/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.androlib.ApktoolProperties;
import brut.androlib.java.AndrolibJava;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.SmaliBuilder;
import brut.androlib.src.SmaliDecoder;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ZipExtFile;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Androlib {
    private final AndrolibResources mAndRes = new AndrolibResources();
    private String mAaptPath = null;
    private Path mPath = null;
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private static final String SMALI_DIRNAME = "smali";
    private static final String APK_DIRNAME = "build/apk";
    private static final String UNK_DIRNAME = "unknown";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};
    private static final String[] APK_MANIFEST_FILENAMES = new String[]{"AndroidManifest.xml"};
    private static final String[] APK_STANDARD_ALL_FILENAMES = new String[]{"classes.dex", "AndroidManifest.xml", "resources.arsc", "res", "lib", "libs", "assets", "META-INF"};

    public ResTable getResTable(ExtFile apkFile) throws AndrolibException {
        return this.mAndRes.getResTable(apkFile, true);
    }

    public ResTable getResTable(ExtFile apkFile, boolean loadMainPkg) throws AndrolibException {
        return this.mAndRes.getResTable(apkFile, loadMainPkg);
    }

    public void decodeSourcesRaw(ExtFile apkFile, File outDir, boolean debug) throws AndrolibException {
        try {
            Directory apk = apkFile.getDirectory();
            LOGGER.info("Copying raw classes.dex file...");
            apkFile.getDirectory().copyToDir(outDir, "classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeSourcesSmali(File apkFile, File outDir, boolean debug, String debugLinePrefix, boolean bakdeb, int api) throws AndrolibException {
        try {
            File smaliDir = new File(outDir, SMALI_DIRNAME);
            OS.rmdir((File)smaliDir);
            smaliDir.mkdirs();
            LOGGER.info("Baksmaling...");
            SmaliDecoder.decode(apkFile, smaliDir, debug, debugLinePrefix, bakdeb, api);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeSourcesJava(ExtFile apkFile, File outDir, boolean debug) throws AndrolibException {
        LOGGER.info("Decoding Java sources...");
        new AndrolibJava().decode(apkFile, outDir);
    }

    public void decodeManifestRaw(ExtFile apkFile, File outDir) throws AndrolibException {
        try {
            Directory apk = apkFile.getDirectory();
            LOGGER.info("Copying raw manifest...");
            apkFile.getDirectory().copyToDir(outDir, APK_MANIFEST_FILENAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeManifestFull(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decodeManifest(resTable, apkFile, outDir);
    }

    public void decodeResourcesRaw(ExtFile apkFile, File outDir) throws AndrolibException {
        try {
            LOGGER.info("Copying raw resources...");
            apkFile.getDirectory().copyToDir(outDir, APK_RESOURCES_FILENAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeResourcesFull(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decode(resTable, apkFile, outDir);
    }

    public void decodeRawFiles(ExtFile apkFile, File outDir) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory in = apkFile.getDirectory();
            if (in.containsDir("assets")) {
                in.copyToDir(outDir, "assets");
            }
            if (in.containsDir("lib")) {
                in.copyToDir(outDir, "lib");
            }
            if (in.containsDir("libs")) {
                in.copyToDir(outDir, "libs");
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean isAPKFileNames(String file) {
        String[] stringArray = APK_STANDARD_ALL_FILENAMES;
        int n = APK_STANDARD_ALL_FILENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String apkFile = stringArray[n2];
            if (apkFile.equals(file) || file.startsWith(apkFile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void decodeUnknownFiles(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        LOGGER.info("Copying unknown files/dir...");
        File unknownOut = new File(outDir, UNK_DIRNAME);
        try {
            Directory unk = apkFile.getDirectory();
            ZipExtFile apkZipFile = new ZipExtFile(apkFile.getAbsolutePath());
            Set files = unk.getFiles(true);
            for (String file : files) {
                if (this.isAPKFileNames(file)) continue;
                unk.copyToDir(unknownOut, file);
                try {
                    apkZipFile.getEntry(file.toString()).getGeneralPurposeBit().useEncryption(false);
                    ZipArchiveEntry invZipFile = apkZipFile.getEntry(file.toString());
                    if (invZipFile == null) continue;
                    resTable.addUnknownFileInfo(invZipFile.getName(), String.valueOf(invZipFile.getMethod()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            apkZipFile.close();
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeOriginalFiles(ExtFile apkFile, File outDir) throws AndrolibException {
        LOGGER.info("Copying original files...");
        File originalDir = new File(outDir, "original");
        if (!originalDir.exists()) {
            originalDir.mkdirs();
        }
        try {
            Directory in = apkFile.getDirectory();
            if (in.containsFile("AndroidManifest.xml")) {
                in.copyToDir(originalDir, "AndroidManifest.xml");
            }
            if (in.containsDir("META-INF")) {
                in.copyToDir(originalDir, "META-INF");
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeMetaFile(File mOutDir, Map<String, Object> meta) throws AndrolibException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(new File(mOutDir, "apktool.yml"));
                yaml.dump(meta, (Writer)writer);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Map<String, Object> readMetaFile(ExtFile appDir) throws AndrolibException {
        InputStream in = null;
        try {
            in = appDir.getDirectory().getFileInput("apktool.yml");
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(in);
            return map;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void build(File appDir, File outFile, HashMap<String, Boolean> flags, String aaptPath) throws BrutException {
        this.build(new ExtFile(appDir), outFile, flags, aaptPath);
    }

    public void build(ExtFile appDir, File outFile, HashMap<String, Boolean> flags, String aaptPath) throws BrutException {
        LOGGER.info("Using Apktool " + Androlib.getVersion() + " on " + appDir.getName());
        this.mAaptPath = aaptPath;
        Map<String, Object> meta = this.readMetaFile(appDir);
        Object t1 = meta.get("isFrameworkApk");
        flags.put("framework", t1 == null ? false : (Boolean)t1);
        flags.put("compression", meta.get("compressionType") == null ? false : Boolean.valueOf(meta.get("compressionType").toString()));
        this.mAndRes.setSdkInfo((Map)meta.get("sdkInfo"));
        this.mAndRes.setPackageId((Map)meta.get("packageInfo"));
        this.mAndRes.setVersionInfo((Map)meta.get("versionInfo"));
        if (outFile == null) {
            String outFileName = (String)meta.get("apkFileName");
            outFile = new File(appDir, "dist" + File.separator + (outFileName == null ? "out.apk" : outFileName));
        }
        new File(appDir, APK_DIRNAME).mkdirs();
        this.buildSources(appDir, flags);
        this.buildResources(appDir, flags, (Map)meta.get("usesFramework"));
        this.buildLib(appDir, flags);
        this.buildCopyOriginalFiles(appDir, flags);
        this.buildApk(appDir, outFile, flags);
        this.buildUnknownFiles(appDir, outFile, meta);
    }

    public void buildSources(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        if (!(this.buildSourcesRaw(appDir, flags) || this.buildSourcesSmali(appDir, flags) || this.buildSourcesJava(appDir, flags))) {
            LOGGER.warning("Could not find sources");
        }
    }

    public boolean buildSourcesRaw(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        File working;
        block4: {
            try {
                working = new File(appDir, "classes.dex");
                if (working.exists()) break block4;
                return false;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        File stored = new File(appDir, "build/apk/classes.dex");
        if (flags.get("forceBuildAll").booleanValue() || this.isModified(working, stored)) {
            LOGGER.info("Copying classes.dex file...");
            BrutIO.copyAndClose((InputStream)new FileInputStream(working), (OutputStream)new FileOutputStream(stored));
        }
        return true;
    }

    public boolean buildSourcesSmali(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        ExtFile smaliDir = new ExtFile(appDir, SMALI_DIRNAME);
        if (!smaliDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/classes.dex");
        if (!flags.get("forceBuildAll").booleanValue()) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (flags.get("forceBuildAll").booleanValue() || this.isModified(smaliDir, dex)) {
            LOGGER.info("Smaling...");
            dex.delete();
            SmaliBuilder.build(smaliDir, dex, flags);
        }
        return true;
    }

    public boolean buildSourcesJava(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        File javaDir = new File(appDir, "src");
        if (!javaDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/classes.dex");
        if (!flags.get("forceBuildAll").booleanValue()) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (flags.get("forceBuildAll").booleanValue() || this.isModified(javaDir, dex)) {
            LOGGER.info("Building java sources...");
            dex.delete();
            new AndrolibJava().build(javaDir, dex);
        }
        return true;
    }

    public void buildResources(ExtFile appDir, HashMap<String, Boolean> flags, Map<String, Object> usesFramework) throws BrutException {
        if (!(this.buildResourcesRaw(appDir, flags) || this.buildResourcesFull(appDir, flags, usesFramework) || this.buildManifest(appDir, flags, usesFramework))) {
            LOGGER.warning("Could not find resources");
        }
    }

    public boolean buildResourcesRaw(ExtFile appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        block5: {
            try {
                if (new File(appDir, "resources.arsc").exists()) break block5;
                return false;
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
        File apkDir = new File(appDir, APK_DIRNAME);
        if (!flags.get("forceBuildAll").booleanValue()) {
            LOGGER.info("Checking whether resources has changed...");
        }
        if (flags.get("forceBuildAll").booleanValue() || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
            LOGGER.info("Copying raw resources...");
            appDir.getDirectory().copyToDir(apkDir, APK_RESOURCES_FILENAMES);
        }
        return true;
    }

    public boolean buildResourcesFull(File appDir, HashMap<String, Boolean> flags, Map<String, Object> usesFramework) throws AndrolibException {
        block8: {
            if (new File(appDir, "res").exists()) break block8;
            return false;
        }
        try {
            if (!flags.get("forceBuildAll").booleanValue()) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (flags.get("forceBuildAll").booleanValue() || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Building resources...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                this.mAndRes.aaptPackage(apkFile, new File(appDir, "AndroidManifest.xml"), new File(appDir, "res"), ninePatch, null, this.parseUsesFramework(usesFramework), flags, this.mAaptPath);
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, tmpDir.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
                apkFile.delete();
            }
            return true;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildManifestRaw(ExtFile appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        try {
            File apkDir = new File(appDir, APK_DIRNAME);
            LOGGER.info("Copying raw AndroidManifest.xml...");
            appDir.getDirectory().copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildManifest(ExtFile appDir, HashMap<String, Boolean> flags, Map<String, Object> usesFramework) throws BrutException {
        block9: {
            if (new File(appDir, "AndroidManifest.xml").exists()) break block9;
            return false;
        }
        try {
            if (!flags.get("forceBuildAll").booleanValue()) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (flags.get("debug").booleanValue()) {
                this.mAndRes.remove_application_debug(new File(apkDir, "AndroidManifest.xml").getAbsolutePath());
            }
            if (flags.get("forceBuildAll").booleanValue() || this.isModified(this.newFiles(APK_MANIFEST_FILENAMES, appDir), this.newFiles(APK_MANIFEST_FILENAMES, apkDir))) {
                LOGGER.info("Building AndroidManifest.xml...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                this.mAndRes.aaptPackage(apkFile, new File(appDir, "AndroidManifest.xml"), null, ninePatch, null, this.parseUsesFramework(usesFramework), flags, this.mAaptPath);
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            }
            return true;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        catch (AndrolibException ex) {
            LOGGER.warning("Parse AndroidManifest.xml failed, treat it as raw file.");
            return this.buildManifestRaw(appDir, flags);
        }
    }

    public void buildLib(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        File working = new File(appDir, "lib");
        if (!working.exists()) {
            return;
        }
        File stored = new File(appDir, "build/apk/lib");
        if (flags.get("forceBuildAll").booleanValue() || this.isModified(working, stored)) {
            LOGGER.info("Copying libs...");
            try {
                OS.rmdir((File)stored);
                OS.cpdir((File)working, (File)stored);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void buildCopyOriginalFiles(File appDir, HashMap<String, Boolean> flags) throws AndrolibException {
        File originalDir;
        if (flags.get("copyOriginal").booleanValue() && (originalDir = new File(appDir, "original")).exists()) {
            try {
                LOGGER.info("Copy original files...");
                Directory in = new ExtFile(originalDir).getDirectory();
                if (in.containsFile("AndroidManifest.xml")) {
                    LOGGER.info("Copy AndroidManifest.xml...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "AndroidManifest.xml");
                }
                if (in.containsDir("META-INF")) {
                    LOGGER.info("Copy META-INF...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "META-INF");
                }
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void buildUnknownFiles(File appDir, File outFile, Map<String, Object> meta) throws AndrolibException {
        this.mPath = Paths.get(String.valueOf(appDir.getPath()) + File.separatorChar + UNK_DIRNAME, new String[0]);
        if (meta.containsKey("unknownFiles")) {
            LOGGER.info("Copying unknown files/dir...");
            Map files = (Map)meta.get("unknownFiles");
            try {
                HashMap<String, String> zip_properties = new HashMap<String, String>();
                zip_properties.put("create", "false");
                zip_properties.put("encoding", "UTF-8");
                Path path = Paths.get(outFile.getAbsolutePath(), new String[0]);
                URI apkFileSystem = new URI("jar", path.toUri().toString(), null);
                for (Map.Entry entry : files.entrySet()) {
                    File file = new File(this.mPath.toFile(), (String)entry.getKey());
                    if (!file.isFile() || !file.exists()) continue;
                    this.insertFolder(apkFileSystem, zip_properties, file.getParentFile(), (String)entry.getValue(), this.mPath.toAbsolutePath());
                    this.insertFile(apkFileSystem, zip_properties, file, (String)entry.getValue(), this.mPath.toAbsolutePath());
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
            catch (URISyntaxException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void insertFile(URI apkFileSystem, Map<String, String> zip_properties, File insert, String method, Path location) throws AndrolibException, IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileSystem fs = FileSystems.newFileSystem(apkFileSystem, zip_properties);){
            Path root = fs.getPath("/", new String[0]);
            Path dest = fs.getPath(String.valueOf(root.toString()) + insert.getAbsolutePath().replace(location.toString(), ""), new String[0]);
            Path newFile = Paths.get(insert.getAbsolutePath(), new String[0]);
            Files.copy(newFile, dest, StandardCopyOption.REPLACE_EXISTING);
            fs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void insertFolder(URI apkFileSystem, Map<String, String> zip_properties, File insert, String method, Path location) throws AndrolibException, IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileSystem fs = FileSystems.newFileSystem(apkFileSystem, zip_properties);){
            Path root = fs.getPath("/", new String[0]);
            Path dest = fs.getPath(String.valueOf(root.toString()) + insert.getAbsolutePath().replace(location.toString(), ""), new String[0]);
            Path parent = dest.normalize();
            if (parent != null && Files.notExists(parent, new LinkOption[0]) && !Files.isDirectory(parent, LinkOption.NOFOLLOW_LINKS)) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            fs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void buildApk(File appDir, File outApk, HashMap<String, Boolean> flags) throws AndrolibException {
        LOGGER.info("Building apk file...");
        if (outApk.exists()) {
            outApk.delete();
        } else {
            File outDir = outApk.getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdirs();
            }
        }
        File assetDir = new File(appDir, "assets");
        if (!assetDir.exists()) {
            assetDir = null;
        }
        this.mAndRes.aaptPackage(outApk, null, null, new File(appDir, APK_DIRNAME), assetDir, null, flags, this.mAaptPath);
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        this.mAndRes.publicizeResources(arscFile);
    }

    public void installFramework(File frameFile, String tag, String frame_path) throws AndrolibException {
        this.mAndRes.setFrameworkFolder(frame_path);
        this.mAndRes.installFramework(frameFile, tag);
    }

    public boolean isFrameworkApk(ResTable resTable) {
        for (ResPackage pkg : resTable.listMainPackages()) {
            if (pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public static String getVersion() {
        String version = ApktoolProperties.get("application.version");
        return version.endsWith("-SNAPSHOT") ? String.valueOf(version.substring(0, version.length() - 9)) + '.' + ApktoolProperties.get("git.commit.id.abbrev") : version;
    }

    private File[] parseUsesFramework(Map<String, Object> usesFramework) throws AndrolibException {
        if (usesFramework == null) {
            return null;
        }
        List ids = (List)usesFramework.get("ids");
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        String tag = (String)usesFramework.get("tag");
        File[] files = new File[ids.size()];
        int i = 0;
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            files[i++] = this.mAndRes.getFrameworkApk(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        if (!stored.exists()) {
            return true;
        }
        return BrutIO.recursiveModifiedTime((File)working) > BrutIO.recursiveModifiedTime((File)stored);
    }

    private boolean isModified(File[] working, File[] stored) {
        int i = 0;
        while (i < stored.length) {
            if (!stored[i].exists()) {
                return true;
            }
            ++i;
        }
        return BrutIO.recursiveModifiedTime((File[])working) > BrutIO.recursiveModifiedTime((File[])stored);
    }

    private File[] newFiles(String[] names, File dir) {
        File[] files = new File[names.length];
        int i = 0;
        while (i < names.length) {
            files[i] = new File(dir, names[i]);
            ++i;
        }
        return files;
    }

    public void setFrameworkFolder(String path) {
        this.mAndRes.setFrameworkFolder(path);
    }
}

