/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.mod;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.io.IOUtils;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class SmaliMod {
    public static boolean assembleSmaliFile(String smali, DexBuilder dexBuilder, boolean verboseErrors, boolean printTokens, File smaliFile) throws IOException, RuntimeException, RecognitionException {
        ByteArrayInputStream is = new ByteArrayInputStream(smali.getBytes());
        return SmaliMod.assembleSmaliFile(is, dexBuilder, verboseErrors, printTokens, smaliFile);
    }

    public static boolean assembleSmaliFile(InputStream is, DexBuilder dexBuilder, boolean verboseErrors, boolean printTokens, File smaliFile) throws IOException, RecognitionException {
        File tmp = File.createTempFile("BRUT", ".bak");
        tmp.deleteOnExit();
        FileOutputStream os = new FileOutputStream(tmp);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        ((OutputStream)os).close();
        return SmaliMod.assembleSmaliFile(tmp, dexBuilder, verboseErrors, printTokens);
    }

    public static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, boolean verboseErrors, boolean printTokens) throws IOException, RecognitionException {
        FileInputStream is = new FileInputStream(smaliFile);
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        smaliFlexLexer lexer = new smaliFlexLexer((Reader)reader);
        lexer.setSourceFile(smaliFile);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        if (printTokens) {
            tokens.getTokens();
            int i = 0;
            while (i < tokens.size()) {
                Token token = tokens.get(i);
                if (token.getChannel() != 99) {
                    System.out.println(String.valueOf(smaliParser.tokenNames[token.getType()]) + ": " + token.getText());
                }
                ++i;
            }
        }
        smaliParser parser = new smaliParser((TokenStream)tokens);
        parser.setVerboseErrors(verboseErrors);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            return false;
        }
        CommonTree t = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)t);
        treeStream.setTokenStream((TokenStream)tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker((TreeNodeStream)treeStream);
        dexGen.setVerboseErrors(verboseErrors);
        dexGen.smali_file();
        return dexGen.getNumberOfSyntaxErrors() == 0;
    }
}

