/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFindFrameworkResException;
import brut.androlib.res.ResSmaliUpdater;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtFile;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.util.ExtXmlSerializer;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import brut.directory.ZipExtFile;
import brut.util.Duo;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlSerializer;

public final class AndrolibResources {
    public static boolean sKeepBroken = false;
    public static String sFrameworkFolder = null;
    private static final Logger LOGGER = Logger.getLogger(AndrolibResources.class.getName());
    private String mPackageId = null;
    private String mMinSdkVersion = null;
    private String mMaxSdkVersion = null;
    private String mTargetSdkVersion = null;
    private String mVersionCode = null;
    private String mVersionName = null;
    private String mPackageRenamed = null;
    private File mAaptBinary = null;

    public ResTable getResTable(ExtFile apkFile) throws AndrolibException {
        return this.getResTable(apkFile, true);
    }

    public ResTable getResTable(ExtFile apkFile, boolean loadMainPkg) throws AndrolibException {
        ResTable resTable = new ResTable(this);
        if (loadMainPkg) {
            this.loadMainPkg(resTable, apkFile);
        }
        return resTable;
    }

    public ResPackage loadMainPkg(ResTable resTable, ExtFile apkFile) throws AndrolibException {
        ResPackage[] pkgs = this.getResPackagesFromApk(apkFile, resTable, sKeepBroken);
        ResPackage pkg = null;
        switch (pkgs.length) {
            case 1: {
                pkg = pkgs[0];
                break;
            }
            case 2: {
                if (pkgs[0].getName().equals("android")) {
                    LOGGER.warning("Skipping \"android\" package group");
                    pkg = pkgs[1];
                    break;
                }
                if (!pkgs[0].getName().equals("com.htc")) break;
                LOGGER.warning("Skipping \"htc\" package group");
                pkg = pkgs[1];
            }
        }
        if (pkg == null) {
            throw new AndrolibException("Arsc files with zero or multiple packages");
        }
        resTable.addPackage(pkg, true);
        return pkg;
    }

    public ResPackage loadFrameworkPkg(ResTable resTable, int id, String frameTag) throws AndrolibException {
        File apk = this.getFrameworkApk(id, frameTag);
        ResPackage[] pkgs = this.getResPackagesFromApk(new ExtFile(apk), resTable, true);
        if (pkgs.length != 1) {
            throw new AndrolibException("Arsc files with zero or multiple packages");
        }
        ResPackage pkg = pkgs[0];
        if (pkg.getId() != id) {
            throw new AndrolibException("Expected pkg of id: " + String.valueOf(id) + ", got: " + pkg.getId());
        }
        resTable.addPackage(pkg, false);
        return pkg;
    }

    public void decodeManifest(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getManifestFileDecoder();
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ((AXmlResourceParser)duo.m2).setAttrDecoder(new ResAttrDecoder());
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setCurrentPackage(new ResPackage(resTable, 0, null));
        try {
            Directory inApk = apkFile.getDirectory();
            FileDirectory out = new FileDirectory(outDir);
            LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            fileDecoder.decodeManifest(inApk, "AndroidManifest.xml", (Directory)out, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void remove_application_debug(String filePath) throws AndrolibException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(filePath.toString());
            Element application = doc.getElementById("application");
            NamedNodeMap attr = application.getAttributes();
            Node debugAttr = attr.getNamedItem("debug");
            if (debugAttr != null) {
                attr.removeNamedItem("debug");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filePath));
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public void adjust_package_manifest(ResTable resTable, String filePath) throws AndrolibException {
        Map<String, String> packageInfo = resTable.getPackageInfo();
        if (packageInfo.get("cur_package").equalsIgnoreCase(packageInfo.get("orig_package")) || "android".equalsIgnoreCase(packageInfo.get("cur_package")) || "com.htc".equalsIgnoreCase(packageInfo.get("cur_package"))) {
            LOGGER.info("Regular manifest package...");
        } else {
            try {
                LOGGER.info("Renamed manifest package found! Fixing...");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(filePath.toString());
                Node manifest = doc.getFirstChild();
                NamedNodeMap attr = manifest.getAttributes();
                Node nodeAttr = attr.getNamedItem("package");
                this.mPackageRenamed = nodeAttr.getNodeValue();
                nodeAttr.setNodeValue(packageInfo.get("cur_package"));
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("standalone", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(filePath));
                transformer.transform(source, result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public void remove_manifest_versions(String filePath) throws AndrolibException {
        File f = new File(filePath);
        if (f.exists()) {
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(filePath.toString());
                Node manifest = doc.getFirstChild();
                NamedNodeMap attr = manifest.getAttributes();
                Node vCode = attr.getNamedItem("android:versionCode");
                Node vName = attr.getNamedItem("android:versionName");
                if (vCode != null) {
                    attr.removeNamedItem("android:versionCode");
                }
                if (vName != null) {
                    attr.removeNamedItem("android:versionName");
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("standalone", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(filePath));
                transformer.transform(source, result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public void decode(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        FileDirectory out;
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getResFileDecoder();
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setCurrentPackage(resTable.listMainPackages().iterator().next());
        Directory in = null;
        try {
            Directory inApk = apkFile.getDirectory();
            out = new FileDirectory(outDir);
            LOGGER.info("Decoding AndroidManifest.xml with resources...");
            fileDecoder.decodeManifest(inApk, "AndroidManifest.xml", (Directory)out, "AndroidManifest.xml");
            this.adjust_package_manifest(resTable, String.valueOf(outDir.getAbsolutePath()) + File.separator + "AndroidManifest.xml");
            if (!resTable.getAnalysisMode()) {
                this.remove_manifest_versions(String.valueOf(outDir.getAbsolutePath()) + File.separator + "AndroidManifest.xml");
            }
            if (inApk.containsDir("res")) {
                in = inApk.getDir("res");
            }
            out = out.createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ExtMXSerializer xmlSerializer = this.getResXmlSerializer();
        for (ResPackage pkg : resTable.listMainPackages()) {
            attrDecoder.setCurrentPackage(pkg);
            LOGGER.info("Decoding file-resources...");
            for (ResResource res : pkg.listFiles()) {
                fileDecoder.decode(res, in, (Directory)out);
            }
            LOGGER.info("Decoding values */* XMLs...");
            for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                this.generateValuesFile(valuesFile, (Directory)out, xmlSerializer);
            }
            this.generatePublicXml(pkg, (Directory)out, xmlSerializer);
        }
        AndrolibException decodeError = ((AXmlResourceParser)duo.m2).getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    public void setSdkInfo(Map<String, String> map) {
        if (map != null) {
            this.mMinSdkVersion = map.get("minSdkVersion");
            this.mTargetSdkVersion = map.get("targetSdkVersion");
            this.mMaxSdkVersion = map.get("maxSdkVersion");
        }
    }

    public void setVersionInfo(Map<String, String> map) {
        if (map != null) {
            this.mVersionCode = map.get("versionCode");
            this.mVersionName = map.get("versionName");
        }
    }

    public void setPackageInfo(Map<String, String> map) {
        if (map != null) {
            this.mPackageRenamed = map.get("package");
        }
    }

    public void setPackageId(Map<String, String> map) {
        if (map != null) {
            this.mPackageId = map.get("cur_package_id");
        }
    }

    public void aaptPackage(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, HashMap<String, Boolean> flags, String aaptPath) throws AndrolibException {
        boolean customAapt = false;
        ArrayList<String> cmd = new ArrayList<String>();
        if (!aaptPath.isEmpty()) {
            File aaptFile = new File(aaptPath);
            if (aaptFile.canRead() && aaptFile.exists()) {
                aaptFile.setExecutable(true);
                cmd.add(aaptFile.getPath());
                customAapt = true;
                if (flags.get("verbose").booleanValue()) {
                    LOGGER.info(String.valueOf(aaptFile.getPath()) + " being used as aapt location.");
                }
            } else {
                LOGGER.warning("aapt location could not be found. Defaulting back to default");
                try {
                    cmd.add(this.getAaptBinaryFile().getAbsolutePath());
                }
                catch (BrutException ignored) {
                    cmd.add("aapt");
                }
            }
        } else {
            try {
                cmd.add(this.getAaptBinaryFile().getAbsolutePath());
            }
            catch (BrutException ignored) {
                cmd.add("aapt");
            }
        }
        cmd.add("p");
        if (flags.get("verbose").booleanValue()) {
            cmd.add("-v");
        }
        if (flags.get("update").booleanValue()) {
            cmd.add("-u");
        }
        if (flags.get("debug").booleanValue()) {
            cmd.add("--debug-mode");
        }
        if (this.mPackageId != null && !customAapt) {
            cmd.add("--forced-package-id");
            cmd.add(this.mPackageId);
        }
        if (this.mMinSdkVersion != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mMinSdkVersion);
        }
        if (this.mTargetSdkVersion != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.mTargetSdkVersion);
        }
        if (this.mMaxSdkVersion != null) {
            cmd.add("--max-sdk-version");
            cmd.add(this.mMaxSdkVersion);
            cmd.add("--max-res-version");
            cmd.add(this.mMaxSdkVersion);
        }
        if (this.mPackageRenamed != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mPackageRenamed);
        }
        if (this.mVersionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mVersionCode);
        }
        if (this.mVersionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mVersionName);
        }
        cmd.add("-F");
        cmd.add(apkFile.getAbsolutePath());
        if (flags.get("framework").booleanValue()) {
            cmd.add("-x");
        }
        if (!flags.get("compression").booleanValue()) {
            cmd.add("-0");
            cmd.add("arsc");
        }
        if (include != null) {
            File[] fileArray = include;
            int n = include.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                cmd.add("-I");
                cmd.add(file.getPath());
                ++n2;
            }
        }
        if (resDir != null) {
            cmd.add("-S");
            cmd.add(resDir.getAbsolutePath());
        }
        if (manifest != null) {
            cmd.add("-M");
            cmd.add(manifest.getAbsolutePath());
        }
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add(rawDir.getAbsolutePath());
        }
        try {
            OS.exec((String[])cmd.toArray(new String[0]));
            if (flags.get("verbose").booleanValue()) {
                LOGGER.info("command ran: ");
                LOGGER.info(((Object)cmd).toString());
            }
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void tagSmaliResIDs(ResTable resTable, File smaliDir) throws AndrolibException {
        new ResSmaliUpdater().tagResIDs(resTable, smaliDir);
    }

    public void updateSmaliResIDs(ResTable resTable, File smaliDir) throws AndrolibException {
        new ResSmaliUpdater().updateResIDs(resTable, smaliDir);
    }

    public Duo<ResFileDecoder, AXmlResourceParser> getResFileDecoder() {
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser();
        axmlParser.setAttrDecoder(new ResAttrDecoder());
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        return new Duo((Object)new ResFileDecoder(decoders), (Object)axmlParser);
    }

    public Duo<ResFileDecoder, AXmlResourceParser> getManifestFileDecoder() {
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        AXmlResourceParser axmlParser = new AXmlResourceParser();
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        return new Duo((Object)new ResFileDecoder(decoders), (Object)axmlParser);
    }

    public ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer serial = new ExtMXSerializer();
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        serial.setProperty("DEFAULT_ENCODING", "utf-8");
        serial.setDisabledAttrEscape(true);
        return serial;
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory out, ExtXmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput(valuesFile.getPath());
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.newLine();
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory out, XmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput("values/public.xml");
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResSpec spec : pkg.listResSpecs()) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", String.format("0x%08x", spec.getId().id));
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }

    private ResPackage[] getResPackagesFromApk(ExtFile apkFile, ResTable resTable, boolean keepBroken) throws AndrolibException {
        try {
            return ARSCDecoder.decode(apkFile.getDirectory().getFileInput("resources.arsc"), false, keepBroken, resTable).getPackages();
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
        }
    }

    public File getFrameworkApk(int id, String frameTag) throws AndrolibException {
        File apk;
        File dir = this.getFrameworkDir();
        if (frameTag != null && (apk = new File(dir, String.valueOf(String.valueOf(id)) + '-' + frameTag + ".apk")).exists()) {
            return apk;
        }
        apk = new File(dir, String.valueOf(String.valueOf(id)) + ".apk");
        if (apk.exists()) {
            return apk;
        }
        if (id == 1) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = AndrolibResources.class.getResourceAsStream("/brut/androlib/android-framework.jar");
                out = new FileOutputStream(apk);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                File file = apk;
                return file;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new CantFindFrameworkResException(id);
    }

    public void installFramework(File frameFile, String tag) throws AndrolibException {
        InputStream in = null;
        ZipArchiveOutputStream out = null;
        try {
            try {
                ZipExtFile zip = new ZipExtFile(frameFile);
                ZipArchiveEntry entry = zip.getEntry("resources.arsc");
                if (entry == null) {
                    throw new AndrolibException("Can't find resources.arsc file");
                }
                in = zip.getInputStream(entry);
                byte[] data = IOUtils.toByteArray((InputStream)in);
                ARSCDecoder.ARSCData arsc = ARSCDecoder.decode(new ByteArrayInputStream(data), true, true);
                this.publicizeResources(data, arsc.getFlagsOffsets());
                File outFile = new File(this.getFrameworkDir(), String.valueOf(String.valueOf(arsc.getOnePackage().getId())) + (tag == null ? "" : String.valueOf('-') + tag) + ".apk");
                out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(outFile));
                out.setMethod(0);
                CRC32 crc = new CRC32();
                crc.update(data);
                entry = new ZipArchiveEntry("resources.arsc");
                entry.setSize((long)data.length);
                entry.setCrc(crc.getValue());
                out.putArchiveEntry((ArchiveEntry)entry);
                out.write(data);
                out.closeArchiveEntry();
                zip.close();
                LOGGER.info("Framework installed to: " + outFile);
            }
            catch (ZipException ex) {
                throw new AndrolibException(ex);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        byte[] data = new byte[(int)arscFile.length()];
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(arscFile);
                ((InputStream)in).read(data);
                this.publicizeResources(data);
                out = new FileOutputStream(arscFile);
                out.write(data);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void publicizeResources(byte[] arsc) throws AndrolibException {
        this.publicizeResources(arsc, ARSCDecoder.decode(new ByteArrayInputStream(arsc), true, true).getFlagsOffsets());
    }

    public void publicizeResources(byte[] arsc, ARSCDecoder.FlagsOffset[] flagsOffsets) throws AndrolibException {
        ARSCDecoder.FlagsOffset[] flagsOffsetArray = flagsOffsets;
        int n = flagsOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            ARSCDecoder.FlagsOffset flags = flagsOffsetArray[n2];
            int offset = flags.offset + 3;
            int end = offset + 4 * flags.count;
            while (offset < end) {
                int n3 = offset;
                arsc[n3] = (byte)(arsc[n3] | 0x40);
                offset += 4;
            }
            ++n2;
        }
    }

    private File getFrameworkDir() throws AndrolibException {
        String path = sFrameworkFolder != null ? sFrameworkFolder : (OSDetection.isMacOSX() ? String.valueOf(System.getProperty("user.home")) + File.separatorChar + "Library" + File.separatorChar + "apktool" + File.separatorChar + "framework" : String.valueOf(System.getProperty("user.home")) + File.separatorChar + "apktool" + File.separatorChar + "framework");
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            if (sFrameworkFolder != null) {
                System.err.println("Can't create Framework directory: " + dir);
            }
            throw new AndrolibException("Can't create directory: " + dir);
        }
        return dir;
    }

    public File getAaptBinaryFile() throws AndrolibException {
        block5: {
            try {
                if (OSDetection.isMacOSX()) {
                    this.mAaptBinary = Jar.getResourceAsFile((String)"/prebuilt/aapt/macosx/aapt");
                    break block5;
                }
                if (OSDetection.isUnix()) {
                    this.mAaptBinary = Jar.getResourceAsFile((String)"/prebuilt/aapt/linux/aapt");
                    break block5;
                }
                if (OSDetection.isWindows()) {
                    this.mAaptBinary = Jar.getResourceAsFile((String)"/prebuilt/aapt/windows/aapt.exe");
                    break block5;
                }
                LOGGER.warning("Unknown Operating System: " + OSDetection.returnOS());
                return null;
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
        this.mAaptBinary.setExecutable(true);
        return this.mAaptBinary;
    }

    public File getAndroidResourcesFile() throws AndrolibException {
        try {
            return Jar.getResourceAsFile((String)"/brut/androlib/android-framework.jar");
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void setFrameworkFolder(String path) {
        sFrameworkFolder = path;
    }
}

