/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ResResSpec {
    private final ResID mId;
    private final String mName;
    private final ResPackage mPackage;
    private final ResType mType;
    private final Map<ResConfigFlags, ResResource> mResources = new LinkedHashMap<ResConfigFlags, ResResource>();

    public ResResSpec(ResID id, String name, ResPackage pkg, ResType type) {
        this.mId = id;
        this.mName = name;
        this.mPackage = pkg;
        this.mType = type;
    }

    public Set<ResResource> listResources() {
        return new LinkedHashSet<ResResource>(this.mResources.values());
    }

    public ResResource getResource(ResConfig config) throws AndrolibException {
        return this.getResource(config.getFlags());
    }

    public ResResource getResource(ResConfigFlags config) throws AndrolibException {
        ResResource res = this.mResources.get(config);
        if (res == null) {
            throw new UndefinedResObject(String.format("resource: spec=%s, config=%s", this, config));
        }
        return res;
    }

    public boolean hasResource(ResConfig config) {
        return this.hasResource(config.getFlags());
    }

    private boolean hasResource(ResConfigFlags flags) {
        return this.mResources.containsKey(flags);
    }

    public ResResource getDefaultResource() throws AndrolibException {
        return this.getResource(new ResConfigFlags());
    }

    public boolean hasDefaultResource() {
        return this.mResources.containsKey(new ResConfigFlags());
    }

    public String getFullName() {
        return this.getFullName(false, false);
    }

    public String getFullName(ResPackage relativeToPackage, boolean excludeType) {
        return this.getFullName(this.getPackage().equals(relativeToPackage), excludeType);
    }

    public String getFullName(boolean excludePackage, boolean excludeType) {
        return String.valueOf(excludePackage ? "" : String.valueOf(this.getPackage().getName()) + ":") + (excludeType ? "" : String.valueOf(this.getType().getName()) + "/") + this.getName();
    }

    public ResID getId() {
        return this.mId;
    }

    public String getName() {
        return StringUtils.replace((String)this.mName, (String)"\"", (String)"q");
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public ResType getType() {
        return this.mType;
    }

    public void addResource(ResResource res) throws AndrolibException {
        this.addResource(res, false);
    }

    public void addResource(ResResource res, boolean overwrite) throws AndrolibException {
        ResConfigFlags flags = res.getConfig().getFlags();
        if (this.mResources.put(flags, res) != null && !overwrite) {
            throw new AndrolibException(String.format("Multiple resources: spec=%s, config=%s", this, flags));
        }
    }

    public String toString() {
        return String.valueOf(this.mId.toString()) + " " + this.mType.toString() + "/" + this.mName;
    }
}

