/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResTable {
    private final AndrolibResources mAndRes;
    private final Map<Integer, ResPackage> mPackagesById = new HashMap<Integer, ResPackage>();
    private final Map<String, ResPackage> mPackagesByName = new HashMap<String, ResPackage>();
    private final Set<ResPackage> mMainPackages = new LinkedHashSet<ResPackage>();
    private final Set<ResPackage> mFramePackages = new LinkedHashSet<ResPackage>();
    private String mFrameTag;
    private boolean mAnalysisMode = false;
    private Map<String, String> mSdkInfo = new LinkedHashMap<String, String>();
    private Map<String, String> mPackageInfo = new LinkedHashMap<String, String>();
    private Map<String, String> mVersionInfo = new LinkedHashMap<String, String>();
    private Map<String, String> mUnknownFiles = new LinkedHashMap<String, String>();

    public ResTable() {
        this.mAndRes = null;
    }

    public ResTable(AndrolibResources andRes) {
        this.mAndRes = andRes;
    }

    public ResResSpec getResSpec(int resID) throws AndrolibException {
        return this.getResSpec(new ResID(resID));
    }

    public ResResSpec getResSpec(ResID resID) throws AndrolibException {
        return this.getPackage(resID.package_).getResSpec(resID);
    }

    public Set<ResPackage> listMainPackages() {
        return this.mMainPackages;
    }

    public Set<ResPackage> listFramePackages() {
        return this.mFramePackages;
    }

    public ResPackage getPackage(int id) throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(id);
        if (pkg != null) {
            return pkg;
        }
        if (this.mAndRes != null) {
            return this.mAndRes.loadFrameworkPkg(this, id, this.mFrameTag);
        }
        throw new UndefinedResObject(String.format("package: id=%d", id));
    }

    public ResPackage getPackage(String name) throws AndrolibException {
        ResPackage pkg = this.mPackagesByName.get(name);
        if (pkg == null) {
            throw new UndefinedResObject("package: name=" + name);
        }
        return pkg;
    }

    public boolean hasPackage(int id) {
        return this.mPackagesById.containsKey(id);
    }

    public boolean hasPackage(String name) {
        return this.mPackagesByName.containsKey(name);
    }

    public ResValue getValue(String package_, String type, String name) throws AndrolibException {
        return this.getPackage(package_).getType(type).getResSpec(name).getDefaultResource().getValue();
    }

    public void addPackage(ResPackage pkg, boolean main2) throws AndrolibException {
        Integer id = pkg.getId();
        if (this.mPackagesById.containsKey(id)) {
            throw new AndrolibException("Multiple packages: id=" + id.toString());
        }
        String name = pkg.getName();
        if (this.mPackagesByName.containsKey(name)) {
            throw new AndrolibException("Multiple packages: name=" + name);
        }
        this.mPackagesById.put(id, pkg);
        this.mPackagesByName.put(name, pkg);
        if (main2) {
            this.mMainPackages.add(pkg);
        } else {
            this.mFramePackages.add(pkg);
        }
    }

    public void setFrameTag(String tag) {
        this.mFrameTag = tag;
    }

    public void setAnalysisMode(boolean mode) {
        this.mAnalysisMode = mode;
    }

    public void clearSdkInfo() {
        this.mSdkInfo.clear();
    }

    public void addSdkInfo(String key, String value) {
        this.mSdkInfo.put(key, value);
    }

    public void addVersionInfo(String key, String value) {
        this.mVersionInfo.put(key, value);
    }

    public void addPackageInfo(String key, String value) {
        this.mPackageInfo.put(key, value);
    }

    public void addUnknownFileInfo(String file, String value) {
        this.mUnknownFiles.put(file, value);
    }

    public Map<String, String> getPackageInfo() {
        return this.mPackageInfo;
    }

    public Map<String, String> getVersionInfo() {
        return this.mVersionInfo;
    }

    public Map<String, String> getSdkInfo() {
        return this.mSdkInfo;
    }

    public boolean getAnalysisMode() {
        return this.mAnalysisMode;
    }

    public Map<String, String> getUnknownFiles() {
        return this.mUnknownFiles;
    }

    public boolean isPackageInfoValueSet(String key) {
        return this.mPackageInfo.containsKey(key);
    }
}

