/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResPluralsValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private final ResScalarValue[] mItems = new ResScalarValue[6];
    public static final int BAG_KEY_PLURALS_START = 0x1000004;
    public static final int BAG_KEY_PLURALS_END = 0x1000009;
    private static final String[] QUANTITY_MAP = new String[]{"other", "zero", "one", "two", "few", "many"};

    ResPluralsValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items) {
        super(parent);
        int i = 0;
        while (i < items.length) {
            this.mItems[((Integer)items[i].m1).intValue() - 0x1000004] = (ResScalarValue)items[i].m2;
            ++i;
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        serializer.startTag(null, "plurals");
        serializer.attribute(null, "name", res.getResSpec().getName());
        int i = 0;
        while (i < this.mItems.length) {
            ResScalarValue item = this.mItems[i];
            if (item != null) {
                ResScalarValue rawValue = item;
                serializer.startTag(null, "item");
                serializer.attribute(null, "quantity", QUANTITY_MAP[i]);
                serializer.text(ResXmlEncoders.enumerateNonPositionalSubstitutionsIfRequired(item.encodeAsResXmlValue()));
                serializer.endTag(null, "item");
            }
            ++i;
        }
        serializer.endTag(null, "plurals");
    }
}

