/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.decoder.StringBlock;
import brut.util.Duo;
import brut.util.ExtDataInput;
import com.mindprod.ledatastream.LEDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.input.CountingInputStream;

public class ARSCDecoder {
    private final ExtDataInput mIn;
    private final ResTable mResTable;
    private final CountingInputStream mCountIn;
    private final List<FlagsOffset> mFlagsOffsets;
    private final boolean mKeepBroken;
    private Header mHeader;
    private StringBlock mTableStrings;
    private StringBlock mTypeNames;
    private StringBlock mSpecNames;
    private ResPackage mPkg;
    private ResType mType;
    private ResConfig mConfig;
    private int mResId;
    private boolean[] mMissingResSpecs;
    private static final short ENTRY_FLAG_COMPLEX = 1;
    private static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    private static final int KNOWN_CONFIG_BYTES = 38;

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken) throws AndrolibException {
        return ARSCDecoder.decode(arscStream, findFlagsOffsets, keepBroken, new ResTable());
    }

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken, ResTable resTable) throws AndrolibException {
        try {
            ARSCDecoder decoder = new ARSCDecoder(arscStream, resTable, findFlagsOffsets, keepBroken);
            ResPackage[] pkgs = decoder.readTable();
            return new ARSCData(pkgs, decoder.mFlagsOffsets == null ? null : decoder.mFlagsOffsets.toArray(new FlagsOffset[0]), resTable);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode arsc file", ex);
        }
    }

    private ARSCDecoder(InputStream arscStream, ResTable resTable, boolean storeFlagsOffsets, boolean keepBroken) {
        if (storeFlagsOffsets) {
            this.mCountIn = new CountingInputStream(arscStream);
            arscStream = this.mCountIn;
            this.mFlagsOffsets = new ArrayList<FlagsOffset>();
        } else {
            this.mCountIn = null;
            this.mFlagsOffsets = null;
        }
        this.mIn = new ExtDataInput((DataInput)new LEDataInputStream(arscStream));
        this.mResTable = resTable;
        this.mKeepBroken = keepBroken;
    }

    private ResPackage[] readTable() throws IOException, AndrolibException {
        this.nextChunkCheckType(2);
        int packageCount = this.mIn.readInt();
        this.mTableStrings = StringBlock.read(this.mIn);
        ResPackage[] packages = new ResPackage[packageCount];
        this.nextChunk();
        int i = 0;
        while (i < packageCount) {
            packages[i] = this.readPackage();
            ++i;
        }
        if (!this.mResTable.isPackageInfoValueSet("cur_package")) {
            this.mResTable.addPackageInfo("cur_package", packages[0].getName());
            this.mResTable.addPackageInfo("cur_package_id", String.valueOf(packages[0].getId()));
        }
        return packages;
    }

    private ResPackage readPackage() throws IOException, AndrolibException {
        this.checkChunkType(512);
        byte id = (byte)this.mIn.readInt();
        String name = this.mIn.readNulEndedString(128, true);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mTypeNames = StringBlock.read(this.mIn);
        this.mSpecNames = StringBlock.read(this.mIn);
        this.mResId = id << 24;
        this.mPkg = new ResPackage(this.mResTable, id, name);
        this.nextChunk();
        while (this.mHeader.type == 514) {
            this.readType();
        }
        return this.mPkg;
    }

    private ResType readType() throws AndrolibException, IOException {
        this.checkChunkType(514);
        byte id = this.mIn.readByte();
        this.mIn.skipBytes(3);
        int entryCount = this.mIn.readInt();
        this.mMissingResSpecs = new boolean[entryCount];
        Arrays.fill(this.mMissingResSpecs, true);
        if (this.mFlagsOffsets != null) {
            this.mFlagsOffsets.add(new FlagsOffset(this.mCountIn.getCount(), entryCount));
        }
        this.mIn.skipBytes(entryCount * 4);
        this.mResId = 0xFF000000 & this.mResId | id << 16;
        this.mType = new ResType(this.mTypeNames.getString(id - 1), this.mResTable, this.mPkg);
        this.mPkg.addType(this.mType);
        while (this.nextChunk().type == 513) {
            this.readConfig();
        }
        this.addMissingResSpecs();
        return this.mType;
    }

    private ResConfig readConfig() throws IOException, AndrolibException {
        this.checkChunkType(513);
        this.mIn.skipInt();
        int entryCount = this.mIn.readInt();
        this.mIn.skipInt();
        ResConfigFlags flags = this.readConfigFlags();
        int[] entryOffsets = this.mIn.readIntArray(entryCount);
        if (flags.isInvalid) {
            String resName = String.valueOf(this.mType.getName()) + flags.getQualifiers();
            if (this.mKeepBroken) {
                LOGGER.warning("Invalid config flags detected: " + resName);
            } else {
                LOGGER.warning("Invalid config flags detected. Dropping resources: " + resName);
            }
        }
        this.mConfig = flags.isInvalid && !this.mKeepBroken ? null : this.mPkg.getOrCreateConfig(flags);
        int i = 0;
        while (i < entryOffsets.length) {
            if (entryOffsets[i] != -1) {
                this.mMissingResSpecs[i] = false;
                this.mResId = this.mResId & 0xFFFF0000 | i;
                this.readEntry();
            }
            ++i;
        }
        return this.mConfig;
    }

    private void readEntry() throws IOException, AndrolibException {
        ResResSpec spec;
        ResValue value;
        this.mIn.skipBytes(2);
        short flags = this.mIn.readShort();
        int specNamesId = this.mIn.readInt();
        ResValue resValue = value = (flags & 1) == 0 ? this.readValue() : this.readComplexEntry();
        if (this.mConfig == null) {
            return;
        }
        ResID resId = new ResID(this.mResId);
        if (this.mPkg.hasResSpec(resId)) {
            spec = this.mPkg.getResSpec(resId);
        } else {
            spec = new ResResSpec(resId, this.mSpecNames.getString(specNamesId), this.mPkg, this.mType);
            this.mPkg.addResSpec(spec);
            this.mType.addResSpec(spec);
        }
        ResResource res = new ResResource(this.mConfig, spec, value);
        this.mConfig.addResource(res);
        spec.addResource(res);
        this.mPkg.addResource(res);
    }

    private ResBagValue readComplexEntry() throws IOException, AndrolibException {
        int parent = this.mIn.readInt();
        int count = this.mIn.readInt();
        ResValueFactory factory = this.mPkg.getValueFactory();
        Duo[] items = new Duo[count];
        int i = 0;
        while (i < count) {
            int a = this.mIn.readInt();
            ResValue v = this.readValue();
            ResScalarValue vv = (ResScalarValue)v;
            items[i] = new Duo((Object)a, (Object)vv);
            ++i;
        }
        return factory.bagFactory(parent, items);
    }

    private ResValue readValue() throws IOException, AndrolibException {
        this.mIn.skipCheckShort((short)8);
        this.mIn.skipCheckByte((byte)0);
        byte type = this.mIn.readByte();
        int data = this.mIn.readInt();
        return type == 3 ? this.mPkg.getValueFactory().factory(this.mTableStrings.getHTML(data)) : this.mPkg.getValueFactory().factory(type, data, null);
    }

    private ResConfigFlags readConfigFlags() throws IOException, AndrolibException {
        int exceedingSize;
        int size = this.mIn.readInt();
        if (size < 28) {
            throw new AndrolibException("Config size < 28");
        }
        boolean isInvalid = false;
        short mcc = this.mIn.readShort();
        short mnc = this.mIn.readShort();
        char[] language = new char[]{(char)this.mIn.readByte(), (char)this.mIn.readByte()};
        char[] country = new char[]{(char)this.mIn.readByte(), (char)this.mIn.readByte()};
        byte orientation = this.mIn.readByte();
        byte touchscreen = this.mIn.readByte();
        int density = this.mIn.readUnsignedShort();
        byte keyboard = this.mIn.readByte();
        byte navigation = this.mIn.readByte();
        byte inputFlags = this.mIn.readByte();
        this.mIn.skipBytes(1);
        short screenWidth = this.mIn.readShort();
        short screenHeight = this.mIn.readShort();
        short sdkVersion = this.mIn.readShort();
        this.mIn.skipBytes(2);
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = this.mIn.readByte();
            uiMode = this.mIn.readByte();
            smallestScreenWidthDp = this.mIn.readShort();
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = this.mIn.readShort();
            screenHeightDp = this.mIn.readShort();
        }
        short layoutDirection = 0;
        if (size >= 38) {
            layoutDirection = this.mIn.readShort();
        }
        if ((exceedingSize = size - 38) > 0) {
            byte[] buf = new byte[exceedingSize];
            this.mIn.readFully(buf);
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", 38));
            } else {
                LOGGER.warning(String.format("Config flags size > %d. Exceeding bytes: 0x%X.", 38, exceedingBI));
                isInvalid = true;
            }
        }
        return new ResConfigFlags(mcc, mnc, language, country, layoutDirection, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, isInvalid);
    }

    private void addMissingResSpecs() throws AndrolibException {
        int resId = this.mResId & 0xFFFF0000;
        int i = 0;
        while (i < this.mMissingResSpecs.length) {
            if (this.mMissingResSpecs[i]) {
                ResResSpec spec = new ResResSpec(new ResID(resId | i), String.format("APKTOOL_DUMMY_%04x", i), this.mPkg, this.mType);
                this.mPkg.addResSpec(spec);
                this.mType.addResSpec(spec);
                if (this.mConfig == null) {
                    this.mConfig = this.mPkg.getOrCreateConfig(new ResConfigFlags());
                }
                ResBoolValue value = new ResBoolValue(false, null);
                ResResource res = new ResResource(this.mConfig, spec, value);
                this.mPkg.addResource(res);
                this.mConfig.addResource(res);
                spec.addResource(res);
            }
            ++i;
        }
    }

    private Header nextChunk() throws IOException {
        this.mHeader = Header.read(this.mIn);
        return this.mHeader;
    }

    private void checkChunkType(int expectedType) throws AndrolibException {
        if (this.mHeader.type != expectedType) {
            throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", expectedType, this.mHeader.type));
        }
    }

    private void nextChunkCheckType(int expectedType) throws IOException, AndrolibException {
        this.nextChunk();
        this.checkChunkType(expectedType);
    }

    public static class ARSCData {
        private final ResPackage[] mPackages;
        private final FlagsOffset[] mFlagsOffsets;
        private final ResTable mResTable;

        public ARSCData(ResPackage[] packages, FlagsOffset[] flagsOffsets, ResTable resTable) {
            this.mPackages = packages;
            this.mFlagsOffsets = flagsOffsets;
            this.mResTable = resTable;
        }

        public FlagsOffset[] getFlagsOffsets() {
            return this.mFlagsOffsets;
        }

        public ResPackage[] getPackages() {
            return this.mPackages;
        }

        public ResPackage getOnePackage() throws AndrolibException {
            if (this.mPackages.length <= 0) {
                throw new AndrolibException("Arsc file contains zero packages");
            }
            if (this.mPackages.length != 1) {
                int id = this.findPackageWithMostResSpecs();
                LOGGER.warning("Arsc file contains multiple packages. Using package " + this.mPackages[id].getName() + " as default.");
                return this.mPackages[id];
            }
            return this.mPackages[0];
        }

        public int findPackageWithMostResSpecs() {
            int count = -1;
            int id = 0;
            count = this.mPackages[0].getResSpecCount();
            int i = 0;
            while (i < this.mPackages.length) {
                if (this.mPackages[i].getResSpecCount() >= count) {
                    count = this.mPackages[i].getResSpecCount();
                    id = i;
                }
                ++i;
            }
            return id;
        }

        public ResTable getResTable() {
            return this.mResTable;
        }
    }

    public static class FlagsOffset {
        public final int offset;
        public final int count;

        public FlagsOffset(int offset, int count) {
            this.offset = offset;
            this.count = count;
        }
    }

    public static class Header {
        public final short type;
        public final int chunkSize;
        public static final short TYPE_NONE = -1;
        public static final short TYPE_TABLE = 2;
        public static final short TYPE_PACKAGE = 512;
        public static final short TYPE_TYPE = 514;
        public static final short TYPE_CONFIG = 513;

        public Header(short type, int size) {
            this.type = type;
            this.chunkSize = size;
        }

        public static Header read(ExtDataInput in) throws IOException {
            short type;
            try {
                type = in.readShort();
            }
            catch (EOFException ex) {
                return new Header(-1, 0);
            }
            in.skipBytes(2);
            return new Header(type, in.readInt());
        }
    }
}

