/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.util.ExtXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.classic.StaticXmlSerializerWrapper;

public class XmlPullStreamDecoder
implements ResStreamDecoder {
    public String label = null;
    public String icon = null;
    public String packagename = null;
    private final XmlPullParser mParser;
    private final ExtXmlSerializer mSerial;
    private boolean mOptimizeForManifest = false;
    private static final Logger LOGGER = Logger.getLogger(XmlPullStreamDecoder.class.getName());

    public XmlPullStreamDecoder(XmlPullParser parser, ExtXmlSerializer serializer) {
        this.mParser = parser;
        this.mSerial = serializer;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            XmlPullWrapperFactory factory = XmlPullWrapperFactory.newInstance();
            XmlPullParserWrapper par = factory.newPullParserWrapper(this.mParser);
            final ResTable resTable = ((AXmlResourceParser)this.mParser).getAttrDecoder().getCurrentPackage().getResTable();
            StaticXmlSerializerWrapper ser = new StaticXmlSerializerWrapper(this.mSerial, factory){
                boolean hideSdkInfo;
                boolean hidePackageInfo;
                {
                    super($anonymous0, $anonymous1);
                    this.hideSdkInfo = false;
                    this.hidePackageInfo = false;
                }

                public void event(XmlPullParser pp) throws XmlPullParserException, IOException {
                    int type = pp.getEventType();
                    if (type == 2) {
                        if ("manifest".equalsIgnoreCase(pp.getName())) {
                            try {
                                this.hidePackageInfo = this.parseManifest(pp);
                            }
                            catch (AndrolibException androlibException) {}
                        } else if ("uses-sdk".equalsIgnoreCase(pp.getName())) {
                            try {
                                this.hideSdkInfo = this.parseAttr(pp);
                                if (this.hideSdkInfo) {
                                    return;
                                }
                            }
                            catch (AndrolibException androlibException) {}
                        }
                    } else {
                        if (this.hideSdkInfo && type == 3 && "uses-sdk".equalsIgnoreCase(pp.getName())) {
                            return;
                        }
                        if (this.hidePackageInfo && type == 3 && "manifest".equalsIgnoreCase(pp.getName())) {
                            super.event(pp);
                            return;
                        }
                    }
                    super.event(pp);
                }

                private boolean parseManifest(XmlPullParser pp) throws AndrolibException {
                    ResTable restable = resTable;
                    int i = 0;
                    while (i < pp.getAttributeCount()) {
                        String name = pp.getAttributeName(i);
                        String value = pp.getAttributeValue(i);
                        if (name.equals("label")) {
                            XmlPullStreamDecoder.this.label = value;
                        }
                        if (name.equals("icon")) {
                            XmlPullStreamDecoder.this.icon = value;
                        }
                        XmlPullStreamDecoder.this.packagename = pp.getAttributeValue(i);
                        if (pp.getAttributeName(i).equalsIgnoreCase("package")) {
                            restable.addPackageInfo("orig_package", pp.getAttributeValue(i));
                        } else if (pp.getAttributeName(i).equalsIgnoreCase("versionCode")) {
                            restable.addVersionInfo("versionCode", pp.getAttributeValue(i).toString());
                        } else if (pp.getAttributeName(i).equalsIgnoreCase("versionName")) {
                            restable.addVersionInfo("versionName", pp.getAttributeValue(i).toString());
                        }
                        ++i;
                    }
                    return true;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                private boolean parseAttr(XmlPullParser pp) throws AndrolibException {
                    ResTable restable = resTable;
                    int i = 0;
                    while (i < pp.getAttributeCount()) {
                        String a_ns = "http://schemas.android.com/apk/res/android";
                        String ns = pp.getAttributeNamespace(i);
                        if ("http://schemas.android.com/apk/res/android".equalsIgnoreCase(ns)) {
                            String name = pp.getAttributeName(i);
                            String value = pp.getAttributeValue(i);
                            if (name != null && value != null) {
                                if (!(name.equalsIgnoreCase("minSdkVersion") || name.equalsIgnoreCase("targetSdkVersion") || name.equalsIgnoreCase("maxSdkVersion"))) {
                                    restable.clearSdkInfo();
                                    return false;
                                }
                                restable.addSdkInfo(name, value);
                            }
                        } else {
                            resTable.clearSdkInfo();
                            if (i >= pp.getAttributeCount()) {
                                return false;
                            }
                        }
                        ++i;
                    }
                    return !resTable.getAnalysisMode();
                }
            };
            par.setInput(in, null);
            ser.setOutput(out, null);
            while (par.nextToken() != 1) {
                ser.event((XmlPullParser)par);
            }
            ser.flush();
        }
        catch (XmlPullParserException ex) {
            throw new AndrolibException("Could not decode XML", ex);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode XML", ex);
        }
    }

    public void decodeManifest(InputStream in, OutputStream out) throws AndrolibException {
        this.mOptimizeForManifest = true;
        try {
            this.decode(in, out);
        }
        finally {
            this.mOptimizeForManifest = false;
        }
    }
}

